/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import sun.misc.MetaIndex;
import sun.security.action.GetPropertyAction;

public class JarIndex {
    private HashMap<String, LinkedList<String>> indexMap = new HashMap();
    private HashMap<String, LinkedList<String>> jarMap = new HashMap();
    private String[] jarFiles;
    public static final String INDEX_NAME = "META-INF/INDEX.LIST";
    private static final boolean metaInfFilenames = "true".equals(AccessController.doPrivileged(new GetPropertyAction("sun.misc.JarIndex.metaInfFilenames")));

    public JarIndex() {
    }

    public JarIndex(InputStream inputStream) throws IOException {
        this();
        this.read(inputStream);
    }

    public JarIndex(String[] stringArray) throws IOException {
        this();
        this.jarFiles = stringArray;
        this.parseJars(stringArray);
    }

    public static JarIndex getJarIndex(JarFile jarFile) throws IOException {
        return JarIndex.getJarIndex(jarFile, null);
    }

    public static JarIndex getJarIndex(JarFile jarFile, MetaIndex metaIndex) throws IOException {
        JarIndex jarIndex = null;
        if (metaIndex != null && !metaIndex.mayContain(INDEX_NAME)) {
            return null;
        }
        JarEntry jarEntry = jarFile.getJarEntry(INDEX_NAME);
        if (jarEntry != null) {
            jarIndex = new JarIndex(jarFile.getInputStream(jarEntry));
        }
        return jarIndex;
    }

    public String[] getJarFiles() {
        return this.jarFiles;
    }

    private void addToList(String string, String string2, HashMap<String, LinkedList<String>> hashMap) {
        LinkedList<String> linkedList = hashMap.get(string);
        if (linkedList == null) {
            linkedList = new LinkedList();
            linkedList.add(string2);
            hashMap.put(string, linkedList);
        } else if (!linkedList.contains(string2)) {
            linkedList.add(string2);
        }
    }

    public LinkedList<String> get(String string) {
        int n;
        LinkedList<String> linkedList = null;
        linkedList = this.indexMap.get(string);
        if (linkedList == null && (n = string.lastIndexOf("/")) != -1) {
            linkedList = this.indexMap.get(string.substring(0, n));
        }
        return linkedList;
    }

    public void add(String string, String string2) {
        int n = string.lastIndexOf("/");
        String string3 = n != -1 ? string.substring(0, n) : string;
        this.addMapping(string3, string2);
    }

    private void addMapping(String string, String string2) {
        this.addToList(string, string2, this.indexMap);
        this.addToList(string2, string, this.jarMap);
    }

    private void parseJars(String[] stringArray) throws IOException {
        if (stringArray == null) {
            return;
        }
        String string = null;
        for (int i = 0; i < stringArray.length; ++i) {
            string = stringArray[i];
            ZipFile zipFile = new ZipFile(string.replace('/', File.separatorChar));
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String string2 = zipEntry.getName();
                if (string2.equals("META-INF/") || string2.equals(INDEX_NAME) || string2.equals("META-INF/MANIFEST.MF")) continue;
                if (!metaInfFilenames || !string2.startsWith("META-INF/")) {
                    this.add(string2, string);
                    continue;
                }
                if (zipEntry.isDirectory()) continue;
                this.addMapping(string2, string);
            }
            zipFile.close();
        }
    }

    public void write(OutputStream outputStream) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF8"));
        bufferedWriter.write("JarIndex-Version: 1.0\n\n");
        if (this.jarFiles != null) {
            for (int i = 0; i < this.jarFiles.length; ++i) {
                String string = this.jarFiles[i];
                bufferedWriter.write(string + "\n");
                LinkedList<String> linkedList = this.jarMap.get(string);
                if (linkedList != null) {
                    Iterator iterator = linkedList.iterator();
                    while (iterator.hasNext()) {
                        bufferedWriter.write((String)iterator.next() + "\n");
                    }
                }
                bufferedWriter.write("\n");
            }
            bufferedWriter.flush();
        }
    }

    public void read(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF8"));
        String string = null;
        String string2 = null;
        Vector<String> vector = new Vector<String>();
        while ((string = bufferedReader.readLine()) != null && !string.endsWith(".jar")) {
        }
        while (string != null) {
            if (!string.isEmpty()) {
                if (string.endsWith(".jar")) {
                    string2 = string;
                    vector.add(string2);
                } else {
                    String string3 = string;
                    this.addMapping(string3, string2);
                }
            }
            string = bufferedReader.readLine();
        }
        this.jarFiles = vector.toArray(new String[vector.size()]);
    }

    public void merge(JarIndex jarIndex, String string) {
        for (Map.Entry<String, LinkedList<String>> entry : this.indexMap.entrySet()) {
            String string2 = entry.getKey();
            LinkedList<String> linkedList = entry.getValue();
            for (String string3 : linkedList) {
                if (string != null) {
                    string3 = string.concat(string3);
                }
                jarIndex.addMapping(string2, string3);
            }
        }
    }
}

