/*
 * Decompiled with CFR 0.152.
 */
package jdk.xml.internal;

import com.sun.org.apache.xalan.internal.utils.XMLSecurityManager;
import com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl;
import com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl;
import com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import jdk.xml.internal.SecuritySupport;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class JdkXmlUtils {
    private static final String DOM_FACTORY_ID = "javax.xml.parsers.DocumentBuilderFactory";
    private static final String SAX_FACTORY_ID = "javax.xml.parsers.SAXParserFactory";
    private static final String SAX_DRIVER = "org.xml.sax.driver";
    public static final String NAMESPACES_FEATURE = "http://xml.org/sax/features/namespaces";
    public static final String NAMESPACE_PREFIXES_FEATURE = "http://xml.org/sax/features/namespace-prefixes";
    public static final String OVERRIDE_PARSER = "jdk.xml.overrideDefaultParser";
    public static final boolean OVERRIDE_PARSER_DEFAULT = SecuritySupport.getJAXPSystemProperty(Boolean.class, "jdk.xml.overrideDefaultParser", "false");
    public static final String FEATURE_TRUE = "true";
    public static final String FEATURE_FALSE = "false";
    private static final SAXParserFactory defaultSAXFactory = JdkXmlUtils.getSAXFactory(false);

    public static int getValue(Object object, int n) {
        if (object == null) {
            return n;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (object instanceof String) {
            return Integer.parseInt(String.valueOf(object));
        }
        throw new IllegalArgumentException("Unexpected class: " + object.getClass());
    }

    public static void setXMLReaderPropertyIfSupport(XMLReader xMLReader, String string, Object object, boolean bl) {
        block2: {
            try {
                xMLReader.setProperty(string, object);
            }
            catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
                if (!bl) break block2;
                XMLSecurityManager.printWarning(xMLReader.getClass().getName(), string, sAXException);
            }
        }
    }

    public static XMLReader getXMLReader(boolean bl, boolean bl2) {
        XMLReader xMLReader = null;
        String string = SecuritySupport.getSystemProperty(SAX_DRIVER);
        if (string != null) {
            xMLReader = JdkXmlUtils.getXMLReaderWXMLReaderFactory();
        } else if (bl) {
            xMLReader = JdkXmlUtils.getXMLReaderWSAXFactory(bl);
        }
        if (xMLReader != null) {
            if (bl2) {
                try {
                    xMLReader.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", bl2);
                }
                catch (SAXException sAXException) {
                    XMLSecurityManager.printWarning(xMLReader.getClass().getName(), "http://javax.xml.XMLConstants/feature/secure-processing", sAXException);
                }
            }
            try {
                xMLReader.setFeature(NAMESPACES_FEATURE, true);
                xMLReader.setFeature(NAMESPACE_PREFIXES_FEATURE, false);
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
            return xMLReader;
        }
        SAXParserFactory sAXParserFactory = defaultSAXFactory;
        try {
            xMLReader = sAXParserFactory.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException | SAXException exception) {
            // empty catch block
        }
        return xMLReader;
    }

    public static Document getDOMDocument() {
        try {
            DocumentBuilderFactory documentBuilderFactory = JdkXmlUtils.getDOMFactory(false);
            return documentBuilderFactory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return null;
        }
    }

    public static DocumentBuilderFactory getDOMFactory(boolean bl) {
        boolean bl2 = bl;
        String string = SecuritySupport.getJAXPSystemProperty(DOM_FACTORY_ID);
        if (string != null && System.getSecurityManager() == null) {
            bl2 = true;
        }
        DocumentBuilderFactory documentBuilderFactory = !bl2 ? new DocumentBuilderFactoryImpl() : DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(false);
        return documentBuilderFactory;
    }

    public static SAXParserFactory getSAXFactory(boolean bl) {
        boolean bl2 = bl;
        String string = SecuritySupport.getJAXPSystemProperty(SAX_FACTORY_ID);
        if (string != null && System.getSecurityManager() == null) {
            bl2 = true;
        }
        SAXParserFactory sAXParserFactory = !bl2 ? new SAXParserFactoryImpl() : SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(true);
        return sAXParserFactory;
    }

    public static SAXTransformerFactory getSAXTransformFactory(boolean bl) {
        SAXTransformerFactory sAXTransformerFactory = bl ? (SAXTransformerFactory)SAXTransformerFactory.newInstance() : new TransformerFactoryImpl();
        try {
            sAXTransformerFactory.setFeature(OVERRIDE_PARSER, bl);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            // empty catch block
        }
        return sAXTransformerFactory;
    }

    public static char getQuoteChar(String string) {
        if (string != null && string.indexOf(34) > -1) {
            return '\'';
        }
        return '\"';
    }

    private static XMLReader getXMLReaderWSAXFactory(boolean bl) {
        SAXParserFactory sAXParserFactory = JdkXmlUtils.getSAXFactory(bl);
        try {
            return sAXParserFactory.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException | SAXException exception) {
            return JdkXmlUtils.getXMLReaderWXMLReaderFactory();
        }
    }

    private static XMLReader getXMLReaderWXMLReaderFactory() {
        try {
            return XMLReaderFactory.createXMLReader();
        }
        catch (SAXException sAXException) {
            return null;
        }
    }
}

