/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.instrumentation;

import java.util.ArrayList;
import java.util.List;
import jdk.internal.instrumentation.Logger;
import jdk.internal.instrumentation.MethodInliningAdapter;
import jdk.internal.org.objectweb.asm.Label;
import jdk.internal.org.objectweb.asm.MethodVisitor;
import jdk.internal.org.objectweb.asm.tree.MethodNode;

final class MethodCallInliner
extends MethodVisitor {
    private final String newClass;
    private final MethodNode inlineTarget;
    private final List<CatchBlock> blocks = new ArrayList<CatchBlock>();
    private boolean inlining;
    private final Logger logger;
    private final int maxLocals;

    public MethodCallInliner(int n, String string, MethodVisitor methodVisitor, MethodNode methodNode, String string2, int n2, Logger logger) {
        super(327680, methodVisitor);
        this.newClass = string2;
        this.inlineTarget = methodNode;
        this.logger = logger;
        this.maxLocals = n2;
        logger.trace("MethodCallInliner: targetMethod=" + string2 + "." + methodNode.name + methodNode.desc);
    }

    @Override
    public void visitMethodInsn(int n, String string, String string2, String string3, boolean bl) {
        if (!this.shouldBeInlined(string, string2, string3)) {
            this.mv.visitMethodInsn(n, string, string2, string3, bl);
            return;
        }
        this.logger.trace("Inlining call to " + string2 + string3);
        Label label = new Label();
        this.inlining = true;
        this.inlineTarget.instructions.resetLabels();
        MethodInliningAdapter methodInliningAdapter = new MethodInliningAdapter(this, label, n == 184 ? 8 : 0, string3, this.maxLocals);
        this.inlineTarget.accept(methodInliningAdapter);
        this.logger.trace("Inlining done");
        this.inlining = false;
        super.visitLabel(label);
    }

    private boolean shouldBeInlined(String string, String string2, String string3) {
        return this.inlineTarget.desc.equals(string3) && this.inlineTarget.name.equals(string2) && string.equals(this.newClass.replace('.', '/'));
    }

    @Override
    public void visitTryCatchBlock(Label label, Label label2, Label label3, String string) {
        if (!this.inlining) {
            this.blocks.add(new CatchBlock(label, label2, label3, string));
        } else {
            super.visitTryCatchBlock(label, label2, label3, string);
        }
    }

    @Override
    public void visitMaxs(int n, int n2) {
        for (CatchBlock catchBlock : this.blocks) {
            super.visitTryCatchBlock(catchBlock.start, catchBlock.end, catchBlock.handler, catchBlock.type);
        }
        super.visitMaxs(n, n2);
    }

    static final class CatchBlock {
        final Label start;
        final Label end;
        final Label handler;
        final String type;

        CatchBlock(Label label, Label label2, Label label3, String string) {
            this.start = label;
            this.end = label2;
            this.handler = label3;
            this.type = string;
        }
    }
}

