/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.SortedSet;
import java.util.Spliterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import sun.misc.SharedSecrets;
import sun.misc.Unsafe;

public class PriorityBlockingQueue<E>
extends AbstractQueue<E>
implements BlockingQueue<E>,
Serializable {
    private static final long serialVersionUID = 5595510919245408276L;
    private static final int DEFAULT_INITIAL_CAPACITY = 11;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private transient Object[] queue;
    private transient int size;
    private transient Comparator<? super E> comparator;
    private final ReentrantLock lock;
    private final Condition notEmpty;
    private volatile transient int allocationSpinLock;
    private PriorityQueue<E> q;
    private static final Unsafe UNSAFE;
    private static final long allocationSpinLockOffset;

    public PriorityBlockingQueue() {
        this(11, null);
    }

    public PriorityBlockingQueue(int n) {
        this(n, null);
    }

    public PriorityBlockingQueue(int n, Comparator<? super E> comparator) {
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        this.lock = new ReentrantLock();
        this.notEmpty = this.lock.newCondition();
        this.comparator = comparator;
        this.queue = new Object[n];
    }

    public PriorityBlockingQueue(Collection<? extends E> collection) {
        Object[] objectArray;
        this.lock = new ReentrantLock();
        this.notEmpty = this.lock.newCondition();
        boolean bl = true;
        boolean bl2 = true;
        if (collection instanceof SortedSet) {
            objectArray = (SortedSet)collection;
            this.comparator = objectArray.comparator();
            bl = false;
        } else if (collection instanceof PriorityBlockingQueue) {
            objectArray = (PriorityBlockingQueue)collection;
            this.comparator = objectArray.comparator();
            bl2 = false;
            if (objectArray.getClass() == PriorityBlockingQueue.class) {
                bl = false;
            }
        }
        objectArray = collection.toArray();
        int n = objectArray.length;
        if (collection.getClass() != ArrayList.class) {
            objectArray = Arrays.copyOf(objectArray, n, Object[].class);
        }
        if (bl2 && (n == 1 || this.comparator != null)) {
            for (int i = 0; i < n; ++i) {
                if (objectArray[i] != null) continue;
                throw new NullPointerException();
            }
        }
        this.queue = objectArray;
        this.size = n;
        if (bl) {
            this.heapify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryGrow(Object[] objectArray, int n) {
        this.lock.unlock();
        Object[] objectArray2 = null;
        if (this.allocationSpinLock == 0 && UNSAFE.compareAndSwapInt(this, allocationSpinLockOffset, 0, 1)) {
            try {
                int n2 = n + (n < 64 ? n + 2 : n >> 1);
                if (n2 - 0x7FFFFFF7 > 0) {
                    int n3 = n + 1;
                    if (n3 < 0 || n3 > 0x7FFFFFF7) {
                        throw new OutOfMemoryError();
                    }
                    n2 = 0x7FFFFFF7;
                }
                if (n2 > n && this.queue == objectArray) {
                    objectArray2 = new Object[n2];
                }
            }
            finally {
                this.allocationSpinLock = 0;
            }
        }
        if (objectArray2 == null) {
            Thread.yield();
        }
        this.lock.lock();
        if (objectArray2 != null && this.queue == objectArray) {
            this.queue = objectArray2;
            System.arraycopy(objectArray, 0, objectArray2, 0, n);
        }
    }

    private E dequeue() {
        int n = this.size - 1;
        if (n < 0) {
            return null;
        }
        Object[] objectArray = this.queue;
        Object object = objectArray[0];
        Object object2 = objectArray[n];
        objectArray[n] = null;
        Comparator<? super E> comparator = this.comparator;
        if (comparator == null) {
            PriorityBlockingQueue.siftDownComparable(0, object2, objectArray, n);
        } else {
            PriorityBlockingQueue.siftDownUsingComparator(0, object2, objectArray, n, comparator);
        }
        this.size = n;
        return (E)object;
    }

    private static <T> void siftUpComparable(int n, T t, Object[] objectArray) {
        int n2;
        Object object;
        Comparable comparable = (Comparable)t;
        while (n > 0 && comparable.compareTo(object = objectArray[n2 = n - 1 >>> 1]) < 0) {
            objectArray[n] = object;
            n = n2;
        }
        objectArray[n] = comparable;
    }

    private static <T> void siftUpUsingComparator(int n, T t, Object[] objectArray, Comparator<? super T> comparator) {
        int n2;
        Object object;
        while (n > 0 && comparator.compare(t, object = objectArray[n2 = n - 1 >>> 1]) < 0) {
            objectArray[n] = object;
            n = n2;
        }
        objectArray[n] = t;
    }

    private static <T> void siftDownComparable(int n, T t, Object[] objectArray, int n2) {
        if (n2 > 0) {
            Comparable comparable = (Comparable)t;
            int n3 = n2 >>> 1;
            while (n < n3) {
                int n4 = (n << 1) + 1;
                Object object = objectArray[n4];
                int n5 = n4 + 1;
                if (n5 < n2 && ((Comparable)object).compareTo(objectArray[n5]) > 0) {
                    n4 = n5;
                    object = objectArray[n4];
                }
                if (comparable.compareTo(object) <= 0) break;
                objectArray[n] = object;
                n = n4;
            }
            objectArray[n] = comparable;
        }
    }

    private static <T> void siftDownUsingComparator(int n, T t, Object[] objectArray, int n2, Comparator<? super T> comparator) {
        if (n2 > 0) {
            int n3 = n2 >>> 1;
            while (n < n3) {
                int n4 = (n << 1) + 1;
                Object object = objectArray[n4];
                int n5 = n4 + 1;
                if (n5 < n2 && comparator.compare(object, objectArray[n5]) > 0) {
                    n4 = n5;
                    object = objectArray[n4];
                }
                if (comparator.compare(t, object) <= 0) break;
                objectArray[n] = object;
                n = n4;
            }
            objectArray[n] = t;
        }
    }

    private void heapify() {
        Object[] objectArray = this.queue;
        int n = this.size;
        int n2 = (n >>> 1) - 1;
        Comparator<? super E> comparator = this.comparator;
        if (comparator == null) {
            for (int i = n2; i >= 0; --i) {
                PriorityBlockingQueue.siftDownComparable(i, objectArray[i], objectArray, n);
            }
        } else {
            for (int i = n2; i >= 0; --i) {
                PriorityBlockingQueue.siftDownUsingComparator(i, objectArray[i], objectArray, n, comparator);
            }
        }
    }

    @Override
    public boolean add(E e) {
        return this.offer(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e) {
        Object[] objectArray;
        int n;
        if (e == null) {
            throw new NullPointerException();
        }
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        while (true) {
            n = this.size;
            objectArray = this.queue;
            int n2 = this.queue.length;
            if (n < n2) break;
            this.tryGrow(objectArray, n2);
        }
        try {
            Comparator<? super E> comparator = this.comparator;
            if (comparator == null) {
                PriorityBlockingQueue.siftUpComparable(n, e, objectArray);
            } else {
                PriorityBlockingQueue.siftUpUsingComparator(n, e, objectArray, comparator);
            }
            this.size = n + 1;
            this.notEmpty.signal();
        }
        finally {
            reentrantLock.unlock();
        }
        return true;
    }

    @Override
    public void put(E e) {
        this.offer(e);
    }

    @Override
    public boolean offer(E e, long l, TimeUnit timeUnit) {
        return this.offer(e);
    }

    @Override
    public E poll() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            E e = this.dequeue();
            return e;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public E take() throws InterruptedException {
        E e;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lockInterruptibly();
        try {
            while ((e = this.dequeue()) == null) {
                this.notEmpty.await();
            }
        }
        finally {
            reentrantLock.unlock();
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll(long l, TimeUnit timeUnit) throws InterruptedException {
        E e;
        long l2 = timeUnit.toNanos(l);
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lockInterruptibly();
        try {
            while ((e = this.dequeue()) == null && l2 > 0L) {
                l2 = this.notEmpty.awaitNanos(l2);
            }
        }
        finally {
            reentrantLock.unlock();
        }
        return e;
    }

    @Override
    public E peek() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Object object = this.size == 0 ? null : this.queue[0];
            return (E)object;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    public Comparator<? super E> comparator() {
        return this.comparator;
    }

    @Override
    public int size() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n = this.size;
            return n;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    private int indexOf(Object object) {
        if (object != null) {
            Object[] objectArray = this.queue;
            int n = this.size;
            for (int i = 0; i < n; ++i) {
                if (!object.equals(objectArray[i])) continue;
                return i;
            }
        }
        return -1;
    }

    private void removeAt(int n) {
        Object[] objectArray = this.queue;
        int n2 = this.size - 1;
        if (n2 == n) {
            objectArray[n] = null;
        } else {
            Object object = objectArray[n2];
            objectArray[n2] = null;
            Comparator<? super E> comparator = this.comparator;
            if (comparator == null) {
                PriorityBlockingQueue.siftDownComparable(n, object, objectArray, n2);
            } else {
                PriorityBlockingQueue.siftDownUsingComparator(n, object, objectArray, n2, comparator);
            }
            if (objectArray[n] == object) {
                if (comparator == null) {
                    PriorityBlockingQueue.siftUpComparable(n, object, objectArray);
                } else {
                    PriorityBlockingQueue.siftUpUsingComparator(n, object, objectArray, comparator);
                }
            }
        }
        this.size = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object object) {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n = this.indexOf(object);
            if (n == -1) {
                boolean bl = false;
                return bl;
            }
            this.removeAt(n);
            boolean bl = true;
            return bl;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeEQ(Object object) {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Object[] objectArray = this.queue;
            int n = this.size;
            for (int i = 0; i < n; ++i) {
                if (object != objectArray[i]) continue;
                this.removeAt(i);
                break;
            }
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object object) {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean bl = this.indexOf(object) != -1;
            return bl;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public Object[] toArray() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Object[] objectArray = Arrays.copyOf(this.queue, this.size);
            return objectArray;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n = this.size;
            if (n == 0) {
                String string = "[]";
                return string;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('[');
            for (int i = 0; i < n; ++i) {
                Object object = this.queue[i];
                stringBuilder.append(object == this ? "(this Collection)" : object);
                if (i == n - 1) continue;
                stringBuilder.append(',').append(' ');
            }
            String string = stringBuilder.append(']').toString();
            return string;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public int drainTo(Collection<? super E> collection) {
        return this.drainTo(collection, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> collection, int n) {
        if (collection == null) {
            throw new NullPointerException();
        }
        if (collection == this) {
            throw new IllegalArgumentException();
        }
        if (n <= 0) {
            return 0;
        }
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n2;
            int n3 = Math.min(this.size, n);
            for (n2 = 0; n2 < n3; ++n2) {
                collection.add(this.queue[0]);
                this.dequeue();
            }
            n2 = n3;
            return n2;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Object[] objectArray = this.queue;
            int n = this.size;
            this.size = 0;
            for (int i = 0; i < n; ++i) {
                objectArray[i] = null;
            }
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] TArray) {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n = this.size;
            if (TArray.length < n) {
                T[] TArray2 = Arrays.copyOf(this.queue, this.size, TArray.getClass());
                return TArray2;
            }
            System.arraycopy(this.queue, 0, TArray, 0, n);
            if (TArray.length > n) {
                TArray[n] = null;
            }
            T[] TArray3 = TArray;
            return TArray3;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr(this.toArray());
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.lock.lock();
        try {
            this.q = new PriorityQueue<E>(Math.max(this.size, 1), this.comparator);
            this.q.addAll(this);
            objectOutputStream.defaultWriteObject();
        }
        finally {
            this.q = null;
            this.lock.unlock();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        try {
            objectInputStream.defaultReadObject();
            int n = this.q.size();
            SharedSecrets.getJavaOISAccess().checkArray(objectInputStream, Object[].class, n);
            this.queue = new Object[n];
            this.comparator = this.q.comparator();
            this.addAll(this.q);
        }
        finally {
            this.q = null;
        }
    }

    @Override
    public Spliterator<E> spliterator() {
        return new PBQSpliterator(this, null, 0, -1);
    }

    static {
        try {
            UNSAFE = Unsafe.getUnsafe();
            Class<PriorityBlockingQueue> clazz = PriorityBlockingQueue.class;
            allocationSpinLockOffset = UNSAFE.objectFieldOffset(clazz.getDeclaredField("allocationSpinLock"));
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }

    final class Itr
    implements Iterator<E> {
        final Object[] array;
        int cursor;
        int lastRet = -1;

        Itr(Object[] objectArray) {
            this.array = objectArray;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.array.length;
        }

        @Override
        public E next() {
            if (this.cursor >= this.array.length) {
                throw new NoSuchElementException();
            }
            this.lastRet = this.cursor;
            return this.array[this.cursor++];
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            PriorityBlockingQueue.this.removeEQ(this.array[this.lastRet]);
            this.lastRet = -1;
        }
    }

    static final class PBQSpliterator<E>
    implements Spliterator<E> {
        final PriorityBlockingQueue<E> queue;
        Object[] array;
        int index;
        int fence;

        PBQSpliterator(PriorityBlockingQueue<E> priorityBlockingQueue, Object[] objectArray, int n, int n2) {
            this.queue = priorityBlockingQueue;
            this.array = objectArray;
            this.index = n;
            this.fence = n2;
        }

        final int getFence() {
            int n = this.fence;
            if (n < 0) {
                this.array = this.queue.toArray();
                n = this.fence = this.array.length;
            }
            return n;
        }

        @Override
        public Spliterator<E> trySplit() {
            PBQSpliterator<E> pBQSpliterator;
            int n = this.index;
            int n2 = this.getFence();
            int n3 = n + n2 >>> 1;
            if (n >= n3) {
                pBQSpliterator = null;
            } else {
                this.index = n3;
                PBQSpliterator<E> pBQSpliterator2 = new PBQSpliterator<E>(this.queue, this.array, n, this.index);
                pBQSpliterator = pBQSpliterator2;
            }
            return pBQSpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super E> consumer) {
            int n;
            int n2;
            if (consumer == null) {
                throw new NullPointerException();
            }
            Object[] objectArray = this.array;
            if (this.array == null) {
                objectArray = this.queue.toArray();
                this.fence = objectArray.length;
            }
            if ((n2 = this.fence) <= objectArray.length && (n = this.index) >= 0 && n < (this.index = n2)) {
                do {
                    consumer.accept(objectArray[n]);
                } while (++n < n2);
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super E> consumer) {
            if (consumer == null) {
                throw new NullPointerException();
            }
            if (this.getFence() > this.index && this.index >= 0) {
                Object object = this.array[this.index++];
                consumer.accept(object);
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return this.getFence() - this.index;
        }

        @Override
        public int characteristics() {
            return 16704;
        }
    }
}

