/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.policy.subject;

import com.sun.xml.internal.ws.policy.privateutil.LocalizationMessages;
import com.sun.xml.internal.ws.policy.privateutil.PolicyLogger;
import javax.xml.namespace.QName;

public class WsdlBindingSubject {
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(WsdlBindingSubject.class);
    private final QName name;
    private final WsdlMessageType messageType;
    private final WsdlNameScope nameScope;
    private final WsdlBindingSubject parent;

    WsdlBindingSubject(QName qName, WsdlNameScope wsdlNameScope, WsdlBindingSubject wsdlBindingSubject) {
        this(qName, WsdlMessageType.NO_MESSAGE, wsdlNameScope, wsdlBindingSubject);
    }

    WsdlBindingSubject(QName qName, WsdlMessageType wsdlMessageType, WsdlNameScope wsdlNameScope, WsdlBindingSubject wsdlBindingSubject) {
        this.name = qName;
        this.messageType = wsdlMessageType;
        this.nameScope = wsdlNameScope;
        this.parent = wsdlBindingSubject;
    }

    public static WsdlBindingSubject createBindingSubject(QName qName) {
        return new WsdlBindingSubject(qName, WsdlNameScope.ENDPOINT, null);
    }

    public static WsdlBindingSubject createBindingOperationSubject(QName qName, QName qName2) {
        WsdlBindingSubject wsdlBindingSubject = WsdlBindingSubject.createBindingSubject(qName);
        return new WsdlBindingSubject(qName2, WsdlNameScope.OPERATION, wsdlBindingSubject);
    }

    public static WsdlBindingSubject createBindingMessageSubject(QName qName, QName qName2, QName qName3, WsdlMessageType wsdlMessageType) {
        if (wsdlMessageType == null) {
            throw LOGGER.logSevereException(new IllegalArgumentException(LocalizationMessages.WSP_0083_MESSAGE_TYPE_NULL()));
        }
        if (wsdlMessageType == WsdlMessageType.NO_MESSAGE) {
            throw LOGGER.logSevereException(new IllegalArgumentException(LocalizationMessages.WSP_0084_MESSAGE_TYPE_NO_MESSAGE()));
        }
        if (wsdlMessageType == WsdlMessageType.FAULT && qName3 == null) {
            throw LOGGER.logSevereException(new IllegalArgumentException(LocalizationMessages.WSP_0085_MESSAGE_FAULT_NO_NAME()));
        }
        WsdlBindingSubject wsdlBindingSubject = WsdlBindingSubject.createBindingOperationSubject(qName, qName2);
        return new WsdlBindingSubject(qName3, wsdlMessageType, WsdlNameScope.MESSAGE, wsdlBindingSubject);
    }

    public QName getName() {
        return this.name;
    }

    public WsdlMessageType getMessageType() {
        return this.messageType;
    }

    public WsdlBindingSubject getParent() {
        return this.parent;
    }

    public boolean isBindingSubject() {
        if (this.nameScope == WsdlNameScope.ENDPOINT) {
            return this.parent == null;
        }
        return false;
    }

    public boolean isBindingOperationSubject() {
        if (this.nameScope == WsdlNameScope.OPERATION && this.parent != null) {
            return this.parent.isBindingSubject();
        }
        return false;
    }

    public boolean isBindingMessageSubject() {
        if (this.nameScope == WsdlNameScope.MESSAGE && this.parent != null) {
            return this.parent.isBindingOperationSubject();
        }
        return false;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof WsdlBindingSubject)) {
            return false;
        }
        WsdlBindingSubject wsdlBindingSubject = (WsdlBindingSubject)object;
        boolean bl = true;
        bl = bl && (this.name == null ? wsdlBindingSubject.name == null : this.name.equals(wsdlBindingSubject.name));
        bl = bl && this.messageType.equals((Object)wsdlBindingSubject.messageType);
        boolean bl2 = bl = bl && this.nameScope.equals((Object)wsdlBindingSubject.nameScope);
        bl = bl && (this.parent == null ? wsdlBindingSubject.parent == null : this.parent.equals(wsdlBindingSubject.parent));
        return bl;
    }

    public int hashCode() {
        int n = 23;
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        n = 31 * n + this.messageType.hashCode();
        n = 31 * n + this.nameScope.hashCode();
        n = 31 * n + (this.parent == null ? 0 : this.parent.hashCode());
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("WsdlBindingSubject[");
        stringBuilder.append(this.name).append(", ").append((Object)this.messageType);
        stringBuilder.append(", ").append((Object)this.nameScope).append(", ").append(this.parent);
        return stringBuilder.append("]").toString();
    }

    public static enum WsdlMessageType {
        NO_MESSAGE,
        INPUT,
        OUTPUT,
        FAULT;

    }

    public static enum WsdlNameScope {
        SERVICE,
        ENDPOINT,
        OPERATION,
        MESSAGE;

    }
}

