/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.utils;

import com.sun.org.apache.xalan.internal.utils.SecuritySupport;
import com.sun.org.apache.xalan.internal.utils.XMLSecurityManager;
import java.util.HashMap;
import jdk.xml.internal.JdkXmlUtils;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XMLReaderManager {
    private static final XMLReaderManager m_singletonManager = new XMLReaderManager();
    private static final String property = "org.xml.sax.driver";
    private ThreadLocal<ReaderWrapper> m_readers;
    private boolean m_overrideDefaultParser;
    private HashMap m_inUse;
    private boolean _secureProcessing;
    private String _accessExternalDTD = "all";
    private XMLSecurityManager _xmlSecurityManager;

    private XMLReaderManager() {
    }

    public static XMLReaderManager getInstance(boolean bl) {
        m_singletonManager.setOverrideDefaultParser(bl);
        return m_singletonManager;
    }

    public synchronized XMLReader getXMLReader() throws SAXException {
        ReaderWrapper readerWrapper;
        if (this.m_readers == null) {
            this.m_readers = new ThreadLocal();
        }
        if (this.m_inUse == null) {
            this.m_inUse = new HashMap();
        }
        boolean bl = (readerWrapper = this.m_readers.get()) != null;
        XMLReader xMLReader = bl ? readerWrapper.reader : null;
        String string = SecuritySupport.getSystemProperty(property);
        if (bl && this.m_inUse.get(xMLReader) != Boolean.TRUE && readerWrapper.overrideDefaultParser == this.m_overrideDefaultParser && (string == null || xMLReader.getClass().getName().equals(string))) {
            this.m_inUse.put(xMLReader, Boolean.TRUE);
        } else {
            xMLReader = JdkXmlUtils.getXMLReader(this.m_overrideDefaultParser, this._secureProcessing);
            if (!bl) {
                this.m_readers.set(new ReaderWrapper(xMLReader, this.m_overrideDefaultParser));
                this.m_inUse.put(xMLReader, Boolean.TRUE);
            }
        }
        try {
            xMLReader.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", this._accessExternalDTD);
        }
        catch (SAXException sAXException) {
            XMLSecurityManager.printWarning(xMLReader.getClass().getName(), "http://javax.xml.XMLConstants/property/accessExternalDTD", sAXException);
        }
        String string2 = "";
        try {
            if (this._xmlSecurityManager != null) {
                for (XMLSecurityManager.Limit limit : XMLSecurityManager.Limit.values()) {
                    string2 = limit.apiProperty();
                    xMLReader.setProperty(string2, this._xmlSecurityManager.getLimitValueAsString(limit));
                }
                if (this._xmlSecurityManager.printEntityCountInfo()) {
                    string2 = "http://www.oracle.com/xml/jaxp/properties/getEntityCountInfo";
                    xMLReader.setProperty("http://www.oracle.com/xml/jaxp/properties/getEntityCountInfo", "yes");
                }
            }
        }
        catch (SAXException sAXException) {
            XMLSecurityManager.printWarning(xMLReader.getClass().getName(), string2, sAXException);
        }
        return xMLReader;
    }

    public synchronized void releaseXMLReader(XMLReader xMLReader) {
        ReaderWrapper readerWrapper = this.m_readers.get();
        if (readerWrapper.reader == xMLReader && xMLReader != null) {
            this.m_inUse.remove(xMLReader);
        }
    }

    public boolean overrideDefaultParser() {
        return this.m_overrideDefaultParser;
    }

    public void setOverrideDefaultParser(boolean bl) {
        this.m_overrideDefaultParser = bl;
    }

    public void setFeature(String string, boolean bl) {
        if (string.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
            this._secureProcessing = bl;
        }
    }

    public Object getProperty(String string) {
        if (string.equals("http://javax.xml.XMLConstants/property/accessExternalDTD")) {
            return this._accessExternalDTD;
        }
        if (string.equals("http://apache.org/xml/properties/security-manager")) {
            return this._xmlSecurityManager;
        }
        return null;
    }

    public void setProperty(String string, Object object) {
        if (string.equals("http://javax.xml.XMLConstants/property/accessExternalDTD")) {
            this._accessExternalDTD = (String)object;
        } else if (string.equals("http://apache.org/xml/properties/security-manager")) {
            this._xmlSecurityManager = (XMLSecurityManager)object;
        }
    }

    class ReaderWrapper {
        XMLReader reader;
        boolean overrideDefaultParser;

        public ReaderWrapper(XMLReader xMLReader, boolean bl) {
            this.reader = xMLReader;
            this.overrideDefaultParser = bl;
        }
    }
}

