/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.utils.resolver.implementations;

import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverContext;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverException;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverSpi;
import com.sun.org.slf4j.internal.Logger;
import com.sun.org.slf4j.internal.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ResolverFragment
extends ResourceResolverSpi {
    private static final Logger LOG = LoggerFactory.getLogger(ResolverFragment.class);

    @Override
    public XMLSignatureInput engineResolveURI(ResourceResolverContext resourceResolverContext) throws ResourceResolverException {
        Object object;
        Document document = resourceResolverContext.attr.getOwnerElement().getOwnerDocument();
        Node node = null;
        if (resourceResolverContext.uriToResolve.isEmpty()) {
            LOG.debug("ResolverFragment with empty URI (means complete document)");
            node = document;
        } else {
            Element element;
            object = resourceResolverContext.uriToResolve.substring(1);
            node = document.getElementById((String)object);
            if (node == null) {
                Object[] objectArray = new Object[]{object};
                throw new ResourceResolverException("signature.Verification.MissingID", objectArray, resourceResolverContext.uriToResolve, resourceResolverContext.baseUri);
            }
            if (resourceResolverContext.secureValidation && !XMLUtils.protectAgainstWrappingAttack(element = resourceResolverContext.attr.getOwnerDocument().getDocumentElement(), (String)object)) {
                Object[] objectArray = new Object[]{object};
                throw new ResourceResolverException("signature.Verification.MultipleIDs", objectArray, resourceResolverContext.uriToResolve, resourceResolverContext.baseUri);
            }
            LOG.debug("Try to catch an Element with ID {} and Element was {}", object, node);
        }
        object = new XMLSignatureInput(node);
        ((XMLSignatureInput)object).setSecureValidation(resourceResolverContext.secureValidation);
        ((XMLSignatureInput)object).setExcludeComments(true);
        ((XMLSignatureInput)object).setMIMEType("text/xml");
        if (resourceResolverContext.baseUri != null && resourceResolverContext.baseUri.length() > 0) {
            ((XMLSignatureInput)object).setSourceURI(resourceResolverContext.baseUri.concat(resourceResolverContext.uriToResolve));
        } else {
            ((XMLSignatureInput)object).setSourceURI(resourceResolverContext.uriToResolve);
        }
        return object;
    }

    @Override
    public boolean engineCanResolveURI(ResourceResolverContext resourceResolverContext) {
        if (resourceResolverContext.uriToResolve == null) {
            LOG.debug("Quick fail for null uri");
            return false;
        }
        if (resourceResolverContext.uriToResolve.isEmpty() || resourceResolverContext.uriToResolve.charAt(0) == '#' && !resourceResolverContext.uriToResolve.startsWith("#xpointer(")) {
            LOG.debug("State I can resolve reference: \"{}\"", resourceResolverContext.uriToResolve);
            return true;
        }
        LOG.debug("Do not seem to be able to resolve reference: \"{}\"", resourceResolverContext.uriToResolve);
        return false;
    }
}

