/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.c14n.implementations;

import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.util.Map;

public final class UtfHelpper {
    private static final boolean OLD_UTF8 = AccessController.doPrivileged(() -> Boolean.getBoolean("com.sun.org.apache.xml.internal.security.c14n.oldUtf8"));

    private UtfHelpper() {
    }

    public static void writeByte(String string, OutputStream outputStream, Map<String, byte[]> map) throws IOException {
        byte[] byArray = map.get(string);
        if (byArray == null) {
            byArray = UtfHelpper.getStringInUtf8(string);
            map.put(string, byArray);
        }
        outputStream.write(byArray);
    }

    public static void writeCodePointToUtf8(int n, OutputStream outputStream) throws IOException {
        if (!Character.isValidCodePoint(n) || n >= 55296 && n <= 56319 || n >= 56320 && n <= 57343) {
            outputStream.write(63);
            return;
        }
        if (OLD_UTF8 && n >= 65536) {
            outputStream.write(63);
            outputStream.write(63);
            return;
        }
        if (n < 128) {
            outputStream.write(n);
            return;
        }
        int n2 = 0;
        if (n < 2048) {
            n2 = 1;
        } else if (n < 65536) {
            n2 = 2;
        } else if (n < 0x200000) {
            n2 = 3;
        } else if (n < 0x4000000) {
            n2 = 4;
        } else if (n <= Integer.MAX_VALUE) {
            n2 = 5;
        } else {
            outputStream.write(63);
            return;
        }
        int n3 = 6 * n2;
        byte by = (byte)(254 << 6 - n2 | n >>> n3);
        outputStream.write(by);
        for (int i = n2 - 1; i >= 0; --i) {
            by = (byte)(0x80 | n >>> (n3 -= 6) & 0x3F);
            outputStream.write(by);
        }
    }

    public static void writeStringToUtf8(String string, OutputStream outputStream) throws IOException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            int n3 = string.codePointAt(n2);
            n2 += Character.charCount(n3);
            if (!Character.isValidCodePoint(n3) || n3 >= 55296 && n3 <= 56319 || n3 >= 56320 && n3 <= 57343) {
                outputStream.write(63);
                continue;
            }
            if (OLD_UTF8 && n3 >= 65536) {
                outputStream.write(63);
                outputStream.write(63);
                continue;
            }
            if (n3 < 128) {
                outputStream.write(n3);
                continue;
            }
            int n4 = 0;
            if (n3 < 2048) {
                n4 = 1;
            } else if (n3 < 65536) {
                n4 = 2;
            } else if (n3 < 0x200000) {
                n4 = 3;
            } else if (n3 < 0x4000000) {
                n4 = 4;
            } else if (n3 <= Integer.MAX_VALUE) {
                n4 = 5;
            } else {
                outputStream.write(63);
                continue;
            }
            int n5 = 6 * n4;
            byte by = (byte)(254 << 6 - n4 | n3 >>> n5);
            outputStream.write(by);
            for (int i = n4 - 1; i >= 0; --i) {
                by = (byte)(0x80 | n3 >>> (n5 -= 6) & 0x3F);
                outputStream.write(by);
            }
        }
    }

    public static byte[] getStringInUtf8(String string) {
        int n = string.length();
        boolean bl = false;
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            int n4 = string.codePointAt(n2);
            n2 += Character.charCount(n4);
            if (!Character.isValidCodePoint(n4) || n4 >= 55296 && n4 <= 56319 || n4 >= 56320 && n4 <= 57343) {
                byArray[n3++] = 63;
                continue;
            }
            if (OLD_UTF8 && n4 >= 65536) {
                byArray[n3++] = 63;
                byArray[n3++] = 63;
                continue;
            }
            if (n4 < 128) {
                byArray[n3++] = (byte)n4;
                continue;
            }
            if (!bl) {
                byte[] byArray2 = new byte[6 * n];
                System.arraycopy(byArray, 0, byArray2, 0, n3);
                byArray = byArray2;
                bl = true;
            }
            int n5 = 0;
            if (n4 < 2048) {
                n5 = 1;
            } else if (n4 < 65536) {
                n5 = 2;
            } else if (n4 < 0x200000) {
                n5 = 3;
            } else if (n4 < 0x4000000) {
                n5 = 4;
            } else if (n4 <= Integer.MAX_VALUE) {
                n5 = 5;
            } else {
                byArray[n3++] = 63;
                continue;
            }
            int n6 = 6 * n5;
            byte by = (byte)(254 << 6 - n5 | n4 >>> n6);
            byArray[n3++] = by;
            for (int i = n5 - 1; i >= 0; --i) {
                by = (byte)(0x80 | n4 >>> (n6 -= 6) & 0x3F);
                byArray[n3++] = by;
            }
        }
        if (bl) {
            byte[] byArray3 = new byte[n3];
            System.arraycopy(byArray, 0, byArray3, 0, n3);
            byArray = byArray3;
        }
        return byArray;
    }
}

