/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.util;

import com.sun.org.apache.bcel.internal.classfile.ClassParser;
import com.sun.org.apache.bcel.internal.classfile.JavaClass;
import com.sun.org.apache.bcel.internal.util.Repository;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;

public class SyntheticRepository
implements Repository {
    private final Map<String, SoftReference<JavaClass>> loadedClasses = new HashMap<String, SoftReference<JavaClass>>();

    private SyntheticRepository() {
    }

    public static SyntheticRepository getInstance() {
        return new SyntheticRepository();
    }

    @Override
    public void storeClass(JavaClass javaClass) {
        this.loadedClasses.put(javaClass.getClassName(), new SoftReference<JavaClass>(javaClass));
        javaClass.setRepository(this);
    }

    @Override
    public void removeClass(JavaClass javaClass) {
        this.loadedClasses.remove(javaClass.getClassName());
    }

    @Override
    public JavaClass findClass(String string) {
        SoftReference<JavaClass> softReference = this.loadedClasses.get(string);
        if (softReference == null) {
            return null;
        }
        return softReference.get();
    }

    @Override
    public JavaClass loadClass(String string) throws ClassNotFoundException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Invalid class name " + string);
        }
        JavaClass javaClass = this.findClass(string = string.replace('/', '.'));
        if (javaClass != null) {
            return javaClass;
        }
        IOException iOException = new IOException("Couldn't find: " + string + ".class");
        throw new ClassNotFoundException("Exception while looking for class " + string + ": " + iOException, iOException);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JavaClass loadClass(Class<?> clazz) throws ClassNotFoundException {
        String string = clazz.getName();
        JavaClass javaClass3 = this.findClass(string);
        if (javaClass3 != null) {
            return javaClass3;
        }
        String string2 = string;
        int n = string2.lastIndexOf(46);
        if (n > 0) {
            string2 = string2.substring(n + 1);
        }
        JavaClass javaClass2 = null;
        try (InputStream inputStream = clazz.getResourceAsStream(string2 + ".class");){
            JavaClass javaClass = javaClass2 = this.loadClass(inputStream, string);
            return javaClass;
        }
        catch (IOException iOException) {
            return javaClass2;
        }
    }

    private JavaClass loadClass(InputStream inputStream, String string) throws ClassNotFoundException {
        try {
            if (inputStream != null) {
                ClassParser classParser = new ClassParser(inputStream, string);
                JavaClass javaClass = classParser.parse();
                this.storeClass(javaClass);
                JavaClass javaClass2 = javaClass;
                return javaClass2;
            }
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException("Exception while looking for class " + string + ": " + iOException, iOException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        throw new ClassNotFoundException("SyntheticRepository could not load " + string);
    }

    @Override
    public void clear() {
        this.loadedClasses.clear();
    }
}

