/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.generic.BranchInstruction;
import com.sun.org.apache.bcel.internal.generic.ClassGenException;
import com.sun.org.apache.bcel.internal.generic.InstructionHandle;
import com.sun.org.apache.bcel.internal.generic.StackConsumer;
import com.sun.org.apache.bcel.internal.generic.StackProducer;
import com.sun.org.apache.bcel.internal.generic.VariableLengthInstruction;
import com.sun.org.apache.bcel.internal.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class Select
extends BranchInstruction
implements VariableLengthInstruction,
StackConsumer,
StackProducer {
    private int[] match;
    private int[] indices;
    private InstructionHandle[] targets;
    private int fixed_length;
    private int match_length;
    private int padding = 0;

    Select() {
    }

    Select(short s, int[] nArray, InstructionHandle[] instructionHandleArray, InstructionHandle instructionHandle) {
        super(s, null);
        this.match = nArray;
        this.targets = instructionHandleArray;
        this.setTarget(instructionHandle);
        for (InstructionHandle instructionHandle2 : instructionHandleArray) {
            Select.notifyTarget(null, instructionHandle2, this);
        }
        this.match_length = nArray.length;
        if (this.match_length != instructionHandleArray.length) {
            throw new ClassGenException("Match and target array have not the same length: Match length: " + nArray.length + " Target length: " + instructionHandleArray.length);
        }
        this.indices = new int[this.match_length];
    }

    @Override
    protected int updatePosition(int n, int n2) {
        this.setPosition(this.getPosition() + n);
        short s = (short)super.getLength();
        this.padding = (4 - (this.getPosition() + 1) % 4) % 4;
        super.setLength((short)(this.fixed_length + this.padding));
        return super.getLength() - s;
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(super.getOpcode());
        for (int i = 0; i < this.padding; ++i) {
            dataOutputStream.writeByte(0);
        }
        super.setIndex(this.getTargetOffset());
        dataOutputStream.writeInt(super.getIndex());
    }

    @Override
    protected void initFromFile(ByteSequence byteSequence, boolean bl) throws IOException {
        this.padding = (4 - byteSequence.getIndex() % 4) % 4;
        for (int i = 0; i < this.padding; ++i) {
            byteSequence.readByte();
        }
        super.setIndex(byteSequence.readInt());
    }

    @Override
    public String toString(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(super.toString(bl));
        if (bl) {
            for (int i = 0; i < this.match_length; ++i) {
                String string = "null";
                if (this.targets[i] != null) {
                    string = this.targets[i].getInstruction().toString();
                }
                stringBuilder.append("(").append(this.match[i]).append(", ").append(string).append(" = {").append(this.indices[i]).append("})");
            }
        } else {
            stringBuilder.append(" ...");
        }
        return stringBuilder.toString();
    }

    public void setTarget(int n, InstructionHandle instructionHandle) {
        Select.notifyTarget(this.targets[n], instructionHandle, this);
        this.targets[n] = instructionHandle;
    }

    @Override
    public void updateTarget(InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
        boolean bl = false;
        if (super.getTarget() == instructionHandle) {
            bl = true;
            this.setTarget(instructionHandle2);
        }
        for (int i = 0; i < this.targets.length; ++i) {
            if (this.targets[i] != instructionHandle) continue;
            bl = true;
            this.setTarget(i, instructionHandle2);
        }
        if (!bl) {
            throw new ClassGenException("Not targeting " + instructionHandle);
        }
    }

    @Override
    public boolean containsTarget(InstructionHandle instructionHandle) {
        if (super.getTarget() == instructionHandle) {
            return true;
        }
        for (InstructionHandle instructionHandle2 : this.targets) {
            if (instructionHandle2 != instructionHandle) continue;
            return true;
        }
        return false;
    }

    protected Object clone() throws CloneNotSupportedException {
        Select select = (Select)super.clone();
        select.match = (int[])this.match.clone();
        select.indices = (int[])this.indices.clone();
        select.targets = (InstructionHandle[])this.targets.clone();
        return select;
    }

    @Override
    void dispose() {
        super.dispose();
        for (InstructionHandle instructionHandle : this.targets) {
            instructionHandle.removeTargeter(this);
        }
    }

    public int[] getMatchs() {
        return this.match;
    }

    public int[] getIndices() {
        return this.indices;
    }

    public InstructionHandle[] getTargets() {
        return this.targets;
    }

    final int getMatch(int n) {
        return this.match[n];
    }

    final int getIndices(int n) {
        return this.indices[n];
    }

    final InstructionHandle getTarget(int n) {
        return this.targets[n];
    }

    final int getFixed_length() {
        return this.fixed_length;
    }

    final void setFixed_length(int n) {
        this.fixed_length = n;
    }

    final int getMatch_length() {
        return this.match_length;
    }

    final int setMatch_length(int n) {
        this.match_length = n;
        return n;
    }

    final void setMatch(int n, int n2) {
        this.match[n] = n2;
    }

    final void setIndices(int[] nArray) {
        this.indices = nArray;
    }

    final void setMatches(int[] nArray) {
        this.match = nArray;
    }

    final void setTargets(InstructionHandle[] instructionHandleArray) {
        this.targets = instructionHandleArray;
    }

    final int getPadding() {
        return this.padding;
    }

    final int setIndices(int n, int n2) {
        this.indices[n] = n2;
        return n2;
    }
}

