/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.ClassFormatException;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Node;
import com.sun.org.apache.bcel.internal.classfile.StackMapType;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class StackMapEntry
implements Node,
Cloneable {
    private int frame_type;
    private int byte_code_offset;
    private StackMapType[] types_of_locals;
    private StackMapType[] types_of_stack_items;
    private ConstantPool constant_pool;

    StackMapEntry(DataInput dataInput, ConstantPool constantPool) throws IOException {
        this(dataInput.readByte() & 0xFF, -1, null, null, constantPool);
        if (this.frame_type >= 0 && this.frame_type <= 63) {
            this.byte_code_offset = this.frame_type - 0;
        } else if (this.frame_type >= 64 && this.frame_type <= 127) {
            this.byte_code_offset = this.frame_type - 64;
            this.types_of_stack_items = new StackMapType[1];
            this.types_of_stack_items[0] = new StackMapType(dataInput, constantPool);
        } else if (this.frame_type == 247) {
            this.byte_code_offset = dataInput.readShort();
            this.types_of_stack_items = new StackMapType[1];
            this.types_of_stack_items[0] = new StackMapType(dataInput, constantPool);
        } else if (this.frame_type >= 248 && this.frame_type <= 250) {
            this.byte_code_offset = dataInput.readShort();
        } else if (this.frame_type == 251) {
            this.byte_code_offset = dataInput.readShort();
        } else if (this.frame_type >= 252 && this.frame_type <= 254) {
            this.byte_code_offset = dataInput.readShort();
            int n = this.frame_type - 251;
            this.types_of_locals = new StackMapType[n];
            for (int i = 0; i < n; ++i) {
                this.types_of_locals[i] = new StackMapType(dataInput, constantPool);
            }
        } else if (this.frame_type == 255) {
            int n;
            this.byte_code_offset = dataInput.readShort();
            int n2 = dataInput.readShort();
            this.types_of_locals = new StackMapType[n2];
            for (n = 0; n < n2; ++n) {
                this.types_of_locals[n] = new StackMapType(dataInput, constantPool);
            }
            n = dataInput.readShort();
            this.types_of_stack_items = new StackMapType[n];
            for (int i = 0; i < n; ++i) {
                this.types_of_stack_items[i] = new StackMapType(dataInput, constantPool);
            }
        } else {
            throw new ClassFormatException("Invalid frame type found while parsing stack map table: " + this.frame_type);
        }
    }

    @Deprecated
    public StackMapEntry(int n, int n2, StackMapType[] stackMapTypeArray, int n3, StackMapType[] stackMapTypeArray2, ConstantPool constantPool) {
        this.byte_code_offset = n;
        this.types_of_locals = stackMapTypeArray != null ? stackMapTypeArray : new StackMapType[]{};
        this.types_of_stack_items = stackMapTypeArray2 != null ? stackMapTypeArray2 : new StackMapType[]{};
        this.constant_pool = constantPool;
    }

    public StackMapEntry(int n, int n2, StackMapType[] stackMapTypeArray, StackMapType[] stackMapTypeArray2, ConstantPool constantPool) {
        this.frame_type = n;
        this.byte_code_offset = n2;
        this.types_of_locals = stackMapTypeArray != null ? stackMapTypeArray : new StackMapType[]{};
        this.types_of_stack_items = stackMapTypeArray2 != null ? stackMapTypeArray2 : new StackMapType[]{};
        this.constant_pool = constantPool;
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.write(this.frame_type);
        if (this.frame_type < 0 || this.frame_type > 63) {
            if (this.frame_type >= 64 && this.frame_type <= 127) {
                this.types_of_stack_items[0].dump(dataOutputStream);
            } else if (this.frame_type == 247) {
                dataOutputStream.writeShort(this.byte_code_offset);
                this.types_of_stack_items[0].dump(dataOutputStream);
            } else if (this.frame_type >= 248 && this.frame_type <= 250) {
                dataOutputStream.writeShort(this.byte_code_offset);
            } else if (this.frame_type == 251) {
                dataOutputStream.writeShort(this.byte_code_offset);
            } else if (this.frame_type >= 252 && this.frame_type <= 254) {
                dataOutputStream.writeShort(this.byte_code_offset);
                for (StackMapType stackMapType : this.types_of_locals) {
                    stackMapType.dump(dataOutputStream);
                }
            } else if (this.frame_type == 255) {
                dataOutputStream.writeShort(this.byte_code_offset);
                dataOutputStream.writeShort(this.types_of_locals.length);
                for (StackMapType stackMapType : this.types_of_locals) {
                    stackMapType.dump(dataOutputStream);
                }
                dataOutputStream.writeShort(this.types_of_stack_items.length);
                for (StackMapType stackMapType : this.types_of_stack_items) {
                    stackMapType.dump(dataOutputStream);
                }
            } else {
                throw new ClassFormatException("Invalid Stack map table tag: " + this.frame_type);
            }
        }
    }

    public String toString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append("(");
        if (this.frame_type >= 0 && this.frame_type <= 63) {
            stringBuilder.append("SAME");
        } else if (this.frame_type >= 64 && this.frame_type <= 127) {
            stringBuilder.append("SAME_LOCALS_1_STACK");
        } else if (this.frame_type == 247) {
            stringBuilder.append("SAME_LOCALS_1_STACK_EXTENDED");
        } else if (this.frame_type >= 248 && this.frame_type <= 250) {
            stringBuilder.append("CHOP ").append(String.valueOf(251 - this.frame_type));
        } else if (this.frame_type == 251) {
            stringBuilder.append("SAME_EXTENDED");
        } else if (this.frame_type >= 252 && this.frame_type <= 254) {
            stringBuilder.append("APPEND ").append(String.valueOf(this.frame_type - 251));
        } else if (this.frame_type == 255) {
            stringBuilder.append("FULL");
        } else {
            stringBuilder.append("UNKNOWN (").append(this.frame_type).append(")");
        }
        stringBuilder.append(", offset delta=").append(this.byte_code_offset);
        if (this.types_of_locals.length > 0) {
            stringBuilder.append(", locals={");
            for (n = 0; n < this.types_of_locals.length; ++n) {
                stringBuilder.append(this.types_of_locals[n]);
                if (n >= this.types_of_locals.length - 1) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append("}");
        }
        if (this.types_of_stack_items.length > 0) {
            stringBuilder.append(", stack items={");
            for (n = 0; n < this.types_of_stack_items.length; ++n) {
                stringBuilder.append(this.types_of_stack_items[n]);
                if (n >= this.types_of_stack_items.length - 1) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append("}");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    int getMapEntrySize() {
        if (this.frame_type >= 0 && this.frame_type <= 63) {
            return 1;
        }
        if (this.frame_type >= 64 && this.frame_type <= 127) {
            return 1 + (this.types_of_stack_items[0].hasIndex() ? 3 : 1);
        }
        if (this.frame_type == 247) {
            return 3 + (this.types_of_stack_items[0].hasIndex() ? 3 : 1);
        }
        if (this.frame_type >= 248 && this.frame_type <= 250) {
            return 3;
        }
        if (this.frame_type == 251) {
            return 3;
        }
        if (this.frame_type >= 252 && this.frame_type <= 254) {
            int n = 3;
            for (StackMapType stackMapType : this.types_of_locals) {
                n += stackMapType.hasIndex() ? 3 : 1;
            }
            return n;
        }
        if (this.frame_type == 255) {
            int n = 7;
            for (StackMapType stackMapType : this.types_of_locals) {
                n += stackMapType.hasIndex() ? 3 : 1;
            }
            for (StackMapType stackMapType : this.types_of_stack_items) {
                n += stackMapType.hasIndex() ? 3 : 1;
            }
            return n;
        }
        throw new RuntimeException("Invalid StackMap frame_type: " + this.frame_type);
    }

    public void setFrameType(int n) {
        if (n >= 0 && n <= 63) {
            this.byte_code_offset = n - 0;
        } else if (n >= 64 && n <= 127) {
            this.byte_code_offset = n - 64;
        } else if (!(n == 247 || n >= 248 && n <= 250 || n == 251 || n >= 252 && n <= 254 || n == 255)) {
            throw new RuntimeException("Invalid StackMap frame_type");
        }
        this.frame_type = n;
    }

    public int getFrameType() {
        return this.frame_type;
    }

    public void setByteCodeOffset(int n) {
        if (n < 0 || n > Short.MAX_VALUE) {
            throw new RuntimeException("Invalid StackMap offset: " + n);
        }
        if (this.frame_type >= 0 && this.frame_type <= 63) {
            this.frame_type = n > 63 ? 251 : n;
        } else if (this.frame_type >= 64 && this.frame_type <= 127) {
            this.frame_type = n > 63 ? 247 : 64 + n;
        } else if (!(this.frame_type == 247 || this.frame_type >= 248 && this.frame_type <= 250 || this.frame_type == 251 || this.frame_type >= 252 && this.frame_type <= 254 || this.frame_type == 255)) {
            throw new RuntimeException("Invalid StackMap frame_type: " + this.frame_type);
        }
        this.byte_code_offset = n;
    }

    public void updateByteCodeOffset(int n) {
        this.setByteCodeOffset(this.byte_code_offset + n);
    }

    public int getByteCodeOffset() {
        return this.byte_code_offset;
    }

    @Deprecated
    public void setNumberOfLocals(int n) {
    }

    public int getNumberOfLocals() {
        return this.types_of_locals.length;
    }

    public void setTypesOfLocals(StackMapType[] stackMapTypeArray) {
        this.types_of_locals = stackMapTypeArray != null ? stackMapTypeArray : new StackMapType[]{};
    }

    public StackMapType[] getTypesOfLocals() {
        return this.types_of_locals;
    }

    @Deprecated
    public void setNumberOfStackItems(int n) {
    }

    public int getNumberOfStackItems() {
        return this.types_of_stack_items.length;
    }

    public void setTypesOfStackItems(StackMapType[] stackMapTypeArray) {
        this.types_of_stack_items = stackMapTypeArray != null ? stackMapTypeArray : new StackMapType[]{};
    }

    public StackMapType[] getTypesOfStackItems() {
        return this.types_of_stack_items;
    }

    public StackMapEntry copy() {
        int n;
        StackMapEntry stackMapEntry;
        try {
            stackMapEntry = (StackMapEntry)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("Clone Not Supported");
        }
        stackMapEntry.types_of_locals = new StackMapType[this.types_of_locals.length];
        for (n = 0; n < this.types_of_locals.length; ++n) {
            stackMapEntry.types_of_locals[n] = this.types_of_locals[n].copy();
        }
        stackMapEntry.types_of_stack_items = new StackMapType[this.types_of_stack_items.length];
        for (n = 0; n < this.types_of_stack_items.length; ++n) {
            stackMapEntry.types_of_stack_items[n] = this.types_of_stack_items[n].copy();
        }
        return stackMapEntry;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitStackMapEntry(this);
    }

    public ConstantPool getConstantPool() {
        return this.constant_pool;
    }

    public void setConstantPool(ConstantPool constantPool) {
        this.constant_pool = constantPool;
    }
}

