/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.StackMapEntry;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class StackMap
extends Attribute {
    private StackMapEntry[] map;

    public StackMap(int n, int n2, StackMapEntry[] stackMapEntryArray, ConstantPool constantPool) {
        super((byte)11, n, n2, constantPool);
        this.map = stackMapEntryArray;
    }

    StackMap(int n, int n2, DataInput dataInput, ConstantPool constantPool) throws IOException {
        this(n, n2, (StackMapEntry[])null, constantPool);
        int n3 = dataInput.readUnsignedShort();
        this.map = new StackMapEntry[n3];
        for (int i = 0; i < n3; ++i) {
            this.map[i] = new StackMapEntry(dataInput, constantPool);
        }
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.map.length);
        for (StackMapEntry stackMapEntry : this.map) {
            stackMapEntry.dump(dataOutputStream);
        }
    }

    public StackMapEntry[] getStackMap() {
        return this.map;
    }

    public void setStackMap(StackMapEntry[] stackMapEntryArray) {
        this.map = stackMapEntryArray;
        int n = 2;
        for (StackMapEntry stackMapEntry : stackMapEntryArray) {
            n += stackMapEntry.getMapEntrySize();
        }
        this.setLength(n);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("StackMap(");
        for (int i = 0; i < this.map.length; ++i) {
            stringBuilder.append(this.map[i]);
            if (i >= this.map.length - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    @Override
    public Attribute copy(ConstantPool constantPool) {
        StackMap stackMap = (StackMap)this.clone();
        stackMap.map = new StackMapEntry[this.map.length];
        for (int i = 0; i < this.map.length; ++i) {
            stackMap.map[i] = this.map[i].copy();
        }
        stackMap.setConstantPool(constantPool);
        return stackMap;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitStackMap(this);
    }

    public int getMapLength() {
        return this.map == null ? 0 : this.map.length;
    }
}

