/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Node;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ModuleRequires
implements Cloneable,
Node {
    private final int requires_index;
    private final int requires_flags;
    private final int requires_version_index;

    ModuleRequires(DataInput dataInput) throws IOException {
        this.requires_index = dataInput.readUnsignedShort();
        this.requires_flags = dataInput.readUnsignedShort();
        this.requires_version_index = dataInput.readUnsignedShort();
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitModuleRequires(this);
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.requires_index);
        dataOutputStream.writeShort(this.requires_flags);
        dataOutputStream.writeShort(this.requires_version_index);
    }

    public String toString() {
        return "requires(" + this.requires_index + ", " + String.format("%04x", this.requires_flags) + ", " + this.requires_version_index + ")";
    }

    public String toString(ConstantPool constantPool) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = constantPool.constantToString(this.requires_index, (byte)19);
        stringBuilder.append(Utility.compactClassName(string, false));
        stringBuilder.append(", ").append(String.format("%04x", this.requires_flags));
        String string2 = this.requires_version_index == 0 ? "0" : constantPool.getConstantString(this.requires_version_index, (byte)1);
        stringBuilder.append(", ").append(string2);
        return stringBuilder.toString();
    }

    public ModuleRequires copy() {
        try {
            return (ModuleRequires)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

