/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.LocalVariable;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public class LocalVariableTable
extends Attribute {
    private LocalVariable[] local_variable_table;

    public LocalVariableTable(LocalVariableTable localVariableTable) {
        this(localVariableTable.getNameIndex(), localVariableTable.getLength(), localVariableTable.getLocalVariableTable(), localVariableTable.getConstantPool());
    }

    public LocalVariableTable(int n, int n2, LocalVariable[] localVariableArray, ConstantPool constantPool) {
        super((byte)5, n, n2, constantPool);
        this.local_variable_table = localVariableArray;
    }

    LocalVariableTable(int n, int n2, DataInput dataInput, ConstantPool constantPool) throws IOException {
        this(n, n2, (LocalVariable[])null, constantPool);
        int n3 = dataInput.readUnsignedShort();
        this.local_variable_table = new LocalVariable[n3];
        for (int i = 0; i < n3; ++i) {
            this.local_variable_table[i] = new LocalVariable(dataInput, constantPool);
        }
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitLocalVariableTable(this);
    }

    @Override
    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.local_variable_table.length);
        for (LocalVariable localVariable : this.local_variable_table) {
            localVariable.dump(dataOutputStream);
        }
    }

    public final LocalVariable[] getLocalVariableTable() {
        return this.local_variable_table;
    }

    @Deprecated
    public final LocalVariable getLocalVariable(int n) {
        for (LocalVariable localVariable : this.local_variable_table) {
            if (localVariable.getIndex() != n) continue;
            return localVariable;
        }
        return null;
    }

    public final LocalVariable getLocalVariable(int n, int n2) {
        for (LocalVariable localVariable : this.local_variable_table) {
            if (localVariable.getIndex() != n) continue;
            int n3 = localVariable.getStartPC();
            int n4 = n3 + localVariable.getLength();
            if (n2 < n3 || n2 > n4) continue;
            return localVariable;
        }
        return null;
    }

    public final void setLocalVariableTable(LocalVariable[] localVariableArray) {
        this.local_variable_table = localVariableArray;
    }

    @Override
    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.local_variable_table.length; ++i) {
            stringBuilder.append(this.local_variable_table[i]);
            if (i >= this.local_variable_table.length - 1) continue;
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    @Override
    public Attribute copy(ConstantPool constantPool) {
        LocalVariableTable localVariableTable = (LocalVariableTable)this.clone();
        localVariableTable.local_variable_table = new LocalVariable[this.local_variable_table.length];
        for (int i = 0; i < this.local_variable_table.length; ++i) {
            localVariableTable.local_variable_table[i] = this.local_variable_table[i].copy();
        }
        localVariableTable.setConstantPool(constantPool);
        return localVariableTable;
    }

    public final int getTableLength() {
        return this.local_variable_table == null ? 0 : this.local_variable_table.length;
    }
}

