/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Node;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class LineNumber
implements Cloneable,
Node {
    private short start_pc;
    private short line_number;

    public LineNumber(LineNumber lineNumber) {
        this(lineNumber.getStartPC(), lineNumber.getLineNumber());
    }

    LineNumber(DataInput dataInput) throws IOException {
        this(dataInput.readUnsignedShort(), dataInput.readUnsignedShort());
    }

    public LineNumber(int n, int n2) {
        this.start_pc = (short)n;
        this.line_number = (short)n2;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitLineNumber(this);
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.start_pc);
        dataOutputStream.writeShort(this.line_number);
    }

    public int getLineNumber() {
        return 0xFFFF & this.line_number;
    }

    public int getStartPC() {
        return 0xFFFF & this.start_pc;
    }

    public void setLineNumber(int n) {
        this.line_number = (short)n;
    }

    public void setStartPC(int n) {
        this.start_pc = (short)n;
    }

    public String toString() {
        return "LineNumber(" + this.start_pc + ", " + this.line_number + ")";
    }

    public LineNumber copy() {
        try {
            return (LineNumber)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

