/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.InnerClass;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class InnerClasses
extends Attribute {
    private InnerClass[] inner_classes;

    public InnerClasses(InnerClasses innerClasses) {
        this(innerClasses.getNameIndex(), innerClasses.getLength(), innerClasses.getInnerClasses(), innerClasses.getConstantPool());
    }

    public InnerClasses(int n, int n2, InnerClass[] innerClassArray, ConstantPool constantPool) {
        super((byte)6, n, n2, constantPool);
        this.inner_classes = innerClassArray != null ? innerClassArray : new InnerClass[]{};
    }

    InnerClasses(int n, int n2, DataInput dataInput, ConstantPool constantPool) throws IOException {
        this(n, n2, (InnerClass[])null, constantPool);
        int n3 = dataInput.readUnsignedShort();
        this.inner_classes = new InnerClass[n3];
        for (int i = 0; i < n3; ++i) {
            this.inner_classes[i] = new InnerClass(dataInput);
        }
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitInnerClasses(this);
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.inner_classes.length);
        for (InnerClass innerClass : this.inner_classes) {
            innerClass.dump(dataOutputStream);
        }
    }

    public InnerClass[] getInnerClasses() {
        return this.inner_classes;
    }

    public void setInnerClasses(InnerClass[] innerClassArray) {
        this.inner_classes = innerClassArray != null ? innerClassArray : new InnerClass[]{};
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("InnerClasses(");
        stringBuilder.append(this.inner_classes.length);
        stringBuilder.append("):\n");
        for (InnerClass innerClass : this.inner_classes) {
            stringBuilder.append(innerClass.toString(super.getConstantPool())).append("\n");
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    @Override
    public Attribute copy(ConstantPool constantPool) {
        InnerClasses innerClasses = (InnerClasses)this.clone();
        innerClasses.inner_classes = new InnerClass[this.inner_classes.length];
        for (int i = 0; i < this.inner_classes.length; ++i) {
            innerClasses.inner_classes[i] = this.inner_classes[i].copy();
        }
        innerClasses.setConstantPool(constantPool);
        return innerClasses;
    }
}

