/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantClass;
import com.sun.org.apache.bcel.internal.classfile.ConstantNameAndType;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public class EnclosingMethod
extends Attribute {
    private int classIndex;
    private int methodIndex;

    EnclosingMethod(int n, int n2, DataInput dataInput, ConstantPool constantPool) throws IOException {
        this(n, n2, dataInput.readUnsignedShort(), dataInput.readUnsignedShort(), constantPool);
    }

    private EnclosingMethod(int n, int n2, int n3, int n4, ConstantPool constantPool) {
        super((byte)18, n, n2, constantPool);
        this.classIndex = n3;
        this.methodIndex = n4;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitEnclosingMethod(this);
    }

    @Override
    public Attribute copy(ConstantPool constantPool) {
        return (Attribute)this.clone();
    }

    public final int getEnclosingClassIndex() {
        return this.classIndex;
    }

    public final int getEnclosingMethodIndex() {
        return this.methodIndex;
    }

    public final void setEnclosingClassIndex(int n) {
        this.classIndex = n;
    }

    public final void setEnclosingMethodIndex(int n) {
        this.methodIndex = n;
    }

    public final ConstantClass getEnclosingClass() {
        ConstantClass constantClass = (ConstantClass)super.getConstantPool().getConstant(this.classIndex, (byte)7);
        return constantClass;
    }

    public final ConstantNameAndType getEnclosingMethod() {
        if (this.methodIndex == 0) {
            return null;
        }
        ConstantNameAndType constantNameAndType = (ConstantNameAndType)super.getConstantPool().getConstant(this.methodIndex, (byte)12);
        return constantNameAndType;
    }

    @Override
    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.classIndex);
        dataOutputStream.writeShort(this.methodIndex);
    }
}

