/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ClassFormatException;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Field;
import com.sun.org.apache.bcel.internal.classfile.JavaClass;
import com.sun.org.apache.bcel.internal.classfile.Method;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class ClassParser {
    private DataInputStream dataInputStream;
    private final boolean fileOwned;
    private final String file_name;
    private String zip_file;
    private int class_name_index;
    private int superclass_name_index;
    private int major;
    private int minor;
    private int access_flags;
    private int[] interfaces;
    private ConstantPool constant_pool;
    private Field[] fields;
    private Method[] methods;
    private Attribute[] attributes;
    private final boolean is_zip;
    private static final int BUFSIZE = 8192;

    public ClassParser(InputStream inputStream, String string) {
        this.file_name = string;
        this.fileOwned = false;
        String string2 = inputStream.getClass().getName();
        this.is_zip = string2.startsWith("java.util.zip.") || string2.startsWith("java.util.jar.");
        this.dataInputStream = inputStream instanceof DataInputStream ? (DataInputStream)inputStream : new DataInputStream(new BufferedInputStream(inputStream, 8192));
    }

    public ClassParser(String string) {
        this.is_zip = false;
        this.file_name = string;
        this.fileOwned = true;
    }

    public ClassParser(String string, String string2) {
        this.is_zip = true;
        this.fileOwned = true;
        this.zip_file = string;
        this.file_name = string2;
    }

    public JavaClass parse() throws IOException, ClassFormatException {
        ZipFile zipFile = null;
        try {
            if (this.fileOwned) {
                if (this.is_zip) {
                    zipFile = new ZipFile(this.zip_file);
                    ZipEntry zipEntry = zipFile.getEntry(this.file_name);
                    if (zipEntry == null) {
                        throw new IOException("File " + this.file_name + " not found");
                    }
                    this.dataInputStream = new DataInputStream(new BufferedInputStream(zipFile.getInputStream(zipEntry), 8192));
                } else {
                    this.dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(this.file_name), 8192));
                }
            }
            this.readID();
            this.readVersion();
            this.readConstantPool();
            this.readClassInfo();
            this.readInterfaces();
            this.readFields();
            this.readMethods();
            this.readAttributes();
        }
        finally {
            if (this.fileOwned) {
                try {
                    if (this.dataInputStream != null) {
                        this.dataInputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (IOException iOException) {}
        }
        return new JavaClass(this.class_name_index, this.superclass_name_index, this.file_name, this.major, this.minor, this.access_flags, this.constant_pool, this.interfaces, this.fields, this.methods, this.attributes, this.is_zip ? (byte)3 : 2);
    }

    private void readAttributes() throws IOException, ClassFormatException {
        int n = this.dataInputStream.readUnsignedShort();
        this.attributes = new Attribute[n];
        for (int i = 0; i < n; ++i) {
            this.attributes[i] = Attribute.readAttribute(this.dataInputStream, this.constant_pool);
        }
    }

    private void readClassInfo() throws IOException, ClassFormatException {
        this.access_flags = this.dataInputStream.readUnsignedShort();
        if ((this.access_flags & 0x200) != 0) {
            this.access_flags |= 0x400;
        }
        if ((this.access_flags & 0x400) != 0 && (this.access_flags & 0x10) != 0) {
            throw new ClassFormatException("Class " + this.file_name + " can't be both final and abstract");
        }
        this.class_name_index = this.dataInputStream.readUnsignedShort();
        this.superclass_name_index = this.dataInputStream.readUnsignedShort();
    }

    private void readConstantPool() throws IOException, ClassFormatException {
        this.constant_pool = new ConstantPool(this.dataInputStream);
    }

    private void readFields() throws IOException, ClassFormatException {
        int n = this.dataInputStream.readUnsignedShort();
        this.fields = new Field[n];
        for (int i = 0; i < n; ++i) {
            this.fields[i] = new Field((DataInput)this.dataInputStream, this.constant_pool);
        }
    }

    private void readID() throws IOException, ClassFormatException {
        if (this.dataInputStream.readInt() != -889275714) {
            throw new ClassFormatException(this.file_name + " is not a Java .class file");
        }
    }

    private void readInterfaces() throws IOException, ClassFormatException {
        int n = this.dataInputStream.readUnsignedShort();
        this.interfaces = new int[n];
        for (int i = 0; i < n; ++i) {
            this.interfaces[i] = this.dataInputStream.readUnsignedShort();
        }
    }

    private void readMethods() throws IOException, ClassFormatException {
        int n = this.dataInputStream.readUnsignedShort();
        this.methods = new Method[n];
        for (int i = 0; i < n; ++i) {
            this.methods[i] = new Method((DataInput)this.dataInputStream, this.constant_pool);
        }
    }

    private void readVersion() throws IOException, ClassFormatException {
        this.minor = this.dataInputStream.readUnsignedShort();
        this.major = this.dataInputStream.readUnsignedShort();
    }
}

