/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ec;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.EllipticCurve;
import java.util.Optional;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;
import sun.security.ec.ECKeyFactory;
import sun.security.ec.ECOperations;
import sun.security.ec.ECPrivateKeyImpl;
import sun.security.ec.ECPublicKeyImpl;
import sun.security.ec.point.AffinePoint;
import sun.security.ec.point.MutablePoint;
import sun.security.util.ArrayUtil;
import sun.security.util.ECUtil;
import sun.security.util.math.ImmutableIntegerModuloP;
import sun.security.util.math.IntegerFieldModuloP;
import sun.security.util.math.MutableIntegerModuloP;
import sun.security.util.math.SmallValue;

public final class ECDHKeyAgreement
extends KeyAgreementSpi {
    private ECPrivateKey privateKey;
    private ECPublicKey publicKey;
    private int secretLen;

    @Override
    protected void engineInit(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        if (!(key instanceof PrivateKey)) {
            throw new InvalidKeyException("Key must be instance of PrivateKey");
        }
        this.privateKey = (ECPrivateKey)ECKeyFactory.toECKey(key);
        this.publicKey = null;
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("Parameters not supported");
        }
        this.engineInit(key, secureRandom);
    }

    @Override
    protected Key engineDoPhase(Key key, boolean bl) throws InvalidKeyException, IllegalStateException {
        if (this.privateKey == null) {
            throw new IllegalStateException("Not initialized");
        }
        if (this.publicKey != null) {
            throw new IllegalStateException("Phase already executed");
        }
        if (!bl) {
            throw new IllegalStateException("Only two party agreement supported, lastPhase must be true");
        }
        if (!(key instanceof ECPublicKey)) {
            throw new InvalidKeyException("Key must be a PublicKey with algorithm EC");
        }
        this.publicKey = (ECPublicKey)key;
        ECParameterSpec eCParameterSpec = this.publicKey.getParams();
        int n = eCParameterSpec.getCurve().getField().getFieldSize();
        this.secretLen = n + 7 >> 3;
        return null;
    }

    private static void validateCoordinate(BigInteger bigInteger, BigInteger bigInteger2) {
        if (bigInteger.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalStateException("invalid coordinate");
        }
        if (bigInteger.compareTo(bigInteger2) >= 0) {
            throw new IllegalStateException("invalid coordinate");
        }
    }

    private static void validate(ECOperations eCOperations, ECPublicKey eCPublicKey) {
        BigInteger bigInteger = eCPublicKey.getW().getAffineX();
        BigInteger bigInteger2 = eCPublicKey.getW().getAffineY();
        BigInteger bigInteger3 = eCOperations.getField().getSize();
        ECDHKeyAgreement.validateCoordinate(bigInteger, bigInteger3);
        ECDHKeyAgreement.validateCoordinate(bigInteger2, bigInteger3);
        EllipticCurve ellipticCurve = eCPublicKey.getParams().getCurve();
        BigInteger bigInteger4 = bigInteger.modPow(BigInteger.valueOf(3L), bigInteger3).add(ellipticCurve.getA().multiply(bigInteger)).add(ellipticCurve.getB()).mod(bigInteger3);
        BigInteger bigInteger5 = bigInteger2.modPow(BigInteger.valueOf(2L), bigInteger3).mod(bigInteger3);
        if (!bigInteger4.equals(bigInteger5)) {
            throw new IllegalStateException("point is not on curve");
        }
        ImmutableIntegerModuloP immutableIntegerModuloP = eCOperations.getField().getElement(bigInteger);
        ImmutableIntegerModuloP immutableIntegerModuloP2 = eCOperations.getField().getElement(bigInteger2);
        AffinePoint affinePoint = new AffinePoint(immutableIntegerModuloP, immutableIntegerModuloP2);
        byte[] byArray = eCPublicKey.getParams().getOrder().toByteArray();
        ArrayUtil.reverse(byArray);
        MutablePoint mutablePoint = eCOperations.multiply(affinePoint, byArray);
        if (!eCOperations.isNeutral(mutablePoint)) {
            throw new IllegalStateException("point has incorrect order");
        }
    }

    @Override
    protected byte[] engineGenerateSecret() throws IllegalStateException {
        if (this.privateKey == null || this.publicKey == null) {
            throw new IllegalStateException("Not initialized correctly");
        }
        Optional<byte[]> optional = ECDHKeyAgreement.deriveKeyImpl(this.privateKey, this.publicKey);
        byte[] byArray = optional.orElseGet(() -> ECDHKeyAgreement.deriveKeyNative(this.privateKey, this.publicKey));
        return byArray;
    }

    @Override
    protected int engineGenerateSecret(byte[] byArray, int n) throws IllegalStateException, ShortBufferException {
        if (n + this.secretLen > byArray.length) {
            throw new ShortBufferException("Need " + this.secretLen + " bytes, only " + (byArray.length - n) + " available");
        }
        byte[] byArray2 = this.engineGenerateSecret();
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        return byArray2.length;
    }

    @Override
    protected SecretKey engineGenerateSecret(String string) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        if (string == null) {
            throw new NoSuchAlgorithmException("Algorithm must not be null");
        }
        if (!string.equals("TlsPremasterSecret")) {
            throw new NoSuchAlgorithmException("Only supported for algorithm TlsPremasterSecret");
        }
        return new SecretKeySpec(this.engineGenerateSecret(), "TlsPremasterSecret");
    }

    private static Optional<byte[]> deriveKeyImpl(ECPrivateKey eCPrivateKey, ECPublicKey eCPublicKey) {
        ECParameterSpec eCParameterSpec = eCPrivateKey.getParams();
        EllipticCurve ellipticCurve = eCParameterSpec.getCurve();
        Optional<ECOperations> optional = ECOperations.forParameters(eCParameterSpec);
        if (!optional.isPresent()) {
            return Optional.empty();
        }
        ECOperations eCOperations = optional.get();
        if (!(eCPrivateKey instanceof ECPrivateKeyImpl)) {
            return Optional.empty();
        }
        ECPrivateKeyImpl eCPrivateKeyImpl = (ECPrivateKeyImpl)eCPrivateKey;
        byte[] byArray = eCPrivateKeyImpl.getArrayS();
        ECDHKeyAgreement.validate(eCOperations, eCPublicKey);
        IntegerFieldModuloP integerFieldModuloP = eCOperations.getField();
        MutableIntegerModuloP mutableIntegerModuloP = integerFieldModuloP.getElement(byArray).mutable();
        SmallValue smallValue = integerFieldModuloP.getSmallValue(eCPrivateKey.getParams().getCofactor());
        mutableIntegerModuloP.setProduct(smallValue);
        int n = (ellipticCurve.getField().getFieldSize() + 7) / 8;
        byte[] byArray2 = mutableIntegerModuloP.asByteArray(n);
        ImmutableIntegerModuloP immutableIntegerModuloP = integerFieldModuloP.getElement(eCPublicKey.getW().getAffineX());
        ImmutableIntegerModuloP immutableIntegerModuloP2 = integerFieldModuloP.getElement(eCPublicKey.getW().getAffineY());
        AffinePoint affinePoint = new AffinePoint(immutableIntegerModuloP, immutableIntegerModuloP2);
        MutablePoint mutablePoint = eCOperations.multiply(affinePoint, byArray2);
        if (eCOperations.isNeutral(mutablePoint)) {
            throw new IllegalStateException("Product is zero");
        }
        AffinePoint affinePoint2 = mutablePoint.asAffine();
        byte[] byArray3 = affinePoint2.getX().asByteArray(n);
        ArrayUtil.reverse(byArray3);
        return Optional.of(byArray3);
    }

    private static byte[] deriveKeyNative(ECPrivateKey eCPrivateKey, ECPublicKey eCPublicKey) {
        byte[] byArray;
        ECParameterSpec eCParameterSpec = eCPrivateKey.getParams();
        byte[] byArray2 = eCPrivateKey.getS().toByteArray();
        byte[] byArray3 = ECUtil.encodeECParameterSpec(null, eCParameterSpec);
        if (eCPublicKey instanceof ECPublicKeyImpl) {
            ECPublicKeyImpl eCPublicKeyImpl = (ECPublicKeyImpl)eCPublicKey;
            byArray = eCPublicKeyImpl.getEncodedPublicValue();
        } else {
            byArray = ECUtil.encodePoint(eCPublicKey.getW(), eCParameterSpec.getCurve());
        }
        try {
            return ECDHKeyAgreement.deriveKey(byArray2, byArray, byArray3);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IllegalStateException("Could not derive key", generalSecurityException);
        }
    }

    private static native byte[] deriveKey(byte[] var0, byte[] var1, byte[] var2) throws GeneralSecurityException;
}

