---
title: Introduction
order: 0
redirect_from:
  - /en/docs/manual
---

G2Plot is an interactive and responsive charting library based on the grammar of graphics, which enables users to generate high quality statistical charts through a few lines of code easily. G2 in "G2Plot" means the grammar of graphics and pays homage to ggplot2.

[![Version](https://badgen.net/npm/v/@antv/g2plot)](https://www.npmjs.com/@antv/g2plot)
[![NPM downloads](https://img.shields.io/npm/dm/@antv/g2plot.svg)](https://npmjs.com/@antv/g2plot)
![Latest commit](https://badgen.net/github/last-commit/antvis/G2Plot)
[![build Status](https://github.com/antvis/G2Plot/workflows/build/badge.svg?branch=master)](https://github.com/antvis/G2Plot/actions?query=workflow%3Abuild)
[![coverage](https://img.shields.io/coveralls/antvis/G2Plot/master.svg)](https://coveralls.io/github/antvis/G2Plot)
[![Percentage of issues still open](http://isitmaintained.com/badge/open/antvis/g2plot.svg)](http://isitmaintained.com/project/antvis/g2plot "Percentage of issues still open")
[![Average time to resolve an issue](http://isitmaintained.com/badge/resolution/antvis/g2plot.svg)](http://isitmaintained.com/project/antvis/g2plot "Average time to resolve an issue")

## Features

- 📦 Pretty and high-quality charts out of box

- 🎨 Visual language and design specification extracted from enterprise products

- 📊 Responsive charts

- 🔳 Story-telling charts

<img alt="Image loading failed" src="https://gw.alipayobjects.com/mdn/rms_d314dd/afts/img/A*sXqrRrEwFRQAAAAAAAAAAABkARQnAQ" width="800">

## Installation

```bash
$ npm install @antv/g2plot
```

## Usage

```html
<div id="container"></div>
```

<playground path='bar/basic/demo/basic.ts' rid='basic-bar-demo'></playground>

## Development

```bash
# install dependences
$ npm install

# run test case
$ npm run test

# build & run website with watching file changes
$ npm run start
```
