---
title: 玫瑰图
order: 13
---

### 图表容器

`markdown:docs/common/chart-options.zh.md`

### 数据映射

#### data

<description>**required** _array object_</description>

设置图表数据源。数据源为对象集合，例如：

```ts
[
  { year: '2001', population: 41.8 },
  { year: '2002', population: 38 },
  { year: '2003', population: 33.7 },
  { year: '2004', population: 30.7 },
  { year: '2005', population: 25.8 },
  { year: '2006', population: 31.7 },
  { year: '2007', population: 33 },
  { year: '2008', population: 46 },
  { year: '2009', population: 38.3 },
  { year: '2010', population: 28 },
  { year: '2011', population: 42.5 },
  { year: '2012', population: 30.3 },
];
```

`markdown:docs/common/xy-field.zh.md`

#### meta

`markdown:docs/common/meta.zh.md`

```ts
const data = [
  { year: '2001', population: 41.8 },
  { year: '2002', population: 38 },
  { year: '2003', population: 33.7 },
  { year: '2004', population: 30.7 },
  { year: '2005', population: 25.8 },
  { year: '2006', population: 31.7 },
];

const rosePlot = new Rose('container', {
  data,
  xField: 'year',
  yField: 'population',
  meta: {
    year: {
      alias: '年份',
      // 只显示 2001、2002、2003 年份的信息
      values: ['2001', '2002', '2003'],
      // 转换结果类似于 “2001年”
      formatter: (v) => {
        return `${v}年`;
      },
    },
  },
  seriesField: 'year',
});

piePlot.render();
```

#### seriesField

<description>**optional** _string_</description>

用于对数据进行分组的字段，比如想根据某个字段内容的不同显示不同的颜色，就可以把该字段的名字设为`seriesField`的值。

#### isGroup

<description>**optional** _string_ _default:_ `false`</description>

是否分组玫瑰图。

#### isStack

<description>**optional** _string_ _default:_ `false`</description>

是否堆积玫瑰图。

### 图形样式

#### radius

<description>**optional** _number_</description>

玫瑰图的半径，原点为画布中心。配置值域为 (0,1]，1 代表玫瑰图撑满绘图区域。

#### innerRadius

<description>**optional** _number_</description>

玫瑰图内部空心圆的半径，规则与 radius 一致。

#### startAngle

<description>**optional** _number_ _default:_ `(Math.PI * 0) / 180`</description>

配置坐标系的起始角度。

#### endAngle

<description>**optional** _number_ _default:_ `(Math.PI * 180) / 180`</description>

配置坐标系的结束角度。

`markdown:docs/common/color.zh.md`

#### pattern ✨

<description>**optional** _object | Function_</description>

`markdown:docs/common/pattern.zh.md`

#### sectorStyle

<description>**optional** _object | Function_</description>

设置扇形样式。sectorStyle 中的`fill`会覆盖 `color` 的配置。sectorStyle 可以直接指定，也可以通过 callback 的方式，根据数据为每个扇形切片指定单独的样式。

`markdown:docs/common/shape-style.zh.md`

#### state

<description>**可选** _object_</description>

`markdown:docs/common/state-style.zh.md`

### 图表组件

`markdown:docs/common/component.zh.md`

### 图表事件

`markdown:docs/common/events.zh.md`

### 图表方法

`markdown:docs/common/chart-methods.zh.md`

### 图表主题

`markdown:docs/common/theme.zh.md`

### 图表交互

`markdown:docs/common/interactions.zh.md`