//欢迎使用CSPE自定义光影

/*
根据《中华人民共和国著作权法》第一章第二条，第三条第四框的内容，
本着色器版权在著作权法法律保护范围之内，任何对本着色器的盗用和非法挪用，
根据《中华人民共和国著作权法》第一章第八条，著作人有权对侵权者和侵权行为提起诉讼。
*/

/*
根据《中华人民共和国著作权法》第二章第一节第十条（六），
著作者有出售或者赠与方式向公众提供作品的原件或者复制件的权利。
任何倒卖，非法传播的行为，只要被查处，我们将会依法进行维权。
*/

//请尊重作者权益！

//在修改前，请先*仔细阅读条款*

//1.修改后的光影发布或者整合必须注明使用苦力怕光影自定义光影，*严禁改名发布*！

//2.请按照注释修改，否则将会出错

//3.修改光影时请使用浮点数，也就是*小数*。
//例如*1要写成1.0*

//4.修改方法，光影用光的三原色进行调色，格式是vec3(红，绿，蓝)；
//例如:纯红色vec3(1.0,0.0,0.0);
//纯蓝色vec3(0.0,0.0,1.0);
//大声告诉我纯绿色是什么？！

//下面是自定义修改区域

//本光影是自定义光影回归的第一个版本，支持自定义的内容较少，后续将会加入更多自定义内容，请见谅！谢谢！

//光照颜色修改
// day-白天 dusk-黄昏 night-晚上 rain-雨天 nether-地狱 end-末地 unw-水下
vec3 day_color =vec3(1.85,1.78,1.63);
vec3 dusk_color =vec3(1.85,1.25,0.85);
vec3 night_color =vec3(0.16,0.4,0.68);
vec3 rain_color =vec3(0.55);
vec3 nether_color=vec3(0.65,0.42,0.25)*0.8;
vec3 end_color =vec3(0.3,0.45,0.50);
vec3 unw_color =vec3(0.25,0.45,0.7);

//阴影颜色修改
vec3 sh_color =vec3(0.925,1.157,1.385);
vec3 dark_sh_color =vec3(0.1,0.1,0.1);

//光源颜色修改
//l-主世界 nether-地狱 end-末地 unw-水下
vec3 l_color =vec3(0.58,0.24,0.0);
vec3 unw_l_color =vec3(0.3,0.5,0.7);
vec3 nether_l_color =vec3(0.90,0.5,0.0);
vec3 end_l_color =vec3(0.3,0.0,0.5 );

//天空颜色修改（会影响水反射颜色）
//day-白天 dusk-黄昏 night-晚上 rain-雨天
vec3 sky_day_color = vec3(0.01,0.2,0.55);
vec3 sky_dusk_color = vec3(1.0,0.2,0.0);
vec3 sky_night_color = vec3(0.0,0.15,0.35);
vec3 sky_rain_color = vec3(0.5);

//云颜色修改（会影响水反射颜色）
//day-白天 dusk-黄昏 night-晚上 rain-雨天
vec3 cloud_day_color =vec3(1.0);
vec3 cloud_night_color =vec3(0.05,0.1,0.2);
vec3 cloud_dusk_color =vec3(1.5,1.2,0.8);
vec3 cloud_rain_color =vec3(0.8);

//警告
//警告，以下部分如果不会写光影最好不要修改！
//警告

#include "shaders/uniformPerFrameConstants.h"
#include "shaders/uniformEntityConstants.h"

highp float maps(highp float x, highp float z){
highp float r0 = sin(x+(z*0.5+(x-10.0+TIME*0.1)))*0.1;
highp float r1 = sin(z+(x*0.5+(z-10.0+TIME*0.5)))*0.1;
highp float r2 = sin(x+cos(z+sin(x+z+TIME*0.2)));
highp float r3 = cos(z+sin(x+sin(z+x+TIME*0.6)));
highp float r4 = sin(r0-cos(r2+sin(r0)));
highp float r5 = cos(r1-cos(r3+sin(r1+TIME*0.3)));
return sin(r0+r1-r2+r3-r4+r5);
}

highp float clouds(highp vec3 pos,vec4 flag){
//flag =vec4(0.0,0.01)水 vec4(1.0)天
highp float sky_aa =pow(length(pos),1.0);
POS3 cp = (pos-sky_aa) * vec3(15.0);
highp float random0=(cos(pos.x*8.0+TIME*0.2)*26.0+sin(pos.z*5.0+TIME*0.1)*28.0);
highp float random1=(cos(pos.z*9.0+TIME*0.2)*25.0+sin(pos.x*8.0+TIME*0.2)*29.0);
highp float random =(random0-random1)*0.2*flag.r;
highp float c_x = cp.x*0.6*flag.g+TIME*0.2;
highp float c_z = cp.z*0.7*flag.g+TIME*0.1;
highp float s0 = sin(c_x*2.0+c_z*1.5-random+TIME*0.5)* 1.7+sin(c_x*1.5-c_z*0.6-random+TIME*0.4)+cos(-c_z*2.3+c_x*2.8-random+TIME*1.2);
highp float s1 = cos(c_x*2.9+c_z*0.9-random+TIME*0.2)* 1.7+cos(c_x*1.8-c_z*1.2-random+TIME*1.3)-sin(-c_z*0.9+c_x*2.0-random+TIME*0.8);
highp float st0 = maps(c_x,c_z*1.5)-maps(s0,3.14)*0.4;
highp float st1 = maps(c_x,c_z*1.5)-maps(s1,3.14)*0.4;
highp float c0 = sin(c_x*1.9+c_z*1.13+random+TIME*1.3)* 1.7+sin(c_x*1.2-c_z*2.6+random+TIME*1.2)+cos(-c_z*1.3+c_x*2.8+random+TIME*0.5);
highp float c1 = cos(c_x*0.9+c_z*1.9+random+TIME*0.8)* 1.7+cos(c_x*0.8-c_z*1.3+random+TIME*0.6)-sin(-c_z*0.9+c_x*2.0+random+TIME*1.2);
highp float cs0 = maps(c_x,c_z*1.5)-maps(c0,3.14)*0.4;
highp float cs1 = maps(c_x,c_z*1.5)-maps(c1,3.14)*0.4;
return (1.0-(st0+st1+(cs0+cs1)*flag.r))*0.10;
}
highp vec4 sky(highp vec3 pos,float flag){
highp float sky_a =length(pos);
float f_pos =length(-pos)/FAR_CHUNKS_DISTANCE;
float night_f =pow(max(min(1.0-FOG_COLOR.r*1.5,1.0),0.0),0.3);
float dusk_f =pow(max(min(1.0-FOG_COLOR.b*1.2,1.0),0.0),0.5);
float rain_f =(1.0-pow(FOG_CONTROL.y,2.0));
vec4 sky_color =vec4(mix(mix(mix(sky_day_color,sky_dusk_color,dusk_f),sky_night_color,night_f),sky_rain_color,rain_f),1.0);
vec4 cloud_color =vec4(mix(mix(mix(cloud_day_color,cloud_dusk_color,dusk_f),cloud_night_color,night_f),cloud_rain_color,rain_f),1.0);

highp vec4 sky =sky_color;
if(flag==1.0){
sky=mix(sky_color, FOG_COLOR, pow(clamp(sky_a*1.3,0.0,1.0),0.9));
sky=mix( sky, FOG_COLOR, pow(clamp(sky_a*1.3,0.0,1.0),1.0));
sky=mix( sky, FOG_COLOR, pow(clamp(sky_a*1.3,0.0,1.0),1.0));
sky=mix( sky, cloud_color, max(0.0,min(1.0,(clouds(pos,vec4(1.0)))*1.4)-pow(sky_a+0.2,5.0)));
}
else if(flag==0.0){
sky=mix(sky_color*1.5, FOG_COLOR, min(max(pow(f_pos,0.5),0.0),1.0));
sky=mix( sky, cloud_color, max(0.0,min(1.0,(clouds(pos,vec4(0.0,0.01,0.0,0.0)))*2.0-f_pos*0.5)));
}
return sky;
}

highp vec4 waterRender(vec4 color,highp vec3 w_pos,vec3 v_pos,vec2 uv1){
float night_f =pow(max(min(1.0-FOG_COLOR.r*1.5,1.0),0.0),0.3);
highp float w_x = (w_pos.x+w_pos.z)*1.2+TIME*0.2;
highp float w_z = w_pos.z*0.1+TIME*0.1;
highp float w0 = sin(w_x*0.5+w_z*6.03+TIME*1.0)* 1.7+sin(w_x*1.0-w_z*2.6+TIME*1.1);
highp float w1 = cos(w_x*0.9+w_z*2.9+TIME*1.8)* 1.7+cos(w_x*0.8-w_z*5.3+TIME*2.1);
highp float w2 = sin(w_x*1.0+w_z*3.53+TIME*1.5)* 1.7+sin(w_x*1.2-w_z*4.6+TIME*1.1);
highp float ws0 = maps(w2,w1)*0.6;
highp float ws1 = maps(w0,w2)*0.5;
highp float ws2 = maps(w1,w0)*0.4;
float f_pos =length(-v_pos)/FAR_CHUNKS_DISTANCE;
highp vec4 water_color =mix(color*vec4(0.5,0.5,0.55,1.0),vec4(0.4,0.4,0.55,0.0),0.5)-(night_f*0.2)-ws0*ws1*0.1;
float ahp =0.0;
if(uv1.y>=0.895244){
    ahp =min(max(mix(abs(ws2*ws0)*0.7,abs(0.8-ws2*ws0)*2.0+abs(ws2*ws0)*0.2,f_pos),0.0),1.0)*0.9;
    }
    else{
    water_color*=vec4(0.7,0.7,0.8,1.2);
    }
water_color =mix(water_color,sky(v_pos,0.0),ahp);
water_color+=vec4(l_color,0.1)*pow(uv1.x*1.5,5.0)*abs(ws2*ws0)*4.0;
return water_color;
}

highp float shadowSet(vec4 sh_set,float x_sh_f,float f_sh_f,float no_sh_f){
highp float sh_a =1.0;
if((f_sh_f>=0.0&&f_sh_f<sh_set.r) || (x_sh_f<sh_set.g&&no_sh_f!=1.0)){
sh_a=0.0;
}
else if((f_sh_f>=0.0&&f_sh_f<sh_set.b)|| (x_sh_f<sh_set.a&&no_sh_f!=1.0)){
sh_a=min((f_sh_f-sh_set.r)*(x_sh_f-sh_set.g)*400.0,1.0);
}
else{
sh_a=1.0;
}
return sh_a;
}

highp vec4 blockRender(vec4 diffuse,vec4 color,vec4 light_f,highp vec3 w_pos,vec3 v_pos,highp vec2 uv1){
float x_sh_f =color.a;
float f_sh_f =uv1.y;
float rain_f =(1.0-pow(FOG_CONTROL.y,5.0));
float night_f = min(pow(1.0-light_f.r,2.0)*2.0,1.0);
float dusk_f = pow(min(max((1.0-pow(light_f.r,10.0))*2.0,0.0),1.0),3.0);
float fog_f =length(-v_pos)/FAR_CHUNKS_DISTANCE;
float snow_lea_f =0.0;
float water_f =0.0;
float no_sh_f =0.0;

vec4 world_light =vec4(mix(mix(mix(day_color,dusk_color,dusk_f),night_color,night_f),rain_color-vec3(night_f*0.4),rain_f),1.0);
vec4 shadow =vec4(dark_sh_color+uv1.y*world_light.rgb*vec3(0.54,0.56,0.61)*sh_color*1.1,1.0);
vec4 light_color =vec4(l_color,0.2);
vec4 f_color=mix(vec4(0.2,0.2,0.4,1.0),vec4(0.65,0.65,1.0,1.0)*FOG_COLOR,min(f_sh_f*1.5,1.0));

#ifndef SEASONS
#else
snow_lea_f =1.0;
f_sh_f *=1.03;
world_light*=1.25;
#endif

vec4 sh_set = vec4(0.875244,0.64,0.894244,0.75);
if(uv1.y>=0.0&&color.a==0.0&&snow_lea_f!=1.0){
x_sh_f = pow((color.g*2.3+color.r*0.3+color.b*1.2)*0.7,5.0);
f_sh_f+=0.005;
world_light*=1.25;
}
if(((FOG_COLOR.r>FOG_COLOR.g)&&(FOG_COLOR.b>FOG_COLOR.g)&&(FOG_COLOR.b>FOG_COLOR.r))&&(FOG_COLOR.r<0.05&&FOG_COLOR.b<0.05&&FOG_COLOR.g<0.05)){
sh_set =vec4(0.0,0.0,0.0,0.90);
world_light=vec4(end_color,1.0);
shadow=vec4(end_color,1.0);
light_color=vec4(end_l_color,0.2);
f_color =FOG_COLOR;
fog_f*=0.6;
}
if((FOG_COLOR.b==FOG_COLOR.g)&&(FOG_COLOR.b*2.0<FOG_COLOR.r)){//nether
sh_set =vec4(0.0,0.0,0.0,0.65);
world_light=vec4(nether_color,1.0);
shadow=vec4(nether_color,1.0);
light_color=vec4(nether_l_color,0.2);
f_color =FOG_COLOR;
}
if((FOG_COLOR.r==FOG_COLOR.g)&&(FOG_COLOR.b>FOG_COLOR.r*1.2)){
sh_set =vec4(0.0);
vec4 unw_light =vec4((world_light.rgb+0.3)*unw_color*(uv1.y+0.4),0.8);
world_light=unw_light;
light_color=vec4(unw_l_color,0.2);
f_color =FOG_COLOR;
fog_f*=3.5;
}
float sh_a =shadowSet(sh_set,x_sh_f,f_sh_f,no_sh_f);
world_light =mix(shadow,world_light,sh_a);
vec4 light=light_color*max(1.8-world_light.r,0.0)*pow(uv1.x*(sin(TIME*10.0)*0.015+1.6),3.0);
vec4 bright_light =vec4(day_color,0.0)*(0.05+night_f*0.05)*sh_a*(1.0-uv1.x*night_f);
vec4 render =(diffuse+bright_light)*(world_light+light)*0.9;
render =mix(render,f_color,fog_f*0.37);

highp vec4 water =waterRender(color,w_pos,v_pos,uv1);
#ifdef NEAR_WATER
render = water;
#endif
#ifdef FOG
if(((color.r*1.5<=color.b)&&(color.b>=color.g*1.05))&&color.a>=0.0&&snow_lea_f!=1.0){
render = water;
}
#endif
return render;
}

vec4 entityRender(vec4 diffuse,vec4 color,vec4 light_f,vec3 w_pos,vec3 v_pos,float L){
float x_sh_f =color.a;
float f_sh_f =TILE_LIGHT_COLOR.r;
float rain_f =(1.0-pow(FOG_CONTROL.y,5.0));
float night_f = min(pow(1.0-light_f.r,2.0)*2.0,1.0);
float dusk_f = pow(min(max((1.0-pow(light_f.r,10.0))*2.0,0.0),1.0),3.0);
float fog_f =length(-v_pos)/FAR_CHUNKS_DISTANCE;
float snow_lea_f =0.0;
float water_f =0.0;
float no_sh_f =0.0;

#ifdef ITEM_IN_HAND
night_f = min(pow(1.0-f_sh_f,2.0)*2.0,1.0);
dusk_f = 0.0;
#endif

vec4 world_light =vec4(day_color*0.7,1.0);
vec4 light_color =vec4(l_color,0.2);
vec4 f_color=mix(vec4(0.2,0.2,0.4,1.0),vec4(0.65,0.65,1.0,1.0)*FOG_COLOR,min(f_sh_f*1.5,1.0));
if(rain_f>=0.0){
world_light =vec4(mix(mix(mix(day_color,dusk_color,dusk_f),night_color,night_f),rain_color-vec3(night_f*0.4),rain_f),1.0)*0.9;
}
vec4 shadow =vec4(dark_sh_color+f_sh_f*world_light.rgb*vec3(0.54,0.56,0.61)*sh_color*1.1,1.0)*0.7;

vec4 sh_set =mix(mix(vec4(0.85,0.95,1.0,1.3)*1.06,vec4(0.85,0.95,1.0,1.3)*0.48,dusk_f),vec4(0.85,0.95,0.88,0.98)*(0.325),night_f);

#ifdef ITEM_IN_HAND
sh_set =vec4(0.95,0.95,1.12,1.12)*1.05;
x_sh_f=L;
f_sh_f=L;
#endif

if(((FOG_COLOR.r>FOG_COLOR.g)&&(FOG_COLOR.b>FOG_COLOR.g)&&(FOG_COLOR.b>FOG_COLOR.r))&&(FOG_COLOR.r<0.05&&FOG_COLOR.b<0.05&&FOG_COLOR.g<0.05)){
sh_set =vec4(0.0,0.95,0.0,1.0);
world_light=vec4(end_color,1.0);
shadow=vec4(end_color,1.0);
//light_color=vec4(end_l_color,0.2);
f_color =FOG_COLOR;
fog_f*=0.6;
}
if((FOG_COLOR.b==FOG_COLOR.g)&&(FOG_COLOR.b*2.0<FOG_COLOR.r)){//nether
sh_set =vec4(0.0,1.0,0.0,1.2);
world_light=vec4(nether_color,1.0);
shadow=vec4(nether_color,1.0);
//light_color=vec4(nether_l_color,0.2);
f_color =FOG_COLOR;
}
if((FOG_COLOR.r==FOG_COLOR.g)&&(FOG_COLOR.b>FOG_COLOR.r*1.2)){
sh_set =vec4(0.0);
vec4 unw_light =vec4((world_light.rgb+0.3)*unw_color*(f_sh_f+0.4),0.8);
world_light=unw_light;
//light_color=vec4(unw_l_color,0.2);
f_color =FOG_COLOR;
fog_f*=3.5;
}

float sh_a =shadowSet(sh_set,x_sh_f,f_sh_f,no_sh_f);
world_light =mix(shadow,world_light,sh_a);
vec4 bright_light =vec4(day_color,0.0)*(0.05+night_f*0.05)*sh_a*(1.0-f_sh_f*night_f);
vec4 render =(diffuse+bright_light)*(world_light)*0.9;
render =mix(render,f_color,fog_f*0.37);
return render;
}


#if __VERSION__ >= 300

#include "shaders/uniformShaderConstants.h"

vec4 texture2D_AA(in sampler2D tex, in highp vec2 uv)
{
	// Texture antialiasing
	//
	// The texture coordinates are modified so that the bilinear filter will be one pixel wide instead of one texel wide. 

	// Get the UV deltas
	highp vec2 dUVdx = dFdx(uv) * TEXTURE_DIMENSIONS.xy;
	highp vec2 dUVdy = dFdy(uv) * TEXTURE_DIMENSIONS.xy;
	highp vec2 dU = vec2(dUVdx.x, dUVdy.x);
	highp vec2 dV = vec2(dUVdx.y, dUVdy.y);

	highp float duUV = sqrt(dot(dU, dU));
	highp float dvUV = sqrt(dot(dV, dV));

	// Determine mip map LOD
	highp float d = max(dot(dUVdx, dUVdx), dot(dUVdy, dUVdy));
	highp float mipLevel = .5 * log2(d);
	mipLevel = mipLevel + .5;	// Mip bias to reduce aliasing
	mipLevel = clamp(mipLevel, 0.0, TEXTURE_DIMENSIONS.z);

	highp vec2 uvModified;
	if( mipLevel >= 1.0)
	{
		uvModified = uv;
	}
	else
	{
		// First scale the uv so that each texel has a uv range of [0,1]
		highp vec2 texelUV = fract(uv * TEXTURE_DIMENSIONS.xy);

		// Initially set uvModified to the floor of the texel position
		uvModified = (uv * TEXTURE_DIMENSIONS.xy) - texelUV;

		// Modify the texelUV to push the uvs toward the edges.
		//          |                 |       |                   |
		//          |         _/      |       |           /       |
		//  Change  | U     _/        |  to   | U     ___/        |
		//          |     _/          |       |     /             |
		//          |    /            |       |    /              |
		//          |         X       |       |         X         |
		highp float scalerU = 1.0 / (duUV);
		highp float scalerV = 1.0 / (dvUV);
		highp vec2 scaler = max(vec2(scalerU, scalerV), 1.0);
		texelUV = clamp(texelUV * scaler, 0.0, .5) + clamp(texelUV*scaler - (scaler - .5), 0.0, .5);
		uvModified += texelUV;
		uvModified /= TEXTURE_DIMENSIONS.xy;
	}
	vec4 diffuse = texture2D(tex, uvModified);
	return diffuse;

}

#endif //__VERSION__ >= 300
