/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.theTitans.render;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.BossStatus;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.titan.EntityEnderColossus;
import net.minecraft.theTitans.models.ModelEnderColossus;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderEnderColossus
extends RenderLiving {
    private static final ResourceLocation enderColossusCrystalBeamTextures = new ResourceLocation("thetitans", "textures/entities/endercrystal_beam.png");
    private static final ResourceLocation endermanEyesTexture = new ResourceLocation("thetitans", "textures/entities/titans/ender_colossus_eyes.png");
    private static final ResourceLocation endermanTextures = new ResourceLocation("thetitans", "textures/entities/titans/ender_colossus.png");
    private static final ResourceLocation endermanEyesDeadTexture = new ResourceLocation("thetitans", "textures/entities/titans/ender_colossus_eyes_dead.png");
    private static final ResourceLocation endermanDeadTextures = new ResourceLocation("thetitans", "textures/entities/titans/ender_colossus_dead.png");
    private ModelEnderColossus endermanModel;
    private Random rnd = new Random();

    public RenderEnderColossus() {
        super((ModelBase)new ModelEnderColossus(), 1.0f);
        this.endermanModel = (ModelEnderColossus)this.field_77045_g;
        this.func_77042_a(this.endermanModel);
    }

    protected void func_180592_a(EntityEnderColossus p_180592_1_, float p_180592_2_) {
        float f1 = 20.0f;
        int i = p_180592_1_.getInvulTime();
        if (i > 0) {
            f1 -= ((float)i - p_180592_2_) / 440.0f * 7.75f;
        }
        GL11.glScalef((float)f1, (float)f1, (float)f1);
        GL11.glTranslatef((float)0.0f, (float)0.1f, (float)0.0f);
        if (p_180592_1_.field_70154_o != null) {
            GL11.glTranslatef((float)0.0f, (float)0.1f, (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
    }

    protected void func_77041_b(EntityLivingBase p_77041_1_, float p_77041_2_) {
        this.func_180592_a((EntityEnderColossus)p_77041_1_, p_77041_2_);
    }

    protected void func_180588_a(EntityEnderColossus p_180588_1_, float p_180588_2_, float p_180588_3_, float p_180588_4_) {
        super.func_77043_a((EntityLivingBase)p_180588_1_, p_180588_2_, p_180588_3_, p_180588_4_);
    }

    protected void func_77043_a(EntityLivingBase p_77043_1_, float p_77043_2_, float p_77043_3_, float p_77043_4_) {
        this.func_180588_a((EntityEnderColossus)p_77043_1_, p_77043_2_, p_77043_3_, p_77043_4_);
    }

    public void doRender(EntityEnderColossus entity, double x, double y, double z, float p_76986_8_, float partialTicks) {
        this.endermanModel.isAttacking = entity.isScreaming();
        BossStatus.func_82824_a((IBossDisplayData)entity, (boolean)true);
        super.func_76986_a((EntityLiving)entity, x, y, z, p_76986_8_, partialTicks);
        if (entity.healingEnderCrystal != null) {
            float f2 = (float)entity.healingEnderCrystal.innerRotation + partialTicks;
            float f3 = MathHelper.func_76126_a((float)(f2 * 0.2f)) / 2.0f + 0.5f;
            f3 = (f3 * f3 + f3) * 0.2f;
            float f4 = (float)(entity.healingEnderCrystal.field_70165_t - entity.field_70165_t - (entity.field_70169_q - entity.field_70165_t) * (double)(1.0f - partialTicks));
            float f5 = (float)((double)f3 + entity.healingEnderCrystal.field_70163_u - (double)entity.func_70047_e() + 0.75 - entity.field_70163_u - (entity.field_70167_r - entity.field_70163_u) * (double)(1.0f - partialTicks));
            float f6 = (float)(entity.healingEnderCrystal.field_70161_v - entity.field_70161_v - (entity.field_70166_s - entity.field_70161_v) * (double)(1.0f - partialTicks));
            float f7 = MathHelper.func_76129_c((float)(f4 * f4 + f6 * f6));
            float f8 = MathHelper.func_76129_c((float)(f4 * f4 + f5 * f5 + f6 * f6));
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)x), (float)((float)y + entity.func_70047_e()), (float)((float)z));
            GL11.glRotatef((float)((float)(-Math.atan2(f6, f4)) * 180.0f / (float)Math.PI - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)((float)(-Math.atan2(f7, f5)) * 180.0f / (float)Math.PI - 90.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            Tessellator tessellator = Tessellator.field_78398_a;
            RenderHelper.func_74518_a();
            GL11.glDisable((int)2884);
            this.func_110776_a(enderColossusCrystalBeamTextures);
            GL11.glShadeModel((int)7425);
            float f9 = 0.0f - ((float)entity.field_70173_aa + partialTicks) * 0.01f;
            float f10 = MathHelper.func_76129_c((float)(f4 * f4 + f5 * f5 + f6 * f6)) / 32.0f - ((float)entity.field_70173_aa + partialTicks) * 0.01f;
            tessellator.func_78371_b(5);
            int b0 = 32;
            for (int i = 0; i <= b0; ++i) {
                float f11 = MathHelper.func_76126_a((float)((float)(i % b0) * (float)Math.PI * 2.0f / (float)b0)) * 0.75f;
                float f12 = MathHelper.func_76134_b((float)((float)(i % b0) * (float)Math.PI * 2.0f / (float)b0)) * 0.75f;
                float f13 = (float)(i % b0) * 1.0f / (float)b0;
                tessellator.func_78378_d(0);
                tessellator.func_78374_a((double)(f11 * 0.2f), (double)(f12 * 0.2f), 0.0, (double)f13, (double)f10);
                tessellator.func_78378_d(0xFFFFFF);
                tessellator.func_78374_a((double)f11, (double)f12, (double)f8, (double)f13, (double)f9);
            }
            tessellator.func_78381_a();
            GL11.glEnable((int)2884);
            GL11.glShadeModel((int)7424);
            RenderHelper.func_74519_b();
            GL11.glPopMatrix();
        }
    }

    protected int shouldRenderPass(EntityEnderColossus p_77032_1_, int p_77032_2_, float p_77032_3_) {
        if (p_77032_2_ != 0) {
            return -1;
        }
        if (p_77032_1_.getAnimID() == 10 && p_77032_1_.deathTicks > 160) {
            this.func_110776_a(endermanEyesDeadTexture);
        } else {
            this.func_110776_a(endermanEyesTexture);
        }
        float f1 = 2.0f;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glBlendFunc((int)1, (int)1);
        GL11.glDisable((int)2896);
        if (p_77032_1_.func_82150_aj()) {
            GL11.glDepthMask((boolean)false);
        } else {
            GL11.glDepthMask((boolean)true);
        }
        int c0 = 61680;
        int j = c0 % 65536;
        int k = c0 / 65536;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)j / 1.0f), (float)((float)k / 1.0f));
        GL11.glEnable((int)2896);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)f1);
        return 1;
    }

    protected int func_77032_a(EntityLivingBase p_77032_1_, int p_77032_2_, float p_77032_3_) {
        return this.shouldRenderPass((EntityEnderColossus)p_77032_1_, p_77032_2_, p_77032_3_);
    }

    protected ResourceLocation func_180573_a(EntityEnderColossus p_180573_1_) {
        return p_180573_1_.getAnimID() == 10 && p_180573_1_.deathTicks > 200 ? endermanDeadTextures : endermanTextures;
    }

    public void func_76986_a(EntityLiving entity, double x, double y, double z, float p_76986_8_, float partialTicks) {
        this.doRender((EntityEnderColossus)entity, x, y, z, p_76986_8_, partialTicks);
    }

    public void func_76986_a(EntityLivingBase entity, double x, double y, double z, float p_76986_8_, float partialTicks) {
        this.doRender((EntityEnderColossus)entity, x, y, z, p_76986_8_, partialTicks);
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        return this.func_180573_a((EntityEnderColossus)entity);
    }

    public void func_76986_a(Entity entity, double x, double y, double z, float p_76986_8_, float partialTicks) {
        this.doRender((EntityEnderColossus)entity, x, y, z, p_76986_8_, partialTicks);
    }
}

