/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.titanminion;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityWitherSkull;
import net.minecraft.entity.titan.EntityEnderColossus;
import net.minecraft.entity.titan.EntityTitan;
import net.minecraft.entity.titan.EntityTitanSpirit;
import net.minecraft.entity.titan.ITitan;
import net.minecraft.entity.titan.ai.EntityAIBreakDoorMinion;
import net.minecraft.entity.titan.ai.EntityAINearestTargetTitan;
import net.minecraft.entity.titanminion.EntityDragonMinion;
import net.minecraft.entity.titanminion.EnumMinionType;
import net.minecraft.entity.titanminion.IMinion;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.theTitans.TheTitans;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;

public class EntityEndermanLoyalist
extends EntityMob
implements IMinion {
    private static final UUID attackingSpeedBoostModifierUUID = UUID.fromString("020E0DFB-87AE-4653-9556-831010E291A0");
    private static final AttributeModifier attackingSpeedBoostModifier = new AttributeModifier(attackingSpeedBoostModifierUUID, "Attacking speed boost", (double)0.15f, 0).func_111168_a(false);
    @Deprecated
    private static boolean[] carriableBlocks = new boolean[256];
    private boolean isAggressive;
    public EntityLiving master;
    public int randomSoundDelay;
    private static IdentityHashMap<Block, Boolean> carriable;

    public EntityEndermanLoyalist(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.5f, 2.88f);
        if (this.field_70163_u <= 1.0) {
            this.field_70163_u = 1.0;
        }
        this.field_70138_W = 1.0f;
        this.func_70661_as().func_75498_b(true);
        this.func_70661_as().func_75490_c(true);
        this.func_70661_as().func_75495_e(true);
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityWitherSkull.class, 2.0f, 1.0, 1.75));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityTitanSpirit.class, 48.0f, 1.5, 1.5));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIBreakDoorMinion((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.2));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.5));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 16.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        if (TheTitans.TitansFFAMode) {
            this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan((EntityCreature)this, EntityLivingBase.class, 0, false, false, ITitan.EnderColossusSorter));
        } else {
            this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan((EntityCreature)this, EntityLiving.class, 0, false, false, ITitan.SearchForAThingToKill));
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.master != null && this.master instanceof EntityTitan) {
            ((EntityTitan)this.master).retractMinionNumFromType(this.getMinionType());
        }
    }

    @Override
    public EnumMinionType getMinionType() {
        return EnumMinionType.LOYALIST;
    }

    public boolean func_70650_aV() {
        return true;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(7.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
    }

    public boolean func_70686_a(Class p_70686_1_) {
        return p_70686_1_ != EntityEndermanLoyalist.class && p_70686_1_ != EntityEnderColossus.class && p_70686_1_ != EntityDragon.class && p_70686_1_ != EntityDragonMinion.class;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)new Byte(0));
        this.field_70180_af.func_75682_a(17, (Object)new Byte(0));
        this.field_70180_af.func_75682_a(18, (Object)new Byte(0));
    }

    public void func_70014_b(NBTTagCompound p_70014_1_) {
        super.func_70014_b(p_70014_1_);
        p_70014_1_.func_74777_a("carried", (short)Block.func_149682_b((Block)this.func_146080_bZ()));
        p_70014_1_.func_74777_a("carriedData", (short)this.getCarryingData());
    }

    public void func_70037_a(NBTTagCompound p_70037_1_) {
        super.func_70037_a(p_70037_1_);
        this.func_146081_a(Block.func_149729_e((int)p_70037_1_.func_74765_d("carried")));
        this.setCarryingData(p_70037_1_.func_74765_d("carriedData"));
    }

    protected Entity findPlayerToLookAt() {
        EntityPlayer entityplayer = this.field_70170_p.func_72890_a((Entity)this, 64.0);
        if (entityplayer != null && this.isPlayerRegistered(entityplayer) && !entityplayer.field_71075_bZ.field_75102_a && this.func_70638_az() == null) {
            this.func_85030_a("mob.endermen.stare", 10.0f, 1.0f);
            this.setScreaming(true);
            this.func_70624_b((EntityLivingBase)entityplayer);
            this.func_70625_a((Entity)entityplayer, 180.0f, 180.0f);
        }
        return null;
    }

    protected boolean isPlayerRegistered(EntityPlayer p_70821_1_) {
        ItemStack itemstack = p_70821_1_.field_71071_by.field_70460_b[3];
        if (itemstack != null && itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150423_aK)) {
            return false;
        }
        Vec3 vec3 = p_70821_1_.func_70676_i(1.0f).func_72432_b();
        Vec3 vec31 = Vec3.func_72443_a((double)(this.field_70165_t - p_70821_1_.field_70165_t), (double)(this.field_70121_D.field_72338_b + (double)this.func_70047_e() - (p_70821_1_.field_70163_u + (double)p_70821_1_.func_70047_e())), (double)(this.field_70161_v - p_70821_1_.field_70161_v));
        double d0 = vec31.func_72433_c();
        double d1 = vec3.func_72430_b(vec31 = vec31.func_72432_b());
        return d1 > 1.0 - 0.025 / d0 ? p_70821_1_.func_70685_l((Entity)this) : false;
    }

    public float func_70047_e() {
        return 2.55f;
    }

    public void func_70636_d() {
        float f;
        this.findPlayerToLookAt();
        if (this.func_70638_az() != null && this.func_70638_az().func_70068_e((Entity)this) > 256.0 && this.field_70173_aa % 30 == 0 && !this.field_70170_p.field_72995_K) {
            this.teleportToEntity((Entity)this.func_70638_az());
        }
        if (this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K && (f = this.func_70013_c(1.0f)) > 0.5f && this.field_70170_p.func_72937_j(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v)) && this.field_70146_Z.nextFloat() * 30.0f < (f - 0.4f) * 2.0f) {
            this.field_70789_a = null;
            this.setScreaming(false);
            this.isAggressive = false;
            this.teleportRandomly();
        }
        if ((this.func_70026_G() || this.func_70027_ad()) && this.getMinionType() != EnumMinionType.TEMPLAR) {
            this.func_70624_b(null);
            this.setScreaming(true);
            this.isAggressive = false;
            this.teleportRandomly();
        }
        if (this.func_70026_G() && this.getMinionType() != EnumMinionType.TEMPLAR) {
            this.setScreaming(true);
            this.teleportRandomly();
            this.func_70097_a(DamageSource.field_76370_b, 4.0f);
            this.field_70737_aN = 1;
            this.field_70721_aZ = 1.5f;
            if (this.field_70170_p.field_72995_K) {
                for (int i = 0; i < 15; ++i) {
                    if (this.func_110143_aJ() <= 20.0f) {
                        this.field_70170_p.func_72869_a("lava", this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0);
                    } else {
                        this.field_70170_p.func_72869_a("flame", this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0);
                    }
                    this.field_70170_p.func_72869_a("largesmoke", this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0);
                }
            }
            if (this.field_70146_Z.nextInt(10) == 0) {
                this.func_70015_d(1);
            }
            if ((this.field_70146_Z.nextInt(60) == 0 || this.field_70146_Z.nextInt(10) == 0 && this.func_110143_aJ() <= 15.0f) && !this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t + (this.field_70146_Z.nextDouble() * 1.0 - 0.5), this.field_70163_u + this.field_70146_Z.nextDouble() * 3.0, this.field_70161_v + (this.field_70146_Z.nextDouble() * 1.0 - 0.5), 0.0f, true, true);
            }
            if ((this.field_70146_Z.nextInt(1000) == 0 || this.func_110143_aJ() <= 1.0f) && !this.field_70170_p.field_72995_K) {
                this.func_85030_a(this.func_70673_aS(), this.func_70599_aP(), this.func_70647_i());
                this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, 2.0f, true, true);
                this.field_70181_x += 3.0;
                this.func_70097_a(DamageSource.field_76370_b, Float.MAX_VALUE);
            }
        }
        if (this.func_70638_az() != null) {
            this.setScreaming(true);
            this.isAggressive = true;
        } else if (!this.func_70026_G() && !this.func_70027_ad() && this.func_110143_aJ() <= this.func_110138_aP() / 10.0f) {
            this.setScreaming(false);
            this.isAggressive = false;
        }
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_72869_a("portal", this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
            }
        }
        this.field_70703_bu = false;
        if (this.func_70638_az() != null && this.func_70681_au().nextInt(20) == 0 && this.func_70638_az().func_70068_e((Entity)this) < 2.0 && !this.field_70170_p.field_72995_K) {
            this.teleportRandomly();
        }
        if (this.master != null && this.func_70068_e((Entity)this.master) > 1024.0 && !this.field_70170_p.field_72995_K) {
            this.teleportToEntity((Entity)this.master);
        }
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
            if (this.func_146080_bZ().func_149688_o() == Material.field_151579_a) {
                int j;
                int i;
                int k = MathHelper.func_76128_c((double)(this.field_70165_t - 2.0 + this.field_70146_Z.nextDouble() * 4.0));
                Block block = this.field_70170_p.func_147439_a(k, i = MathHelper.func_76128_c((double)(this.field_70163_u + this.field_70146_Z.nextDouble() * 3.0)), j = MathHelper.func_76128_c((double)(this.field_70161_v - 2.0 + this.field_70146_Z.nextDouble() * 4.0)));
                if (EntityEnderman.getCarriable((Block)block)) {
                    this.func_146081_a(block);
                    this.setCarryingData(this.field_70170_p.func_72805_g(k, i, j));
                    this.field_70170_p.func_147449_b(k, i, j, Blocks.field_150350_a);
                }
            } else if (this.field_70146_Z.nextInt(2000) == 0) {
                int k = MathHelper.func_76128_c((double)(this.field_70165_t - 1.0 + this.field_70146_Z.nextDouble() * 2.0));
                int i = MathHelper.func_76128_c((double)(this.field_70163_u + this.field_70146_Z.nextDouble() * 2.0));
                int j = MathHelper.func_76128_c((double)(this.field_70161_v - 1.0 + this.field_70146_Z.nextDouble() * 2.0));
                Block block = this.field_70170_p.func_147439_a(k, i, j);
                Block block1 = this.field_70170_p.func_147439_a(k, i - 1, j);
                if (block.func_149688_o() == Material.field_151579_a && block1.func_149688_o() != Material.field_151579_a && block1.func_149686_d()) {
                    this.field_70170_p.func_147465_d(k, i, j, this.func_146080_bZ(), this.getCarryingData(), 3);
                    this.func_146081_a(Blocks.field_150350_a);
                }
            }
        }
        super.func_70636_d();
    }

    protected void func_70619_bc() {
        if (this.randomSoundDelay > 0 && --this.randomSoundDelay == 0) {
            this.func_85030_a("mob.endermen.scream", this.func_70599_aP(), this.func_70647_i() + 0.25f);
        }
        if (this.field_70123_F && this.master != null) {
            this.field_70181_x = 0.2;
        }
        if (this.func_70638_az() != null && !this.func_70638_az().func_70089_S()) {
            this.func_70624_b(null);
        }
        if (this.master != null) {
            if (this.master.func_70638_az() != null && this.master.func_70638_az().field_70131_O < 4.0f) {
                this.func_70624_b(this.master.func_70638_az());
            }
        } else {
            List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(256.0, 256.0, 256.0));
            if (list != null && !list.isEmpty()) {
                for (int i1 = 0; i1 < list.size(); ++i1) {
                    Entity entity = (Entity)list.get(i1);
                    if (entity == null || !(entity instanceof EntityEnderColossus)) continue;
                    this.master = (EntityEnderColossus)entity;
                }
            }
        }
        super.func_70619_bc();
    }

    protected boolean teleportRandomly() {
        double d0 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        double d1 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(64) - 32);
        double d2 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        return this.teleportTo(d0, d1, d2);
    }

    protected boolean teleportToEntity(Entity p_70816_1_) {
        Vec3 vec3 = Vec3.func_72443_a((double)(this.field_70165_t - p_70816_1_.field_70165_t), (double)(this.field_70121_D.field_72338_b + (double)(this.field_70131_O / 2.0f) - p_70816_1_.field_70163_u + (double)p_70816_1_.func_70047_e()), (double)(this.field_70161_v - p_70816_1_.field_70161_v));
        vec3 = vec3.func_72432_b();
        double d0 = 16.0;
        double d1 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3.field_72450_a * d0;
        double d2 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(16) - 8) - vec3.field_72448_b * d0;
        double d3 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3.field_72449_c * d0;
        return this.teleportTo(d1, d2, d3);
    }

    protected boolean teleportTo(double p_70825_1_, double p_70825_3_, double p_70825_5_) {
        int k;
        int j;
        EnderTeleportEvent event = new EnderTeleportEvent((EntityLivingBase)this, p_70825_1_, p_70825_3_, p_70825_5_, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        double d3 = this.field_70165_t;
        double d4 = this.field_70163_u;
        double d5 = this.field_70161_v;
        this.field_70165_t = event.targetX;
        this.field_70163_u = event.targetY;
        this.field_70161_v = event.targetZ;
        boolean flag = false;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        if (this.field_70170_p.func_72899_e(i, j = MathHelper.func_76128_c((double)this.field_70163_u), k = MathHelper.func_76128_c((double)this.field_70161_v))) {
            boolean flag1 = false;
            while (!flag1 && j > 0) {
                Block block = this.field_70170_p.func_147439_a(i, j - 1, k);
                if (block.func_149688_o().func_76230_c()) {
                    flag1 = true;
                    continue;
                }
                this.field_70163_u -= 1.0;
                --j;
            }
            if (flag1) {
                this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                if (this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).isEmpty() && !this.field_70170_p.func_72953_d(this.field_70121_D)) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            this.func_70107_b(d3, d4, d5);
            return false;
        }
        int short1 = 128;
        for (int l = 0; l < short1; ++l) {
            double d6 = (double)l / ((double)short1 - 1.0);
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            double d7 = d3 + (this.field_70165_t - d3) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            double d8 = d4 + (this.field_70163_u - d4) * d6 + this.field_70146_Z.nextDouble() * (double)this.field_70131_O;
            double d9 = d5 + (this.field_70161_v - d5) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            this.field_70170_p.func_72869_a("portal", d7, d8, d9, (double)f, (double)f1, (double)f2);
            if (!this.func_70026_G()) continue;
            if (this.func_110143_aJ() <= 20.0f) {
                this.field_70170_p.func_72869_a("lava", d7, d8, d9, (double)f, (double)f1, (double)f2);
            } else {
                this.field_70170_p.func_72869_a("flame", d7, d8, d9, (double)f, (double)f1, (double)f2);
            }
            this.field_70170_p.func_72869_a("largesmoke", d7, d8, d9, (double)f, (double)f1, (double)f2);
        }
        this.field_70170_p.func_72908_a(d3, d4, d5, "mob.endermen.portal", 1.0f, 1.0f);
        this.func_85030_a("mob.endermen.portal", 1.0f, 1.0f);
        return true;
    }

    protected String func_70639_aQ() {
        return this.isScreaming() ? "mob.endermen.scream" : "mob.endermen.idle";
    }

    protected String func_70621_aR() {
        this.setScreaming(true);
        return "mob.endermen.hit";
    }

    protected String func_70673_aS() {
        return "mob.endermen.death";
    }

    protected Item func_146068_u() {
        return Items.field_151079_bi;
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        int k;
        int j;
        Item item = this.func_146068_u();
        if (item != null) {
            j = this.field_70146_Z.nextInt(2 + p_70628_2_);
            for (k = 0; k < j; ++k) {
                this.func_145779_a(item, 1);
            }
        }
        j = this.field_70146_Z.nextInt(2 + p_70628_2_);
        for (k = 0; k < j; ++k) {
            this.func_145779_a(Items.field_151061_bv, 1);
        }
        j = this.field_70146_Z.nextInt(3 + p_70628_2_);
        for (k = 0; k < j; ++k) {
            this.func_145779_a(Items.field_151044_h, 1);
        }
        if (this.field_70146_Z.nextInt(5) == 0 || this.field_70146_Z.nextInt(1 + p_70628_2_) > 0) {
            this.func_70099_a(new ItemStack(Blocks.field_150377_bs), 0.0f);
        }
        if (this.field_70146_Z.nextInt(20) == 0 || this.field_70146_Z.nextInt(1 + p_70628_2_) > 0) {
            this.func_70099_a(new ItemStack(Blocks.field_150343_Z), 0.0f);
        }
    }

    public void func_146081_a(Block p_146081_1_) {
        this.field_70180_af.func_75692_b(16, (Object)((byte)(Block.func_149682_b((Block)p_146081_1_) & 0xFF)));
    }

    public Block func_146080_bZ() {
        return Block.func_149729_e((int)this.field_70180_af.func_75683_a(16));
    }

    public void setCarryingData(int p_70817_1_) {
        this.field_70180_af.func_75692_b(17, (Object)((byte)(p_70817_1_ & 0xFF)));
    }

    public int getCarryingData() {
        return this.field_70180_af.func_75683_a(17);
    }

    protected void func_70069_a(float p_70069_1_) {
        super.func_70069_a(p_70069_1_);
        this.field_70701_bs = 0.0f;
        this.field_70702_br = 0.0f;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        Entity entity;
        if (source instanceof EntityDamageSourceIndirect) {
            this.isAggressive = false;
            if (!this.field_70170_p.field_72995_K) {
                for (int i = 0; i < 16; ++i) {
                    this.teleportRandomly();
                }
            }
            return false;
        }
        if (this.func_85032_ar()) {
            return false;
        }
        if (source.func_76346_g() instanceof EntityEndermanLoyalist || source.func_76346_g() instanceof EntityEnderColossus || source.func_76346_g() instanceof EntityDragon) {
            return false;
        }
        if (source.func_76346_g() != null && this.field_70702_br == 0.0f && this.getMinionType() == EnumMinionType.ZEALOT) {
            this.field_70761_aq = this.field_70177_z = this.field_70759_as;
            this.func_85030_a("thetitans:titanSwing", 1.0f, 2.0f);
            switch (this.field_70146_Z.nextInt(3)) {
                case 0: {
                    this.field_70701_bs = -2.0f;
                    this.func_70060_a(0.0f, -2.0f, 0.99f);
                    this.field_70702_br = 0.01f;
                    break;
                }
                case 1: {
                    this.field_70702_br = 1.0f;
                    this.func_70060_a(1.0f, 0.0f, 0.25f);
                    break;
                }
                case 2: {
                    this.field_70702_br = -1.0f;
                    this.func_70060_a(-1.0f, 0.0f, 0.25f);
                }
            }
            this.func_70664_aZ();
            return false;
        }
        if (source.func_76346_g() == null) {
            if (!this.field_70170_p.field_72995_K) {
                this.setScreaming(true);
            }
            if (source instanceof EntityDamageSource && source.func_76346_g() instanceof EntityPlayer) {
                if (source.func_76346_g() instanceof EntityPlayerMP && ((EntityPlayerMP)source.func_76346_g()).field_71134_c.func_73083_d()) {
                    this.setScreaming(false);
                } else {
                    this.isAggressive = true;
                }
            }
        }
        boolean flag = super.func_70097_a(source, amount);
        if (this.field_70146_Z.nextInt(2) != 0) {
            this.teleportRandomly();
        }
        if ((entity = source.func_76346_g()) instanceof EntityLivingBase) {
            List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(64.0, 64.0, 64.0));
            for (int i = 0; i < list.size(); ++i) {
                Entity entity1 = (Entity)list.get(i);
                if (entity1 instanceof EntityEndermanLoyalist) {
                    EntityEndermanLoyalist entitypigzombie = (EntityEndermanLoyalist)entity1;
                    entitypigzombie.func_70624_b((EntityLivingBase)entity);
                    entitypigzombie.func_70604_c((EntityLivingBase)entity);
                    entitypigzombie.randomSoundDelay = this.field_70146_Z.nextInt(40);
                }
                this.func_70624_b((EntityLivingBase)entity);
                this.func_70604_c((EntityLivingBase)entity);
                this.randomSoundDelay = this.field_70146_Z.nextInt(40);
            }
        }
        return flag;
    }

    public boolean isScreaming() {
        return this.field_70180_af.func_75683_a(18) > 0;
    }

    public void setScreaming(boolean p_70819_1_) {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_75692_b(18, (Object)((byte)(p_70819_1_ ? 1 : 0)));
        }
    }

    public static void setCarriable(Block block, boolean canCarry) {
        if (carriable == null) {
            carriable = new IdentityHashMap(4096);
        }
        carriable.put(block, canCarry);
    }

    public static boolean getCarriable(Block block) {
        Boolean ret = carriable.get(block);
        return ret != null ? ret : false;
    }

    static {
        EntityEndermanLoyalist.carriableBlocks[Block.func_149682_b((Block)Blocks.field_150349_c)] = true;
        EntityEndermanLoyalist.carriableBlocks[Block.func_149682_b((Block)Blocks.field_150346_d)] = true;
        EntityEndermanLoyalist.carriableBlocks[Block.func_149682_b((Block)Blocks.field_150354_m)] = true;
        EntityEndermanLoyalist.carriableBlocks[Block.func_149682_b((Block)Blocks.field_150351_n)] = true;
        EntityEndermanLoyalist.carriableBlocks[Block.func_149682_b((Block)Blocks.field_150327_N)] = true;
        EntityEndermanLoyalist.carriableBlocks[Block.func_149682_b((Block)Blocks.field_150328_O)] = true;
        EntityEndermanLoyalist.carriableBlocks[Block.func_149682_b((Block)Blocks.field_150338_P)] = true;
        EntityEndermanLoyalist.carriableBlocks[Block.func_149682_b((Block)Blocks.field_150337_Q)] = true;
        EntityEndermanLoyalist.carriableBlocks[Block.func_149682_b((Block)Blocks.field_150335_W)] = true;
        EntityEndermanLoyalist.carriableBlocks[Block.func_149682_b((Block)Blocks.field_150434_aF)] = true;
        EntityEndermanLoyalist.carriableBlocks[Block.func_149682_b((Block)Blocks.field_150435_aG)] = true;
        EntityEndermanLoyalist.carriableBlocks[Block.func_149682_b((Block)Blocks.field_150423_aK)] = true;
        EntityEndermanLoyalist.carriableBlocks[Block.func_149682_b((Block)Blocks.field_150440_ba)] = true;
        EntityEndermanLoyalist.carriableBlocks[Block.func_149682_b((Block)Blocks.field_150391_bh)] = true;
        EntityEndermanLoyalist.carriableBlocks[Block.func_149682_b((Block)Blocks.field_150462_ai)] = true;
        EntityEndermanLoyalist.carriableBlocks[Block.func_149682_b((Block)Blocks.field_150484_ah)] = true;
        EntityEndermanLoyalist.carriableBlocks[Block.func_149682_b((Block)Blocks.field_150460_al)] = true;
        EntityEndermanLoyalist.carriableBlocks[Block.func_149682_b((Block)Blocks.field_150470_am)] = true;
        EntityEndermanLoyalist.carriableBlocks[Block.func_149682_b((Block)Blocks.field_150486_ae)] = true;
        EntityEndermanLoyalist.carriableBlocks[Block.func_149682_b((Block)Blocks.field_150340_R)] = true;
        EntityEndermanLoyalist.carriableBlocks[Block.func_149682_b((Block)Blocks.field_150364_r)] = true;
        EntityEndermanLoyalist.carriableBlocks[Block.func_149682_b((Block)Blocks.field_150363_s)] = true;
        EntityEndermanLoyalist.carriableBlocks[Block.func_149682_b((Block)Blocks.field_150362_t)] = true;
        EntityEndermanLoyalist.carriableBlocks[Block.func_149682_b((Block)Blocks.field_150361_u)] = true;
        EntityEndermanLoyalist.carriableBlocks[Block.func_149682_b((Block)Blocks.field_150339_S)] = true;
        EntityEndermanLoyalist.carriableBlocks[Block.func_149682_b((Block)Blocks.field_150344_f)] = true;
        EntityEndermanLoyalist.carriableBlocks[Block.func_149682_b((Block)Blocks.field_150478_aa)] = true;
        EntityEndermanLoyalist.carriableBlocks[Block.func_149682_b((Block)Blocks.field_150467_bQ)] = true;
        EntityEndermanLoyalist.carriableBlocks[Block.func_149682_b((Block)Blocks.field_150382_bo)] = true;
        EntityEndermanLoyalist.carriableBlocks[Block.func_149682_b((Block)Blocks.field_150342_X)] = true;
        for (int x = 0; x < carriableBlocks.length; ++x) {
            if (!carriableBlocks[x]) continue;
            EntityEndermanLoyalist.setCarriable(Block.func_149729_e((int)x), true);
        }
    }
}

