/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.titanminion;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityWitherSkull;
import net.minecraft.entity.titan.EntityCreeperTitan;
import net.minecraft.entity.titan.EntityTitan;
import net.minecraft.entity.titan.EntityTitanSpirit;
import net.minecraft.entity.titan.ITitan;
import net.minecraft.entity.titan.ai.EntityAIBreakDoorMinion;
import net.minecraft.entity.titan.ai.EntityAICreeperLoyalistSwell;
import net.minecraft.entity.titan.ai.EntityAINearestTargetTitan;
import net.minecraft.entity.titanminion.EnumMinionType;
import net.minecraft.entity.titanminion.IMinion;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.theTitans.TheTitans;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class EntityCreeperLoyalist
extends EntityMob
implements IMinion {
    public int randomSoundDelay;
    private int lastActiveTime;
    private int timeSinceIgnited;
    public int fuseTime = 30;
    public int explosionRadius = 3;
    private int field_175494_bm = 0;
    public EntityLiving master;
    public boolean shouldMelee = true;

    public EntityCreeperLoyalist(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.5f, 1.625f);
        if (this.field_70163_u <= 1.0) {
            this.field_70163_u = 1.0;
        }
        this.field_70728_aV = 10;
        this.func_70661_as().func_75498_b(true);
        this.func_70661_as().func_75490_c(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityWitherSkull.class, 2.0f, 1.2, 1.75));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityTitanSpirit.class, 48.0f, 1.5, 1.5));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIBreakDoorMinion((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.2));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAICreeperLoyalistSwell(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        if (TheTitans.TitansFFAMode) {
            this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan((EntityCreature)this, EntityLivingBase.class, 0, false, false, ITitan.CreeperTitanSorter));
        } else {
            this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan((EntityCreature)this, EntityLivingBase.class, 0, false, false, ITitan.SearchForAThingToKill));
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.master != null && this.master instanceof EntityTitan) {
            ((EntityTitan)this.master).retractMinionNumFromType(this.getMinionType());
        }
    }

    @Override
    public EnumMinionType getMinionType() {
        return EnumMinionType.LOYALIST;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(26.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
    }

    public boolean func_70686_a(Class p_70686_1_) {
        return p_70686_1_ != EntityCreeperLoyalist.class && p_70686_1_ != EntityCreeperTitan.class;
    }

    public int getMaxFallHeight() {
        return this.func_70638_az() == null ? 3 : 3 + (int)(this.func_110143_aJ() - 1.0f);
    }

    protected void func_70069_a(float p_70069_1_) {
        super.func_70069_a(p_70069_1_);
        this.field_70701_bs = 0.0f;
        this.field_70702_br = 0.0f;
        this.timeSinceIgnited = (int)((float)this.timeSinceIgnited + p_70069_1_ * 1.5f);
        if (this.timeSinceIgnited > this.fuseTime - 5) {
            this.timeSinceIgnited = this.fuseTime - 5;
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)-1);
        this.field_70180_af.func_75682_a(17, (Object)0);
        this.field_70180_af.func_75682_a(18, (Object)0);
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        if (this.field_70180_af.func_75683_a(17) == 1) {
            tagCompound.func_74757_a("powered", true);
        }
        tagCompound.func_74777_a("Fuse", (short)this.fuseTime);
        tagCompound.func_74774_a("ExplosionRadius", (byte)this.explosionRadius);
        tagCompound.func_74757_a("ignited", this.func_146078_ca());
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.field_70180_af.func_75692_b(17, (Object)((byte)(tagCompund.func_74767_n("powered") ? 1 : 0)));
        if (tagCompund.func_150297_b("Fuse", 99)) {
            this.fuseTime = tagCompund.func_74765_d("Fuse");
        }
        if (tagCompund.func_150297_b("ExplosionRadius", 99)) {
            this.explosionRadius = tagCompund.func_74771_c("ExplosionRadius");
        }
        if (tagCompund.func_74767_n("ignited")) {
            this.func_146079_cb();
        }
    }

    public void func_70071_h_() {
        if (this.func_70089_S()) {
            int i;
            if (this.func_110143_aJ() < this.func_110138_aP() / 4.0f) {
                this.shouldMelee = false;
            }
            this.lastActiveTime = this.timeSinceIgnited;
            if (this.func_146078_ca() && !this.shouldMelee) {
                this.setCreeperState(1);
            }
            if ((i = this.getCreeperState()) > 0 && this.timeSinceIgnited == 0) {
                this.func_85030_a("creeper.primed", 1.0f, 0.5f);
            }
            this.timeSinceIgnited += i;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            if (this.timeSinceIgnited >= this.fuseTime) {
                this.timeSinceIgnited = this.fuseTime;
                this.explode();
            }
        }
        super.func_70071_h_();
    }

    protected String func_70621_aR() {
        return "mob.creeper.say";
    }

    protected String func_70673_aS() {
        return "mob.creeper.death";
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (cause.func_76346_g() instanceof EntitySkeleton) {
            int i = Item.func_150891_b((Item)Items.field_151096_cd);
            int j = Item.func_150891_b((Item)Items.field_151084_co);
            int k = i + this.field_70146_Z.nextInt(j - i + 1);
            this.func_145779_a(Item.func_150899_d((int)k), 1);
        }
    }

    public boolean func_70652_k(Entity p_70652_1_) {
        if (this.shouldMelee) {
            return super.func_70652_k(p_70652_1_);
        }
        return true;
    }

    public boolean getPowered() {
        return this.field_70180_af.func_75683_a(17) == 1;
    }

    @SideOnly(value=Side.CLIENT)
    public float getCreeperFlashIntensity(float p_70831_1_) {
        return ((float)this.lastActiveTime + (float)(this.timeSinceIgnited - this.lastActiveTime) * p_70831_1_) / (float)(this.fuseTime - 2);
    }

    protected Item func_146068_u() {
        return Items.field_151016_H;
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        super.func_70628_a(p_70628_1_, p_70628_2_);
        int j = this.field_70146_Z.nextInt(3 + p_70628_2_);
        for (int k = 0; k < j; ++k) {
            this.func_70099_a(new ItemStack((Block)Blocks.field_150362_t, 1, 0 + this.field_70146_Z.nextInt(3)), 0.0f);
        }
        if (this.field_70146_Z.nextInt(60) == 0 || this.field_70146_Z.nextInt(1 + p_70628_2_) > 0) {
            this.func_70099_a(new ItemStack(Blocks.field_150335_W), 0.0f);
        }
    }

    protected void func_70600_l(int p_70600_1_) {
        this.func_70099_a(new ItemStack(Items.field_151144_bL, 1, 4), 0.0f);
    }

    public int getCreeperState() {
        return this.field_70180_af.func_75683_a(16);
    }

    public void setCreeperState(int p_70829_1_) {
        this.field_70180_af.func_75692_b(16, (Object)((byte)p_70829_1_));
    }

    public void func_70077_a(EntityLightningBolt lightningBolt) {
        this.field_70180_af.func_75692_b(17, (Object)1);
    }

    protected boolean func_70085_c(EntityPlayer player) {
        ItemStack itemstack = player.field_71071_by.func_70448_g();
        if (itemstack != null && itemstack.func_77973_b() == Items.field_151033_d) {
            this.field_70170_p.func_72908_a(this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, "fire.ignite", 1.0f, this.field_70146_Z.nextFloat() * 0.4f + 0.8f);
            player.func_71038_i();
            if (!this.field_70170_p.field_72995_K) {
                this.func_146079_cb();
                itemstack.func_77972_a(1, (EntityLivingBase)player);
                return true;
            }
        }
        return super.func_70085_c(player);
    }

    public void explode() {
        if (!this.field_70170_p.field_72995_K) {
            boolean flag = this.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
            float f = this.getPowered() ? 2.0f : 1.0f;
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, (float)this.explosionRadius * f, flag);
            this.func_70106_y();
        }
    }

    public boolean func_146078_ca() {
        return this.field_70180_af.func_75683_a(18) != 0;
    }

    public void func_146079_cb() {
        this.field_70180_af.func_75692_b(18, (Object)1);
    }

    public boolean func_70650_aV() {
        return true;
    }

    public void func_175493_co() {
        ++this.field_175494_bm;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_85032_ar()) {
            return false;
        }
        if (source.func_76346_g() instanceof EntityCreeperLoyalist || source.func_76346_g() instanceof EntityCreeperTitan) {
            return false;
        }
        if (source.func_76346_g() != null && this.field_70702_br == 0.0f && this.getMinionType() == EnumMinionType.ZEALOT) {
            this.field_70761_aq = this.field_70177_z = this.field_70759_as;
            this.func_85030_a("thetitans:titanSwing", 1.0f, 2.0f);
            switch (this.field_70146_Z.nextInt(3)) {
                case 0: {
                    this.field_70701_bs = -2.0f;
                    this.func_70060_a(0.0f, -2.0f, 0.99f);
                    this.field_70702_br = 0.01f;
                    break;
                }
                case 1: {
                    this.field_70702_br = 1.0f;
                    this.func_70060_a(1.0f, 0.0f, 0.25f);
                    break;
                }
                case 2: {
                    this.field_70702_br = -1.0f;
                    this.func_70060_a(-1.0f, 0.0f, 0.25f);
                }
            }
            this.func_70664_aZ();
            return false;
        }
        Entity entity = source.func_76346_g();
        if (entity instanceof EntityLivingBase) {
            List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(32.0, 32.0, 32.0));
            for (int i = 0; i < list.size(); ++i) {
                Entity entity1 = (Entity)list.get(i);
                if (entity1 instanceof EntityCreeperLoyalist) {
                    EntityCreeperLoyalist entitypigzombie = (EntityCreeperLoyalist)entity1;
                    entitypigzombie.func_70624_b((EntityLivingBase)entity);
                    entitypigzombie.func_70604_c((EntityLivingBase)entity);
                    entitypigzombie.randomSoundDelay = this.field_70146_Z.nextInt(40);
                }
                this.func_70624_b((EntityLivingBase)entity);
                this.func_70604_c((EntityLivingBase)entity);
                this.randomSoundDelay = this.field_70146_Z.nextInt(40);
            }
        }
        return super.func_70097_a(source, amount);
    }

    protected void func_70619_bc() {
        if (this.randomSoundDelay > 0 && --this.randomSoundDelay == 0) {
            this.func_85030_a(this.func_70621_aR(), this.func_70599_aP(), this.func_70647_i() + 0.25f);
        }
        if (this.field_70123_F && this.master != null) {
            this.field_70181_x = 0.2;
        }
        if (this.func_70638_az() != null && !this.func_70638_az().func_70089_S()) {
            this.func_70624_b(null);
        }
        if (this.master != null) {
            if (this.func_70068_e((Entity)this.master) > 2304.0) {
                this.func_70605_aq().func_75642_a(this.master.field_70165_t, this.master.field_70163_u, this.master.field_70161_v, 2.0);
            }
            if (this.master.func_70638_az() != null && this.master.func_70638_az().field_70131_O < 4.0f) {
                this.func_70624_b(this.master.func_70638_az());
            }
        } else {
            List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(100.0, 100.0, 100.0));
            if (list != null && !list.isEmpty()) {
                for (int i1 = 0; i1 < list.size(); ++i1) {
                    Entity entity = (Entity)list.get(i1);
                    if (entity == null || !(entity instanceof EntityCreeperTitan)) continue;
                    this.master = (EntityCreeperTitan)entity;
                }
            }
        }
        super.func_70619_bc();
    }
}

