/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.titan;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.titan.EntityIronGolemTitan;
import net.minecraft.entity.titan.EntityPigZombieTitan;
import net.minecraft.entity.titan.EntityProtoBall;
import net.minecraft.entity.titan.EntitySnowGolemTitan;
import net.minecraft.entity.titan.EntityTitan;
import net.minecraft.entity.titan.EntityTitanSpirit;
import net.minecraft.entity.titan.EnumTitanStatus;
import net.minecraft.entity.titan.ITitan;
import net.minecraft.entity.titan.ai.EntityAINearestTargetTitan;
import net.minecraft.entity.titan.animation.zombietitan.AnimationZombieTitanAntiTitanAttack1;
import net.minecraft.entity.titan.animation.zombietitan.AnimationZombieTitanAntiTitanAttack2;
import net.minecraft.entity.titan.animation.zombietitan.AnimationZombieTitanAttack;
import net.minecraft.entity.titan.animation.zombietitan.AnimationZombieTitanAttack2;
import net.minecraft.entity.titan.animation.zombietitan.AnimationZombieTitanAttack3;
import net.minecraft.entity.titan.animation.zombietitan.AnimationZombieTitanAttack4;
import net.minecraft.entity.titan.animation.zombietitan.AnimationZombieTitanDeath;
import net.minecraft.entity.titan.animation.zombietitan.AnimationZombieTitanKick;
import net.minecraft.entity.titan.animation.zombietitan.AnimationZombieTitanLightningAttack;
import net.minecraft.entity.titan.animation.zombietitan.AnimationZombieTitanRangedAttack;
import net.minecraft.entity.titan.animation.zombietitan.AnimationZombieTitanReformSword;
import net.minecraft.entity.titan.animation.zombietitan.AnimationZombieTitanStun;
import net.minecraft.entity.titanminion.EntityGiantZombieBetter;
import net.minecraft.entity.titanminion.EntityZombieLoyalist;
import net.minecraft.entity.titanminion.EntityZombiePriest;
import net.minecraft.entity.titanminion.EntityZombieTemplar;
import net.minecraft.entity.titanminion.EntityZombieZealot;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.theTitans.DamageSourceExtra;
import net.minecraft.theTitans.TheTitans;
import net.minecraft.theTitans.TitanItems;
import net.minecraft.theTitans.TitansAchievments;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeModContainer;
import thehippomaster.AnimationAPI.AnimationAPI;
import thehippomaster.AnimationAPI.IAnimatedEntity;

public class EntityZombieTitan
extends EntityTitan
implements IAnimatedEntity,
IEntityMultiPart {
    private static final UUID babySpeedBoostUUID = UUID.fromString("B9766B59-9566-4402-BC1F-2EE2A276D836");
    private static final AttributeModifier babySpeedBoostModifier = new AttributeModifier(babySpeedBoostUUID, "Baby speed boost", 0.5, 1);
    private final EntityAIBreakDoor breakDoor = new EntityAIBreakDoor((EntityLiving)this);
    private int conversionTime;
    private boolean field_146076_bu = false;
    public boolean isAttacking;
    public boolean isStunned;
    public EntityDragonPart[] partArray;
    public EntityDragonPart head;
    public EntityDragonPart body;
    public EntityDragonPart rightArm;
    public EntityDragonPart leftArm;
    public EntityDragonPart rightLeg;
    public EntityDragonPart leftLeg;

    public EntityZombieTitan(World worldIn) {
        super(worldIn);
        this.setTitanHealth(this.func_110138_aP());
        this.head = new EntityDragonPart((IEntityMultiPart)this, "head", 8.0f, 8.0f);
        this.body = new EntityDragonPart((IEntityMultiPart)this, "body", 8.0f, 12.0f);
        this.rightArm = new EntityDragonPart((IEntityMultiPart)this, "rightarm", 4.0f, 4.0f);
        this.leftArm = new EntityDragonPart((IEntityMultiPart)this, "leftarm", 4.0f, 4.0f);
        this.rightLeg = new EntityDragonPart((IEntityMultiPart)this, "rightleft", 4.0f, 12.0f);
        this.leftLeg = new EntityDragonPart((IEntityMultiPart)this, "leftleg", 4.0f, 12.0f);
        this.partArray = new EntityDragonPart[]{this.head, this.body, this.rightArm, this.leftArm, this.rightLeg, this.leftLeg};
        this.field_70178_ae = true;
        this.func_70105_a(8.0f, 32.0f);
        this.field_70138_W = 9.0f;
        this.field_70728_aV = 10000;
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan(this, EntityIronGolemTitan.class, 0, false));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan(this, EntitySnowGolemTitan.class, 0, false));
    }

    @Override
    protected void applyEntityAI() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationZombieTitanDeath(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationZombieTitanAttack4(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationZombieTitanStun(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationZombieTitanAttack3(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationZombieTitanAttack2(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationZombieTitanRangedAttack(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationZombieTitanLightningAttack(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationZombieTitanAntiTitanAttack2(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationZombieTitanAntiTitanAttack1(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationZombieTitanAttack(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationZombieTitanReformSword(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationZombieTitanKick(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        if (TheTitans.TitansFFAMode) {
            this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan(this, EntityLivingBase.class, 0, false, false, ITitan.ZombieTitanSorter));
        } else {
            this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan(this, EntityLivingBase.class, 0, false, false, ITitan.SearchForAThingToKill));
        }
    }

    public boolean isArmored() {
        return this.func_110143_aJ() <= this.func_110138_aP() / 5.0f;
    }

    public boolean func_70686_a(Class p_70686_1_) {
        return p_70686_1_ != EntityZombieLoyalist.class && p_70686_1_ != EntityGiantZombieBetter.class && (p_70686_1_ == EntityPigZombieTitan.class || p_70686_1_ != EntityZombieTitan.class);
    }

    @Override
    public float func_70603_bj() {
        float f = 16.0f;
        if (this.func_70631_g_()) {
            f *= 0.6f;
        }
        return f;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.animID != 0 && this.deathTicks < this.getThreashHold()) {
            ++this.animTick;
            if (this.func_70631_g_() && this.func_70089_S() || this.isArmored() && this.func_70089_S()) {
                ++this.animTick;
            }
        }
    }

    @Override
    public boolean func_70601_bi() {
        return this.field_70146_Z.nextInt(50) == 0 && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL && this.isValidLightLevel();
    }

    @Override
    public int getMinionSpawnRate() {
        return TheTitans.ZombieTitanMinionSpawnrate;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(70.0);
    }

    @Override
    public int getRegenTime() {
        if (!this.field_70170_p.func_72935_r()) {
            return 5;
        }
        return super.getRegenTime();
    }

    @Override
    public int getMinionCap() {
        return 180;
    }

    @Override
    public int getPriestCap() {
        return 90;
    }

    @Override
    public int getZealotCap() {
        return 60;
    }

    @Override
    public int getTemplarCap() {
        return 12;
    }

    @Override
    public int getSpecialMinionCap() {
        return 8;
    }

    @Override
    public EnumTitanStatus getTitanStatus() {
        return EnumTitanStatus.AVERAGE;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_70096_w().func_75682_a(12, (Object)0);
        this.func_70096_w().func_75682_a(13, (Object)0);
        this.func_70096_w().func_75682_a(14, (Object)0);
        this.func_70096_w().func_75682_a(15, (Object)0);
        this.func_70096_w().func_75682_a(16, (Object)0);
    }

    public boolean func_70662_br() {
        return this.func_70668_bt() == EnumCreatureAttribute.UNDEAD;
    }

    protected void func_70069_a(float p_70069_1_) {
        if ((p_70069_1_ = ForgeHooks.onLivingFall((EntityLivingBase)this, (float)p_70069_1_)) <= 0.0f) {
            return;
        }
        PotionEffect potioneffect = this.func_70660_b(Potion.field_76430_j);
        float f1 = potioneffect != null ? (float)(potioneffect.func_76458_c() + 1) : 0.0f;
        int i = MathHelper.func_76123_f((float)(p_70069_1_ - 12.0f - f1));
        if (i > 0) {
            int l;
            int k;
            int j;
            Block block;
            this.func_85030_a("thetitans:groundSmash", 20.0f, 1.0f);
            this.func_85030_a("thetitans:titanland", 10000.0f, 1.0f);
            this.destroyBlocksInAABB(this.field_70121_D.func_72314_b(16.0, 2.0, 16.0));
            List list11 = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(48.0, 2.0, 48.0));
            if (list11 != null && !list11.isEmpty()) {
                for (int i1 = 0; i1 < list11.size(); ++i1) {
                    Entity entity = (Entity)list11.get(i1);
                    if (!(entity instanceof EntityLivingBase) || !this.func_70686_a(entity.getClass()) || entity instanceof EntityTitan) continue;
                    float smash = 50.0f - this.func_70032_d(entity);
                    if (smash <= 1.0f) {
                        smash = 1.0f;
                    }
                    entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), smash);
                    double d0 = this.field_70121_D.field_72340_a + this.field_70121_D.field_72336_d;
                    double d1 = this.field_70121_D.field_72339_c + this.field_70121_D.field_72334_f;
                    double d2 = entity.field_70165_t - d0;
                    double d3 = entity.field_70161_v - d1;
                    double d4 = d2 * d2 + d3 * d3;
                    entity.func_70024_g(d2 / d4 * 8.0, 1.0, d3 / d4 * 8.0);
                }
            }
            if ((block = this.field_70170_p.func_147439_a(j = MathHelper.func_76128_c((double)this.field_70165_t), k = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f - (double)this.field_70129_M)), l = MathHelper.func_76128_c((double)this.field_70161_v))).func_149688_o() != Material.field_151579_a) {
                Block.SoundType soundtype = block.field_149762_H;
                this.func_85030_a(soundtype.func_150498_e(), soundtype.func_150497_c() * 0.5f, soundtype.func_150494_d() * 0.75f);
            }
        }
    }

    public boolean func_146072_bX() {
        return this.field_146076_bu;
    }

    public void func_146070_a(boolean p_146070_1_) {
        if (this.field_146076_bu != p_146070_1_) {
            this.field_146076_bu = p_146070_1_;
            if (p_146070_1_) {
                this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.breakDoor);
            } else {
                this.field_70714_bg.func_85156_a((EntityAIBase)this.breakDoor);
            }
        }
    }

    public boolean func_70631_g_() {
        return this.func_70096_w().func_75683_a(12) == 1;
    }

    protected int func_70693_a(EntityPlayer player) {
        if (this.func_70631_g_()) {
            this.field_70728_aV = (int)((float)this.field_70728_aV * 2.5f);
        }
        return super.func_70693_a(player);
    }

    public void setChild(boolean childZombie) {
        this.func_70096_w().func_75692_b(12, (Object)((byte)(childZombie ? 1 : 0)));
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
            iattributeinstance.func_111124_b(babySpeedBoostModifier);
            if (childZombie) {
                iattributeinstance.func_111121_a(babySpeedBoostModifier);
            }
        }
    }

    public boolean isVillager() {
        return this.func_70096_w().func_75683_a(13) == 1;
    }

    public void setVillager(boolean villager) {
        this.func_70096_w().func_75692_b(13, (Object)((byte)(villager ? 1 : 0)));
    }

    public boolean isArmed() {
        return this.func_70096_w().func_75683_a(15) == 1;
    }

    public void setArmed(boolean armed) {
        this.func_70096_w().func_75692_b(15, (Object)((byte)(armed ? 1 : 0)));
    }

    public boolean isSwordSoft() {
        return this.func_70096_w().func_75683_a(16) == 1;
    }

    public void setSwordSoft(boolean armed) {
        this.func_70096_w().func_75692_b(16, (Object)((byte)(armed ? 1 : 0)));
    }

    @Override
    public double getSpeed() {
        return this.func_70631_g_() ? 0.6 : (this.isArmored() ? 0.45 : 0.3);
    }

    @Override
    public boolean canBeHurtByPlayer() {
        return !this.isArmed() && !this.func_85032_ar();
    }

    @Override
    public boolean shouldMove() {
        return this.animID == 0 && !this.isStunned && this.func_70638_az() != null ? super.shouldMove() : false;
    }

    @Override
    public boolean func_70652_k(Entity p_70652_1_) {
        return false;
    }

    public void attackEntityWithRangedAttack(EntityLivingBase p_82196_1_, float p_82196_2_) {
        this.field_70761_aq = this.field_70177_z = this.field_70759_as;
        this.func_70625_a((Entity)p_82196_1_, 180.0f, 30.0f);
        double d8 = 16.0;
        Vec3 vec3 = this.func_70676_i(1.0f);
        double dx = vec3.field_72450_a * d8;
        double dz = vec3.field_72449_c * d8;
        EntityProtoBall entityarrow = new EntityProtoBall(this.field_70170_p, (EntityLivingBase)this);
        double d0 = p_82196_1_.field_70165_t + p_82196_1_.field_70159_w - (this.field_70165_t + dx);
        double d1 = p_82196_1_.field_70163_u + (double)p_82196_1_.func_70047_e() - 8.0 - this.field_70163_u;
        double d2 = p_82196_1_.field_70161_v + p_82196_1_.field_70179_y - (this.field_70161_v + dz);
        float f1 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        entityarrow.func_70186_c(d0, d1 + (double)f1, d2, 0.95f, 45 - this.field_70170_p.field_73013_u.func_151525_a() * 5);
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72838_d((Entity)entityarrow);
        }
        entityarrow.field_70159_w *= 1.5;
        entityarrow.field_70179_y *= 1.5;
        this.field_70170_p.func_72889_a((EntityPlayer)null, 1008, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 0);
        if (this.func_70068_e((Entity)p_82196_1_) < 300.0) {
            this.attackChoosenEntity((Entity)p_82196_1_, 10.0f, 5);
        }
    }

    @Override
    public void func_70636_d() {
        Block block;
        int l;
        int k;
        int j2;
        int j;
        int i2;
        int l1;
        int z;
        int x;
        int y;
        double dz;
        double dx;
        Vec3 vec3;
        double d8;
        super.func_70636_d();
        if (this.isStunned) {
            this.func_70624_b(null);
            AnimationAPI.sendAnimPacket(this, 8);
            this.setAnimID(8);
        }
        if (this.animID == 10) {
            if (this.animTick == 30 || this.animTick == 70) {
                this.func_85030_a("thetitans:titanStep", 10.0f, 1.0f);
            }
            if (this.animTick == 190) {
                this.func_85030_a("thetitans:titanFall", 20.0f, 1.0f);
                this.collideWithEntities(this.leftLeg, this.field_70170_p.func_72839_b((Entity)this, this.leftLeg.field_70121_D.func_72314_b(16.0, 1.0, 16.0)));
                this.collideWithEntities(this.rightLeg, this.field_70170_p.func_72839_b((Entity)this, this.rightLeg.field_70121_D.func_72314_b(16.0, 1.0, 16.0)));
            }
            if (this.animTick == 200) {
                this.func_85030_a("thetitans:distantLargeFall", 10000.0f, 1.0f);
            }
        }
        if (this.animID == 8) {
            this.isStunned = this.animTick <= 138;
        }
        if (this.getAnimID() == 8 && this.getAnimTick() == 4 && !this.field_70170_p.field_72995_K) {
            this.dropSword();
        }
        if (this.getAnimID() == 8 && this.getAnimTick() >= 80 && this.getAnimTick() <= 100) {
            this.func_85030_a(this.func_70639_aQ(), this.func_70599_aP(), 1.1f);
        }
        if (this.getAnimID() == 7) {
            this.field_70181_x *= 0.0;
        }
        if (this.getAnimID() == 7 && this.getAnimTick() == 122) {
            d8 = this.func_70631_g_() ? 16.0 : 32.0;
            vec3 = this.func_70676_i(1.0f);
            dx = vec3.field_72450_a * d8;
            dz = vec3.field_72449_c * d8;
            y = MathHelper.func_76128_c((double)this.field_70163_u);
            x = MathHelper.func_76128_c((double)(this.field_70165_t + dx));
            z = MathHelper.func_76128_c((double)(this.field_70161_v + dz));
            for (l1 = -4; l1 <= 4; ++l1) {
                for (i2 = -4; i2 <= 4; ++i2) {
                    for (j = -1; j <= 1; ++j) {
                        j2 = x + l1;
                        k = y + j;
                        l = z + i2;
                        block = this.field_70170_p.func_147439_a(j2, k, l);
                        if (!block.isAir((IBlockAccess)this.field_70170_p, j2, k, l)) {
                            this.func_85030_a("thetitans:titanStrike", 20.0f, 1.0f);
                            this.func_85030_a("thetitans:titanSlam", 20.0f, 1.0f);
                            this.field_70170_p.func_72926_e(2001, j2, k, l, Block.func_149682_b((Block)block));
                            if (block == Blocks.field_150349_c) {
                                this.field_70170_p.func_147449_b(j2, k, l, Blocks.field_150346_d);
                            }
                        }
                        if (block.func_149638_a((Entity)this) > 500.0f && !this.isSwordSoft()) {
                            this.setAnimTick(0);
                            AnimationAPI.sendAnimPacket(this, 8);
                            this.setAnimID(8);
                            this.func_85030_a("random.anvil_land", 20.0f, 0.5f);
                            this.isStunned = true;
                            continue;
                        }
                        if (!(block.func_149638_a((Entity)this) <= 1.5f) || !this.isSwordSoft() || block == Blocks.field_150350_a || block == Blocks.field_150424_aL || block == Blocks.field_150346_d || block == Blocks.field_150349_c || block == Blocks.field_150359_w || block == Blocks.field_150410_aZ) continue;
                        this.setAnimTick(0);
                        AnimationAPI.sendAnimPacket(this, 8);
                        this.setAnimID(8);
                        this.func_85030_a("random.anvil_land", 20.0f, 0.5f);
                        this.isStunned = true;
                    }
                }
            }
        }
        if (this.getAnimID() == 2 && this.getAnimTick() == 160) {
            d8 = 12.0;
            vec3 = this.func_70676_i(1.0f);
            dx = vec3.field_72450_a * d8;
            dz = vec3.field_72449_c * d8;
            y = MathHelper.func_76128_c((double)this.field_70163_u);
            x = MathHelper.func_76128_c((double)(this.field_70165_t + dx));
            z = MathHelper.func_76128_c((double)(this.field_70161_v + dz));
            for (l1 = -2; l1 <= 2; ++l1) {
                for (i2 = -2; i2 <= 2; ++i2) {
                    for (j = -1; j <= 1; ++j) {
                        j2 = x + l1;
                        k = y + j;
                        l = z + i2;
                        block = this.field_70170_p.func_147439_a(j2, k, l);
                        if (!block.isAir((IBlockAccess)this.field_70170_p, j2, k, l)) {
                            this.field_70170_p.func_72926_e(2001, j2, k, l, Block.func_149682_b((Block)block));
                            if (block == Blocks.field_150349_c) {
                                this.field_70170_p.func_147449_b(j2, k, l, Blocks.field_150346_d);
                            }
                        }
                        if (block.func_149638_a((Entity)this) > 500.0f) {
                            this.setSwordSoft(true);
                            continue;
                        }
                        if (!(block.func_149638_a((Entity)this) <= 500.0f)) continue;
                        this.setSwordSoft(false);
                    }
                }
            }
        }
        float f = this.field_70761_aq * (float)Math.PI / 180.0f;
        float f1 = MathHelper.func_76126_a((float)f);
        float f2 = MathHelper.func_76134_b((float)f);
        if (this.func_70631_g_()) {
            this.func_70105_a(6.0f, 18.0f);
            this.head.func_70071_h_();
            this.head.func_70012_b(this.field_70165_t, this.field_70163_u + 12.0, this.field_70161_v, 0.0f, 0.0f);
            this.body.func_70071_h_();
            this.body.func_70012_b(this.field_70165_t, this.field_70163_u + 6.0, this.field_70161_v, 0.0f, 0.0f);
            this.rightArm.func_70071_h_();
            this.rightArm.func_70012_b(this.field_70165_t + (double)(f2 * 4.0f), this.field_70163_u + 10.0, this.field_70161_v + (double)(f1 * 4.0f), 0.0f, 0.0f);
            this.leftArm.func_70071_h_();
            this.leftArm.func_70012_b(this.field_70165_t - (double)(f2 * 4.0f), this.field_70163_u + 10.0, this.field_70161_v - (double)(f1 * 4.0f), 0.0f, 0.0f);
            this.rightLeg.func_70071_h_();
            this.rightLeg.func_70012_b(this.field_70165_t + (double)(f2 * 1.0f), this.field_70163_u, this.field_70161_v + (double)(f1 * 1.0f), 0.0f, 0.0f);
            this.leftLeg.func_70071_h_();
            this.leftLeg.func_70012_b(this.field_70165_t - (double)(f2 * 1.0f), this.field_70163_u, this.field_70161_v - (double)(f1 * 1.0f), 0.0f, 0.0f);
        } else {
            this.func_70105_a(8.0f, 32.0f);
            this.head.func_70071_h_();
            this.head.func_70012_b(this.field_70165_t, this.field_70163_u + 24.0, this.field_70161_v, 0.0f, 0.0f);
            this.body.func_70071_h_();
            this.body.func_70012_b(this.field_70165_t, this.field_70163_u + 12.0, this.field_70161_v, 0.0f, 0.0f);
            this.rightArm.func_70071_h_();
            this.rightArm.func_70012_b(this.field_70165_t + (double)(f2 * 8.0f), this.field_70163_u + 20.0, this.field_70161_v + (double)(f1 * 8.0f), 0.0f, 0.0f);
            this.leftArm.func_70071_h_();
            this.leftArm.func_70012_b(this.field_70165_t - (double)(f2 * 8.0f), this.field_70163_u + 20.0, this.field_70161_v - (double)(f1 * 8.0f), 0.0f, 0.0f);
            this.rightLeg.func_70071_h_();
            this.rightLeg.func_70012_b(this.field_70165_t + (double)(f2 * 2.0f), this.field_70163_u, this.field_70161_v + (double)(f1 * 2.0f), 0.0f, 0.0f);
            this.leftLeg.func_70071_h_();
            this.leftLeg.func_70012_b(this.field_70165_t - (double)(f2 * 2.0f), this.field_70163_u, this.field_70161_v - (double)(f1 * 2.0f), 0.0f, 0.0f);
        }
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && !this.isStunned) {
            this.collideWithEntities(this.head, this.field_70170_p.func_72839_b((Entity)this, this.head.field_70121_D.func_72314_b(1.0, 1.0, 1.0)));
            this.collideWithEntities(this.body, this.field_70170_p.func_72839_b((Entity)this, this.body.field_70121_D.func_72314_b(1.0, 1.0, 1.0)));
            this.collideWithEntities(this.rightArm, this.field_70170_p.func_72839_b((Entity)this, this.rightArm.field_70121_D.func_72314_b(1.0, 1.0, 1.0)));
            this.collideWithEntities(this.leftArm, this.field_70170_p.func_72839_b((Entity)this, this.leftArm.field_70121_D.func_72314_b(1.0, 1.0, 1.0)));
            this.collideWithEntities(this.leftLeg, this.field_70170_p.func_72839_b((Entity)this, this.leftLeg.field_70121_D.func_72314_b(1.0, 1.0, 1.0)));
            this.collideWithEntities(this.rightLeg, this.field_70170_p.func_72839_b((Entity)this, this.rightLeg.field_70121_D.func_72314_b(1.0, 1.0, 1.0)));
        }
        this.destroyBlocksInAABB(this.head.field_70121_D);
        this.destroyBlocksInAABB(this.body.field_70121_D);
        this.destroyBlocksInAABB(this.rightArm.field_70121_D);
        this.destroyBlocksInAABB(this.leftArm.field_70121_D);
        this.destroyBlocksInAABB(this.leftLeg.field_70121_D);
        this.destroyBlocksInAABB(this.rightLeg.field_70121_D);
        if (this.field_70173_aa % 20 == 0 && this.animID == 0) {
            this.isAttacking = false;
        }
        this.meleeTitan = true;
        if (this.getAnimID() == 5) {
            if (this.getAnimTick() > 120) {
                this.animTick = 0;
                this.animID = 0;
                this.isAttacking = false;
            }
            if (this.getAnimTick() <= 46 && this.getAnimTick() >= 26 && this.func_70638_az() != null) {
                float ex = this.func_70631_g_() ? 4.5f : 9.5f;
                float fl = this.field_70761_aq * (float)Math.PI / 180.0f;
                float fl1 = MathHelper.func_76126_a((float)fl);
                float fl2 = MathHelper.func_76134_b((float)fl);
                this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t - (double)(fl2 * ex), this.field_70163_u + (this.func_70631_g_() ? 12.0 : 24.0), this.field_70161_v - (double)(fl1 * ex)));
                this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t + (double)(fl2 * ex), this.field_70163_u + (this.func_70631_g_() ? 12.0 : 24.0), this.field_70161_v + (double)(fl1 * ex)));
            }
            for (int i = 0; i < 2; ++i) {
                if (this.getAnimTick() != 64 || this.func_70638_az() == null || this.field_70170_p.field_72995_K) continue;
                double d82 = this.func_70631_g_() ? 6.0 : 12.0;
                Vec3 vec32 = this.func_70676_i(1.0f);
                double dx2 = vec32.field_72450_a * d82;
                double dz2 = vec32.field_72449_c * d82;
                float da = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
                int i1 = this.getKnockbackAmount();
                this.attackChoosenEntity((Entity)this.func_70638_az(), da * 3.0f, i1);
                this.func_70638_az().field_70181_x += (double)(1.0f + this.field_70146_Z.nextFloat());
                this.field_70170_p.func_72885_a((Entity)this, this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v, 2.0f, false, false);
                this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t + dx2, this.field_70163_u + 26.0, this.field_70161_v + dz2, 1.0f, false, false);
                this.func_70638_az().func_70097_a(DamageSourceExtra.lightningBolt, da);
                this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t + dx2, this.field_70163_u + (this.func_70631_g_() ? 9.0 : 18.0), this.field_70161_v + dz2));
                this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t + dx2, this.field_70163_u + (this.func_70631_g_() ? 9.0 : 18.0), this.field_70161_v + dz2));
                this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t + dx2, this.field_70163_u + (this.func_70631_g_() ? 9.0 : 18.0), this.field_70161_v + dz2));
                this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t + dx2, this.field_70163_u + (this.func_70631_g_() ? 9.0 : 18.0), this.field_70161_v + dz2));
                this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v));
                List list1 = this.field_70170_p.func_72839_b((Entity)this.func_70638_az(), this.func_70638_az().field_70121_D.func_72314_b(12.0, 12.0, 12.0));
                if (list1 == null || list1.isEmpty()) continue;
                for (int i11 = 0; i11 < list1.size(); ++i11) {
                    Entity entity1 = (Entity)list1.get(i11);
                    if (!(entity1 instanceof EntityLivingBase) || !this.func_70686_a(entity1.getClass())) continue;
                    this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, entity1.field_70165_t, entity1.field_70163_u, entity1.field_70161_v));
                    this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, entity1.field_70165_t, entity1.field_70163_u, entity1.field_70161_v));
                    this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, entity1.field_70165_t, entity1.field_70163_u, entity1.field_70161_v));
                    this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, entity1.field_70165_t, entity1.field_70163_u, entity1.field_70161_v));
                    this.attackChoosenEntity(entity1, da, i);
                    if (entity1 instanceof EntityTitan) continue;
                    entity1.field_70181_x += (double)(1.0f + this.field_70146_Z.nextFloat());
                }
            }
        }
        if (this.getAnimID() == 12 && this.func_70638_az() != null && this.getAnimTick() > (this.field_70170_p.field_73013_u == EnumDifficulty.HARD ? 52 : (this.field_70170_p.field_73013_u == EnumDifficulty.NORMAL ? 54 : 56)) && this.getAnimTick() <= 60) {
            this.attackEntityWithRangedAttack(this.func_70638_az(), 0.0f);
        }
        if (this.animID != 0 || this.isStunned || this.isAttacking) {
            this.field_70159_w *= 0.0;
            this.field_70179_y *= 0.0;
        }
        if (!AnimationAPI.isEffectiveClient() && this.func_70638_az() != null && !this.isStunned && this.getAnimID() == 0) {
            double d0 = this.func_70068_e((Entity)this.func_70638_az());
            double d = this.field_70130_N * this.field_70130_N + this.func_70638_az().field_70130_N * this.func_70638_az().field_70130_N;
            double d2 = this.func_70631_g_() ? 400.0 : 800.0;
            if (d0 < d + d2) {
                if (this.func_70638_az() instanceof EntityTitan || this.func_70638_az().field_70131_O >= 6.0f || this.func_70638_az().field_70163_u > this.field_70163_u + 6.0) {
                    this.isAttacking = true;
                    switch (this.field_70146_Z.nextInt(2)) {
                        case 0: {
                            AnimationAPI.sendAnimPacket(this, 4);
                            this.setAnimID(4);
                            this.setAnimTick(0);
                            break;
                        }
                        case 1: {
                            AnimationAPI.sendAnimPacket(this, 11);
                            this.setAnimID(11);
                            this.setAnimTick(0);
                        }
                    }
                } else {
                    this.isAttacking = true;
                    switch (this.field_70146_Z.nextInt(5)) {
                        case 0: {
                            AnimationAPI.sendAnimPacket(this, 6);
                            this.setAnimID(6);
                            this.setAnimTick(0);
                            break;
                        }
                        case 1: {
                            if (this.isArmed()) {
                                AnimationAPI.sendAnimPacket(this, 7);
                                this.setAnimID(7);
                            } else if (this.func_70681_au().nextInt(2) == 0) {
                                AnimationAPI.sendAnimPacket(this, 2);
                                this.setAnimID(2);
                            } else {
                                AnimationAPI.sendAnimPacket(this, 1);
                                this.setAnimID(1);
                            }
                            this.setAnimTick(0);
                            break;
                        }
                        case 2: {
                            AnimationAPI.sendAnimPacket(this, 9);
                            this.setAnimID(9);
                            this.setAnimTick(0);
                            break;
                        }
                        case 3: {
                            AnimationAPI.sendAnimPacket(this, 1);
                            this.setAnimID(1);
                            this.setAnimTick(0);
                            break;
                        }
                        case 4: {
                            AnimationAPI.sendAnimPacket(this, 3);
                            this.setAnimID(3);
                            this.setAnimTick(0);
                        }
                    }
                }
            } else if (this.getAnimID() == 0 && this.func_70681_au().nextInt(100) == 0) {
                this.isAttacking = true;
                switch (this.field_70146_Z.nextInt(2)) {
                    case 0: {
                        AnimationAPI.sendAnimPacket(this, 5);
                        this.setAnimID(5);
                        this.setAnimTick(0);
                        break;
                    }
                    case 1: {
                        AnimationAPI.sendAnimPacket(this, 12);
                        this.setAnimID(12);
                        this.setAnimTick(0);
                    }
                }
            }
        }
        if (this.isVillager() && this.func_70631_g_()) {
            this.func_94058_c(StatCollector.func_74838_a((String)"entity.ZombieTitan.name.babyvillager"));
        } else if (!this.isVillager() && this.func_70631_g_()) {
            this.func_94058_c(StatCollector.func_74838_a((String)"entity.ZombieTitan.name.baby"));
        } else if (this.isVillager() && !this.func_70631_g_()) {
            this.func_94058_c(StatCollector.func_74838_a((String)"entity.ZombieTitan.name.villager"));
        } else {
            this.func_94058_c(StatCollector.func_74838_a((String)"entity.ZombieTitan.name"));
        }
        if (TheTitans.NightmareMode) {
            if (this.func_70631_g_()) {
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20000.0);
                if (this.isArmed()) {
                    this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(480.0);
                } else {
                    this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(240.0);
                }
            } else {
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40000.0);
                if (this.isArmed()) {
                    this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(720.0);
                } else {
                    this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(360.0);
                }
            }
        } else if (this.func_70631_g_()) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10000.0);
            if (this.isArmed()) {
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(160.0);
            } else {
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(80.0);
            }
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20000.0);
            if (this.isArmed()) {
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(240.0);
            } else {
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(120.0);
            }
        }
        if (this.field_70146_Z.nextInt(120) == 0 && this.func_70638_az() != null && this.field_70122_E && this.func_70068_e((Entity)this.func_70638_az()) > 512.0 && this.func_110143_aJ() <= this.func_110138_aP() / 2.0f) {
            this.func_70664_aZ();
            this.func_85030_a(this.func_70621_aR(), this.func_70599_aP(), this.func_70647_i());
            double d01 = this.func_70638_az().field_70165_t - this.field_70165_t;
            double d11 = this.func_70638_az().field_70161_v - this.field_70161_v;
            float f21 = MathHelper.func_76133_a((double)(d01 * d01 + d11 * d11));
            double hor = 5.0;
            this.field_70159_w = d01 / (double)f21 * hor * hor + this.field_70159_w * hor;
            this.field_70179_y = d11 / (double)f21 * hor * hor + this.field_70179_y * hor;
        }
        if (this.field_70146_Z.nextInt(this.getMinionSpawnRate()) == 0 && this.func_110143_aJ() > 0.0f && !this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL) {
            if (this.numSpecialMinions < this.getSpecialMinionCap() && this.field_70146_Z.nextInt(100) == 0) {
                EntityGiantZombieBetter entitychicken = new EntityGiantZombieBetter(this.field_70170_p);
                this.teleportEntityRandomly((EntityLivingBase)entitychicken);
                entitychicken.master = this;
                entitychicken.func_110161_a(null);
                this.field_70170_p.func_72838_d((Entity)entitychicken);
                entitychicken.func_70024_g(0.0, 1.0, 0.0);
                entitychicken.func_85030_a("thetitans:titansummonminion", 10.0f, 0.5f);
                ++this.numSpecialMinions;
            } else if (this.numMinions < this.getMinionCap()) {
                EntityZombieLoyalist entitychicken = new EntityZombieLoyalist(this.field_70170_p);
                this.teleportEntityRandomly((EntityLivingBase)entitychicken);
                entitychicken.master = this;
                entitychicken.func_110161_a(null);
                entitychicken.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 40, 4, false));
                entitychicken.func_70024_g(0.0, 0.8, 0.0);
                this.field_70170_p.func_72838_d((Entity)entitychicken);
                entitychicken.func_85030_a("thetitans:titansummonminion", 2.0f, 1.0f);
                entitychicken.func_70690_d(new PotionEffect(Potion.field_76426_n.field_76415_H, Integer.MAX_VALUE, 0, false));
                ++this.numMinions;
                if (this.isVillager()) {
                    entitychicken.func_82229_g(true);
                }
                if (this.func_70631_g_()) {
                    entitychicken.func_82227_f(true);
                }
                Block block2 = this.field_70170_p.func_147439_a((int)entitychicken.field_70165_t, (int)entitychicken.field_70163_u, (int)entitychicken.field_70161_v);
                this.field_70170_p.func_72926_e(2001, (int)entitychicken.field_70165_t, (int)entitychicken.field_70163_u, (int)entitychicken.field_70161_v, Block.func_149682_b((Block)block2));
                if (block2 == Blocks.field_150349_c) {
                    this.field_70170_p.func_147449_b((int)entitychicken.field_70165_t, (int)entitychicken.field_70163_u, (int)entitychicken.field_70161_v, Blocks.field_150346_d);
                }
            }
        }
        if (this.field_70146_Z.nextInt(this.getMinionSpawnRate() * 2) == 0 && this.func_110143_aJ() > 0.0f && !this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL) {
            if (this.numSpecialMinions < this.getSpecialMinionCap() && this.field_70146_Z.nextInt(100) == 0) {
                EntityGiantZombieBetter entitychicken = new EntityGiantZombieBetter(this.field_70170_p);
                this.teleportEntityRandomly((EntityLivingBase)entitychicken);
                entitychicken.master = this;
                entitychicken.func_110161_a(null);
                this.field_70170_p.func_72838_d((Entity)entitychicken);
                entitychicken.func_70024_g(0.0, 1.0, 0.0);
                entitychicken.func_85030_a("thetitans:titansummonminion", 10.0f, 0.5f);
                ++this.numSpecialMinions;
            } else if (this.numPriests < this.getPriestCap()) {
                EntityZombiePriest entitychicken = new EntityZombiePriest(this.field_70170_p);
                this.teleportEntityRandomly((EntityLivingBase)entitychicken);
                entitychicken.master = this;
                entitychicken.func_110161_a(null);
                entitychicken.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 40, 4, false));
                entitychicken.func_70024_g(0.0, 0.8, 0.0);
                this.field_70170_p.func_72838_d((Entity)entitychicken);
                entitychicken.func_85030_a("thetitans:titansummonminion", 2.0f, 1.0f);
                entitychicken.func_70690_d(new PotionEffect(Potion.field_76426_n.field_76415_H, Integer.MAX_VALUE, 0, false));
                ++this.numPriests;
                if (this.isVillager()) {
                    entitychicken.func_82229_g(true);
                }
                if (this.func_70631_g_()) {
                    entitychicken.func_82227_f(true);
                }
                Block block3 = this.field_70170_p.func_147439_a((int)entitychicken.field_70165_t, (int)entitychicken.field_70163_u, (int)entitychicken.field_70161_v);
                this.field_70170_p.func_72926_e(2001, (int)entitychicken.field_70165_t, (int)entitychicken.field_70163_u, (int)entitychicken.field_70161_v, Block.func_149682_b((Block)block3));
                if (block3 == Blocks.field_150349_c) {
                    this.field_70170_p.func_147449_b((int)entitychicken.field_70165_t, (int)entitychicken.field_70163_u, (int)entitychicken.field_70161_v, Blocks.field_150346_d);
                }
            }
        }
        if (this.field_70146_Z.nextInt(this.getMinionSpawnRate() * 5) == 0 && this.func_110143_aJ() > 0.0f && !this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL) {
            if (this.numSpecialMinions < this.getSpecialMinionCap() && this.field_70146_Z.nextInt(100) == 0) {
                EntityGiantZombieBetter entitychicken = new EntityGiantZombieBetter(this.field_70170_p);
                this.teleportEntityRandomly((EntityLivingBase)entitychicken);
                entitychicken.master = this;
                entitychicken.func_110161_a(null);
                this.field_70170_p.func_72838_d((Entity)entitychicken);
                entitychicken.func_70024_g(0.0, 1.0, 0.0);
                entitychicken.func_85030_a("thetitans:titansummonminion", 10.0f, 0.5f);
                ++this.numSpecialMinions;
            } else if (this.numZealots < this.getZealotCap()) {
                EntityZombieZealot entitychicken = new EntityZombieZealot(this.field_70170_p);
                this.teleportEntityRandomly((EntityLivingBase)entitychicken);
                entitychicken.master = this;
                entitychicken.func_110161_a(null);
                entitychicken.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 40, 4, false));
                entitychicken.func_70024_g(0.0, 0.8, 0.0);
                this.field_70170_p.func_72838_d((Entity)entitychicken);
                entitychicken.func_85030_a("thetitans:titansummonminion", 2.0f, 1.0f);
                entitychicken.func_70690_d(new PotionEffect(Potion.field_76426_n.field_76415_H, Integer.MAX_VALUE, 0, false));
                ++this.numZealots;
                if (this.isVillager()) {
                    entitychicken.func_82229_g(true);
                }
                if (this.func_70631_g_()) {
                    entitychicken.func_82227_f(true);
                }
                Block block4 = this.field_70170_p.func_147439_a((int)entitychicken.field_70165_t, (int)entitychicken.field_70163_u, (int)entitychicken.field_70161_v);
                this.field_70170_p.func_72926_e(2001, (int)entitychicken.field_70165_t, (int)entitychicken.field_70163_u, (int)entitychicken.field_70161_v, Block.func_149682_b((Block)block4));
                if (block4 == Blocks.field_150349_c) {
                    this.field_70170_p.func_147449_b((int)entitychicken.field_70165_t, (int)entitychicken.field_70163_u, (int)entitychicken.field_70161_v, Blocks.field_150346_d);
                }
            }
        }
        if (this.field_70146_Z.nextInt(this.getMinionSpawnRate() * 10) == 0 && this.func_110143_aJ() > 0.0f && !this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL) {
            if (this.numSpecialMinions < this.getSpecialMinionCap() && this.field_70146_Z.nextInt(100) == 0) {
                EntityGiantZombieBetter entitychicken = new EntityGiantZombieBetter(this.field_70170_p);
                this.teleportEntityRandomly((EntityLivingBase)entitychicken);
                entitychicken.master = this;
                entitychicken.func_110161_a(null);
                this.field_70170_p.func_72838_d((Entity)entitychicken);
                entitychicken.func_70024_g(0.0, 1.0, 0.0);
                entitychicken.func_85030_a("thetitans:titansummonminion", 10.0f, 0.5f);
                ++this.numSpecialMinions;
            } else if (this.numTemplar < this.getTemplarCap()) {
                EntityZombieTemplar entitychicken = new EntityZombieTemplar(this.field_70170_p);
                this.teleportEntityRandomly((EntityLivingBase)entitychicken);
                entitychicken.master = this;
                entitychicken.func_110161_a(null);
                entitychicken.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 40, 4, false));
                entitychicken.func_70024_g(0.0, 0.8, 0.0);
                this.field_70170_p.func_72838_d((Entity)entitychicken);
                entitychicken.func_85030_a("thetitans:titansummonminion", 2.0f, 1.0f);
                entitychicken.func_70690_d(new PotionEffect(Potion.field_76426_n.field_76415_H, Integer.MAX_VALUE, 0, false));
                ++this.numTemplar;
                if (this.isVillager()) {
                    entitychicken.func_82229_g(true);
                }
                if (this.func_70631_g_()) {
                    entitychicken.func_82227_f(true);
                }
                Block block5 = this.field_70170_p.func_147439_a((int)entitychicken.field_70165_t, (int)entitychicken.field_70163_u, (int)entitychicken.field_70161_v);
                this.field_70170_p.func_72926_e(2001, (int)entitychicken.field_70165_t, (int)entitychicken.field_70163_u, (int)entitychicken.field_70161_v, Block.func_149682_b((Block)block5));
                if (block5 == Blocks.field_150349_c) {
                    this.field_70170_p.func_147449_b((int)entitychicken.field_70165_t, (int)entitychicken.field_70163_u, (int)entitychicken.field_70161_v, Blocks.field_150346_d);
                }
            }
        }
    }

    @Override
    protected void func_70619_bc() {
        List list11 = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D);
        if (list11 != null && !list11.isEmpty()) {
            for (int i1 = 0; i1 < list11.size(); ++i1) {
                Entity entity = (Entity)list11.get(i1);
                if (!(entity instanceof EntityLivingBase) || !entity.field_70122_E || entity instanceof EntityTitan || !this.func_70089_S() || this.isStunned) continue;
                float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
                entity.func_70097_a(DamageSourceExtra.causeSquishingDamage((Entity)this), f / 2.0f);
            }
        }
        super.func_70619_bc();
    }

    protected String func_70639_aQ() {
        this.func_85030_a("mob.zombie.say", this.func_70599_aP(), this.func_70647_i() - 0.6f);
        return "thetitans:titanZombieLiving";
    }

    @Override
    protected String func_70621_aR() {
        this.func_85030_a("mob.zombie.hurt", this.func_70599_aP(), this.func_70647_i() - 0.6f);
        return "thetitans:titanZombieGrunt";
    }

    @Override
    protected String func_70673_aS() {
        this.func_85030_a("mob.zombie.death", this.func_70599_aP(), this.func_70647_i() - 0.6f);
        return "thetitans:titanZombieDeath";
    }

    protected void func_145780_a(int p_145780_1_, int p_145780_2_, int p_145780_3_, Block p_145780_4_) {
        this.func_85030_a("thetitans:titanStep", 10.0f, 1.0f);
        float f3 = this.field_70177_z * (float)Math.PI / 180.0f;
        float f11 = MathHelper.func_76126_a((float)f3);
        float f4 = MathHelper.func_76134_b((float)f3);
        this.collideWithEntities(this.leftLeg, this.field_70170_p.func_72839_b((Entity)this, this.leftLeg.field_70121_D.func_72314_b(1.0, 1.0, 1.0).func_72317_d((double)(f11 * 4.0f), 0.0, (double)(f4 * 4.0f))));
        this.collideWithEntities(this.rightLeg, this.field_70170_p.func_72839_b((Entity)this, this.rightLeg.field_70121_D.func_72314_b(1.0, 1.0, 1.0).func_72317_d((double)(f11 * 4.0f), 0.0, (double)(f4 * 4.0f))));
    }

    protected void dropSword() {
        if (this.isArmed()) {
            EntityItem entityitem;
            int l;
            for (l = 0; l < 16; ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 8.0f - 4.0f), this.field_70163_u + 32.0 + (double)(this.field_70146_Z.nextFloat() * 8.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 8.0f - 4.0f), new ItemStack(Items.field_151055_y));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 32; ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 8.0f - 4.0f), this.field_70163_u + 40.0 + (double)(this.field_70146_Z.nextFloat() * 16.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 8.0f - 4.0f), new ItemStack(Items.field_151042_j));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            this.func_85030_a("random.break", 100.0f, 0.5f);
            this.setArmed(false);
        }
    }

    protected Item func_146068_u() {
        return Items.field_151078_bh;
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        if (this.deathTicks > 0) {
            EntityItem entityitem;
            int l;
            if (this.isArmed()) {
                for (l = 0; l < 16; ++l) {
                    entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151055_y));
                    entityitem.field_145804_b = 40;
                    this.field_70170_p.func_72838_d((Entity)entityitem);
                }
                for (l = 0; l < 32; ++l) {
                    entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151042_j));
                    entityitem.field_145804_b = 40;
                    this.field_70170_p.func_72838_d((Entity)entityitem);
                }
            }
            for (l = 0; l < 128 + this.field_70146_Z.nextInt(128 + p_70628_2_) + p_70628_2_; ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151078_bh));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 32 + this.field_70146_Z.nextInt(32 + p_70628_2_) + p_70628_2_; ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151103_aS));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 32 + this.field_70146_Z.nextInt(32 + p_70628_2_) + p_70628_2_; ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151044_h));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 32 + this.field_70146_Z.nextInt(32 + p_70628_2_) + p_70628_2_; ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151042_j));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 8 + this.field_70146_Z.nextInt(8 + p_70628_2_); ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151166_bC));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 8 + this.field_70146_Z.nextInt(8 + p_70628_2_); ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151045_i));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 0 + this.field_70146_Z.nextInt(4 + p_70628_2_); ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(TitanItems.harcadium));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            if (this.field_70146_Z.nextInt(10) == 0) {
                EntityItem entityitem2 = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Blocks.field_150357_h));
                entityitem2.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem2);
            }
        }
    }

    protected void func_70600_l(int p_70600_1_) {
        switch (this.field_70146_Z.nextInt(3)) {
            case 0: {
                this.func_145779_a(Items.field_151042_j, 64);
                break;
            }
            case 1: {
                this.func_145779_a(Items.field_151172_bF, 64);
                break;
            }
            case 2: {
                this.func_145779_a(Items.field_151174_bG, 64);
            }
        }
    }

    protected void func_82164_bB() {
        super.func_82164_bB();
        float f = this.field_70146_Z.nextFloat();
        float f2 = this.field_70170_p.field_73013_u == EnumDifficulty.HARD ? 0.05f : 0.01f;
        if (f < f2) {
            int i = this.field_70146_Z.nextInt(3);
            if (i == 0) {
                this.func_70062_b(0, new ItemStack(Items.field_151040_l));
            } else {
                this.func_70062_b(0, new ItemStack(Items.field_151037_a));
            }
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        if (this.func_70631_g_()) {
            tagCompound.func_74757_a("IsBaby", true);
        }
        if (this.isVillager()) {
            tagCompound.func_74757_a("IsVillager", true);
        }
        if (this.isArmed()) {
            tagCompound.func_74757_a("IsArmed", true);
        }
        tagCompound.func_74757_a("Stunned", this.isStunned);
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        if (tagCompund.func_74767_n("IsBaby")) {
            this.setChild(true);
        }
        if (tagCompund.func_74767_n("IsVillager")) {
            this.setVillager(true);
        }
        if (tagCompund.func_74767_n("IsArmed")) {
            this.setArmed(true);
        }
        this.isStunned = tagCompund.func_74767_n("Stunned");
    }

    public void func_82206_m() {
        this.setInvulTime(860);
        this.setTitanHealth(this.func_110138_aP() / 10.0f);
    }

    public void func_70074_a(EntityLivingBase entityLivingIn) {
        super.func_70074_a(entityLivingIn);
        if (entityLivingIn instanceof EntityVillager) {
            EntityZombieLoyalist entityzombie = new EntityZombieLoyalist(this.field_70170_p);
            entityzombie.func_82149_j((Entity)entityLivingIn);
            this.field_70170_p.func_72900_e((Entity)entityLivingIn);
            entityzombie.func_110161_a(null);
            entityzombie.func_82229_g(true);
            if (entityLivingIn.func_70631_g_()) {
                entityzombie.func_82227_f(true);
            }
            this.field_70170_p.func_72838_d((Entity)entityzombie);
            this.field_70170_p.func_72889_a((EntityPlayer)null, 1016, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 0);
        }
    }

    public float func_70047_e() {
        float f = 27.6f;
        if (this.func_70631_g_()) {
            f = 14.8f;
        }
        return f;
    }

    @Override
    public IEntityLivingData func_110161_a(IEntityLivingData p_180482_2_) {
        Calendar calendar;
        IEntityLivingData p_180482_2_1 = super.func_110161_a(p_180482_2_);
        this.func_98053_h(true);
        if (p_180482_2_1 == null) {
            p_180482_2_1 = new GroupData(this.field_70170_p.field_73012_v.nextFloat() < ForgeModContainer.zombieBabyChance, this.field_70170_p.field_73012_v.nextFloat() < 0.05f, null);
        }
        if (p_180482_2_1 instanceof GroupData) {
            GroupData groupdata = (GroupData)p_180482_2_1;
            if (groupdata.field_142046_b) {
                this.setVillager(true);
            }
            if (groupdata.field_142048_a) {
                this.setChild(true);
            }
        }
        this.setArmed(true);
        this.func_82164_bB();
        this.func_82162_bC();
        if (this.func_71124_b(4) == null && (calendar = this.field_70170_p.func_83015_S()).get(2) + 1 == 10 && calendar.get(5) == 31 && this.field_70146_Z.nextFloat() < 0.25f) {
            this.func_70062_b(4, new ItemStack(this.field_70146_Z.nextFloat() < 0.1f ? Blocks.field_150428_aP : Blocks.field_150423_aK));
            this.field_82174_bp[4] = 0.0f;
        }
        return p_180482_2_1;
    }

    public double func_70033_W() {
        return super.func_70033_W() - 8.0;
    }

    @Override
    public StatBase getAchievement() {
        return TitansAchievments.zombietitan;
    }

    @Override
    protected void inactDeathAction() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
                this.func_70628_a(true, 0);
                this.func_82160_b(true, 0);
                this.func_70600_l(1);
            }
            EntityTitanSpirit entitytitan = new EntityTitanSpirit(this.field_70170_p);
            entitytitan.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
            this.field_70170_p.func_72838_d((Entity)entitytitan);
            entitytitan.setVesselHunting(false);
            entitytitan.setSpiritType(6);
        }
    }

    @Override
    protected void onTitanDeathUpdate() {
        this.field_70180_af.func_75692_b(6, (Object)Float.valueOf(MathHelper.func_76131_a((float)this.field_70180_af.func_111145_d(5), (float)0.0f, (float)this.func_110138_aP())));
        if (this.field_70180_af.func_111145_d(5) <= 0.0f) {
            ++this.deathTicks;
            AnimationAPI.sendAnimPacket(this, 10);
            this.setAnimID(10);
            this.setTitanHealth(0.0f);
        } else {
            this.func_70097_a(DamageSource.field_76380_i, 25.0f);
            this.setTitanHealth(this.field_70180_af.func_111145_d(5));
            this.func_70606_j(this.field_70180_af.func_111145_d(5));
            this.deathTicks = 0;
            if (this.animID == 10) {
                this.animID = 0;
            }
        }
        this.field_70159_w *= 0.0;
        this.field_70179_y *= 0.0;
        this.func_70624_b(null);
        if (this.deathTicks == 1 && !this.field_70170_p.field_72995_K) {
            this.func_85030_a(this.func_70673_aS(), this.func_70599_aP(), this.func_70647_i());
            ArrayList listp = Lists.newArrayList((Iterable)this.field_70170_p.field_73010_i);
            if (listp != null && !listp.isEmpty()) {
                for (int i1 = 0; i1 < listp.size(); ++i1) {
                    Entity entity = (Entity)listp.get(i1);
                    if (entity == null || !(entity instanceof EntityPlayer)) continue;
                    ((EntityPlayer)entity).func_71029_a(this.getAchievement());
                }
            }
        }
        if (this.deathTicks == 1) {
            this.setAnimTick(1);
        }
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot") && this.deathTicks >= 500 && this.deathTicks % 10 == 0) {
            int j;
            for (int i = this.func_70693_a(this.field_70717_bb) / 10; i > 0; i -= j) {
                j = EntityXPOrb.func_70527_a((int)i);
                this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u + 64.0, this.field_70161_v, j));
            }
        }
        if (this.deathTicks >= 500) {
            this.setInvulTime(this.getInvulTime() + 8);
            --this.animTick;
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 12.0f;
            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 3.0f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 12.0f;
            this.field_70170_p.func_72869_a("hugeexplosion", this.field_70165_t + (double)f, this.field_70163_u + 2.0 + (double)f1, this.field_70161_v + (double)f2, 0.0, 0.0, 0.0);
        }
        if (this.getInvulTime() >= this.getThreashHold()) {
            this.func_70106_y();
        }
    }

    public void collideWithEntities(EntityDragonPart part, List p_70970_1_) {
        double d0 = (part.field_70121_D.field_72340_a + part.field_70121_D.field_72336_d) / 2.0;
        double d1 = (part.field_70121_D.field_72339_c + part.field_70121_D.field_72334_f) / 2.0;
        for (Entity entity : p_70970_1_) {
            if (entity == null || !(entity instanceof EntityLivingBase) || entity instanceof EntityTitan || entity instanceof EntityTitanSpirit || !this.func_70686_a(entity.getClass()) || !entity.func_70067_L()) continue;
            double d2 = entity.field_70165_t - d0;
            double d3 = entity.field_70161_v - d1;
            double d4 = d2 * d2 + d3 * d3;
            entity.func_70024_g(d2 / d4 * 0.75, 0.25, d3 / d4 * 0.75);
            entity.func_70097_a(DamageSource.func_92087_a((Entity)this), 10.0f);
        }
    }

    public boolean attackZombieFrom(DamageSource source, float amount) {
        if (this.isArmored()) {
            amount *= 0.1f;
        }
        if (source.func_76346_g() instanceof EntityPlayer && !this.field_70170_p.field_72995_K) {
            this.func_70624_b((EntityLivingBase)source.func_76346_g());
            this.func_70604_c((EntityLivingBase)source.func_76346_g());
        }
        if (this.func_85032_ar()) {
            return false;
        }
        if (this.isArmed() && source.func_76346_g() instanceof EntityPlayer) {
            return false;
        }
        if (this.isArmored() && source instanceof EntityDamageSourceIndirect) {
            return false;
        }
        if (source.func_76346_g() instanceof EntityZombieLoyalist || source.func_76346_g() instanceof EntityZombieTitan || source.func_76346_g() instanceof EntityGiantZombieBetter) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (entity instanceof EntityLivingBase && !this.func_85032_ar() && amount > 25.0f) {
            List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(100.0, 100.0, 100.0));
            for (int i = 0; i < list.size(); ++i) {
                Entity entity1 = (Entity)list.get(i);
                if (entity1 instanceof EntityZombieTitan) {
                    EntityZombieTitan entitypigzombie = (EntityZombieTitan)entity1;
                    entitypigzombie.func_70624_b((EntityLivingBase)entity);
                    entitypigzombie.func_70604_c((EntityLivingBase)entity);
                }
                this.func_70624_b((EntityLivingBase)entity);
                this.func_70604_c((EntityLivingBase)entity);
            }
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        return this.attackZombieFrom(source, amount);
    }

    public boolean func_70067_L() {
        return false;
    }

    public Entity[] func_70021_al() {
        return this.partArray;
    }

    public boolean func_70965_a(EntityDragonPart p_70965_1_, DamageSource source, float amount) {
        if (p_70965_1_ != this.head) {
            amount /= 3.0f;
        }
        this.func_82195_e(source, amount);
        return true;
    }

    protected boolean func_82195_e(DamageSource p_82195_1_, float p_82195_2_) {
        return this.attackZombieFrom(p_82195_1_, p_82195_2_);
    }

    public World func_82194_d() {
        return this.field_70170_p;
    }

    @Override
    public void setAnimID(int id) {
        this.animID = id;
    }

    @Override
    public void setAnimTick(int tick) {
        this.animTick = tick;
    }

    @Override
    public int getAnimID() {
        return this.animID;
    }

    @Override
    public int getAnimTick() {
        return this.animTick;
    }

    class GroupData
    implements IEntityLivingData {
        public boolean field_142048_a = false;
        public boolean field_142046_b = false;

        private GroupData(boolean p_i2348_2_, boolean p_i2348_3_) {
            this.field_142048_a = p_i2348_2_;
            this.field_142046_b = p_i2348_3_;
        }

        GroupData(boolean p_i2349_2_, boolean p_i2349_3_, Object p_i2349_4_) {
            this(p_i2349_2_, p_i2349_3_);
        }
    }
}

