/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.titan;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEndPortal;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityWitherSkull;
import net.minecraft.entity.titan.EntityTitan;
import net.minecraft.entity.titan.EntityTitanSpirit;
import net.minecraft.entity.titan.EntityWitherTurret;
import net.minecraft.entity.titan.EntityWitherTurretGround;
import net.minecraft.entity.titan.EntityWitherTurretMortar;
import net.minecraft.entity.titan.EntityWitherzillaMinion;
import net.minecraft.entity.titan.EnumTitanStatus;
import net.minecraft.entity.titan.ai.EntityAINearestTargetTitan;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.UserListBansEntry;
import net.minecraft.server.management.UserListEntry;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.theTitans.TheTitans;
import net.minecraft.theTitans.TitanBlocks;
import net.minecraft.theTitans.TitanItems;
import net.minecraft.theTitans.TitansAchievments;
import net.minecraft.theTitans.world.WorldProviderVoid;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Facing;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderEnd;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;

public class EntityWitherzilla
extends EntityTitan
implements IRangedAttackMob {
    private float[] field_82220_d = new float[2];
    private float[] field_82221_e = new float[2];
    private float[] field_82217_f = new float[2];
    private float[] field_82218_g = new float[2];
    private int[] field_82223_h = new int[2];
    private int[] field_82224_i = new int[2];
    private int blockBreakCounter;
    public int affectTicks;
    private int attackTimer;
    private int omegacounter;
    ArrayList allPlayerList;
    private static final IEntitySelector attackEntitySelector = new IEntitySelector(){

        public boolean func_82704_a(Entity p_180027_1_) {
            return !(p_180027_1_ instanceof EntityTitanSpirit) && !(p_180027_1_ instanceof EntityWitherzilla) && !(p_180027_1_ instanceof EntityWitherzillaMinion) && !(p_180027_1_ instanceof EntityWitherTurret) && !(p_180027_1_ instanceof EntityWitherTurretGround) && !(p_180027_1_ instanceof EntityWitherTurretMortar);
        }
    };

    public EntityWitherzilla(World worldIn) {
        super(worldIn);
        this.allPlayerList = Lists.newArrayList((Iterable)this.field_70170_p.field_73010_i);
        this.setTitanHealth(this.func_110138_aP());
        this.field_70156_m = true;
        this.func_70105_a(48.0f, 48.0f);
        this.field_70178_ae = true;
        this.field_70145_X = true;
        this.field_70728_aV = 5000000;
        this.func_85030_a("thetitans:witherzillaSpawn", Float.MAX_VALUE, 1.0f);
        this.func_85030_a("thetitans:witherzillaSpawn", Float.MAX_VALUE, 1.0f);
        this.func_85030_a("thetitans:witherzillaSpawn", Float.MAX_VALUE, 1.0f);
        this.func_85030_a("thetitans:witherzillaSpawn", Float.MAX_VALUE, 1.0f);
        this.func_85030_a("thetitans:titanBirth", Float.MAX_VALUE, 0.75f);
        this.func_85030_a("thetitans:titanBirth", Float.MAX_VALUE, 0.75f);
        this.func_85030_a("thetitans:titanBirth", Float.MAX_VALUE, 0.75f);
        this.func_85030_a("thetitans:titanBirth", Float.MAX_VALUE, 0.75f);
        this.playLivingSound2();
    }

    @Override
    protected void applyEntityAI() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan(this, EntityLivingBase.class, 0, false, false, attackEntitySelector));
    }

    @Override
    public int getMinionCap() {
        return 240;
    }

    public boolean func_70067_L() {
        return true;
    }

    @Override
    protected EntityLivingBase getMinion() {
        return new EntityWitherzillaMinion(this.field_70170_p);
    }

    @Override
    public int getMinionSpawnRate() {
        return TheTitans.WitherzillaMinionSpawnrate;
    }

    @Override
    public int getParticleCount() {
        return 50;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(Double.MAX_VALUE);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    @Override
    public int getRegenTime() {
        return 1;
    }

    @Override
    public float getRegen() {
        return 20.0f;
    }

    @Override
    public EnumTitanStatus getTitanStatus() {
        return EnumTitanStatus.GOD;
    }

    @Override
    public float func_70603_bj() {
        return this.isInOmegaForm() ? 64.0f : 32.0f;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(17, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(18, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(19, (Object)new Integer(0));
    }

    public int getTalkInterval2() {
        return 20;
    }

    public void func_70030_z() {
        super.func_70030_z();
        this.field_70170_p.field_72984_F.func_76320_a("zillaBaseTick");
        if (this.isArmored() && this.func_70089_S() && this.field_70146_Z.nextInt(50) < this.field_70757_a++) {
            this.field_70757_a = -30;
            this.playLivingSound2();
        }
        this.field_70170_p.field_72984_F.func_76319_b();
    }

    public void playLivingSound2() {
        String s = this.getLivingSound2();
        if (s != null) {
            this.func_85030_a(s, this.func_70599_aP(), 1.0f);
        }
    }

    protected String getLivingSound2() {
        return "thetitans:witherzillaLiving2";
    }

    protected String func_70639_aQ() {
        return "thetitans:witherzillaLiving";
    }

    @Override
    protected String func_70621_aR() {
        return "thetitans:witherzillaGrunt";
    }

    @Override
    protected String func_70673_aS() {
        return "thetitans:witherzillaDeath";
    }

    @Override
    public boolean func_70601_bi() {
        return false;
    }

    @Override
    public boolean canBeHurtByPlayer() {
        return this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL && !this.func_85032_ar();
    }

    protected void func_70076_C() {
        this.field_70170_p.func_82739_e(1013, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 0);
        if (this.field_70170_p.field_73011_w instanceof WorldProviderVoid || this.field_70170_p.field_73011_w instanceof WorldProviderEnd) {
            this.teleportRandomly(true);
        } else {
            this.teleportRandomly(false);
        }
    }

    public void doLightningAttackTo(Entity entity) {
        if (entity != null && entity.func_70089_S()) {
            if (!(entity instanceof EntityTitan) && entity.field_70131_O >= 6.0f || entity.func_85032_ar()) {
                ((EntityLivingBase)entity).func_70606_j(0.0f);
                ((EntityLivingBase)entity).func_70097_a(DamageSource.field_76380_i, Float.MAX_VALUE);
            }
            if (!(entity == null || this.affectTicks < 600 && !(entity.field_70131_O >= 6.0f) || entity instanceof EntityTitan || entity instanceof EntityPlayer)) {
                ((EntityLivingBase)entity).func_70606_j(0.0f);
                for (int i = 0; i < 50; ++i) {
                    this.attackChoosenEntity(entity, 2.1474836E9f, 0);
                }
            }
            this.func_70625_a((Entity)((EntityLivingBase)entity), 180.0f, 180.0f);
            if (entity instanceof EntityTitan) {
                this.attackChoosenEntity(entity, 1000.0f, 0);
                ((EntityTitan)entity).setInvulTime(((EntityTitan)entity).getInvulTime() - 20);
            } else {
                this.attackChoosenEntity(entity, 10.0f, 0);
                entity.field_70181_x += 0.5;
            }
            if (entity instanceof EntityMob) {
                ((EntityLivingBase)entity).func_70604_c((EntityLivingBase)this);
            }
            this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v));
            this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v));
            entity.field_70172_ad = 1;
        }
    }

    @Override
    public void func_70624_b(EntityLivingBase p_70624_1_) {
        if (this.field_70170_p.field_73011_w instanceof WorldProviderVoid && p_70624_1_ != null && this.field_70165_t == 0.0 && this.field_70163_u == 200.0 && this.field_70161_v == 0.0) {
            p_70624_1_ = null;
        } else {
            super.func_70624_b(p_70624_1_);
        }
    }

    @Override
    public void func_70636_d() {
        int j;
        int i;
        Entity entity;
        List list11;
        List list;
        ArrayList listp;
        int i1;
        Entity entity2;
        double d0;
        if (this.func_70638_az() != null && this.canAttack() && this.func_70638_az() instanceof EntityLivingBase && (d0 = this.func_70068_e((Entity)this.func_70638_az())) < (double)(this.field_70130_N * this.field_70130_N + this.func_70638_az().field_70130_N * this.func_70638_az().field_70130_N) + 6000.0) {
            this.func_71038_i();
            this.func_70652_k((Entity)this.func_70638_az());
        }
        if (this.field_70163_u <= 0.0) {
            this.field_70170_p.func_82739_e(1013, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 0);
            if (this.field_70170_p.field_73011_w instanceof WorldProviderVoid || this.field_70170_p.field_73011_w instanceof WorldProviderEnd) {
                this.teleportRandomly(true);
            } else {
                this.teleportRandomly(false);
            }
        }
        if (this.affectTicks >= 800) {
            this.func_82142_c(true);
        } else {
            this.func_82142_c(false);
        }
        --this.omegacounter;
        this.func_70105_a(48.0f, 48.0f);
        this.field_70170_p.func_72877_b(1806000L);
        if (this.field_70173_aa % 200 == 0 && !(this.field_70170_p.field_73011_w instanceof WorldProviderVoid)) {
            WorldServer worldserver = MinecraftServer.func_71276_C().field_71305_c[0];
            WorldInfo worldinfo = worldserver.func_72912_H();
            worldinfo.func_76080_g(9999999);
            worldinfo.func_76090_f(1000000);
            worldinfo.func_76084_b(true);
            worldinfo.func_76069_a(true);
            entity2 = this.field_70170_p.func_72890_a((Entity)this, -1.0);
            if (!(this.field_70170_p.field_73011_w instanceof WorldProviderVoid)) {
                this.omegacounter = 600;
            }
            if (this.allPlayerList != null && !this.allPlayerList.isEmpty() && !(this.field_70170_p.field_73011_w instanceof WorldProviderVoid) && this.func_70638_az() == null && this.field_70170_p.field_73011_w == entity2.field_70170_p.field_73011_w) {
                for (i1 = 0; i1 < this.allPlayerList.size(); ++i1) {
                    this.teleportToEntity(entity2, true);
                    if (entity2.field_71075_bZ.field_75102_a) continue;
                    this.func_70624_b((EntityLivingBase)entity2);
                }
            }
            if (this.deathTicks <= 0 && this.allPlayerList != null && !this.allPlayerList.isEmpty() && !(this.field_70170_p.field_73011_w instanceof WorldProviderVoid) && this.field_70146_Z.nextInt(20) == 0 && this.func_70638_az() != null && this.func_70638_az() == entity2 && this.isArmored()) {
                for (i1 = 0; i1 < this.allPlayerList.size(); ++i1) {
                    if (!this.field_70170_p.field_72995_K) {
                        MinecraftServer minecraftserver = MinecraftServer.func_71276_C();
                        GameProfile gameprofile = minecraftserver.func_152358_ax().func_152655_a(entity2.func_70005_c_());
                        EntityPlayerMP entityplayermp = minecraftserver.func_71203_ab().func_152612_a(entity2.func_70005_c_());
                        if (entityplayermp == null || entity2.getDisplayName().equals("Umbrella_Ghast")) continue;
                        this.attackChoosenEntity(entity2, 2.1474836E9f, 0);
                        entity2.func_70106_y();
                        UserListBansEntry userlistbansentry = new UserListBansEntry(gameprofile, (Date)null, entity2.func_70005_c_(), (Date)null, null);
                        minecraftserver.func_71203_ab().func_152608_h().func_152687_a((UserListEntry)userlistbansentry);
                        entityplayermp.field_71135_a.func_147360_c("You've been banned from this server by Witherzilla for being annoying.");
                        continue;
                    }
                    if (entity2.getDisplayName().equals("Umbrella_Ghast")) continue;
                    this.attackChoosenEntity(entity2, 2.1474836E9f, 0);
                    entity2.func_70106_y();
                    throw new IllegalArgumentException("You've been banned from your saved world by Witherzilla for being annoying.");
                }
            }
        }
        if ((listp = Lists.newArrayList((Iterable)this.field_70170_p.field_73010_i)) != null && !listp.isEmpty()) {
            for (int i12 = 0; i12 < listp.size(); ++i12) {
                entity2 = (Entity)listp.get(i12);
                if (entity2 == null || !(entity2 instanceof EntityPlayer) || this.field_70146_Z.nextInt(400) != 0) continue;
                this.func_70642_aH();
                if (!(this.field_70170_p.field_73011_w instanceof WorldProviderVoid)) {
                    ((EntityPlayer)entity2).func_70097_a(DamageSource.field_76380_i, 10.0f);
                    ((EntityPlayer)entity2).func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)("dialog.witherzilla.taunt." + this.field_70146_Z.nextInt(6)))));
                    continue;
                }
                ((EntityPlayer)entity2).func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)("dialog.witherzilla.plead." + this.field_70146_Z.nextInt(6)))));
            }
        }
        if ((list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(256.0, 256.0, 256.0))) != null && !list.isEmpty()) {
            for (int i13 = 0; i13 < list.size(); ++i13) {
                Entity entity3 = (Entity)list.get(i13);
                if (entity3 == null || this.func_70638_az() == null || !(entity3 instanceof EntityWitherzillaMinion)) continue;
                ((EntityWitherzillaMinion)entity3).func_70624_b(this.func_70638_az());
            }
        }
        if (TheTitans.NightmareMode) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(1000000.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(500000.0);
        }
        if (this.field_70173_aa % 3 + this.field_70146_Z.nextInt(3) == 0) {
            this.func_94058_c("\u00a7kJvguremvyyn");
        } else {
            this.func_94058_c("\u00a7l" + StatCollector.func_74838_a((String)"entity.WitherBossTitan.name"));
        }
        if (this.func_70638_az() != null && !(this.field_70170_p.field_73011_w instanceof WorldProviderVoid) && (this.affectTicks >= 400 || this.func_70638_az().field_70131_O > 6.0f && !(this.func_70638_az() instanceof EntityTitan))) {
            this.doLightningAttackTo((Entity)this.func_70638_az());
            if (this.isInOmegaForm()) {
                for (int i14 = 0; i14 < 49; ++i14) {
                    this.doLightningAttackTo((Entity)this.func_70638_az());
                    this.func_70638_az().func_70097_a(DamageSource.field_76380_i, 1.0f);
                }
            }
        }
        ++this.affectTicks;
        if (this.affectTicks >= 1010) {
            this.affectTicks = 0;
        }
        if (this.func_70638_az() != null && !this.func_70638_az().func_70089_S()) {
            this.func_70624_b(null);
        }
        if (this.numMinions < this.getMinionCap() && this.field_70146_Z.nextInt(this.getMinionSpawnRate()) == 0 && this.func_110143_aJ() > 0.0f && !this.field_70170_p.field_72995_K) {
            EntityWitherzillaMinion entitychicken = new EntityWitherzillaMinion(this.field_70170_p);
            entitychicken.func_70012_b(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, this.field_70177_z, 0.0f);
            entitychicken.func_82206_m();
            this.field_70170_p.func_72838_d((Entity)entitychicken);
            entitychicken.func_70024_g(-MathHelper.func_76126_a((float)(this.field_70759_as * (float)Math.PI / 180.0f)) * 3.0f, 0.0, MathHelper.func_76134_b((float)(this.field_70759_as * (float)Math.PI / 180.0f)) * 3.0f);
            ++this.numMinions;
        }
        if (this.field_70146_Z.nextInt(120) == 0 && this.func_70638_az() != null && !this.field_70170_p.field_72995_K) {
            if (TheTitans.NightmareMode) {
                this.field_70170_p.func_72885_a((Entity)this, this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v, 14.0f, true, true);
            } else {
                this.field_70170_p.func_72885_a((Entity)this, this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v, 7.0f, false, this.field_70170_p.func_82736_K().func_82766_b("mobGriefing"));
            }
            this.field_70170_p.func_82739_e(1013, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 0);
        }
        if ((list11 = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(256.0, 256.0, 256.0))) != null && !list11.isEmpty() && this.field_70170_p.field_73011_w instanceof WorldProviderVoid) {
            for (i1 = 0; i1 < list11.size(); ++i1) {
                Entity entity1;
                int i11;
                Entity entity4 = (Entity)list11.get(i1);
                if (entity4 != null && (entity4 instanceof EntityWitherTurret && !((EntityWitherTurret)entity4).isPlayerCreated() || entity4 instanceof EntityWitherTurretGround && !((EntityWitherTurretGround)entity4).isPlayerCreated())) {
                    super.func_70634_a(0.0, 200.0, 0.0);
                    this.field_70181_x *= 0.0;
                    if (listp == null || listp.isEmpty()) continue;
                    for (i11 = 0; i11 < listp.size(); ++i11) {
                        entity1 = (Entity)listp.get(i11);
                        if (entity1 == null || !(entity1 instanceof EntityPlayer)) continue;
                        this.func_70671_ap().func_75651_a(entity1, 180.0f, 180.0f);
                    }
                    continue;
                }
                super.func_70634_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                this.field_70181_x *= 1.0;
                if (listp == null || listp.isEmpty()) continue;
                for (i11 = 0; i11 < listp.size(); ++i11) {
                    entity1 = (Entity)listp.get(i11);
                    if (entity1 == null || !(entity1 instanceof EntityPlayer)) continue;
                    this.func_70624_b((EntityLivingBase)((EntityPlayer)entity1));
                }
            }
        }
        this.field_70181_x = !this.isArmored() ? (this.field_70181_x *= 0.1) : (this.field_70181_x *= 0.9);
        if (!this.field_70170_p.field_72995_K && this.getWatchedTargetId(0) > 0 && (entity = this.field_70170_p.func_73045_a(this.getWatchedTargetId(0))) != null) {
            double d02 = entity.field_70165_t - this.field_70165_t;
            double d1 = entity.field_70163_u + (this.isArmored() ? 2.0 : 12.0) - this.field_70163_u;
            double d2 = entity.field_70161_v - this.field_70161_v;
            double d3 = d02 * d02 + d1 * d1 + d2 * d2;
            this.func_70671_ap().func_75651_a(entity, 180.0f, 40.0f);
            if (entity instanceof EntityLivingBase && d3 < 10000.0) {
                this.func_82196_d((EntityLivingBase)entity, 0.0f);
            }
            if (d3 > 64.0) {
                double d5 = MathHelper.func_76133_a((double)d3);
                this.field_70159_w += d02 / d5 * 1.5 - this.field_70159_w;
                this.field_70181_x += d1 / d5 * 1.5 - this.field_70181_x;
                this.field_70179_y += d2 / d5 * 1.5 - this.field_70179_y;
                this.field_70761_aq = this.field_70177_z = (float)Math.atan2(this.field_70179_y, this.field_70159_w) * 57.295776f - 90.0f;
            }
        }
        super.func_70636_d();
        for (i = 0; i < 2; ++i) {
            this.field_82218_g[i] = this.field_82221_e[i];
            this.field_82217_f[i] = this.field_82220_d[i];
        }
        for (i = 0; i < 2; ++i) {
            int j2 = this.getWatchedTargetId(i + 1);
            Entity entity1 = null;
            if (j2 > 0) {
                entity1 = this.field_70170_p.func_73045_a(j2);
            }
            if (entity1 != null) {
                double d1 = this.func_82214_u(i + 1);
                double d3 = this.func_82208_v(i + 1);
                double d5 = this.func_82213_w(i + 1);
                double d6 = entity1.field_70165_t - d1;
                double d7 = entity1.field_70163_u + (double)entity1.func_70047_e() - d3;
                double d8 = entity1.field_70161_v - d5;
                double d9 = MathHelper.func_76133_a((double)(d6 * d6 + d8 * d8));
                float f = (float)(Math.atan2(d8, d6) * 180.0 / Math.PI) - 90.0f;
                float f1 = (float)(-(Math.atan2(d7, d9) * 180.0 / Math.PI));
                this.field_82220_d[i] = this.func_82204_b(this.field_82220_d[i], f1, 5.0f);
                this.field_82221_e[i] = this.func_82204_b(this.field_82221_e[i], f, 5.0f);
                continue;
            }
            if (this.field_70146_Z.nextInt(120) == 0) {
                for (j2 = 0; j2 < 36; ++j2) {
                    this.field_82220_d[i] = this.func_82204_b(this.field_82220_d[i], this.field_70146_Z.nextFloat() * 360.0f - 180.0f, 5.0f);
                }
            }
            if (this.field_70146_Z.nextInt(120) != 0) continue;
            for (j2 = 0; j2 < 36; ++j2) {
                this.field_82221_e[i] = this.func_82204_b(this.field_82221_e[i], this.field_70146_Z.nextFloat() * 360.0f - 180.0f, 5.0f);
            }
        }
        this.shouldParticlesBeUpward = false;
        boolean flag = this.isArmored();
        for (j = 0; j < 3; ++j) {
            double d10 = this.func_82214_u(j);
            double d2 = this.func_82208_v(j);
            double d4 = this.func_82213_w(j);
            for (int j1 = 0; j1 < 150; ++j1) {
                this.field_70170_p.func_72869_a("largesmoke", d10 + this.field_70146_Z.nextGaussian() * 10.0, d2 + this.field_70146_Z.nextGaussian() * 10.0, d4 + this.field_70146_Z.nextGaussian() * 10.0, 0.0, 0.0, 0.0);
            }
            if (!flag || this.field_70170_p.field_73012_v.nextInt(4) != 0) continue;
            this.field_70170_p.func_72869_a("mobSpell", d10 + this.field_70146_Z.nextGaussian() * 10.0, d2 + this.field_70146_Z.nextGaussian() * 10.0, d4 + this.field_70146_Z.nextGaussian() * (double)0.3f, (double)0.7f, (double)0.7f, 0.5);
        }
        if (this.getInvulTime() > 0) {
            for (j = 0; j < 3; ++j) {
                this.field_70170_p.func_72869_a("mobSpell", this.field_70165_t + this.field_70146_Z.nextGaussian() * 24.0, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * 70.0f), this.field_70161_v + this.field_70146_Z.nextGaussian() * 1.0, (double)0.7f, (double)0.7f, (double)0.9f);
            }
        }
        if (this.field_70170_p.field_72995_K) {
            for (int i15 = 0; i15 < this.getParticleCount(); ++i15) {
                this.field_70170_p.func_72869_a(this.getParticles(), this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * ((double)this.field_70130_N * 3.0), this.field_70163_u + this.field_70146_Z.nextDouble() * 72.0, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * ((double)this.field_70130_N * 3.0), 0.0, 0.5, 0.0);
            }
        }
        if (this.field_70173_aa % 100 == 0) {
            int i2 = MathHelper.func_76128_c((double)this.field_70163_u);
            int i11 = MathHelper.func_76128_c((double)this.field_70165_t);
            int j1 = MathHelper.func_76128_c((double)this.field_70161_v);
            for (int l1 = -64; l1 <= 64; ++l1) {
                for (int i22 = -64; i22 <= 64; ++i22) {
                    for (int j2 = -64; j2 <= 64; ++j2) {
                        int j3 = i11 + l1;
                        int k = i2 + j2;
                        int l = j1 + i22;
                        Block block = this.field_70170_p.func_147439_a(j2, k, l);
                        j2 += Facing.field_71586_b[0];
                        if (this.field_70146_Z.nextInt(100) != 0 || !block.isAir((IBlockAccess)this.field_70170_p, j3, (k += Facing.field_71587_c[0]) + 1, l += Facing.field_71585_d[0]) || this.field_70170_p.field_72995_K || block.isAir((IBlockAccess)this.field_70170_p, j3, k, l) || block == Blocks.field_150357_h || block == Blocks.field_150384_bq || block == Blocks.field_150378_br || block == Blocks.field_150483_bI) continue;
                        EntityFallingBlock entityfallingblock = new EntityFallingBlock(this.field_70170_p, (double)j3, (double)k, (double)l, block, this.field_70170_p.func_72805_g(j2, k, l));
                        this.field_70170_p.func_72838_d((Entity)entityfallingblock);
                        this.field_70170_p.func_147468_f(j3, k, l);
                        entityfallingblock.field_70181_x = 0.75;
                        entityfallingblock.func_85030_a("random.explode", 5.0f, 0.5f);
                    }
                }
            }
        }
    }

    @Override
    public boolean func_70652_k(Entity p_70652_1_) {
        if (p_70652_1_.field_70131_O >= 6.0f || p_70652_1_ instanceof EntityTitan) {
            float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            int i = this.getKnockbackAmount();
            List list11 = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(32.0, 32.0, 32.0));
            if (list11 != null && !list11.isEmpty()) {
                for (int i1 = 0; i1 < list11.size(); ++i1) {
                    Entity entity1 = (Entity)list11.get(i1);
                    if (!(entity1 instanceof EntityLivingBase) || !(entity1.field_70131_O >= 6.0f) && !(entity1 instanceof EntityTitan) || entity1 instanceof EntityWitherzilla) continue;
                    this.attackChoosenEntity(entity1, 1000.0f, i);
                }
            }
            for (int it = 0; it < 10; ++it) {
                this.attackChoosenEntity(p_70652_1_, f, 2);
                if (!(p_70652_1_ instanceof EntityTitan) || ((EntityTitan)p_70652_1_).getInvulTime() <= 1) continue;
                ((EntityTitan)p_70652_1_).setInvulTime(((EntityTitan)p_70652_1_).getInvulTime() - 20);
            }
            return super.func_70652_k(p_70652_1_);
        }
        return false;
    }

    @Override
    protected void func_70619_bc() {
        int i;
        List list1;
        int i1;
        int i2;
        --this.attackTimer;
        if (this.getInvulTime() > 0 && (i2 = this.getInvulTime() - 1) <= 0) {
            this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 3000.0f, true, true);
            this.blockBreakCounter = 1;
            this.field_70170_p.func_82739_e(1013, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 0);
            this.field_70170_p.func_82739_e(1013, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 0);
            this.field_70170_p.func_82739_e(1013, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 0);
            this.field_70170_p.func_82739_e(1013, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 0);
            if (!this.field_70170_p.field_73010_i.isEmpty()) {
                for (i1 = 0; i1 < this.field_70170_p.field_73010_i.size(); ++i1) {
                    EntityPlayer player = (EntityPlayer)this.field_70170_p.field_73010_i.get(this.field_70170_p.field_73010_i.size());
                    this.field_70170_p.func_72956_a((Entity)player, "thetitans:witherzillaSpawn", 100.0f, 1.0f);
                }
            }
        }
        super.func_70619_bc();
        List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(256.0, 256.0, 256.0));
        if (list != null && !list.isEmpty()) {
            for (i1 = 0; i1 < list.size(); ++i1) {
                Entity entity = (Entity)list.get(i1);
                if (!this.field_70170_p.field_72995_K && !(this.field_70170_p.field_73011_w instanceof WorldProviderVoid) && entity != null && entity instanceof EntityPlayer && ((EntityPlayer)entity).func_70694_bm() != null && ((EntityPlayer)entity).func_70694_bm().func_77973_b() != TitanItems.ultimaBlade) {
                    ((EntityPlayer)entity).func_70669_a(((EntityPlayer)entity).func_70694_bm());
                    ((EntityPlayer)entity).func_70694_bm().field_77994_a = 0;
                    ((EntityPlayer)entity).func_71028_bD();
                    this.doLightningAttackTo(entity);
                }
                if (this.field_70170_p.field_72995_K || this.field_70170_p.field_73011_w instanceof WorldProviderVoid || entity == null || !(entity instanceof EntityLiving) || !this.func_70686_a(entity.getClass()) || entity instanceof EntityWitherzilla || entity instanceof EntityWitherzillaMinion || ((EntityLiving)entity).func_70638_az() == this) continue;
                ((EntityLiving)entity).func_70624_b((EntityLivingBase)this);
            }
        }
        if ((list1 = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D)) != null && !list1.isEmpty()) {
            for (int i12 = 0; i12 < list1.size(); ++i12) {
                Entity entity = (Entity)list1.get(i12);
                if (entity == null || !(entity instanceof EntityFallingBlock)) continue;
                entity.func_70106_y();
                this.func_70691_i(5.0f);
                this.func_85030_a("random.break", 10.0f, 1.0f);
            }
        }
        block3: for (i = 1; i < 3; ++i) {
            int i13;
            if (this.field_70173_aa < this.field_82223_h[i - 1] || this.func_70638_az() == null) continue;
            this.field_82223_h[i - 1] = this.field_70173_aa + this.field_70146_Z.nextInt(20);
            int k2 = i - 1;
            int l2 = this.field_82224_i[i - 1];
            this.field_82224_i[k2] = this.field_82224_i[i - 1] + 1;
            if (l2 > 15) {
                for (int i11 = 0; i11 < 100; ++i11) {
                    float f = 100.0f;
                    float f1 = 20.0f;
                    double d0 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.field_70165_t - (double)f), (double)(this.field_70165_t + (double)f));
                    double d1 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.field_70163_u - (double)f1), (double)(this.field_70163_u + (double)f1));
                    double d2 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.field_70161_v - (double)f), (double)(this.field_70161_v + (double)f));
                    this.launchWitherSkullToCoords(i + 1, d0, d1, d2, true);
                }
                this.field_82224_i[i - 1] = 0;
            }
            if ((i13 = this.getWatchedTargetId(i)) > 0) {
                Entity entity = this.field_70170_p.func_73045_a(i13);
                if (entity != null && entity.func_70089_S() && this.func_70068_e(entity) <= 200000.0 && this.func_70685_l(entity)) {
                    this.launchWitherSkullToEntity(i + 1, (EntityLivingBase)entity);
                    this.field_82223_h[i - 1] = this.field_70173_aa;
                    this.field_82224_i[i - 1] = 0;
                    continue;
                }
                this.func_82211_c(i, 0);
                continue;
            }
            List list11 = this.field_70170_p.func_82733_a(EntityLivingBase.class, this.field_70121_D.func_72314_b(100.0, 100.0, 100.0), attackEntitySelector);
            for (int k1 = 0; k1 < 10 && !list11.isEmpty(); ++k1) {
                EntityLivingBase entitylivingbase = (EntityLivingBase)list11.get(this.field_70146_Z.nextInt(list11.size()));
                if (entitylivingbase != this && entitylivingbase.func_70089_S() && this.func_70685_l((Entity)entitylivingbase)) {
                    if (entitylivingbase instanceof EntityPlayer) {
                        if (((EntityPlayer)entitylivingbase).field_71075_bZ.field_75102_a) continue block3;
                        this.func_82211_c(i, entitylivingbase.func_145782_y());
                        continue block3;
                    }
                    this.func_82211_c(i, entitylivingbase.func_145782_y());
                    continue block3;
                }
                list11.remove(entitylivingbase);
            }
        }
        if (this.func_70638_az() != null) {
            this.func_82211_c(0, this.func_70638_az().func_145782_y());
        } else {
            this.func_82211_c(0, 0);
        }
        if (this.blockBreakCounter > 0) {
            --this.blockBreakCounter;
            if (this.blockBreakCounter == 0 && this.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
                i = MathHelper.func_76128_c((double)this.field_70163_u);
                int i14 = MathHelper.func_76128_c((double)this.field_70165_t);
                int j1 = MathHelper.func_76128_c((double)this.field_70161_v);
                boolean flag = false;
                for (int l1 = -16; l1 <= 16; ++l1) {
                    for (int i22 = -16; i22 <= 16; ++i22) {
                        for (int j = -2; j <= 112; ++j) {
                            int j2 = i14 + l1;
                            int k = i + j;
                            int l = j1 + i22;
                            Block block = this.field_70170_p.func_147439_a(j2, k, l);
                            if (block.isAir((IBlockAccess)this.field_70170_p, j2, k, l) || block == Blocks.field_150357_h || block == Blocks.field_150384_bq || block == Blocks.field_150378_br || block == Blocks.field_150483_bI) continue;
                            flag = this.field_70170_p.func_147480_a(j2, k, l, false) || flag;
                        }
                    }
                }
                if (flag) {
                    this.destroyBlocksInAABB(this.field_70121_D);
                    this.field_70170_p.func_72889_a((EntityPlayer)null, 1012, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 0);
                }
            }
        }
    }

    public void func_82206_m() {
        this.setInvulTime(2700);
    }

    @Override
    public void onKillCommand() {
        ArrayList list11 = Lists.newArrayList((Iterable)this.field_70170_p.field_73010_i);
        if (list11 != null && !list11.isEmpty()) {
            for (int i1 = 0; i1 < list11.size(); ++i1) {
                Entity entity = (Entity)list11.get(i1);
                if (entity == null || !(entity instanceof EntityPlayer)) continue;
                ((EntityPlayer)entity).func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"dialog.witherzilla.killattempt")));
            }
        }
    }

    private double func_82214_u(int p_82214_1_) {
        if (p_82214_1_ <= 0) {
            return this.field_70165_t;
        }
        float f = (this.field_70761_aq + (float)(180 * (p_82214_1_ - 1))) / 180.0f * (float)Math.PI;
        float f1 = MathHelper.func_76134_b((float)f);
        return this.isInOmegaForm() ? this.field_70165_t + (double)f1 * 176.0 : this.field_70165_t + (double)f1 * 88.0;
    }

    private double func_82208_v(int p_82208_1_) {
        return p_82208_1_ <= 0 ? (double)this.func_70047_e() : (double)(this.func_70047_e() * 0.8f);
    }

    private double func_82213_w(int p_82213_1_) {
        if (p_82213_1_ <= 0) {
            return this.field_70161_v;
        }
        float f = (this.field_70761_aq + (float)(180 * (p_82213_1_ - 1))) / 180.0f * (float)Math.PI;
        float f1 = MathHelper.func_76126_a((float)f);
        return this.isInOmegaForm() ? this.field_70161_v + (double)f1 * 176.0 : this.field_70161_v + (double)f1 * 88.0;
    }

    private float func_82204_b(float p_82204_1_, float p_82204_2_, float p_82204_3_) {
        float f3 = MathHelper.func_76142_g((float)(p_82204_2_ - p_82204_1_));
        if (f3 > p_82204_3_) {
            f3 = p_82204_3_;
        }
        if (f3 < -p_82204_3_) {
            f3 = -p_82204_3_;
        }
        return p_82204_1_ + f3;
    }

    private void launchWitherSkullToEntity(int p_82216_1_, EntityLivingBase p_82216_2_) {
        if (p_82216_2_ instanceof EntityTitan || p_82216_2_.field_70131_O >= 6.0f) {
            double d0 = this.func_70068_e((Entity)p_82216_2_);
            if (d0 < 1000.0 && this.attackTimer <= 0) {
                this.attackTimer = 10;
                this.func_70652_k((Entity)p_82216_2_);
            }
        } else {
            this.launchWitherSkullToCoords(p_82216_1_, p_82216_2_.field_70165_t, p_82216_2_.field_70163_u + (double)p_82216_2_.func_70047_e() * 0.5, p_82216_2_.field_70161_v, p_82216_1_ == 0 && this.field_70146_Z.nextFloat() < 0.001f);
            p_82216_2_.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 21.0f);
            p_82216_2_.field_70172_ad = 0;
        }
        this.launchWitherSkullToCoords(p_82216_1_, p_82216_2_.field_70165_t, p_82216_2_.field_70163_u + (double)p_82216_2_.func_70047_e() * 0.5, p_82216_2_.field_70161_v, p_82216_1_ == 0 && this.field_70146_Z.nextFloat() < 0.001f);
    }

    private void launchWitherSkullToCoords(int p_82209_1_, double p_82209_2_, double p_82209_4_, double p_82209_6_, boolean p_82209_8_) {
        double d3 = this.func_82214_u(p_82209_1_);
        double d4 = this.func_82208_v(p_82209_1_);
        double d5 = this.func_82213_w(p_82209_1_);
        double d6 = p_82209_2_ - d3;
        double d7 = p_82209_4_ - d4;
        double d8 = p_82209_6_ - d5;
        EntityWitherSkull entitywitherskull = new EntityWitherSkull(this.field_70170_p, (EntityLivingBase)this, d6, d7, d8);
        if (p_82209_8_) {
            entitywitherskull.func_82343_e(true);
        }
        entitywitherskull.field_70163_u = d4;
        entitywitherskull.field_70165_t = d3;
        entitywitherskull.field_70161_v = d5;
        this.field_70170_p.func_72908_a(d3, d4, d5, "mob.wither.shoot", 3.0f, 0.8f);
        this.field_70170_p.func_72838_d((Entity)entitywitherskull);
    }

    public void func_82196_d(EntityLivingBase p_82196_1_, float p_82196_2_) {
        if (p_82196_1_ instanceof EntityTitan || p_82196_1_.field_70131_O >= 6.0f) {
            double d0 = this.func_70068_e((Entity)p_82196_1_);
            if (d0 < 1000.0 && this.attackTimer <= 0) {
                this.attackTimer = 1 + this.field_70146_Z.nextInt(9);
                this.func_70652_k((Entity)p_82196_1_);
            }
        } else {
            this.launchWitherSkullToEntity(0, p_82196_1_);
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.field_70146_Z.nextInt(10) == 0 && !(this.field_70170_p.field_73011_w instanceof WorldProviderVoid)) {
            this.omegacounter = 600;
        }
        if (source.func_76346_g() instanceof EntityWitherzillaMinion || source.func_76346_g() instanceof EntityWitherzilla || source.func_94541_c() && !(source.func_76346_g() instanceof EntityWitherTurret)) {
            return false;
        }
        if (this.isArmored() && !(source.func_76346_g() instanceof EntityPlayer) && !(source.func_76346_g() instanceof EntityTitan)) {
            if (source.func_76346_g() != null && this.field_70146_Z.nextInt(10) == 0) {
                this.teleportToEntity(source.func_76346_g(), false);
            }
            return false;
        }
        if (this.blockBreakCounter <= 0) {
            this.blockBreakCounter = 1;
        }
        ++this.field_70173_aa;
        return super.func_70097_a(source, amount);
    }

    public boolean attackWitherzillaFrom(DamageSource source, float amount) {
        if (source.func_76346_g() instanceof EntityWitherzillaMinion || source.func_76346_g() instanceof EntityWitherzilla || source.func_94541_c() && !(source.func_76346_g() instanceof EntityWitherTurret)) {
            return false;
        }
        if (this.isArmored() && !(source.func_76346_g() instanceof EntityPlayer) && !(source.func_76346_g() instanceof EntityTitan)) {
            return false;
        }
        if (this.blockBreakCounter <= 0) {
            this.blockBreakCounter = 1;
        }
        return super.func_70097_a(source, amount);
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        if (this.deathTicks > 0) {
            int l;
            Item it = null;
            Block bl = null;
            Iterator ilist = Item.field_150901_e.iterator();
            int icount = 0;
            while (ilist.hasNext()) {
                it = (Item)ilist.next();
                if (it == null) continue;
                ++icount;
            }
            int j = 0;
            while (j < 256) {
                ilist = Item.field_150901_e.iterator();
                for (int k = 1 + this.field_70146_Z.nextInt(icount); k > 0 && ilist.hasNext(); --k) {
                    it = (Item)ilist.next();
                }
                if (it == null || it == TitanItems.ultimaBlade) continue;
                ++j;
                EntityItem var3 = new EntityItem(this.field_70170_p, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 12.0, this.field_70163_u + 12.0 + (this.field_70146_Z.nextDouble() - 0.5) * 12.0, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 12.0, new ItemStack(it, 1, 0));
                this.field_70170_p.func_72838_d((Entity)var3);
            }
            Iterator blist = Block.field_149771_c.iterator();
            int bcount = 0;
            while (blist.hasNext()) {
                bl = (Block)blist.next();
                if (bl == null) continue;
                ++bcount;
            }
            int j2 = 0;
            while (j2 < 256) {
                blist = Block.field_149771_c.iterator();
                for (int k = 1 + this.field_70146_Z.nextInt(bcount); k > 0 && blist.hasNext(); --k) {
                    bl = (Block)blist.next();
                }
                if (bl == null) continue;
                ++j2;
                EntityItem var3 = new EntityItem(this.field_70170_p, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 12.0, this.field_70163_u + 12.0 + (this.field_70146_Z.nextDouble() - 0.5) * 12.0, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 12.0, new ItemStack(Item.func_150898_a((Block)bl), 1, 0));
                this.field_70170_p.func_72838_d((Entity)var3);
            }
            for (l = 0; l < 1024; ++l) {
                EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Blocks.field_150402_ci));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 512; ++l) {
                EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Blocks.field_150339_S));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 512; ++l) {
                EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Blocks.field_150340_R));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 256; ++l) {
                EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Blocks.field_150475_bE));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 256; ++l) {
                EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Blocks.field_150484_ah));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 128; ++l) {
                EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(TitanBlocks.harcadium_block));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 128; ++l) {
                EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(TitanBlocks.void_block));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 128; ++l) {
                EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(TitanBlocks.bedrock_block));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 256; ++l) {
                EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Blocks.field_150380_bt));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
        }
    }

    @Override
    protected void func_70623_bb() {
    }

    @Override
    protected float func_70599_aP() {
        return 1000.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float p_70070_1_) {
        return 0xF000F0;
    }

    public float func_70013_c(float p_70013_1_) {
        return 1.0f;
    }

    public void fall(float distance, float damageMultiplier) {
    }

    @Override
    public void func_70690_d(PotionEffect p_70690_1_) {
    }

    @SideOnly(value=Side.CLIENT)
    public float func_82207_a(int p_82207_1_) {
        return this.field_82221_e[p_82207_1_];
    }

    @SideOnly(value=Side.CLIENT)
    public float func_82210_r(int p_82210_1_) {
        return this.field_82220_d[p_82210_1_];
    }

    public int getWatchedTargetId(int p_82203_1_) {
        return this.field_70180_af.func_75679_c(17 + p_82203_1_);
    }

    public void func_82211_c(int p_82211_1_, int p_82211_2_) {
        this.field_70180_af.func_75692_b(17 + p_82211_1_, (Object)p_82211_2_);
    }

    public boolean isArmored() {
        return this.func_110143_aJ() <= this.func_110138_aP() / 2.0f;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    public void func_70078_a(Entity entityIn) {
        this.field_70154_o = null;
    }

    @Override
    public StatBase getAchievement() {
        if (this.field_70170_p.field_73011_w instanceof WorldProviderVoid) {
            return TitansAchievments.witherzilla;
        }
        return TitansAchievments.witherzilla2;
    }

    @Override
    public int getThreashHold() {
        return 210;
    }

    @Override
    protected void inactDeathAction() {
        if (!this.field_70170_p.field_72995_K) {
            this.createBeaconPortal(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70161_v));
            if (this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
                this.func_70628_a(true, 0);
                this.func_82160_b(true, 0);
                this.func_70600_l(1);
            }
            EntityTitanSpirit entitytitan = new EntityTitanSpirit(this.field_70170_p);
            entitytitan.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
            this.field_70170_p.func_72838_d((Entity)entitytitan);
            entitytitan.setVesselHunting(false);
            entitytitan.setSpiritType(12);
        }
    }

    @Override
    protected void onTitanDeathUpdate() {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_75692_b(6, (Object)Float.valueOf(MathHelper.func_76131_a((float)this.field_70180_af.func_111145_d(5), (float)0.0f, (float)this.func_110138_aP())));
            if (this.field_70180_af.func_111145_d(5) <= 0.0f) {
                ++this.deathTicks;
                this.setTitanHealth(0.0f);
            } else {
                this.setTitanHealth(this.field_70180_af.func_111145_d(5));
                this.func_70606_j(this.field_70180_af.func_111145_d(5));
                this.deathTicks = 0;
                if (this.animID == 10) {
                    this.animID = 0;
                }
            }
        }
        if (this.deathTicks > 180 && this.deathTicks % 1 == 0) {
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 24.0f;
            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 80.0f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 24.0f;
            this.field_70170_p.func_72869_a("hugeexplosion", this.field_70165_t + (double)f, this.field_70163_u + 2.0 + (double)f1, this.field_70161_v + (double)f2, 0.0, 0.0, 0.0);
        }
        if (!this.field_70170_p.field_72995_K && this.deathTicks == 1) {
            this.func_85030_a(this.func_70673_aS(), this.func_70599_aP(), this.func_70647_i());
            this.func_85030_a(this.func_70673_aS(), this.func_70599_aP(), this.func_70647_i());
            this.func_85030_a(this.func_70673_aS(), this.func_70599_aP(), this.func_70647_i());
            this.func_85030_a(this.func_70673_aS(), this.func_70599_aP(), this.func_70647_i());
            this.field_70170_p.func_82739_e(1018, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 0);
            this.field_70170_p.func_82739_e(1018, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 0);
            this.field_70170_p.func_82739_e(1018, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 0);
            this.field_70170_p.func_82739_e(1018, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 0);
            MinecraftServer.func_71276_C().func_147139_a(EnumDifficulty.PEACEFUL);
            int i = 5000000;
            for (int i1 = 0; i1 < 25; ++i1) {
                this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, i));
            }
            ArrayList listp = Lists.newArrayList((Iterable)this.field_70170_p.field_73010_i);
            if (listp != null && !listp.isEmpty()) {
                for (int i1 = 0; i1 < listp.size(); ++i1) {
                    Entity entity = (Entity)listp.get(i1);
                    if (entity == null || !(entity instanceof EntityPlayer)) continue;
                    ((EntityPlayer)entity).func_71029_a(this.getAchievement());
                    ((EntityPlayer)entity).func_71029_a((StatBase)AchievementList.field_150964_J);
                    ItemStack item = new ItemStack(TitanItems.ultimaBlade);
                    ((EntityPlayer)entity).func_70099_a(item, 0.0f);
                    this.func_70642_aH();
                    if (this.field_70170_p.field_73011_w instanceof WorldProviderVoid) {
                        ((EntityPlayer)entity).func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"dialog.witherzilla.death")));
                        continue;
                    }
                    ((EntityPlayer)entity).func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"dialog.witherzilla.defeat")));
                }
            }
        }
        this.func_70091_d(0.0, 0.1, 0.0);
        this.field_70177_z = this.field_70759_as += 5.0f;
        this.field_70761_aq = this.field_70759_as;
        if (this.deathTicks >= 220) {
            this.func_70106_y();
        }
    }

    private void createBeaconPortal(int p_70975_1_, int p_70975_2_) {
        int b0 = 64;
        BlockEndPortal.field_149948_a = true;
        int b1 = 4;
        for (int k = b0 - 1; k <= b0 + 32; ++k) {
            for (int l = p_70975_1_ - b1; l <= p_70975_1_ + b1; ++l) {
                for (int i1 = p_70975_2_ - b1; i1 <= p_70975_2_ + b1; ++i1) {
                    double d0 = l - p_70975_1_;
                    double d1 = i1 - p_70975_2_;
                    double d2 = d0 * d0 + d1 * d1;
                    if (!(d2 <= ((double)b1 - 0.5) * ((double)b1 - 0.5))) continue;
                    if (k < b0) {
                        if (!(d2 <= ((double)(b1 - 1) - 0.5) * ((double)(b1 - 1) - 0.5))) continue;
                        this.field_70170_p.func_147449_b(l, k, i1, Blocks.field_150357_h);
                        continue;
                    }
                    if (k > b0) {
                        this.field_70170_p.func_147449_b(l, k, i1, Blocks.field_150350_a);
                        continue;
                    }
                    if (d2 > ((double)(b1 - 1) - 0.5) * ((double)(b1 - 1) - 0.5)) {
                        this.field_70170_p.func_147449_b(l, k, i1, Blocks.field_150357_h);
                        continue;
                    }
                    this.field_70170_p.func_147449_b(l, k, i1, Blocks.field_150384_bq);
                }
            }
        }
        this.field_70170_p.func_147449_b(p_70975_1_, b0 + 0, p_70975_2_, Blocks.field_150357_h);
        this.field_70170_p.func_147449_b(p_70975_1_, b0 + 1, p_70975_2_, Blocks.field_150357_h);
        this.field_70170_p.func_147449_b(p_70975_1_, b0 + 2, p_70975_2_, Blocks.field_150357_h);
        this.field_70170_p.func_147449_b(p_70975_1_ - 1, b0 + 2, p_70975_2_, Blocks.field_150478_aa);
        this.field_70170_p.func_147449_b(p_70975_1_ + 1, b0 + 2, p_70975_2_, Blocks.field_150478_aa);
        this.field_70170_p.func_147449_b(p_70975_1_, b0 + 2, p_70975_2_ - 1, Blocks.field_150478_aa);
        this.field_70170_p.func_147449_b(p_70975_1_, b0 + 2, p_70975_2_ + 1, Blocks.field_150478_aa);
        this.field_70170_p.func_147449_b(p_70975_1_, b0 + 3, p_70975_2_, Blocks.field_150357_h);
        this.field_70170_p.func_147449_b(p_70975_1_, b0 + 4, p_70975_2_, Blocks.field_150484_ah);
        this.field_70170_p.func_147449_b(p_70975_1_ + 1, b0 + 4, p_70975_2_ + 1, Blocks.field_150484_ah);
        this.field_70170_p.func_147449_b(p_70975_1_ + 1, b0 + 4, p_70975_2_, Blocks.field_150484_ah);
        this.field_70170_p.func_147449_b(p_70975_1_ + 1, b0 + 4, p_70975_2_ - 1, Blocks.field_150484_ah);
        this.field_70170_p.func_147449_b(p_70975_1_ - 1, b0 + 4, p_70975_2_ + 1, Blocks.field_150484_ah);
        this.field_70170_p.func_147449_b(p_70975_1_ - 1, b0 + 4, p_70975_2_, Blocks.field_150484_ah);
        this.field_70170_p.func_147449_b(p_70975_1_ - 1, b0 + 4, p_70975_2_ - 1, Blocks.field_150484_ah);
        this.field_70170_p.func_147449_b(p_70975_1_, b0 + 4, p_70975_2_ + 1, Blocks.field_150484_ah);
        this.field_70170_p.func_147449_b(p_70975_1_, b0 + 4, p_70975_2_ - 1, Blocks.field_150484_ah);
        this.field_70170_p.func_147449_b(p_70975_1_, b0 + 5, p_70975_2_, (Block)Blocks.field_150461_bJ);
    }

    protected void func_85033_bc() {
    }

    public float func_70047_e() {
        return this.isInOmegaForm() ? 380.8f : 190.4f;
    }

    protected boolean teleportRandomly(boolean bool) {
        double d0 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        double d2 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        if (bool) {
            return this.teleportTo(0.0, 200.0, 0.0);
        }
        return this.teleportTo(d0, 200.0, d2);
    }

    protected boolean teleportToEntity(Entity p_70816_1_, boolean bool) {
        Vec3 vec3 = Vec3.func_72443_a((double)(this.field_70165_t - p_70816_1_.field_70165_t), (double)(this.field_70121_D.field_72338_b + (double)(this.field_70131_O / 2.0f) - p_70816_1_.field_70163_u + (double)p_70816_1_.func_70047_e()), (double)(this.field_70161_v - p_70816_1_.field_70161_v));
        vec3 = vec3.func_72432_b();
        double d0 = 32.0;
        double d1 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 16.0 - vec3.field_72450_a * d0;
        double d2 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(16) - 8) - vec3.field_72448_b * d0;
        double d3 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 16.0 - vec3.field_72449_c * d0;
        if (bool) {
            return this.teleportTo(p_70816_1_.field_70165_t, p_70816_1_.field_70163_u, p_70816_1_.field_70161_v);
        }
        return this.teleportTo(d1, d2, d3);
    }

    protected boolean teleportTo(double p_70825_1_, double p_70825_3_, double p_70825_5_) {
        EnderTeleportEvent event = new EnderTeleportEvent((EntityLivingBase)this, p_70825_1_, p_70825_3_, p_70825_5_, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        this.func_85030_a("portal.travel", 10000.0f, this.func_70647_i());
        if (!this.field_70170_p.field_72995_K) {
            this.func_70107_b(p_70825_1_, p_70825_3_, p_70825_5_);
        }
        return true;
    }

    @Override
    public boolean func_70058_J() {
        return false;
    }

    public boolean isInOmegaForm() {
        return !(this.field_70170_p.field_73011_w instanceof WorldProviderVoid);
    }
}

