/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.titan;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.titan.EntityIronGolemTitan;
import net.minecraft.entity.titan.EntitySnowGolemTitan;
import net.minecraft.entity.titan.EntityTitan;
import net.minecraft.entity.titan.EntityTitanSpirit;
import net.minecraft.entity.titan.EntityUltimaBlade;
import net.minecraft.entity.titan.ITitan;
import net.minecraft.entity.titan.ai.EntityAINearestTargetTitan;
import net.minecraft.entity.titan.animation.omegafish.AnimationOmegafishAntiTitanAttack;
import net.minecraft.entity.titan.animation.omegafish.AnimationOmegafishAttack;
import net.minecraft.entity.titan.animation.omegafish.AnimationOmegafishBodySlam;
import net.minecraft.entity.titan.animation.omegafish.AnimationOmegafishBurrow;
import net.minecraft.entity.titan.animation.omegafish.AnimationOmegafishDeath;
import net.minecraft.entity.titan.animation.omegafish.AnimationOmegafishLightningAttack;
import net.minecraft.entity.titan.animation.omegafish.AnimationOmegafishStunned;
import net.minecraft.entity.titan.animation.omegafish.AnimationOmegafishTailSmash;
import net.minecraft.entity.titan.animation.omegafish.AnimationOmegafishTailSwipe;
import net.minecraft.entity.titan.animation.omegafish.AnimationOmegafishTailSwipeOp;
import net.minecraft.entity.titan.animation.omegafish.AnimationOmegafishUnburrow;
import net.minecraft.entity.titanminion.EntitySilverfishLoyalist;
import net.minecraft.entity.titanminion.EntitySilverfishPriest;
import net.minecraft.entity.titanminion.EntitySilverfishTemplar;
import net.minecraft.entity.titanminion.EntitySilverfishZealot;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.theTitans.DamageSourceExtra;
import net.minecraft.theTitans.TheTitans;
import net.minecraft.theTitans.TitanItems;
import net.minecraft.theTitans.TitansAchievments;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import thehippomaster.AnimationAPI.AnimationAPI;
import thehippomaster.AnimationAPI.IAnimatedEntity;

public class EntitySilverfishTitan
extends EntityTitan
implements IAnimatedEntity,
IEntityMultiPart {
    public boolean isSubdued;
    public boolean isAttacking;
    public boolean isBurrowing;
    public boolean isStunned;
    public EntityDragonPart[] partArray;
    public EntityDragonPart head = new EntityDragonPart((IEntityMultiPart)this, "head", 4.0f, 4.0f);
    public EntityDragonPart body = new EntityDragonPart((IEntityMultiPart)this, "body", 8.0f, 3.0f);
    public EntityDragonPart tailbase = new EntityDragonPart((IEntityMultiPart)this, "tailbase", 4.0f, 4.0f);
    public EntityDragonPart tailtip = new EntityDragonPart((IEntityMultiPart)this, "tailtip", 3.0f, 3.0f);

    public EntitySilverfishTitan(World worldIn) {
        super(worldIn);
        this.partArray = new EntityDragonPart[]{this.head, this.body, this.tailbase, this.tailtip};
        this.func_70105_a(10.0f, 8.0f);
        this.setTitanHealth(this.func_110138_aP());
        this.field_70178_ae = true;
        this.field_70728_aV = 6000 + this.getExtraPower() * 200;
        this.field_70138_W = 4.0f;
    }

    @Override
    protected void applyEntityAI() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationOmegafishDeath(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationOmegafishStunned(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationOmegafishAntiTitanAttack(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationOmegafishBodySlam(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationOmegafishTailSmash(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationOmegafishLightningAttack(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationOmegafishTailSwipe(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationOmegafishTailSwipeOp(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationOmegafishAttack(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationOmegafishUnburrow(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationOmegafishBurrow(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        if (!this.isSubdued) {
            if (TheTitans.TitansFFAMode) {
                this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan(this, EntityLivingBase.class, 0, false, false, ITitan.SilverfishTitanSorter));
            } else {
                this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan(this, EntityLivingBase.class, 0, false, false, ITitan.SearchForAThingToKill));
            }
            this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan(this, EntityIronGolemTitan.class, 0, false));
            this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan(this, EntitySnowGolemTitan.class, 0, false));
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.animID != 0) {
            ++this.animTick;
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.isStunned = tagCompund.func_74767_n("Stunned");
        this.isBurrowing = tagCompund.func_74767_n("Burrowing");
        this.isSubdued = tagCompund.func_74767_n("Subdued");
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74757_a("Stunned", this.isStunned);
        tagCompound.func_74757_a("Burrowing", this.isBurrowing);
        tagCompound.func_74757_a("Subdued", this.isSubdued);
    }

    public boolean func_70686_a(Class p_70686_1_) {
        return p_70686_1_ != EntitySilverfishLoyalist.class && p_70686_1_ != EntitySilverfishTitan.class || this.field_70153_n != null && p_70686_1_ != this.field_70153_n.getClass();
    }

    public boolean isArmored() {
        return this.func_110143_aJ() <= this.func_110138_aP() / 4.0f;
    }

    @Override
    public int getMinionCap() {
        return 240;
    }

    @Override
    public int getPriestCap() {
        return 120;
    }

    @Override
    public int getZealotCap() {
        return 60;
    }

    @Override
    public int getTemplarCap() {
        return 8;
    }

    @Override
    public boolean func_70601_bi() {
        return this.field_70146_Z.nextInt(10) == 0 && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL && this.isValidLightLevel();
    }

    @Override
    public int getMinionSpawnRate() {
        return TheTitans.OmegafishMinionSpawnrate;
    }

    public void func_82206_m() {
        this.setInvulTime(860);
        this.setTitanHealth(this.func_110138_aP() / 10.0f);
    }

    public float func_70047_e() {
        return 2.0f;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    protected String func_70639_aQ() {
        return this.isStunned ? null : "thetitans:titanSilverfishLiving";
    }

    @Override
    protected String func_70621_aR() {
        return "thetitans:titanSilverfishGrunt";
    }

    @Override
    protected String func_70673_aS() {
        return "thetitans:titanSilverfishDeath";
    }

    protected Item func_146068_u() {
        return Items.field_151121_aF;
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        if (this.deathTicks > 0) {
            EntityItem entityitem;
            int l;
            for (l = 0; l < 96 + this.field_70146_Z.nextInt(96 + p_70628_2_) + p_70628_2_; ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151121_aF));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 32 + this.field_70146_Z.nextInt(32 + p_70628_2_) + p_70628_2_; ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151044_h));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 4 + this.field_70146_Z.nextInt(8 + p_70628_2_); ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151166_bC));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 4 + this.field_70146_Z.nextInt(8 + p_70628_2_); ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151045_i));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 16 + this.field_70146_Z.nextInt(48 + p_70628_2_); ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Blocks.field_150347_e));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 16 + this.field_70146_Z.nextInt(48 + p_70628_2_); ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Blocks.field_150348_b));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 0 + this.field_70146_Z.nextInt(48 + p_70628_2_); ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Blocks.field_150341_Y));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 0 + this.field_70146_Z.nextInt(32 + p_70628_2_); ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Blocks.field_150417_aV));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 4 + this.field_70146_Z.nextInt(8 + p_70628_2_); ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Blocks.field_150418_aU));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 0 + this.field_70146_Z.nextInt(4 + p_70628_2_); ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(TitanItems.harcadiumNugget));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
        }
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    @Override
    public boolean canBeHurtByPlayer() {
        return (this.isStunned || this.isBurrowing) && !this.func_85032_ar();
    }

    @Override
    public boolean func_70652_k(Entity p_70652_1_) {
        return false;
    }

    protected void func_145780_a(int p_145780_1_, int p_145780_2_, int p_145780_3_, Block p_145780_4_) {
    }

    public void collideWithEntities(EntityDragonPart part, List p_70970_1_) {
        double d0 = (part.field_70121_D.field_72340_a + part.field_70121_D.field_72336_d) / 2.0;
        double d1 = (part.field_70121_D.field_72339_c + part.field_70121_D.field_72334_f) / 2.0;
        for (Entity entity : p_70970_1_) {
            if (entity == null || !(entity instanceof EntityLivingBase) || entity instanceof EntityTitan || entity instanceof EntityTitanSpirit || !this.func_70686_a(entity.getClass()) || !entity.func_70067_L()) continue;
            double d2 = entity.field_70165_t - d0;
            double d3 = entity.field_70161_v - d1;
            double d4 = d2 * d2 + d3 * d3;
            entity.func_70024_g(d2 / d4 * 1.0, 0.1, d3 / d4 * 1.0);
            entity.func_70097_a(DamageSource.func_92087_a((Entity)this), 8.0f);
        }
    }

    @Override
    public boolean canAttack() {
        return false;
    }

    public Entity[] func_70021_al() {
        return this.partArray;
    }

    @Override
    public boolean shouldMove() {
        return this.getAnimID() == 0 && !this.isStunned && this.func_70638_az() != null ? super.shouldMove() : false;
    }

    @Override
    public double getSpeed() {
        return this.isBurrowing ? 0.9 + (double)this.getExtraPower() * 0.001 : 0.7 + (double)this.getExtraPower() * 0.001;
    }

    @Override
    public void func_70636_d() {
        double d0;
        List list;
        if (this.animID == 1) {
            this.isBurrowing = true;
        } else if (this.animID == 2) {
            this.isBurrowing = false;
        }
        if (this.isBurrowing) {
            this.destroyBlocksInAABB(this.field_70121_D.func_72314_b(2.0, 0.0, 2.0));
            this.field_70170_p.func_72926_e(2006, MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f - (double)this.field_70129_M)), MathHelper.func_76128_c((double)this.field_70161_v), MathHelper.func_76123_f((float)128.0f));
            if (this.field_70173_aa % 40 == 0) {
                this.func_85030_a("thetitans:titanRumble", 10.0f, 1.0f);
                this.func_85030_a("thetitans:titanRumble", 9.0f, 1.0f);
                this.func_85030_a("thetitans:titanRumble", 8.0f, 1.0f);
                this.func_85030_a("thetitans:titanRumble", 7.0f, 1.0f);
                this.func_85030_a("thetitans:titanRumble", 6.0f, 1.0f);
                this.func_85030_a("thetitans:titanQuake", 5.0f, 1.0f);
                this.func_85030_a("thetitans:titanQuake", 4.0f, 1.0f);
                this.func_85030_a("thetitans:titanQuake", 3.0f, 1.0f);
                this.func_85030_a("thetitans:titanQuake", 2.0f, 1.0f);
                this.func_85030_a("thetitans:titanQuake", 1.0f, 1.0f);
            }
        }
        if (this.isSubdued && this.field_70173_aa % 40 == 0) {
            this.field_70715_bh.func_85156_a((EntityAIBase)new EntityAINearestTargetTitan(this, EntityLivingBase.class, 0, false, false, ITitan.SearchForAThingToKill));
            this.field_70715_bh.func_85156_a((EntityAIBase)new EntityAINearestTargetTitan(this, EntityIronGolemTitan.class, 0, false));
            this.field_70715_bh.func_85156_a((EntityAIBase)new EntityAINearestTargetTitan(this, EntitySnowGolemTitan.class, 0, false));
        }
        this.func_70105_a(10.0f, 8.0f);
        if (this.getAnimID() == 7 && this.getAnimTick() == 20 && this.func_70638_az() != null) {
            double d8 = -3.0;
            Vec3 vec3 = this.func_70676_i(1.0f);
            double dx = vec3.field_72450_a * d8;
            double dz = vec3.field_72449_c * d8;
            float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            int i = this.getKnockbackAmount();
            this.attackChoosenEntity((Entity)this.func_70638_az(), f, i);
            this.func_70638_az().field_70181_x += 2.0;
            this.field_70170_p.func_72885_a((Entity)this, this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v, 2.0f, false, false);
            this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t + dx, this.field_70163_u + 8.0, this.field_70161_v + dz, 1.0f, false, false);
            this.func_70638_az().func_70097_a(DamageSourceExtra.lightningBolt, f);
            this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t + dx, this.field_70163_u + 8.0, this.field_70161_v + dz));
            this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v));
            List list1 = this.field_70170_p.func_72839_b((Entity)this.func_70638_az(), this.func_70638_az().field_70121_D.func_72314_b(2.0, 2.0, 2.0));
            if (list1 != null && !list1.isEmpty()) {
                for (int i1 = 0; i1 < list1.size(); ++i1) {
                    Entity entity1 = (Entity)list1.get(i1);
                    if (!(entity1 instanceof EntityLivingBase) || entity1 instanceof EntitySilverfishLoyalist || entity1 instanceof EntitySilverfishTitan) continue;
                    this.attackChoosenEntity(entity1, f, i);
                    entity1.field_70181_x += 1.0;
                }
            }
        }
        this.meleeTitan = true;
        Vec3 vec3 = this.func_70676_i(1.0f);
        double dx = vec3.field_72450_a;
        double dz = vec3.field_72449_c;
        this.head.func_70071_h_();
        this.head.func_70012_b(this.field_70165_t + dx * 3.0, this.field_70163_u, this.field_70161_v + dz * 3.0, 0.0f, 0.0f);
        this.body.func_70071_h_();
        this.body.func_70012_b(this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, 0.0f, 0.0f);
        this.tailbase.func_70071_h_();
        this.tailbase.func_70012_b(this.field_70165_t - dx * 7.0, this.field_70163_u, this.field_70161_v - dz * 7.0, 0.0f, 0.0f);
        this.tailtip.func_70071_h_();
        this.tailtip.func_70012_b(this.field_70165_t - dx * 10.0, this.field_70163_u, this.field_70161_v - dz * 10.0, 0.0f, 0.0f);
        this.field_70761_aq = this.field_70177_z = this.field_70759_as;
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && !this.isStunned) {
            this.collideWithEntities(this.head, this.field_70170_p.func_72839_b((Entity)this, this.head.field_70121_D.func_72314_b(1.0, 1.0, 1.0)));
            this.collideWithEntities(this.tailbase, this.field_70170_p.func_72839_b((Entity)this, this.tailbase.field_70121_D.func_72314_b(1.0, 1.0, 1.0)));
            this.collideWithEntities(this.tailtip, this.field_70170_p.func_72839_b((Entity)this, this.tailtip.field_70121_D.func_72314_b(1.0, 1.0, 1.0)));
        }
        this.destroyBlocksInAABB(this.head.field_70121_D);
        this.destroyBlocksInAABB(this.body.field_70121_D);
        this.destroyBlocksInAABB(this.tailbase.field_70121_D);
        this.destroyBlocksInAABB(this.tailtip.field_70121_D);
        if (this.isStunned) {
            this.func_70624_b(null);
            AnimationAPI.sendAnimPacket(this, 8);
        }
        this.field_70761_aq = this.field_70177_z = this.field_70759_as;
        if (!this.isStunned && (list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(2.0, 2.0, 2.0))) != null && !list.isEmpty()) {
            for (int i1 = 0; i1 < list.size(); ++i1) {
                Entity entity = (Entity)list.get(i1);
                if (!(entity instanceof EntityUltimaBlade)) continue;
                entity.func_70106_y();
            }
        }
        if (!AnimationAPI.isEffectiveClient() && this.func_70638_az() != null && !this.isStunned && this.animID == 0) {
            d0 = this.func_70068_e((Entity)this.func_70638_az());
            if (d0 < (double)(this.field_70130_N * this.field_70130_N + this.func_70638_az().field_70130_N * this.func_70638_az().field_70130_N) + 36.0) {
                if (this.animID == 0) {
                    if (this.isBurrowing) {
                        AnimationAPI.sendAnimPacket(this, 2);
                        this.setAnimID(2);
                    } else if (this.func_70638_az() instanceof EntityTitan || this.func_70638_az().field_70131_O >= 6.0f || this.func_70638_az().field_70163_u > this.field_70163_u + 6.0) {
                        AnimationAPI.sendAnimPacket(this, 11);
                        this.setAnimID(11);
                    } else {
                        switch (this.field_70146_Z.nextInt(3)) {
                            case 0: {
                                AnimationAPI.sendAnimPacket(this, 4);
                                this.setAnimID(4);
                                break;
                            }
                            case 1: {
                                AnimationAPI.sendAnimPacket(this, 5);
                                this.setAnimID(5);
                                break;
                            }
                            case 2: {
                                AnimationAPI.sendAnimPacket(this, 6);
                                this.setAnimID(6);
                            }
                        }
                    }
                }
            } else {
                int i = 60;
                if (this.isArmored()) {
                    i = 20;
                }
                if (this.animID == 0 && !this.isBurrowing && this.func_70681_au().nextInt(i) == 0) {
                    this.isAttacking = true;
                    if (this.func_70638_az().field_70163_u > this.field_70163_u + 12.0) {
                        AnimationAPI.sendAnimPacket(this, 7);
                        this.setAnimID(7);
                    } else {
                        switch (this.field_70146_Z.nextInt(4)) {
                            case 0: {
                                AnimationAPI.sendAnimPacket(this, 3);
                                this.setAnimID(3);
                                break;
                            }
                            case 1: {
                                AnimationAPI.sendAnimPacket(this, 7);
                                this.setAnimID(7);
                                break;
                            }
                            case 2: {
                                if (!this.isBurrowing) {
                                    AnimationAPI.sendAnimPacket(this, 1);
                                    this.setAnimID(1);
                                    break;
                                }
                                AnimationAPI.sendAnimPacket(this, 3);
                                this.setAnimID(3);
                                break;
                            }
                            case 3: {
                                if (this.func_70681_au().nextInt(3) == 0) {
                                    AnimationAPI.sendAnimPacket(this, 9);
                                    this.setAnimID(9);
                                    break;
                                }
                                AnimationAPI.sendAnimPacket(this, 3);
                                this.setAnimID(3);
                            }
                        }
                    }
                }
            }
        }
        if (this.func_70638_az() == null || this.getAnimTick() == 0) {
            this.isAttacking = false;
        }
        if (this.animID != 0 || this.isStunned) {
            this.field_70159_w *= 0.0;
            this.field_70179_y *= 0.0;
        }
        if (this.animID == 8) {
            this.func_70624_b(null);
        }
        if (this.animID == 8) {
            if (this.animTick == 37) {
                this.func_85030_a("thetitans:largeFall", 4.0f, 1.0f);
            }
            if (this.animTick == 37) {
                this.func_85030_a("thetitans:distantLargeFall", 10000.0f, 1.0f);
            }
            if (this.animTick == 380) {
                this.isStunned = false;
            } else {
                this.func_70624_b(null);
            }
        }
        if (this.animID == 10) {
            if (this.animTick == 45 || this.animTick == 215) {
                this.func_85030_a("thetitans:titanFall", 10.0f, 1.0f);
            }
            if (this.animTick == 58) {
                this.func_85030_a("thetitans:distantLargeFall", 10000.0f, 1.0f);
            }
        }
        this.field_70761_aq = this.field_70177_z = this.field_70759_as;
        if (this.field_70173_aa % 20 == 0 && this.animID == 0) {
            this.isAttacking = false;
        }
        if (TheTitans.NightmareMode) {
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(150.0 + (double)(this.getExtraPower() * 15));
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8000.0 + (double)(this.getExtraPower() * 1000));
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(50.0 + (double)(this.getExtraPower() * 5));
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(4000.0 + (double)(this.getExtraPower() * 500));
        }
        this.func_94058_c("\u00a7oOmegafish");
        if (this.field_70146_Z.nextInt(100) == 0 && this.func_70638_az() != null && this.animID == 0) {
            this.func_70625_a((Entity)this.func_70638_az(), 180.0f, 180.0f);
            d0 = this.func_70638_az().field_70165_t - this.field_70165_t;
            double d1 = this.func_70638_az().field_70161_v - this.field_70161_v;
            float f2 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
            this.field_70159_w = d0 / (double)f2 * 2.0 * 2.0 + this.field_70159_w * 2.0;
            this.field_70179_y = d1 / (double)f2 * 2.0 * 2.0 + this.field_70179_y * 2.0;
        }
        if (this.func_70089_S() && this.field_70146_Z.nextInt(40) == 0 && this.func_70638_az() != null && this.isArmored()) {
            this.field_70125_A = -90.0f;
            this.field_70170_p.func_72885_a((Entity)this, this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v, 2.0f, false, false);
        }
        if (this.numMinions < this.getMinionCap() && this.field_70146_Z.nextInt(this.getMinionSpawnRate()) == 0 && this.func_110143_aJ() > 0.0f && !this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL) {
            EntitySilverfishLoyalist entitychicken = new EntitySilverfishLoyalist(this.field_70170_p);
            this.teleportEntityRandomly((EntityLivingBase)entitychicken);
            entitychicken.master = this;
            entitychicken.func_85030_a("thetitans:titansummonminion", 1.0f, 1.0f);
            entitychicken.func_70024_g(0.0, 0.5, 0.0);
            entitychicken.func_110161_a(null);
            this.field_70170_p.func_72838_d((Entity)entitychicken);
            entitychicken.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 40, 4, false));
            Block block = this.field_70170_p.func_147439_a((int)entitychicken.field_70165_t, (int)(entitychicken.field_70163_u + 1.0), (int)entitychicken.field_70161_v);
            this.field_70170_p.func_72926_e(2001, (int)entitychicken.field_70165_t, (int)entitychicken.field_70163_u, (int)entitychicken.field_70161_v, Block.func_149682_b((Block)block));
            ++this.numMinions;
            if (block == Blocks.field_150349_c) {
                this.field_70170_p.func_147449_b((int)entitychicken.field_70165_t, (int)(entitychicken.field_70163_u + 1.0), (int)entitychicken.field_70161_v, Blocks.field_150346_d);
            }
            ++this.numMinions;
            if (this.isSubdued) {
                entitychicken.isMasterSubdued = true;
            }
            if (this.isSubdued) {
                entitychicken.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan((EntityCreature)entitychicken, EntityLivingBase.class, 0, false, true, entitychicken.allowPlayerPresence));
            } else {
                entitychicken.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan((EntityCreature)entitychicken, EntityLivingBase.class, 0, false, true, ITitan.SearchForAThingToKill));
            }
        }
        if (this.numPriests < this.getPriestCap() && this.field_70146_Z.nextInt(this.getMinionSpawnRate() * 2) == 0 && this.func_110143_aJ() > 0.0f && !this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL) {
            EntitySilverfishPriest entitychicken = new EntitySilverfishPriest(this.field_70170_p);
            this.teleportEntityRandomly((EntityLivingBase)entitychicken);
            entitychicken.master = this;
            entitychicken.func_85030_a("thetitans:titansummonminion", 1.0f, 1.0f);
            entitychicken.func_70024_g(0.0, 0.5, 0.0);
            entitychicken.func_110161_a(null);
            this.field_70170_p.func_72838_d((Entity)entitychicken);
            entitychicken.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 40, 4, false));
            Block block = this.field_70170_p.func_147439_a((int)entitychicken.field_70165_t, (int)(entitychicken.field_70163_u + 1.0), (int)entitychicken.field_70161_v);
            this.field_70170_p.func_72926_e(2001, (int)entitychicken.field_70165_t, (int)entitychicken.field_70163_u, (int)entitychicken.field_70161_v, Block.func_149682_b((Block)block));
            ++this.numMinions;
            if (block == Blocks.field_150349_c) {
                this.field_70170_p.func_147449_b((int)entitychicken.field_70165_t, (int)(entitychicken.field_70163_u + 1.0), (int)entitychicken.field_70161_v, Blocks.field_150346_d);
            }
            ++this.numPriests;
            if (this.isSubdued) {
                entitychicken.isMasterSubdued = true;
            }
            if (this.isSubdued) {
                entitychicken.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan((EntityCreature)entitychicken, EntityLivingBase.class, 0, false, true, entitychicken.allowPlayerPresence));
            } else {
                entitychicken.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan((EntityCreature)entitychicken, EntityLivingBase.class, 0, false, true, ITitan.SearchForAThingToKill));
            }
        }
        if (this.numZealots < this.getZealotCap() && this.field_70146_Z.nextInt(this.getMinionSpawnRate() * 5) == 0 && this.func_110143_aJ() > 0.0f && !this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL) {
            EntitySilverfishZealot entitychicken = new EntitySilverfishZealot(this.field_70170_p);
            this.teleportEntityRandomly((EntityLivingBase)entitychicken);
            entitychicken.master = this;
            entitychicken.func_85030_a("thetitans:titansummonminion", 1.0f, 1.0f);
            entitychicken.func_70024_g(0.0, 0.5, 0.0);
            entitychicken.func_110161_a(null);
            this.field_70170_p.func_72838_d((Entity)entitychicken);
            entitychicken.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 40, 4, false));
            Block block = this.field_70170_p.func_147439_a((int)entitychicken.field_70165_t, (int)(entitychicken.field_70163_u + 1.0), (int)entitychicken.field_70161_v);
            this.field_70170_p.func_72926_e(2001, (int)entitychicken.field_70165_t, (int)entitychicken.field_70163_u, (int)entitychicken.field_70161_v, Block.func_149682_b((Block)block));
            ++this.numMinions;
            if (block == Blocks.field_150349_c) {
                this.field_70170_p.func_147449_b((int)entitychicken.field_70165_t, (int)(entitychicken.field_70163_u + 1.0), (int)entitychicken.field_70161_v, Blocks.field_150346_d);
            }
            ++this.numZealots;
            if (this.isSubdued) {
                entitychicken.isMasterSubdued = true;
            }
            if (this.isSubdued) {
                entitychicken.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan((EntityCreature)entitychicken, EntityLivingBase.class, 0, false, true, entitychicken.allowPlayerPresence));
            } else {
                entitychicken.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan((EntityCreature)entitychicken, EntityLivingBase.class, 0, false, true, ITitan.SearchForAThingToKill));
            }
        }
        if (this.numTemplar < this.getTemplarCap() && this.field_70146_Z.nextInt(this.getMinionSpawnRate() * 10) == 0 && this.func_110143_aJ() > 0.0f && !this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL) {
            EntitySilverfishTemplar entitychicken = new EntitySilverfishTemplar(this.field_70170_p);
            this.teleportEntityRandomly((EntityLivingBase)entitychicken);
            entitychicken.master = this;
            entitychicken.func_85030_a("thetitans:titansummonminion", 1.0f, 1.0f);
            entitychicken.func_70024_g(0.0, 0.5, 0.0);
            entitychicken.func_110161_a(null);
            this.field_70170_p.func_72838_d((Entity)entitychicken);
            entitychicken.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 40, 4, false));
            Block block = this.field_70170_p.func_147439_a((int)entitychicken.field_70165_t, (int)(entitychicken.field_70163_u + 1.0), (int)entitychicken.field_70161_v);
            this.field_70170_p.func_72926_e(2001, (int)entitychicken.field_70165_t, (int)entitychicken.field_70163_u, (int)entitychicken.field_70161_v, Block.func_149682_b((Block)block));
            if (block == Blocks.field_150349_c) {
                this.field_70170_p.func_147449_b((int)entitychicken.field_70165_t, (int)(entitychicken.field_70163_u + 1.0), (int)entitychicken.field_70161_v, Blocks.field_150346_d);
            }
            ++this.numTemplar;
            if (this.isSubdued) {
                entitychicken.isMasterSubdued = true;
            }
            if (this.isSubdued) {
                entitychicken.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan((EntityCreature)entitychicken, EntityLivingBase.class, 0, false, true, entitychicken.allowPlayerPresence));
            } else {
                entitychicken.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan((EntityCreature)entitychicken, EntityLivingBase.class, 0, false, true, ITitan.SearchForAThingToKill));
            }
        }
        super.func_70636_d();
    }

    protected void func_70069_a(float p_70069_1_) {
        if ((p_70069_1_ = ForgeHooks.onLivingFall((EntityLivingBase)this, (float)p_70069_1_)) <= 0.0f) {
            return;
        }
        PotionEffect potioneffect = this.func_70660_b(Potion.field_76430_j);
        float f1 = potioneffect != null ? (float)(potioneffect.func_76458_c() + 1) : 0.0f;
        int i = MathHelper.func_76123_f((float)(p_70069_1_ - 12.0f - f1));
        if (i > 0) {
            int l;
            int k;
            int j;
            Block block;
            this.func_85030_a("thetitans:groundSmash", 20.0f, 1.5f);
            this.func_85030_a("thetitans:titanland", 10000.0f, 1.0f);
            this.destroyBlocksInAABB(this.field_70121_D.func_72314_b(16.0, 2.0, 16.0));
            List list11 = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(48.0, 2.0, 48.0));
            if (list11 != null && !list11.isEmpty()) {
                for (int i1 = 0; i1 < list11.size(); ++i1) {
                    Entity entity = (Entity)list11.get(i1);
                    if (!(entity instanceof EntityLivingBase) || !this.func_70686_a(entity.getClass()) || entity instanceof EntityTitan) continue;
                    float smash = 50.0f - this.func_70032_d(entity);
                    if (smash <= 1.0f) {
                        smash = 1.0f;
                    }
                    entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), smash);
                    double d0 = this.field_70121_D.field_72340_a + this.field_70121_D.field_72336_d;
                    double d1 = this.field_70121_D.field_72339_c + this.field_70121_D.field_72334_f;
                    double d2 = entity.field_70165_t - d0;
                    double d3 = entity.field_70161_v - d1;
                    double d4 = d2 * d2 + d3 * d3;
                    entity.func_70024_g(d2 / d4 * 8.0, 1.0, d3 / d4 * 8.0);
                }
            }
            if ((block = this.field_70170_p.func_147439_a(j = MathHelper.func_76128_c((double)this.field_70165_t), k = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f - (double)this.field_70129_M)), l = MathHelper.func_76128_c((double)this.field_70161_v))).func_149688_o() != Material.field_151579_a) {
                Block.SoundType soundtype = block.field_149762_H;
                this.func_85030_a(soundtype.func_150498_e(), soundtype.func_150497_c() * 0.5f, soundtype.func_150494_d() * 0.75f);
            }
        }
    }

    @Override
    public StatBase getAchievement() {
        return TitansAchievments.omegafish;
    }

    public boolean attackOmegafishFrom(DamageSource source, float amount) {
        if (source.func_76346_g() instanceof EntityPlayer && !this.field_70170_p.field_72995_K) {
            this.func_70624_b((EntityLivingBase)source.func_76346_g());
            this.func_70604_c((EntityLivingBase)source.func_76346_g());
        }
        if (this.isArmored()) {
            amount *= 0.25f;
        }
        if (this.func_85032_ar()) {
            return false;
        }
        if (!this.isStunned && !this.isBurrowing && source.func_76346_g() instanceof EntityPlayer) {
            if (source.func_76346_g() instanceof EntityPlayer && source.func_76357_e()) {
                this.func_85030_a(this.func_70621_aR(), this.func_70599_aP(), this.func_70647_i());
                this.isStunned = true;
                this.func_70624_b(null);
            }
            return false;
        }
        if (source.func_76346_g() instanceof EntitySilverfishLoyalist || source.func_76346_g() instanceof EntitySilverfishTitan) {
            return false;
        }
        this.field_70718_bc = 200;
        Entity entity = source.func_76346_g();
        if (entity instanceof EntityLivingBase && !this.func_85032_ar() && amount > 25.0f) {
            List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(100.0, 100.0, 100.0));
            for (int i = 0; i < list.size(); ++i) {
                Entity entity1 = (Entity)list.get(i);
                if (entity1 instanceof EntitySilverfishTitan) {
                    EntitySilverfishTitan entitypigzombie = (EntitySilverfishTitan)entity1;
                    entitypigzombie.func_70624_b((EntityLivingBase)entity);
                    entitypigzombie.func_70604_c((EntityLivingBase)entity);
                }
                this.func_70624_b((EntityLivingBase)entity);
                this.func_70604_c((EntityLivingBase)entity);
            }
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70067_L() {
        return true;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        return this.attackOmegafishFrom(source, amount);
    }

    @Override
    public void setAnimID(int id) {
        this.animID = id;
    }

    @Override
    public void setAnimTick(int tick) {
        this.animTick = tick;
    }

    @Override
    public int getAnimID() {
        return this.animID;
    }

    @Override
    public int getAnimTick() {
        return this.animTick;
    }

    protected boolean func_70610_aX() {
        return this.isSubdued && this.field_70153_n == null ? true : super.func_70610_aX();
    }

    public void func_70043_V() {
        if (this.field_70153_n != null) {
            double d8 = 0.4 + (double)this.getExtraPower() * 0.05;
            Vec3 vec3 = this.func_70676_i(1.0f);
            double dx = vec3.field_72450_a * d8;
            double dz = vec3.field_72449_c * d8;
            this.field_70153_n.func_70107_b(this.field_70165_t + dx, this.field_70163_u + (this.isBurrowing ? 0.5 + (double)this.getExtraPower() * 0.05 : 5.0 + (double)this.getExtraPower() * 0.05), this.field_70161_v + dz);
        }
    }

    public boolean func_70085_c(EntityPlayer p_70085_1_) {
        ItemStack itemstack = p_70085_1_.field_71071_by.func_70448_g();
        p_70085_1_.func_71038_i();
        if (this.isStunned && !this.isSubdued) {
            if (itemstack != null && itemstack.func_77973_b() == Items.field_151153_ao) {
                this.isSubdued = true;
                this.field_70170_p.func_72956_a((Entity)this, "random.levelup", 10.0f, 1.0f);
                p_70085_1_.func_145747_a((IChatComponent)new ChatComponentText(this.func_94057_bL() + " has been subdued by " + p_70085_1_.func_70005_c_()));
                return super.func_70085_c(p_70085_1_);
            }
        } else if (this.isSubdued) {
            if (itemstack == null && p_70085_1_.field_70154_o == null) {
                p_70085_1_.func_70078_a((Entity)this);
            } else if (itemstack != null) {
                if (itemstack.func_77973_b() == Items.field_151045_i) {
                    AnimationAPI.sendAnimPacket(this, 9);
                    this.setAnimID(9);
                    this.isAttacking = true;
                }
                if (itemstack.func_77973_b() == Items.field_151037_a) {
                    if (this.isBurrowing) {
                        AnimationAPI.sendAnimPacket(this, 2);
                        this.setAnimID(2);
                    } else {
                        AnimationAPI.sendAnimPacket(this, 1);
                        this.setAnimID(1);
                    }
                    this.isAttacking = true;
                }
                if (itemstack.func_77973_b() == Items.field_151077_bg) {
                    AnimationAPI.sendAnimPacket(this, 3);
                    this.setAnimID(3);
                    this.isAttacking = true;
                }
                if (itemstack.func_77973_b() == Items.field_151103_aS) {
                    this.isAttacking = true;
                    switch (this.field_70146_Z.nextInt(2)) {
                        case 0: {
                            AnimationAPI.sendAnimPacket(this, 5);
                            this.setAnimID(5);
                            break;
                        }
                        case 1: {
                            AnimationAPI.sendAnimPacket(this, 6);
                            this.setAnimID(6);
                        }
                    }
                }
            }
        }
        return false;
    }

    @Override
    protected void inactDeathAction() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
                this.func_70628_a(true, 0);
                this.func_82160_b(true, 0);
                this.func_70600_l(1);
            }
            EntityTitanSpirit entitytitan = new EntityTitanSpirit(this.field_70170_p);
            entitytitan.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
            this.field_70170_p.func_72838_d((Entity)entitytitan);
            entitytitan.setVesselHunting(false);
            entitytitan.setSpiritType(1);
        }
    }

    @Override
    protected void onTitanDeathUpdate() {
        this.field_70180_af.func_75692_b(6, (Object)Float.valueOf(MathHelper.func_76131_a((float)this.field_70180_af.func_111145_d(5), (float)0.0f, (float)this.func_110138_aP())));
        if (this.field_70180_af.func_111145_d(5) <= 0.0f) {
            ++this.deathTicks;
            AnimationAPI.sendAnimPacket(this, 10);
            this.setAnimID(10);
            this.setTitanHealth(0.0f);
        } else {
            this.func_70097_a(DamageSource.field_76380_i, 25.0f);
            this.setTitanHealth(this.field_70180_af.func_111145_d(5));
            this.func_70606_j(this.field_70180_af.func_111145_d(5));
            this.deathTicks = 0;
            if (this.animID == 10) {
                this.animID = 0;
            }
        }
        this.field_70159_w *= 0.0;
        this.field_70179_y *= 0.0;
        this.func_70624_b(null);
        if (this.deathTicks == 1 && !this.field_70170_p.field_72995_K) {
            this.func_85030_a(this.func_70673_aS(), this.func_70599_aP(), this.func_70647_i());
            ArrayList listp = Lists.newArrayList((Iterable)this.field_70170_p.field_73010_i);
            if (listp != null && !listp.isEmpty()) {
                for (int i1 = 0; i1 < listp.size(); ++i1) {
                    Entity entity = (Entity)listp.get(i1);
                    if (entity == null || !(entity instanceof EntityPlayer)) continue;
                    ((EntityPlayer)entity).func_71029_a(this.getAchievement());
                }
            }
        }
        if (this.deathTicks == 1) {
            this.setAnimTick(1);
        }
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot") && this.deathTicks >= 300 && this.deathTicks % 10 == 0) {
            int j;
            for (int i = this.func_70693_a(this.field_70717_bb) / 10; i > 0; i -= j) {
                j = EntityXPOrb.func_70527_a((int)i);
                this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u + 32.0, this.field_70161_v, j));
            }
        }
        if (this.deathTicks >= 300) {
            this.setInvulTime(this.getInvulTime() + 8);
            --this.animTick;
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 4.0f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            this.field_70170_p.func_72869_a("hugeexplosion", this.field_70165_t + (double)f, this.field_70163_u + 2.0 + (double)f1, this.field_70161_v + (double)f2, 0.0, 0.0, 0.0);
        }
        if (this.getInvulTime() >= this.getThreashHold()) {
            this.func_70106_y();
        }
    }

    public boolean func_70965_a(EntityDragonPart p_70965_1_, DamageSource source, float amount) {
        amount = p_70965_1_ != this.head ? (amount /= 2.0f) : (amount *= 2.0f);
        this.func_82195_e(source, amount);
        return true;
    }

    protected boolean func_82195_e(DamageSource p_82195_1_, float p_82195_2_) {
        return this.attackOmegafishFrom(p_82195_1_, p_82195_2_);
    }

    public World func_82194_d() {
        return this.field_70170_p;
    }

    @Override
    protected void func_70619_bc() {
        super.func_70619_bc();
        List list11 = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D);
        if (list11 != null && !list11.isEmpty()) {
            for (int i1 = 0; i1 < list11.size(); ++i1) {
                Entity entity = (Entity)list11.get(i1);
                if (!(entity instanceof EntityLivingBase) || !entity.field_70122_E || entity instanceof EntityTitan) continue;
                float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
                entity.func_70097_a(DamageSourceExtra.causeSquishingDamage((Entity)this), f / 2.0f);
            }
        }
    }

    public void func_70612_e(float p_70612_1_, float p_70612_2_) {
        if (this.field_70153_n != null && this.field_70153_n instanceof EntityLivingBase && this.isSubdued) {
            this.func_70624_b(null);
            this.field_70125_A = this.field_70153_n.field_70125_A;
            this.field_70759_as = ((EntityLivingBase)this.field_70153_n).field_70759_as;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            p_70612_1_ = ((EntityLivingBase)this.field_70153_n).field_70702_br;
            p_70612_2_ = ((EntityLivingBase)this.field_70153_n).field_70701_bs;
            if (((EntityLivingBase)this.field_70153_n).field_70701_bs > 0.0f) {
                this.func_70024_g((double)(-MathHelper.func_76126_a((float)(((EntityLivingBase)this.field_70153_n).field_70759_as * (float)Math.PI / 180.0f))) * this.getSpeed(), 0.0, (double)MathHelper.func_76134_b((float)(((EntityLivingBase)this.field_70153_n).field_70759_as * (float)Math.PI / 180.0f)) * this.getSpeed());
            }
            if (((EntityLivingBase)this.field_70153_n).field_70701_bs < 0.0f) {
                this.func_70024_g((double)(-MathHelper.func_76126_a((float)(((EntityLivingBase)this.field_70153_n).field_70759_as * (float)Math.PI / 180.0f))) * -this.getSpeed(), 0.0, (double)MathHelper.func_76134_b((float)(((EntityLivingBase)this.field_70153_n).field_70759_as * (float)Math.PI / 180.0f)) * -this.getSpeed());
            }
            if (this.field_70122_E && ((EntityLivingBase)this.field_70153_n).field_70125_A < -80.0f) {
                this.func_70664_aZ();
            }
            if (!this.field_70170_p.field_72995_K) {
                super.func_70612_e(p_70612_1_, p_70612_2_);
            }
            this.field_70722_aY = this.field_70721_aZ;
            double do1 = this.field_70165_t - this.field_70169_q;
            double do0 = this.field_70161_v - this.field_70166_s;
            float f4 = MathHelper.func_76133_a((double)(do1 * do1 + do0 * do0)) * 4.0f;
            if (f4 > 1.0f) {
                f4 = 1.0f;
            }
            this.field_70721_aZ += (f4 - this.field_70721_aZ) * 0.4f;
            this.field_70754_ba += this.field_70721_aZ;
        } else {
            super.func_70612_e(p_70612_1_, p_70612_2_);
        }
    }
}

