/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.titan;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.entity.titan.EntityBlazeTitanFireball;
import net.minecraft.entity.titan.EntityIronGolemTitan;
import net.minecraft.entity.titan.EntitySnowGolemTitan;
import net.minecraft.entity.titan.EntityTitan;
import net.minecraft.entity.titan.EntityTitanSpirit;
import net.minecraft.entity.titan.EnumTitanStatus;
import net.minecraft.entity.titan.ITitan;
import net.minecraft.entity.titan.ai.EntityAINearestTargetTitan;
import net.minecraft.entity.titan.animation.pigzombietitan.AnimationPigZombieTitanAntiTitanAttack1;
import net.minecraft.entity.titan.animation.pigzombietitan.AnimationPigZombieTitanAntiTitanAttack2;
import net.minecraft.entity.titan.animation.pigzombietitan.AnimationPigZombieTitanAttack;
import net.minecraft.entity.titan.animation.pigzombietitan.AnimationPigZombieTitanAttack2;
import net.minecraft.entity.titan.animation.pigzombietitan.AnimationPigZombieTitanAttack3;
import net.minecraft.entity.titan.animation.pigzombietitan.AnimationPigZombieTitanAttack4;
import net.minecraft.entity.titan.animation.pigzombietitan.AnimationPigZombieTitanDeath;
import net.minecraft.entity.titan.animation.pigzombietitan.AnimationPigZombieTitanGroundPunch;
import net.minecraft.entity.titan.animation.pigzombietitan.AnimationPigZombieTitanLightningAttack;
import net.minecraft.entity.titan.animation.pigzombietitan.AnimationPigZombieTitanStun;
import net.minecraft.entity.titanminion.EntityGhastGuard;
import net.minecraft.entity.titanminion.EntityGhastGuardFireball;
import net.minecraft.entity.titanminion.EntityPigZombieLoyalist;
import net.minecraft.entity.titanminion.EntityPigZombiePriest;
import net.minecraft.entity.titanminion.EntityPigZombieTemplar;
import net.minecraft.entity.titanminion.EntityPigZombieZealot;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.theTitans.DamageSourceExtra;
import net.minecraft.theTitans.TheTitans;
import net.minecraft.theTitans.TitanItems;
import net.minecraft.theTitans.TitansAchievments;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import thehippomaster.AnimationAPI.AnimationAPI;
import thehippomaster.AnimationAPI.IAnimatedEntity;

public class EntityPigZombieTitan
extends EntityTitan
implements IAnimatedEntity,
IEntityMultiPart {
    private static final UUID babySpeedBoostUUID = UUID.fromString("B9766B59-9566-4402-BC1F-2EE2A276D836");
    private static final AttributeModifier babySpeedBoostModifier = new AttributeModifier(babySpeedBoostUUID, "Baby speed boost", 0.5, 1);
    private static final UUID field_110189_bq = UUID.fromString("49455A49-7EC5-45BA-B886-3B90B23A1718");
    private static final AttributeModifier field_110190_br = new AttributeModifier(field_110189_bq, "Attacking speed boost", 0.05, 0).func_111168_a(false);
    private UUID field_175459_bn;
    public boolean isAttacking;
    public boolean isStunned;
    public EntityDragonPart[] partArray;
    public EntityDragonPart head = new EntityDragonPart((IEntityMultiPart)this, "head", 8.0f, 8.0f);
    public EntityDragonPart body = new EntityDragonPart((IEntityMultiPart)this, "body", 8.0f, 12.0f);
    public EntityDragonPart rightArm = new EntityDragonPart((IEntityMultiPart)this, "rightarm", 4.0f, 4.0f);
    public EntityDragonPart leftArm = new EntityDragonPart((IEntityMultiPart)this, "leftarm", 4.0f, 4.0f);
    public EntityDragonPart rightLeg = new EntityDragonPart((IEntityMultiPart)this, "rightleft", 4.0f, 12.0f);
    public EntityDragonPart leftLeg = new EntityDragonPart((IEntityMultiPart)this, "leftleg", 4.0f, 12.0f);

    public EntityPigZombieTitan(World worldIn) {
        super(worldIn);
        this.partArray = new EntityDragonPart[]{this.head, this.body, this.rightArm, this.leftArm, this.rightLeg, this.leftLeg};
        this.shouldParticlesBeUpward = true;
        this.field_70178_ae = true;
        this.field_70728_aV = 100000;
        this.func_70105_a(8.0f, 32.0f);
        this.meleeTitan = true;
        this.field_70138_W = 9.0f;
        this.func_70062_b(0, new ItemStack(Items.field_151010_B));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan(this, EntityIronGolemTitan.class, 0, false));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan(this, EntitySnowGolemTitan.class, 0, false));
    }

    @Override
    protected void applyEntityAI() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationPigZombieTitanDeath(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationPigZombieTitanAttack4(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationPigZombieTitanStun(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationPigZombieTitanAttack3(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationPigZombieTitanAttack2(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationPigZombieTitanLightningAttack(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationPigZombieTitanAntiTitanAttack1(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationPigZombieTitanAttack(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationPigZombieTitanAntiTitanAttack2(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationPigZombieTitanGroundPunch(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        if (TheTitans.TitansFFAMode) {
            this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan(this, EntityLivingBase.class, 0, false, false, ITitan.PigZombieTitanSorter));
        } else {
            this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan(this, EntityLivingBase.class, 0, false, false, ITitan.SearchForAThingToKill));
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_70096_w().func_75682_a(12, (Object)0);
    }

    @Override
    public double getSpeed() {
        return this.func_70631_g_() ? 0.8 : 0.5;
    }

    public boolean func_70631_g_() {
        return this.func_70096_w().func_75683_a(12) == 1;
    }

    @Override
    public int getMinionCap() {
        return 180;
    }

    @Override
    public int getPriestCap() {
        return 90;
    }

    @Override
    public int getZealotCap() {
        return 40;
    }

    @Override
    public int getTemplarCap() {
        return 9;
    }

    @Override
    public int getSpecialMinionCap() {
        return 16;
    }

    protected int func_70693_a(EntityPlayer player) {
        if (this.func_70631_g_()) {
            this.field_70728_aV = (int)((float)this.field_70728_aV * 2.5f);
        }
        return super.func_70693_a(player);
    }

    public void setChild(boolean childZombie) {
        this.func_70096_w().func_75692_b(12, (Object)((byte)(childZombie ? 1 : 0)));
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
            iattributeinstance.func_111124_b(babySpeedBoostModifier);
            if (childZombie) {
                iattributeinstance.func_111121_a(babySpeedBoostModifier);
            }
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        if (this.func_70631_g_()) {
            tagCompound.func_74757_a("IsBaby", true);
        }
        tagCompound.func_74757_a("Stunned", this.isStunned);
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        if (tagCompund.func_74767_n("IsBaby")) {
            this.setChild(true);
        }
        this.isStunned = tagCompund.func_74767_n("Stunned");
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.animID != 0) {
            ++this.animTick;
            if (this.func_70631_g_() && this.func_70089_S()) {
                ++this.animTick;
            }
        }
    }

    @Override
    public EnumTitanStatus getTitanStatus() {
        return EnumTitanStatus.AVERAGE;
    }

    public boolean func_70686_a(Class p_70686_1_) {
        return p_70686_1_ != EntityPigZombieLoyalist.class && p_70686_1_ != EntityGhastGuard.class && p_70686_1_ != EntityPigZombieTitan.class;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K && this.deathTicks < this.getThreashHold() && this.func_70026_G()) {
            for (int i = 0; i < this.getParticleCount() * 50; ++i) {
                this.field_70170_p.func_72869_a(this.getParticles(), this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.25, 0.0);
            }
        }
        if (this.field_70146_Z.nextInt(40) == 0 && this.func_70026_G()) {
            this.func_85030_a("random.fizz", 20.0f, 1.5f);
        }
        if (this.animID == 8) {
            if (this.animTick == 70) {
                this.func_85030_a("thetitans:groundSmash", 8.0f, 0.9f);
                this.func_85030_a("thetitans:titanFall", 10.0f, 1.0f);
            }
            if (this.animTick == 74) {
                this.func_85030_a("thetitans:distantLargeFall", 10000.0f, 1.0f);
            }
            if (this.animTick == 530) {
                this.isStunned = false;
            } else {
                this.func_70624_b(null);
            }
        }
        if (this.isStunned) {
            this.func_70624_b(null);
            AnimationAPI.sendAnimPacket(this, 8);
            this.setAnimID(8);
        }
        if (this.animID == 10) {
            if (this.animTick == 30 || this.animTick == 70) {
                this.func_85030_a("thetitans:titanStep", 10.0f, 1.0f);
            }
            if (this.animTick == 190) {
                this.func_85030_a("thetitans:titanFall", 20.0f, 1.0f);
                this.collideWithEntities(this.leftLeg, this.field_70170_p.func_72839_b((Entity)this, this.leftLeg.field_70121_D.func_72314_b(16.0, 1.0, 16.0)));
                this.collideWithEntities(this.rightLeg, this.field_70170_p.func_72839_b((Entity)this, this.rightLeg.field_70121_D.func_72314_b(16.0, 1.0, 16.0)));
            }
            if (this.animTick == 200) {
                this.func_85030_a("thetitans:distantLargeFall", 10000.0f, 1.0f);
            }
        }
        if (!this.isAttacking && this.field_70146_Z.nextInt(200) == 0 && this.func_70638_az() != null && this.field_70122_E && this.func_70068_e((Entity)this.func_70638_az()) > 512.0) {
            this.func_70664_aZ();
            this.func_85030_a(this.func_70621_aR(), this.func_70599_aP(), this.func_70647_i());
        }
        if (this.getAnimID() == 7 && this.getAnimTick() == 122) {
            double d8 = 32.0;
            Vec3 vec3 = this.func_70676_i(1.0f);
            double dx = vec3.field_72450_a * d8;
            double dz = vec3.field_72449_c * d8;
            int y = MathHelper.func_76128_c((double)this.field_70163_u);
            int x = MathHelper.func_76128_c((double)(this.field_70165_t + dx));
            int z = MathHelper.func_76128_c((double)(this.field_70161_v + dz));
            for (int l1 = -4; l1 <= 4; ++l1) {
                for (int i2 = -4; i2 <= 4; ++i2) {
                    for (int j = -1; j <= 1; ++j) {
                        int j2 = x + l1;
                        int k = y + j;
                        int l = z + i2;
                        Block block = this.field_70170_p.func_147439_a(j2, k, l);
                        if (!block.isAir((IBlockAccess)this.field_70170_p, j2, k, l)) {
                            this.func_85030_a("thetitans:titanStrike", 20.0f, 1.0f);
                            this.func_85030_a("thetitans:titanSlam", 20.0f, 1.0f);
                            this.field_70170_p.func_72926_e(2001, j2, k, l, Block.func_149682_b((Block)block));
                            if (block == Blocks.field_150349_c) {
                                this.field_70170_p.func_147449_b(j2, k, l, Blocks.field_150346_d);
                            }
                        }
                        if (!(block.func_149638_a((Entity)this) > 500.0f)) continue;
                        AnimationAPI.sendAnimPacket(this, 8);
                        this.setAnimID(8);
                        this.setAnimTick(0);
                        this.func_85030_a("random.anvil_land", 20.0f, 0.5f);
                        if (this.field_70170_p.field_72995_K) continue;
                        this.isStunned = true;
                    }
                }
            }
        }
        float f = this.field_70761_aq * (float)Math.PI / 180.0f;
        float f1 = MathHelper.func_76126_a((float)f);
        float f2 = MathHelper.func_76134_b((float)f);
        if (this.func_70631_g_()) {
            this.func_70105_a(6.0f, 18.0f);
            this.head.func_70071_h_();
            this.head.func_70012_b(this.field_70165_t, this.field_70163_u + 12.0, this.field_70161_v, 0.0f, 0.0f);
            this.body.func_70071_h_();
            this.body.func_70012_b(this.field_70165_t, this.field_70163_u + 6.0, this.field_70161_v, 0.0f, 0.0f);
            this.rightArm.func_70071_h_();
            this.rightArm.func_70012_b(this.field_70165_t + (double)(f2 * 4.0f), this.field_70163_u + 10.0, this.field_70161_v + (double)(f1 * 4.0f), 0.0f, 0.0f);
            this.leftArm.func_70071_h_();
            this.leftArm.func_70012_b(this.field_70165_t - (double)(f2 * 4.0f), this.field_70163_u + 10.0, this.field_70161_v - (double)(f1 * 4.0f), 0.0f, 0.0f);
            this.rightLeg.func_70071_h_();
            this.rightLeg.func_70012_b(this.field_70165_t + (double)(f2 * 1.0f), this.field_70163_u, this.field_70161_v + (double)(f1 * 1.0f), 0.0f, 0.0f);
            this.leftLeg.func_70071_h_();
            this.leftLeg.func_70012_b(this.field_70165_t - (double)(f2 * 1.0f), this.field_70163_u, this.field_70161_v - (double)(f1 * 1.0f), 0.0f, 0.0f);
        } else {
            this.func_70105_a(8.0f, 32.0f);
            this.head.func_70071_h_();
            this.head.func_70012_b(this.field_70165_t, this.field_70163_u + 24.0, this.field_70161_v, 0.0f, 0.0f);
            this.body.func_70071_h_();
            this.body.func_70012_b(this.field_70165_t, this.field_70163_u + 12.0, this.field_70161_v, 0.0f, 0.0f);
            this.rightArm.func_70071_h_();
            this.rightArm.func_70012_b(this.field_70165_t + (double)(f2 * 8.0f), this.field_70163_u + 20.0, this.field_70161_v + (double)(f1 * 8.0f), 0.0f, 0.0f);
            this.leftArm.func_70071_h_();
            this.leftArm.func_70012_b(this.field_70165_t - (double)(f2 * 8.0f), this.field_70163_u + 20.0, this.field_70161_v - (double)(f1 * 8.0f), 0.0f, 0.0f);
            this.rightLeg.func_70071_h_();
            this.rightLeg.func_70012_b(this.field_70165_t + (double)(f2 * 2.0f), this.field_70163_u, this.field_70161_v + (double)(f1 * 2.0f), 0.0f, 0.0f);
            this.leftLeg.func_70071_h_();
            this.leftLeg.func_70012_b(this.field_70165_t - (double)(f2 * 2.0f), this.field_70163_u, this.field_70161_v - (double)(f1 * 2.0f), 0.0f, 0.0f);
        }
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && !this.isStunned) {
            this.collideWithEntities(this.head, this.field_70170_p.func_72839_b((Entity)this, this.head.field_70121_D.func_72314_b(1.0, 1.0, 1.0)));
            this.collideWithEntities(this.body, this.field_70170_p.func_72839_b((Entity)this, this.body.field_70121_D.func_72314_b(1.0, 1.0, 1.0)));
            this.collideWithEntities(this.rightArm, this.field_70170_p.func_72839_b((Entity)this, this.rightArm.field_70121_D.func_72314_b(1.0, 1.0, 1.0)));
            this.collideWithEntities(this.leftArm, this.field_70170_p.func_72839_b((Entity)this, this.leftArm.field_70121_D.func_72314_b(1.0, 1.0, 1.0)));
            this.collideWithEntities(this.leftLeg, this.field_70170_p.func_72839_b((Entity)this, this.leftLeg.field_70121_D.func_72314_b(1.0, 1.0, 1.0)));
            this.collideWithEntities(this.rightLeg, this.field_70170_p.func_72839_b((Entity)this, this.rightLeg.field_70121_D.func_72314_b(1.0, 1.0, 1.0)));
        }
        this.destroyBlocksInAABB(this.head.field_70121_D);
        this.destroyBlocksInAABB(this.body.field_70121_D);
        this.destroyBlocksInAABB(this.rightArm.field_70121_D);
        this.destroyBlocksInAABB(this.leftArm.field_70121_D);
        if (this.field_70173_aa % 20 == 0 && this.animID != 3 && this.animID != 4 && this.animID != 5 && this.animID != 6 && this.animID != 7 && this.animID != 8 && this.animID != 9 && this.animID != 10) {
            this.isAttacking = false;
        }
        this.meleeTitan = true;
        if (this.getAnimID() == 5) {
            if (this.getAnimTick() > 160) {
                this.animTick = 0;
                this.animID = 0;
                this.isAttacking = false;
            }
            if (this.getAnimTick() <= 50 && this.getAnimTick() >= 20 && this.func_70638_az() != null) {
                float ex = this.func_70631_g_() ? 4.5f : 9.5f;
                float fl = this.field_70761_aq * (float)Math.PI / 180.0f;
                float fl1 = MathHelper.func_76126_a((float)fl);
                float fl2 = MathHelper.func_76134_b((float)fl);
                this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t - (double)(fl2 * ex), this.field_70163_u + (this.func_70631_g_() ? 12.0 : 24.0), this.field_70161_v - (double)(fl1 * ex)));
                this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t + (double)(fl2 * ex), this.field_70163_u + (this.func_70631_g_() ? 12.0 : 24.0), this.field_70161_v + (double)(fl1 * ex)));
            }
            for (int i = 0; i < 3; ++i) {
                if (this.getAnimTick() != 64 || this.func_70638_az() == null || this.field_70170_p.field_72995_K) continue;
                double d8 = this.func_70631_g_() ? 6.0 : 12.0;
                Vec3 vec3 = this.func_70676_i(1.0f);
                double dx = vec3.field_72450_a * d8;
                double dz = vec3.field_72449_c * d8;
                float da = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
                int i1 = this.getKnockbackAmount();
                this.attackChoosenEntity((Entity)this.func_70638_az(), da, i1);
                this.attackChoosenEntity((Entity)this.func_70638_az(), da, i1);
                this.attackChoosenEntity((Entity)this.func_70638_az(), da, i1);
                this.func_70638_az().field_70181_x += (double)(1.0f + this.field_70146_Z.nextFloat());
                this.field_70170_p.func_72885_a((Entity)this, this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v, 2.0f, false, false);
                this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t + dx, this.field_70163_u + 26.0, this.field_70161_v + dz, 1.0f, false, false);
                this.func_70638_az().func_70097_a(DamageSourceExtra.lightningBolt, f);
                this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t + dx, this.field_70163_u + (this.func_70631_g_() ? 9.0 : 18.0), this.field_70161_v + dz));
                this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t + dx, this.field_70163_u + (this.func_70631_g_() ? 9.0 : 18.0), this.field_70161_v + dz));
                this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t + dx, this.field_70163_u + (this.func_70631_g_() ? 9.0 : 18.0), this.field_70161_v + dz));
                this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t + dx, this.field_70163_u + (this.func_70631_g_() ? 9.0 : 18.0), this.field_70161_v + dz));
                this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v));
                List list1 = this.field_70170_p.func_72839_b((Entity)this.func_70638_az(), this.func_70638_az().field_70121_D.func_72314_b(12.0, 12.0, 12.0));
                if (list1 != null && !list1.isEmpty()) {
                    for (int i11 = 0; i11 < list1.size(); ++i11) {
                        Entity entity1 = (Entity)list1.get(i11);
                        if (!(entity1 instanceof EntityLivingBase) || !this.func_70686_a(entity1.getClass())) continue;
                        this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, entity1.field_70165_t, entity1.field_70163_u, entity1.field_70161_v));
                        this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, entity1.field_70165_t, entity1.field_70163_u, entity1.field_70161_v));
                        this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, entity1.field_70165_t, entity1.field_70163_u, entity1.field_70161_v));
                        this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, entity1.field_70165_t, entity1.field_70163_u, entity1.field_70161_v));
                        this.attackChoosenEntity(entity1, da, i1);
                        this.attackChoosenEntity(entity1, da, i1);
                        if (entity1 instanceof EntityTitan) continue;
                        entity1.field_70181_x += (double)(1.0f + this.field_70146_Z.nextFloat());
                    }
                }
                for (int it = 0; it < 40; ++it) {
                    double d5 = this.func_70638_az().field_70165_t + this.field_70146_Z.nextDouble() - this.head.field_70165_t;
                    double d6 = this.func_70638_az().field_70163_u - 32.0 - this.head.field_70163_u;
                    double d7 = this.func_70638_az().field_70161_v + this.field_70146_Z.nextDouble() - this.head.field_70161_v;
                    EntityGhastGuardFireball entitylargefireball = new EntityGhastGuardFireball(this.field_70170_p, (EntityLivingBase)this, d5, d6, d7);
                    Vec3 vec31 = this.func_70676_i(0.25f);
                    entitylargefireball.field_70165_t = this.head.field_70165_t + vec31.field_72450_a + 16.0 + (double)((this.func_70681_au().nextFloat() * 2.0f - 1.0f) * 16.0f);
                    entitylargefireball.field_70163_u = this.head.field_70163_u + 24.0 + (double)((this.func_70681_au().nextFloat() * 2.0f - 1.0f) * 16.0f);
                    entitylargefireball.field_70161_v = this.head.field_70161_v + vec31.field_72449_c + 16.0 + (double)((this.func_70681_au().nextFloat() * 2.0f - 1.0f) * 16.0f);
                    this.field_70170_p.func_72838_d((Entity)entitylargefireball);
                    EntityBlazeTitanFireball entitylargefireball1 = new EntityBlazeTitanFireball(this.field_70170_p, (EntityLivingBase)this, d5, d6, d7);
                    entitylargefireball1.field_70165_t = this.head.field_70165_t + vec31.field_72450_a + 16.0 + (double)((this.func_70681_au().nextFloat() * 2.0f - 1.0f) * 16.0f);
                    entitylargefireball1.field_70163_u = this.head.field_70163_u + 24.0 + (double)((this.func_70681_au().nextFloat() * 2.0f - 1.0f) * 16.0f);
                    entitylargefireball1.field_70161_v = this.head.field_70161_v + vec31.field_72449_c + 16.0 + (double)((this.func_70681_au().nextFloat() * 2.0f - 1.0f) * 16.0f);
                    this.field_70170_p.func_72838_d((Entity)entitylargefireball1);
                    EntitySmallFireball entitysmallfireball = new EntitySmallFireball(this.field_70170_p, (EntityLivingBase)this, d5, d6, d7);
                    entitysmallfireball.field_70165_t = this.head.field_70165_t + vec31.field_72450_a + 16.0 + (double)((this.func_70681_au().nextFloat() * 2.0f - 1.0f) * 16.0f);
                    entitysmallfireball.field_70163_u = this.head.field_70163_u + 24.0 + (double)((this.func_70681_au().nextFloat() * 2.0f - 1.0f) * 16.0f);
                    entitysmallfireball.field_70161_v = this.head.field_70161_v + vec31.field_72449_c + 16.0 + (double)((this.func_70681_au().nextFloat() * 2.0f - 1.0f) * 16.0f);
                    this.field_70170_p.func_72838_d((Entity)entitysmallfireball);
                    EntitySmallFireball entitysmallfireball1 = new EntitySmallFireball(this.field_70170_p, (EntityLivingBase)this, d5, d6, d7);
                    entitysmallfireball1.field_70165_t = this.head.field_70165_t + vec31.field_72450_a + 16.0 + (double)((this.func_70681_au().nextFloat() * 2.0f - 1.0f) * 16.0f);
                    entitysmallfireball1.field_70163_u = this.head.field_70163_u + 24.0 + (double)((this.func_70681_au().nextFloat() * 2.0f - 1.0f) * 16.0f);
                    entitysmallfireball1.field_70161_v = this.head.field_70161_v + vec31.field_72449_c + 16.0 + (double)((this.func_70681_au().nextFloat() * 2.0f - 1.0f) * 16.0f);
                    this.field_70170_p.func_72838_d((Entity)entitysmallfireball1);
                    EntitySmallFireball entitysmallfireball2 = new EntitySmallFireball(this.field_70170_p, (EntityLivingBase)this, d5, d6, d7);
                    entitysmallfireball2.field_70165_t = this.head.field_70165_t + vec31.field_72450_a + 16.0 + (double)((this.func_70681_au().nextFloat() * 2.0f - 1.0f) * 16.0f);
                    entitysmallfireball2.field_70163_u = this.head.field_70163_u + 24.0 + (double)((this.func_70681_au().nextFloat() * 2.0f - 1.0f) * 16.0f);
                    entitysmallfireball2.field_70161_v = this.head.field_70161_v + vec31.field_72449_c + 16.0 + (double)((this.func_70681_au().nextFloat() * 2.0f - 1.0f) * 16.0f);
                    this.field_70170_p.func_72838_d((Entity)entitysmallfireball2);
                }
            }
        }
        if (this.animID == 0 || this.isStunned || this.isAttacking) {
            this.field_70159_w *= 0.0;
            this.field_70179_y *= 0.0;
        }
        if (!AnimationAPI.isEffectiveClient() && this.func_70638_az() != null && !this.isStunned && this.getAnimID() == 0) {
            double d0 = this.func_70068_e((Entity)this.func_70638_az());
            double d = this.field_70130_N * this.field_70130_N + this.func_70638_az().field_70130_N * this.func_70638_az().field_70130_N;
            double d2 = this.func_70631_g_() ? 400.0 : 800.0;
            if (d0 < d + d2) {
                if (this.func_70638_az() instanceof EntityTitan || this.func_70638_az().field_70131_O >= 6.0f || this.func_70638_az().field_70163_u > this.field_70163_u + 6.0) {
                    this.isAttacking = true;
                    switch (this.field_70146_Z.nextInt(2)) {
                        case 0: {
                            AnimationAPI.sendAnimPacket(this, 4);
                            this.setAnimID(4);
                            this.setAnimTick(0);
                            break;
                        }
                        case 1: {
                            AnimationAPI.sendAnimPacket(this, 2);
                            this.setAnimID(2);
                            this.setAnimTick(0);
                        }
                    }
                } else {
                    this.isAttacking = true;
                    switch (this.field_70146_Z.nextInt(6)) {
                        case 0: {
                            AnimationAPI.sendAnimPacket(this, 6);
                            this.setAnimID(6);
                            this.setAnimTick(0);
                            break;
                        }
                        case 1: {
                            AnimationAPI.sendAnimPacket(this, 3);
                            this.setAnimID(3);
                            this.setAnimTick(0);
                            break;
                        }
                        case 2: {
                            AnimationAPI.sendAnimPacket(this, 3);
                            this.setAnimID(3);
                            this.setAnimTick(0);
                            break;
                        }
                        case 3: {
                            AnimationAPI.sendAnimPacket(this, 9);
                            this.setAnimID(9);
                            this.setAnimTick(0);
                            break;
                        }
                        case 4: {
                            AnimationAPI.sendAnimPacket(this, 7);
                            this.setAnimID(7);
                            this.setAnimTick(0);
                            break;
                        }
                        case 5: {
                            AnimationAPI.sendAnimPacket(this, 1);
                            this.setAnimID(1);
                            this.setAnimTick(0);
                        }
                    }
                }
            } else if (this.getAnimID() == 0 && this.func_70681_au().nextInt(100) == 0) {
                this.isAttacking = true;
                AnimationAPI.sendAnimPacket(this, 5);
                this.setAnimID(5);
                this.setAnimTick(0);
            }
        }
        if (this.field_70146_Z.nextInt(40) == 0 && this.func_70638_az() != null) {
            this.func_85030_a("mob.zombiepig.zpigangry", 10000.0f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) * 0.75f);
        }
        if (this.func_70631_g_()) {
            this.func_94058_c(StatCollector.func_74838_a((String)"entity.PigZombieTitan.name.baby"));
        } else {
            this.func_94058_c(StatCollector.func_74838_a((String)"entity.PigZombieTitan.name"));
        }
        if (TheTitans.NightmareMode) {
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1800.0);
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40000.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(600.0);
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20000.0);
        }
        if (this.field_70146_Z.nextInt(this.getMinionSpawnRate()) == 0 && this.func_110143_aJ() > 0.0f && !this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL) {
            if (this.numSpecialMinions < this.getSpecialMinionCap() && this.field_70146_Z.nextInt(100) == 0) {
                EntityGhastGuard entitychicken = new EntityGhastGuard(this.field_70170_p);
                this.teleportEntityRandomly((EntityLivingBase)entitychicken);
                entitychicken.master = this;
                entitychicken.func_110161_a(null);
                this.field_70170_p.func_72838_d((Entity)entitychicken);
                entitychicken.func_70024_g(0.0, 1.5, 0.0);
                entitychicken.func_85030_a("thetitans:titansummonminion", 10.0f, 0.5f);
                ++this.numSpecialMinions;
            } else if (this.numMinions < this.getMinionCap()) {
                EntityPigZombieLoyalist entitychicken = new EntityPigZombieLoyalist(this.field_70170_p);
                this.teleportEntityRandomly((EntityLivingBase)entitychicken);
                entitychicken.master = this;
                entitychicken.func_110161_a(null);
                entitychicken.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 40, 4, false));
                entitychicken.func_70024_g(0.0, 0.8, 0.0);
                this.field_70170_p.func_72838_d((Entity)entitychicken);
                entitychicken.func_85030_a("thetitans:titansummonminion", 2.0f, 1.0f);
                entitychicken.func_70690_d(new PotionEffect(Potion.field_76426_n.field_76415_H, Integer.MAX_VALUE, 0, false));
                if (this.func_70631_g_()) {
                    entitychicken.func_82227_f(true);
                }
                ++this.numMinions;
                Block block = this.field_70170_p.func_147439_a((int)entitychicken.field_70165_t, (int)entitychicken.field_70163_u, (int)entitychicken.field_70161_v);
                this.field_70170_p.func_72926_e(2001, (int)entitychicken.field_70165_t, (int)entitychicken.field_70163_u, (int)entitychicken.field_70161_v, Block.func_149682_b((Block)block));
                if (block == Blocks.field_150349_c) {
                    this.field_70170_p.func_147449_b((int)entitychicken.field_70165_t, (int)entitychicken.field_70163_u, (int)entitychicken.field_70161_v, Blocks.field_150346_d);
                }
            }
        }
        if (this.field_70146_Z.nextInt(this.getMinionSpawnRate() * 2) == 0 && this.func_110143_aJ() > 0.0f && !this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL) {
            if (this.numSpecialMinions < this.getSpecialMinionCap() && this.field_70146_Z.nextInt(100) == 0) {
                EntityGhastGuard entitychicken = new EntityGhastGuard(this.field_70170_p);
                this.teleportEntityRandomly((EntityLivingBase)entitychicken);
                entitychicken.master = this;
                entitychicken.func_110161_a(null);
                this.field_70170_p.func_72838_d((Entity)entitychicken);
                entitychicken.func_70024_g(0.0, 1.5, 0.0);
                entitychicken.func_85030_a("thetitans:titansummonminion", 10.0f, 0.5f);
                ++this.numSpecialMinions;
            } else if (this.numPriests < this.getPriestCap()) {
                EntityPigZombiePriest entitychicken = new EntityPigZombiePriest(this.field_70170_p);
                this.teleportEntityRandomly((EntityLivingBase)entitychicken);
                entitychicken.master = this;
                entitychicken.func_110161_a(null);
                entitychicken.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 40, 4, false));
                entitychicken.func_70024_g(0.0, 0.8, 0.0);
                this.field_70170_p.func_72838_d((Entity)entitychicken);
                entitychicken.func_85030_a("thetitans:titansummonminion", 2.0f, 1.0f);
                entitychicken.func_70690_d(new PotionEffect(Potion.field_76426_n.field_76415_H, Integer.MAX_VALUE, 0, false));
                if (this.func_70631_g_()) {
                    entitychicken.func_82227_f(true);
                }
                ++this.numPriests;
                Block block = this.field_70170_p.func_147439_a((int)entitychicken.field_70165_t, (int)entitychicken.field_70163_u, (int)entitychicken.field_70161_v);
                this.field_70170_p.func_72926_e(2001, (int)entitychicken.field_70165_t, (int)entitychicken.field_70163_u, (int)entitychicken.field_70161_v, Block.func_149682_b((Block)block));
                if (block == Blocks.field_150349_c) {
                    this.field_70170_p.func_147449_b((int)entitychicken.field_70165_t, (int)entitychicken.field_70163_u, (int)entitychicken.field_70161_v, Blocks.field_150346_d);
                }
            }
        }
        if (this.field_70146_Z.nextInt(this.getMinionSpawnRate() * 5) == 0 && this.func_110143_aJ() > 0.0f && !this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL) {
            if (this.numSpecialMinions < this.getSpecialMinionCap() && this.field_70146_Z.nextInt(100) == 0) {
                EntityGhastGuard entitychicken = new EntityGhastGuard(this.field_70170_p);
                this.teleportEntityRandomly((EntityLivingBase)entitychicken);
                entitychicken.master = this;
                entitychicken.func_110161_a(null);
                this.field_70170_p.func_72838_d((Entity)entitychicken);
                entitychicken.func_70024_g(0.0, 1.5, 0.0);
                entitychicken.func_85030_a("thetitans:titansummonminion", 10.0f, 0.5f);
                ++this.numSpecialMinions;
            } else if (this.numZealots < this.getZealotCap()) {
                EntityPigZombieZealot entitychicken = new EntityPigZombieZealot(this.field_70170_p);
                this.teleportEntityRandomly((EntityLivingBase)entitychicken);
                entitychicken.master = this;
                entitychicken.func_110161_a(null);
                entitychicken.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 40, 4, false));
                entitychicken.func_70024_g(0.0, 0.8, 0.0);
                this.field_70170_p.func_72838_d((Entity)entitychicken);
                entitychicken.func_85030_a("thetitans:titansummonminion", 2.0f, 1.0f);
                entitychicken.func_70690_d(new PotionEffect(Potion.field_76426_n.field_76415_H, Integer.MAX_VALUE, 0, false));
                if (this.func_70631_g_()) {
                    entitychicken.func_82227_f(true);
                }
                ++this.numZealots;
                Block block = this.field_70170_p.func_147439_a((int)entitychicken.field_70165_t, (int)entitychicken.field_70163_u, (int)entitychicken.field_70161_v);
                this.field_70170_p.func_72926_e(2001, (int)entitychicken.field_70165_t, (int)entitychicken.field_70163_u, (int)entitychicken.field_70161_v, Block.func_149682_b((Block)block));
                if (block == Blocks.field_150349_c) {
                    this.field_70170_p.func_147449_b((int)entitychicken.field_70165_t, (int)entitychicken.field_70163_u, (int)entitychicken.field_70161_v, Blocks.field_150346_d);
                }
            }
        }
        if (this.field_70146_Z.nextInt(this.getMinionSpawnRate() * 10) == 0 && this.func_110143_aJ() > 0.0f && !this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL) {
            if (this.numSpecialMinions < this.getSpecialMinionCap() && this.field_70146_Z.nextInt(100) == 0) {
                EntityGhastGuard entitychicken = new EntityGhastGuard(this.field_70170_p);
                this.teleportEntityRandomly((EntityLivingBase)entitychicken);
                entitychicken.master = this;
                entitychicken.func_110161_a(null);
                this.field_70170_p.func_72838_d((Entity)entitychicken);
                entitychicken.func_70024_g(0.0, 1.5, 0.0);
                entitychicken.func_85030_a("thetitans:titansummonminion", 10.0f, 0.5f);
                ++this.numSpecialMinions;
            } else if (this.numTemplar < this.getTemplarCap()) {
                EntityPigZombieTemplar entitychicken = new EntityPigZombieTemplar(this.field_70170_p);
                this.teleportEntityRandomly((EntityLivingBase)entitychicken);
                entitychicken.master = this;
                entitychicken.func_110161_a(null);
                entitychicken.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 40, 4, false));
                entitychicken.func_70024_g(0.0, 0.8, 0.0);
                this.field_70170_p.func_72838_d((Entity)entitychicken);
                entitychicken.func_85030_a("thetitans:titansummonminion", 2.0f, 1.0f);
                entitychicken.func_70690_d(new PotionEffect(Potion.field_76426_n.field_76415_H, Integer.MAX_VALUE, 0, false));
                if (this.func_70631_g_()) {
                    entitychicken.func_82227_f(true);
                }
                ++this.numTemplar;
                Block block = this.field_70170_p.func_147439_a((int)entitychicken.field_70165_t, (int)entitychicken.field_70163_u, (int)entitychicken.field_70161_v);
                this.field_70170_p.func_72926_e(2001, (int)entitychicken.field_70165_t, (int)entitychicken.field_70163_u, (int)entitychicken.field_70161_v, Block.func_149682_b((Block)block));
                if (block == Blocks.field_150349_c) {
                    this.field_70170_p.func_147449_b((int)entitychicken.field_70165_t, (int)entitychicken.field_70163_u, (int)entitychicken.field_70161_v, Blocks.field_150346_d);
                }
            }
        }
    }

    public void func_82206_m() {
        this.setInvulTime(860);
        this.setTitanHealth(this.func_110138_aP() / 10.0f);
    }

    @Override
    public boolean func_70601_bi() {
        return this.field_70146_Z.nextInt(100) == 0 && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL;
    }

    @Override
    public int getMinionSpawnRate() {
        return TheTitans.PigZombieTitanMinionSpawnrate;
    }

    @Override
    public int getRegenTime() {
        return 5;
    }

    @Override
    public boolean shouldMove() {
        return this.animID == 0 && !this.isStunned && this.func_70638_az() != null ? super.shouldMove() : false;
    }

    @Override
    public boolean func_70652_k(Entity p_70652_1_) {
        return false;
    }

    @Override
    public boolean canBeHurtByPlayer() {
        return this.isStunned && !this.func_85032_ar();
    }

    @Override
    public String getParticles() {
        if ((double)this.field_70170_p.field_73012_v.nextFloat() < 0.25) {
            return "explode";
        }
        return "smoke";
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(150.0);
    }

    @Override
    protected boolean isValidLightLevel() {
        return true;
    }

    protected void func_70069_a(float p_70069_1_) {
        if ((p_70069_1_ = ForgeHooks.onLivingFall((EntityLivingBase)this, (float)p_70069_1_)) <= 0.0f) {
            return;
        }
        PotionEffect potioneffect = this.func_70660_b(Potion.field_76430_j);
        float f1 = potioneffect != null ? (float)(potioneffect.func_76458_c() + 1) : 0.0f;
        int i = MathHelper.func_76123_f((float)(p_70069_1_ - 12.0f - f1));
        if (i > 0) {
            int l;
            int k;
            int j;
            Block block;
            this.func_85030_a("thetitans:groundSmash", 20.0f, 1.0f);
            this.func_85030_a("thetitans:titanland", 10000.0f, 1.0f);
            if (!this.field_70170_p.field_72995_K) {
                EntityGhastGuard entitychicken = new EntityGhastGuard(this.field_70170_p);
                entitychicken.master = this;
                entitychicken.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
                entitychicken.func_110161_a(null);
                this.field_70170_p.func_72838_d((Entity)entitychicken);
                entitychicken.func_70024_g(0.0, 3.0, 0.0);
                entitychicken.func_85030_a("thetitans:titansummonminion", 10.0f, 0.5f);
                entitychicken.waypointX = this.field_70165_t;
                entitychicken.waypointY = this.field_70163_u + 40.0;
                entitychicken.waypointZ = this.field_70161_v;
            }
            this.destroyBlocksInAABB(this.field_70121_D.func_72314_b(16.0, 2.0, 16.0));
            List list11 = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(48.0, 2.0, 48.0));
            if (list11 != null && !list11.isEmpty()) {
                for (int i1 = 0; i1 < list11.size(); ++i1) {
                    Entity entity = (Entity)list11.get(i1);
                    if (!(entity instanceof EntityLivingBase) || !this.func_70686_a(entity.getClass()) || entity instanceof EntityTitan) continue;
                    float smash = 50.0f - this.func_70032_d(entity);
                    if (smash <= 1.0f) {
                        smash = 1.0f;
                    }
                    entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), smash);
                    double d0 = this.field_70121_D.field_72340_a + this.field_70121_D.field_72336_d;
                    double d1 = this.field_70121_D.field_72339_c + this.field_70121_D.field_72334_f;
                    double d2 = entity.field_70165_t - d0;
                    double d3 = entity.field_70161_v - d1;
                    double d4 = d2 * d2 + d3 * d3;
                    entity.func_70024_g(d2 / d4 * 8.0, 1.0, d3 / d4 * 8.0);
                }
            }
            if ((block = this.field_70170_p.func_147439_a(j = MathHelper.func_76128_c((double)this.field_70165_t), k = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f - (double)this.field_70129_M)), l = MathHelper.func_76128_c((double)this.field_70161_v))).func_149688_o() != Material.field_151579_a) {
                Block.SoundType soundtype = block.field_149762_H;
                this.func_85030_a(soundtype.func_150498_e(), soundtype.func_150497_c() * 0.5f, soundtype.func_150494_d() * 0.75f);
            }
        }
    }

    public float func_70047_e() {
        float f = 27.6f;
        if (this.func_70631_g_()) {
            f = 14.8f;
        }
        return f;
    }

    protected String func_70639_aQ() {
        return this.isStunned ? null : "thetitans:titanPigZombieLiving";
    }

    @Override
    protected String func_70621_aR() {
        return "thetitans:titanPigZombieGrunt";
    }

    @Override
    protected String func_70673_aS() {
        return "thetitans:titanPigZombieDeath";
    }

    protected void func_145780_a(int p_145780_1_, int p_145780_2_, int p_145780_3_, Block p_145780_4_) {
        this.func_85030_a("thetitans:titanStep", 10.0f, 1.0f);
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        if (this.deathTicks > 0) {
            EntityItem entityitem;
            int l;
            for (l = 0; l < 16; ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151055_y));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 32; ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151043_k));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 128 + this.field_70146_Z.nextInt(128 + p_70628_2_) + p_70628_2_; ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151078_bh));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 128 + this.field_70146_Z.nextInt(128 + p_70628_2_) + p_70628_2_; ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151074_bl));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 32 + this.field_70146_Z.nextInt(32 + p_70628_2_) + p_70628_2_; ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151103_aS));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 32 + this.field_70146_Z.nextInt(32 + p_70628_2_) + p_70628_2_; ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151044_h));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 32 + this.field_70146_Z.nextInt(32 + p_70628_2_) + p_70628_2_; ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151043_k));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 12 + this.field_70146_Z.nextInt(12 + p_70628_2_); ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151166_bC));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 12 + this.field_70146_Z.nextInt(12 + p_70628_2_); ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151045_i));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 0 + this.field_70146_Z.nextInt(8 + p_70628_2_); ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(TitanItems.harcadium));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            if (this.field_70146_Z.nextInt(5) == 0) {
                EntityItem entityitem2 = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Blocks.field_150357_h));
                entityitem2.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem2);
            }
            if (this.field_70146_Z.nextInt(5) == 0) {
                EntityItem entityitem3 = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Blocks.field_150357_h));
                entityitem3.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem3);
            }
        }
    }

    @Override
    public StatBase getAchievement() {
        return TitansAchievments.pigzombietitan;
    }

    public double func_70033_W() {
        return super.func_70033_W() - 8.0;
    }

    protected void func_70600_l(int p_70600_1_) {
        this.func_70099_a(new ItemStack(Blocks.field_150340_R, 64, 1), 0.0f);
    }

    protected void func_82164_bB() {
        super.func_82164_bB();
        this.func_70062_b(0, new ItemStack(Items.field_151010_B));
        for (int i = 0; i < 2; ++i) {
            EntityGhastGuard entitychicken = new EntityGhastGuard(this.field_70170_p);
            entitychicken.master = this;
            entitychicken.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
            entitychicken.func_110161_a(null);
            this.field_70170_p.func_72838_d((Entity)entitychicken);
            entitychicken.func_70024_g(0.0, 1.5, 0.0);
            entitychicken.func_85030_a("thetitans:titansummonminion", 10.0f, 0.5f);
        }
    }

    public void collideWithEntities(EntityDragonPart part, List p_70970_1_) {
        double d0 = (part.field_70121_D.field_72340_a + part.field_70121_D.field_72336_d) / 2.0;
        double d1 = (part.field_70121_D.field_72339_c + part.field_70121_D.field_72334_f) / 2.0;
        for (Entity entity : p_70970_1_) {
            if (entity == null || !(entity instanceof EntityLivingBase) || entity instanceof EntityTitan || entity instanceof EntityTitanSpirit || !this.func_70686_a(entity.getClass()) || !entity.func_70067_L()) continue;
            double d2 = entity.field_70165_t - d0;
            double d3 = entity.field_70161_v - d1;
            double d4 = d2 * d2 + d3 * d3;
            entity.func_70024_g(d2 / d4 * 0.75, 0.25, d3 / d4 * 0.75);
            entity.func_70097_a(DamageSource.func_92087_a((Entity)this), 10.0f);
        }
    }

    public boolean attackZombieFrom(DamageSource source, float amount) {
        if (source.func_76346_g() instanceof EntityPlayer && !this.field_70170_p.field_72995_K) {
            this.func_70624_b((EntityLivingBase)source.func_76346_g());
            this.func_70604_c((EntityLivingBase)source.func_76346_g());
        }
        if (this.func_85032_ar()) {
            return false;
        }
        if (!this.isStunned && source.func_76346_g() instanceof EntityPlayer) {
            return false;
        }
        if (source.func_76346_g() instanceof EntityPigZombieLoyalist || source.func_76346_g() instanceof EntityPigZombieTitan || source.func_76346_g() instanceof EntityGhastGuard) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (entity instanceof EntityLivingBase && !this.func_85032_ar() && amount > 25.0f) {
            List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(256.0, 256.0, 256.0));
            for (int i = 0; i < list.size(); ++i) {
                Entity entity1 = (Entity)list.get(i);
                if (entity1 instanceof EntityPigZombieTitan) {
                    EntityPigZombieTitan entitypigzombie = (EntityPigZombieTitan)entity1;
                    entitypigzombie.func_70624_b((EntityLivingBase)entity);
                    entitypigzombie.func_70604_c((EntityLivingBase)entity);
                }
                this.func_70624_b((EntityLivingBase)entity);
                this.func_70604_c((EntityLivingBase)entity);
            }
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        return this.attackZombieFrom(source, amount);
    }

    public boolean func_70067_L() {
        return false;
    }

    public Entity[] func_70021_al() {
        return this.partArray;
    }

    public boolean func_70965_a(EntityDragonPart p_70965_1_, DamageSource source, float amount) {
        if (p_70965_1_ != this.head) {
            amount /= 3.0f;
        }
        this.func_82195_e(source, amount);
        return true;
    }

    protected boolean func_82195_e(DamageSource p_82195_1_, float p_82195_2_) {
        return this.attackZombieFrom(p_82195_1_, p_82195_2_);
    }

    public World func_82194_d() {
        return this.field_70170_p;
    }

    @Override
    public IEntityLivingData func_110161_a(IEntityLivingData p_180482_2_) {
        Calendar calendar;
        IEntityLivingData p_180482_2_1 = super.func_110161_a(p_180482_2_);
        this.func_98053_h(true);
        if (this.field_70170_p.field_73012_v.nextFloat() < 0.05f) {
            this.setChild(true);
        }
        this.func_82164_bB();
        this.func_82162_bC();
        if (this.func_71124_b(4) == null && (calendar = this.field_70170_p.func_83015_S()).get(2) + 1 == 10 && calendar.get(5) == 31 && this.field_70146_Z.nextFloat() < 0.25f) {
            this.func_70062_b(4, new ItemStack(this.field_70146_Z.nextFloat() < 0.1f ? Blocks.field_150428_aP : Blocks.field_150423_aK));
            this.field_82174_bp[4] = 0.0f;
        }
        return p_180482_2_1;
    }

    @Override
    public void setAnimID(int id) {
        this.animID = id;
    }

    @Override
    public void setAnimTick(int tick) {
        this.animTick = tick;
    }

    @Override
    public int getAnimID() {
        return this.animID;
    }

    @Override
    public int getAnimTick() {
        return this.animTick;
    }

    @Override
    protected void inactDeathAction() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
                this.func_70628_a(true, 0);
                this.func_82160_b(true, 0);
                this.func_70600_l(1);
            }
            EntityTitanSpirit entitytitan = new EntityTitanSpirit(this.field_70170_p);
            entitytitan.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
            this.field_70170_p.func_72838_d((Entity)entitytitan);
            entitytitan.setVesselHunting(false);
            entitytitan.setSpiritType(8);
        }
    }

    @Override
    protected void onTitanDeathUpdate() {
        this.field_70180_af.func_75692_b(6, (Object)Float.valueOf(MathHelper.func_76131_a((float)this.field_70180_af.func_111145_d(5), (float)0.0f, (float)this.func_110138_aP())));
        if (this.field_70180_af.func_111145_d(5) <= 0.0f) {
            ++this.deathTicks;
            AnimationAPI.sendAnimPacket(this, 10);
            this.setAnimID(10);
            this.setTitanHealth(0.0f);
        } else {
            this.func_70097_a(DamageSource.field_76380_i, 25.0f);
            this.setTitanHealth(this.field_70180_af.func_111145_d(5));
            this.func_70606_j(this.field_70180_af.func_111145_d(5));
            this.deathTicks = 0;
            if (this.animID == 10) {
                this.animID = 0;
            }
        }
        this.field_70159_w *= 0.0;
        this.field_70179_y *= 0.0;
        this.func_70624_b(null);
        if (this.deathTicks == 1 && !this.field_70170_p.field_72995_K) {
            this.func_85030_a(this.func_70673_aS(), this.func_70599_aP(), this.func_70647_i());
            ArrayList listp = Lists.newArrayList((Iterable)this.field_70170_p.field_73010_i);
            if (listp != null && !listp.isEmpty()) {
                for (int i1 = 0; i1 < listp.size(); ++i1) {
                    Entity entity = (Entity)listp.get(i1);
                    if (entity == null || !(entity instanceof EntityPlayer)) continue;
                    ((EntityPlayer)entity).func_71029_a(this.getAchievement());
                }
            }
        }
        if (this.deathTicks == 1) {
            this.setAnimTick(1);
        }
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot") && this.deathTicks >= 500 && this.deathTicks % 10 == 0) {
            int j;
            for (int i = this.func_70693_a(this.field_70717_bb) / 10; i > 0; i -= j) {
                j = EntityXPOrb.func_70527_a((int)i);
                this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u + 64.0, this.field_70161_v, j));
            }
        }
        if (this.deathTicks >= 500) {
            this.setInvulTime(this.getInvulTime() + 8);
            --this.animTick;
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 12.0f;
            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 3.0f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 12.0f;
            this.field_70170_p.func_72869_a("hugeexplosion", this.field_70165_t + (double)f, this.field_70163_u + 2.0 + (double)f1, this.field_70161_v + (double)f2, 0.0, 0.0, 0.0);
        }
        if (this.getInvulTime() >= this.getThreashHold()) {
            this.func_70106_y();
        }
    }
}

