/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.titan;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityLargeFireball;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.entity.titan.EntityGhastTitanFireball;
import net.minecraft.entity.titan.EntityIronGolemTitan;
import net.minecraft.entity.titan.EntitySnowGolemTitan;
import net.minecraft.entity.titan.EntityTitan;
import net.minecraft.entity.titan.EntityTitanSpirit;
import net.minecraft.entity.titan.EnumTitanStatus;
import net.minecraft.entity.titan.ITitan;
import net.minecraft.entity.titan.ai.EntityAINearestTargetTitan;
import net.minecraft.entity.titanminion.EntityGhastLoyalist;
import net.minecraft.entity.titanminion.EntityGhastPriest;
import net.minecraft.entity.titanminion.EntityGhastTemplar;
import net.minecraft.entity.titanminion.EntityGhastZealot;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.theTitans.TheTitans;
import net.minecraft.theTitans.TitanItems;
import net.minecraft.theTitans.TitansAchievments;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityGhastTitan
extends EntityTitan {
    public int courseChangeCooldown;
    public double waypointX;
    public double waypointY;
    public double waypointZ;
    private int aggroCooldown;
    public int prevAttackCounter;
    public int attackCounter;
    private int explosionStrength = 5;

    public EntityGhastTitan(World worldIn) {
        super(worldIn);
        this.shouldParticlesBeUpward = true;
        this.setTitanHealth(this.func_110138_aP());
        this.field_70178_ae = true;
        this.field_70145_X = true;
        this.func_70105_a(16.0f, 16.0f);
        this.field_70728_aV = 750000;
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan(this, EntityIronGolemTitan.class, 0, false));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan(this, EntitySnowGolemTitan.class, 0, false));
    }

    @Override
    protected void applyEntityAI() {
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        if (TheTitans.TitansFFAMode) {
            this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan(this, EntityLivingBase.class, 0, false, false, ITitan.GhastTitanSorter));
        } else {
            this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan(this, EntityLivingBase.class, 0, false, false, ITitan.SearchForAThingToKill));
        }
    }

    public float func_70047_e() {
        return 60.0f;
    }

    @Override
    public int getMinionCap() {
        return 120;
    }

    @Override
    public int getPriestCap() {
        return 60;
    }

    @Override
    public int getZealotCap() {
        return 20;
    }

    @Override
    public int getTemplarCap() {
        return 8;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_110182_bF() {
        return this.field_70180_af.func_75683_a(16) != 0;
    }

    public boolean func_70686_a(Class p_70686_1_) {
        return p_70686_1_ != EntityGhastLoyalist.class && p_70686_1_ != EntityGhastTitan.class;
    }

    @Override
    public boolean func_70601_bi() {
        return this.field_70146_Z.nextInt(250) == 0 && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL && super.func_70601_bi();
    }

    @Override
    public int getMinionSpawnRate() {
        return TheTitans.GhastTitanMinionSpawnrate;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(900.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)new Byte(0));
    }

    @Override
    public int getParticleCount() {
        return 32;
    }

    @Override
    public String getParticles() {
        if (this.func_70026_G()) {
            return "";
        }
        return "largesmoke";
    }

    @Override
    public int getRegenTime() {
        return 5;
    }

    @Override
    public EnumTitanStatus getTitanStatus() {
        return EnumTitanStatus.GREATER;
    }

    public void func_82206_m() {
        this.setInvulTime(860);
        this.setTitanHealth(this.func_110138_aP() / 10.0f);
    }

    protected String func_70639_aQ() {
        return "thetitans:titanGhastLiving";
    }

    @Override
    protected String func_70621_aR() {
        return "thetitans:titanGhastGrunt";
    }

    @Override
    protected String func_70673_aS() {
        return "thetitans:titanGhastDeath";
    }

    protected void func_145780_a(int p_145780_1_, int p_145780_2_, int p_145780_3_, Block p_145780_4_) {
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float p_70070_1_) {
        return 0xF000F0;
    }

    public float func_70013_c(float p_70013_1_) {
        return 1.0f;
    }

    @Override
    public double getSpeed() {
        return 20.0;
    }

    protected void func_70069_a(float p_70069_1_) {
    }

    protected void func_70064_a(double p_70064_1_, boolean p_70064_3_) {
    }

    public void func_70612_e(float p_70612_1_, float p_70612_2_) {
        if (this.func_70090_H()) {
            this.func_70060_a(p_70612_1_, p_70612_2_, 0.02f);
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)0.8f;
            this.field_70181_x *= (double)0.8f;
            this.field_70179_y *= (double)0.8f;
        } else if (this.func_70058_J()) {
            this.func_70060_a(p_70612_1_, p_70612_2_, 0.02f);
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= 0.5;
            this.field_70181_x *= 0.5;
            this.field_70179_y *= 0.5;
        } else {
            float f2 = 0.91f;
            if (this.field_70122_E) {
                f2 = this.field_70170_p.func_147439_a((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v)).field_149765_K * 0.91f;
            }
            float f3 = 0.16277136f / (f2 * f2 * f2);
            this.func_70060_a(p_70612_1_, p_70612_2_, this.field_70122_E ? 0.1f * f3 : 0.02f);
            f2 = 0.91f;
            if (this.field_70122_E) {
                f2 = this.field_70170_p.func_147439_a((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v)).field_149765_K * 0.91f;
            }
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)f2;
            this.field_70181_x *= (double)f2;
            this.field_70179_y *= (double)f2;
        }
        this.field_70722_aY = this.field_70721_aZ;
        double d1 = this.field_70165_t - this.field_70169_q;
        double d0 = this.field_70161_v - this.field_70166_s;
        float f4 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
        if (f4 > 1.0f) {
            f4 = 1.0f;
        }
        this.field_70721_aZ += (f4 - this.field_70721_aZ) * 0.4f;
        this.field_70754_ba += this.field_70721_aZ;
    }

    public boolean func_70617_f_() {
        return false;
    }

    @Override
    public void func_70636_d() {
        for (int i = 0; i < 90; ++i) {
            double d0 = this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 90.0f - 45.0f);
            double d1 = this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * 30.0f);
            double d2 = this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 90.0f - 45.0f);
            if (this.field_70170_p.field_72995_K || this.field_70170_p.func_147439_a((int)d0, (int)d1 + (int)this.func_70047_e(), (int)d2).func_149688_o() == Material.field_151579_a) continue;
            this.func_70107_b(this.field_70165_t, this.field_70163_u + 0.1, this.field_70161_v);
        }
        EntityPlayer entity = this.field_70170_p.func_72890_a((Entity)this, -1.0);
        if (entity instanceof EntityPlayer && entity != null && entity == this.func_70638_az() && this.func_70638_az() != null) {
            entity.func_70015_d(50);
            if (entity.func_110139_bj() <= 0.0f && this.field_70173_aa % 10 == 0) {
                entity.func_70097_a(DamageSource.field_76370_b.func_151518_m().func_76359_i(), 5.0f);
            } else if (entity.func_110139_bj() >= 0.0f && this.field_70173_aa % 20 == 0) {
                entity.func_70097_a(DamageSource.field_76370_b.func_151518_m().func_76359_i(), 5.0f);
            }
        }
        if (this.field_70170_p.field_72995_K && this.deathTicks < this.getThreashHold()) {
            int i;
            for (i = 0; i < this.getParticleCount(); ++i) {
                if (this.shouldParticlesBeUpward) {
                    this.field_70170_p.func_72869_a(this.getParticles(), this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u - 16.0 + this.field_70146_Z.nextDouble() * 16.0, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0);
                    continue;
                }
                this.field_70170_p.func_72869_a(this.getParticles(), this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u - 16.0 + this.field_70146_Z.nextDouble() * 16.0, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
            }
            if (TheTitans.NightmareMode && this.field_70146_Z.nextInt(20) == 0) {
                for (i = 0; i < 2; ++i) {
                    this.field_70170_p.func_72869_a("flame", this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u - 16.0 + this.field_70146_Z.nextDouble() * 16.0, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0);
                }
            }
        }
        if (TheTitans.NightmareMode) {
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(7200.0);
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(400000.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2400.0);
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(200000.0);
        }
        this.func_94058_c(StatCollector.func_74838_a((String)"entity.GhastTitan.name"));
        if (this.numMinions < this.getMinionCap() && this.field_70146_Z.nextInt(this.getMinionSpawnRate()) == 0 && this.func_110143_aJ() > 0.0f && !this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL) {
            EntityGhastLoyalist entitychicken = new EntityGhastLoyalist(this.field_70170_p);
            entitychicken.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
            this.teleportEntityRandomly((EntityLivingBase)entitychicken);
            this.field_70170_p.func_72838_d((Entity)entitychicken);
            ++this.numMinions;
        }
        if (this.numPriests < this.getPriestCap() && this.field_70146_Z.nextInt(this.getMinionSpawnRate() * 2) == 0 && this.func_110143_aJ() > 0.0f && !this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL) {
            EntityGhastPriest entitychicken = new EntityGhastPriest(this.field_70170_p);
            entitychicken.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
            this.teleportEntityRandomly((EntityLivingBase)entitychicken);
            this.field_70170_p.func_72838_d((Entity)entitychicken);
            ++this.numPriests;
        }
        if (this.numZealots < this.getZealotCap() && this.field_70146_Z.nextInt(this.getMinionSpawnRate() * 5) == 0 && this.func_110143_aJ() > 0.0f && !this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL) {
            EntityGhastZealot entitychicken = new EntityGhastZealot(this.field_70170_p);
            entitychicken.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
            this.teleportEntityRandomly((EntityLivingBase)entitychicken);
            this.field_70170_p.func_72838_d((Entity)entitychicken);
            ++this.numZealots;
        }
        if (this.numTemplar < this.getTemplarCap() && this.field_70146_Z.nextInt(this.getMinionSpawnRate() * 10) == 0 && this.func_110143_aJ() > 0.0f && !this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL) {
            EntityGhastTemplar entitychicken = new EntityGhastTemplar(this.field_70170_p);
            entitychicken.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
            this.teleportEntityRandomly((EntityLivingBase)entitychicken);
            this.field_70170_p.func_72838_d((Entity)entitychicken);
            ++this.numTemplar;
        }
        super.func_70636_d();
    }

    @Override
    protected void func_70619_bc() {
        byte b0;
        byte b1;
        this.explosionStrength = 5;
        if (this.func_70638_az() != null && !this.func_70685_l((Entity)this.func_70638_az()) && this.field_70146_Z.nextInt(150) == 0) {
            this.func_70624_b(null);
        }
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
        if (this.waypointY < 128.0) {
            this.waypointY = 128.0;
        }
        this.prevAttackCounter = this.attackCounter;
        double d0 = this.waypointX - this.field_70165_t;
        double d1 = this.waypointY - this.field_70163_u;
        double d2 = this.waypointZ - this.field_70161_v;
        double d3 = d0 * d0 + d1 * d1 + d2 * d2;
        if (d3 < 1.0 || d3 > 40000.0) {
            if (this.func_70638_az() != null) {
                double x = this.func_70638_az().field_70165_t;
                double y = this.func_70638_az().field_70163_u + 64.0;
                double z = this.func_70638_az().field_70161_v;
                this.waypointX = x + (d0 += (double)(this.field_70146_Z.nextFloat() * 64.0f - 32.0f));
                this.waypointY = y + (d1 += (double)(this.field_70146_Z.nextFloat() * 64.0f - 32.0f));
                this.waypointZ = z + (d2 += (double)(this.field_70146_Z.nextFloat() * 64.0f - 32.0f));
            } else {
                this.waypointX = this.field_70165_t + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 64.0f);
                this.waypointY = this.field_70163_u + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 64.0f);
                this.waypointZ = this.field_70161_v + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 64.0f);
            }
        }
        if (this.courseChangeCooldown-- <= 0) {
            this.courseChangeCooldown += this.field_70146_Z.nextInt(5) + 2;
            d3 = MathHelper.func_76133_a((double)d3);
            this.field_70159_w += d0 / d3 * 0.1;
            this.field_70181_x += d1 / d3 * 0.1;
            this.field_70179_y += d2 / d3 * 0.1;
        }
        double d4 = 1024.0;
        if (this.func_70638_az() != null && this.func_70638_az().func_70068_e((Entity)this) < d4 * d4) {
            this.func_70671_ap().func_75651_a((Entity)this.func_70638_az(), 180.0f, 180.0f);
            double d11 = this.func_70638_az().field_70165_t - this.field_70165_t;
            double d21 = this.func_70638_az().field_70163_u - (this.field_70163_u + 16.0);
            double d31 = this.func_70638_az().field_70161_v - this.field_70161_v;
            if (this.func_70685_l((Entity)this.func_70638_az())) {
                if (this.attackCounter == 10) {
                    this.func_85030_a("thetitans:titanGhastCharge", Float.MAX_VALUE, this.func_70647_i());
                }
                ++this.attackCounter;
                if (this.attackCounter == 50) {
                    if (this.func_70638_az().field_70131_O >= 6.0f || this.func_70068_e((Entity)this.func_70638_az()) < 2000.0) {
                        this.attackChoosenEntity((Entity)this.func_70638_az(), 2000.0f, 0);
                    }
                    this.func_85030_a("thetitans:titanGhastFireball", Float.MAX_VALUE, 1.0f);
                    for (int i = 0; i < 100; ++i) {
                        EntityGhastTitanFireball entitysmallfireball = new EntityGhastTitanFireball(this.field_70170_p, (EntityLivingBase)this, d11 + this.func_70681_au().nextGaussian() * 16.0, d21, d31 + this.func_70681_au().nextGaussian() * 16.0);
                        double d8 = 16.0;
                        Vec3 vec3 = this.func_70676_i(1.0f);
                        entitysmallfireball.field_70165_t = this.field_70165_t + vec3.field_72450_a * d8;
                        entitysmallfireball.field_70163_u = this.field_70163_u + vec3.field_72450_a * d8;
                        entitysmallfireball.field_70161_v = this.field_70161_v + vec3.field_72449_c * d8;
                        this.field_70170_p.func_72838_d((Entity)entitysmallfireball);
                    }
                    this.attackCounter = -40;
                }
            } else if (this.attackCounter > 0) {
                --this.attackCounter;
            }
        } else {
            if (this.func_70638_az() == null) {
                this.func_70671_ap().func_75650_a(this.waypointX, this.waypointY, this.waypointZ, 180.0f, 0.0f);
            }
            if (this.attackCounter > 0) {
                --this.attackCounter;
            }
        }
        if (!this.field_70170_p.field_72995_K && (b1 = this.field_70180_af.func_75683_a(16)) != (b0 = (byte)(this.attackCounter > 20 ? 1 : 0))) {
            this.field_70180_af.func_75692_b(16, (Object)b0);
        }
        super.func_70619_bc();
    }

    public int func_70646_bf() {
        return 180;
    }

    protected Item func_146068_u() {
        return Items.field_151072_bj;
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        if (this.deathTicks > 0) {
            EntityItem entityitem;
            int l;
            for (l = 0; l < 512 + this.field_70146_Z.nextInt(512 + p_70628_2_) + p_70628_2_; ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151016_H));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 512 + this.field_70146_Z.nextInt(512 + p_70628_2_) + p_70628_2_; ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151073_bk));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 256 + this.field_70146_Z.nextInt(256 + p_70628_2_) + p_70628_2_; ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151044_h));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 256 + this.field_70146_Z.nextInt(256 + p_70628_2_) + p_70628_2_; ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Blocks.field_150339_S));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 256 + this.field_70146_Z.nextInt(256 + p_70628_2_) + p_70628_2_; ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Blocks.field_150340_R));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 128 + this.field_70146_Z.nextInt(128 + p_70628_2_); ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Blocks.field_150475_bE));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 128 + this.field_70146_Z.nextInt(128 + p_70628_2_); ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Blocks.field_150484_ah));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 64 + this.field_70146_Z.nextInt(64 + p_70628_2_); ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(TitanItems.harcadium));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 32 + this.field_70146_Z.nextInt(32 + p_70628_2_); ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(TitanItems.voidItem));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 16 + this.field_70146_Z.nextInt(16 + p_70628_2_); ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Blocks.field_150357_h));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 64 + this.field_70146_Z.nextInt(64 + p_70628_2_); ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Blocks.field_150380_bt));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 64; ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Blocks.field_150382_bo));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
        }
    }

    protected void func_82164_bB() {
        this.func_145779_a(Items.field_151067_bt, 64);
    }

    public boolean func_70845_n() {
        return (this.field_70180_af.func_75683_a(16) & 1) != 0;
    }

    public void func_70844_e(boolean p_70844_1_) {
        byte b0 = this.field_70180_af.func_75683_a(16);
        b0 = p_70844_1_ ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_75692_b(16, (Object)b0);
    }

    @Override
    protected boolean isValidLightLevel() {
        return true;
    }

    protected void func_82167_n(Entity p_82167_1_) {
        if (!(p_82167_1_ instanceof EntitySmallFireball) || !(p_82167_1_ instanceof EntityLargeFireball)) {
            p_82167_1_.func_70108_f((Entity)this);
        }
    }

    @Override
    public StatBase getAchievement() {
        return TitansAchievments.ghasttitan;
    }

    public boolean func_70067_L() {
        return true;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_85032_ar()) {
            return false;
        }
        if (source.func_76346_g() instanceof EntityGhastLoyalist || source.func_76346_g() instanceof EntityGhastTitan) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    protected void inactDeathAction() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
                this.func_70628_a(true, 0);
                this.func_82160_b(true, 0);
                this.func_70600_l(1);
            }
            EntityTitanSpirit entitytitan = new EntityTitanSpirit(this.field_70170_p);
            entitytitan.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
            this.field_70170_p.func_72838_d((Entity)entitytitan);
            entitytitan.setVesselHunting(false);
            entitytitan.setSpiritType(11);
        }
    }
}

