/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.titan;

import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.titan.EntityCreeperTitan;
import net.minecraft.entity.titan.EntityEnderColossusCrystal;
import net.minecraft.entity.titan.EntityIronGolemTitan;
import net.minecraft.entity.titan.EntityLightningBall;
import net.minecraft.entity.titan.EntitySnowGolemTitan;
import net.minecraft.entity.titan.EntityTitan;
import net.minecraft.entity.titan.EntityTitanSpirit;
import net.minecraft.entity.titan.EntityWitherTurret;
import net.minecraft.entity.titan.EntityWitherzilla;
import net.minecraft.entity.titan.EnumTitanStatus;
import net.minecraft.entity.titan.ITitan;
import net.minecraft.entity.titan.ai.EntityAINearestTargetTitan;
import net.minecraft.entity.titan.animation.endercolossus.AnimationEnderColossusAntiTitanAttack1;
import net.minecraft.entity.titan.animation.endercolossus.AnimationEnderColossusAntiTitanAttack2;
import net.minecraft.entity.titan.animation.endercolossus.AnimationEnderColossusChainLightning;
import net.minecraft.entity.titan.animation.endercolossus.AnimationEnderColossusDeath;
import net.minecraft.entity.titan.animation.endercolossus.AnimationEnderColossusDragonLightningBall;
import net.minecraft.entity.titan.animation.endercolossus.AnimationEnderColossusLightningAttack;
import net.minecraft.entity.titan.animation.endercolossus.AnimationEnderColossusLightningBall;
import net.minecraft.entity.titan.animation.endercolossus.AnimationEnderColossusScream;
import net.minecraft.entity.titan.animation.endercolossus.AnimationEnderColossusSmash;
import net.minecraft.entity.titan.animation.endercolossus.AnimationEnderColossusStompAttack;
import net.minecraft.entity.titan.animation.endercolossus.AnimationEnderColossusStun;
import net.minecraft.entity.titan.animation.endercolossus.AnimationEnderColossusSwat;
import net.minecraft.entity.titanminion.EntityCreeperLoyalist;
import net.minecraft.entity.titanminion.EntityDragonMinion;
import net.minecraft.entity.titanminion.EntityEndermanLoyalist;
import net.minecraft.entity.titanminion.EntityEndermanPriest;
import net.minecraft.entity.titanminion.EntityEndermanTemplar;
import net.minecraft.entity.titanminion.EntityEndermanZealot;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.theTitans.DamageSourceExtra;
import net.minecraft.theTitans.TheTitans;
import net.minecraft.theTitans.TitanItems;
import net.minecraft.theTitans.TitansAchievments;
import net.minecraft.theTitans.world.WorldProviderVoid;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderEnd;
import net.minecraftforge.common.ForgeHooks;
import thehippomaster.AnimationAPI.AnimationAPI;
import thehippomaster.AnimationAPI.IAnimatedEntity;

public class EntityEnderColossus
extends EntityTitan
implements IAnimatedEntity,
IEntityMultiPart {
    private static final UUID attackingSpeedBoostModifierUUID = UUID.fromString("020E0DFB-87AE-4653-9556-831010E291A0");
    private static final AttributeModifier attackingSpeedBoostModifier = new AttributeModifier(attackingSpeedBoostModifierUUID, "Attacking speed boost", (double)0.15f, 0).func_111168_a(false);
    private int roarcooldownTimer;
    public boolean isRevealed;
    public EntityEnderColossusCrystal healingEnderCrystal;
    public int numOfCrystals;
    public int maxNumOfCrystals = 10;
    public EntityDragonPart[] partArray;
    public EntityDragonPart head = new EntityDragonPart((IEntityMultiPart)this, "head", 10.0f, 10.0f);
    public EntityDragonPart body = new EntityDragonPart((IEntityMultiPart)this, "body", 9.0f, 15.0f);
    public EntityDragonPart rightArm = new EntityDragonPart((IEntityMultiPart)this, "rightarm", 2.5f, 2.5f);
    public EntityDragonPart leftArm = new EntityDragonPart((IEntityMultiPart)this, "leftarm", 2.5f, 2.5f);
    public EntityDragonPart rightLeg = new EntityDragonPart((IEntityMultiPart)this, "rightleft", 2.5f, 36.0f);
    public EntityDragonPart leftLeg = new EntityDragonPart((IEntityMultiPart)this, "leftleg", 2.5f, 36.0f);
    public boolean isStunned;

    public EntityEnderColossus(World worldIn) {
        super(worldIn);
        this.partArray = new EntityDragonPart[]{this.head, this.body, this.rightArm, this.leftArm, this.rightLeg, this.leftLeg};
        this.setTitanHealth(this.func_110138_aP());
        this.field_70178_ae = true;
        this.func_70105_a(10.0f, 60.0f);
        this.func_85030_a("thetitans:titanBirth", 10000.0f, 0.875f);
        this.func_85030_a("thetitans:titanBirth", 10000.0f, 0.875f);
        this.func_85030_a("thetitans:titanBirth", 10000.0f, 0.875f);
        this.func_85030_a("thetitans:titanBirth", 10000.0f, 0.875f);
        this.field_70138_W = 16.0f;
        this.field_70728_aV = 1000000;
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan(this, EntityIronGolemTitan.class, 0, false));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan(this, EntitySnowGolemTitan.class, 0, false));
    }

    @Override
    protected void applyEntityAI() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationEnderColossusDeath(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationEnderColossusStun(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationEnderColossusScream(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationEnderColossusDragonLightningBall(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationEnderColossusChainLightning(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationEnderColossusLightningBall(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationEnderColossusLightningAttack(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationEnderColossusAntiTitanAttack1(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationEnderColossusAntiTitanAttack2(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationEnderColossusStompAttack(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationEnderColossusSmash(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationEnderColossusSwat(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        if (TheTitans.TitansFFAMode) {
            this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan(this, EntityLivingBase.class, 0, false, false, ITitan.EnderColossusSorter));
        } else {
            this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan(this, EntityLivingBase.class, 0, false, false, ITitan.SearchForAThingToKill));
        }
    }

    @Override
    public int getMinionCap() {
        return 160;
    }

    @Override
    public int getPriestCap() {
        return 80;
    }

    @Override
    public int getZealotCap() {
        return 60;
    }

    @Override
    public int getTemplarCap() {
        return 16;
    }

    @Override
    public int getSpecialMinionCap() {
        return 8;
    }

    @Override
    public int func_70627_aG() {
        return 100;
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.isRevealed = tagCompund.func_74767_n("Musmu");
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74757_a("Musmu", this.isRevealed);
    }

    public boolean func_70686_a(Class p_70686_1_) {
        return p_70686_1_ != EntityEndermanLoyalist.class && p_70686_1_ != EntityEnderColossus.class && p_70686_1_ != EntityDragon.class && p_70686_1_ != EntityDragonMinion.class && p_70686_1_ != EntityEnderColossusCrystal.class;
    }

    @Override
    public boolean func_70601_bi() {
        return this.field_70146_Z.nextInt(500) == 0 && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL && this.isValidLightLevel();
    }

    @Override
    public int getMinionSpawnRate() {
        return TheTitans.EnderColossusMinionSpawnrate;
    }

    @Override
    public EnumTitanStatus getTitanStatus() {
        return EnumTitanStatus.GREATER;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.325);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1000.0);
    }

    private void updateEnderColossusEnderCrystal() {
        if (this.healingEnderCrystal != null) {
            if (this.healingEnderCrystal.field_70128_L) {
                for (int i = 0; i < 15; ++i) {
                    this.func_70097_a(DamageSourceExtra.destroy, 500.0f);
                    this.field_70172_ad = 0;
                }
                this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t, this.field_70163_u + (double)(this.field_70131_O / 2.0f), this.field_70161_v, 16.0f, false, this.field_70170_p.func_82736_K().func_82766_b("mobGriefing"));
                this.field_70170_p.func_82739_e(1013, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 0);
                this.destroyBlocksInAABB(this.field_70121_D);
                this.healingEnderCrystal = null;
                this.setScreaming(true);
            } else if (this.field_70173_aa % 5 == 0) {
                this.func_70691_i(10.0f);
            }
        }
        if (this.field_70146_Z.nextInt(2) == 0 && this.healingEnderCrystal == null) {
            float f = 256.0f;
            List list = this.field_70170_p.func_72872_a(EntityEnderColossusCrystal.class, this.field_70121_D.func_72314_b((double)f, (double)f, (double)f));
            EntityEnderColossusCrystal entityendercrystal = null;
            double d0 = Double.MAX_VALUE;
            for (EntityEnderColossusCrystal entityendercrystal1 : list) {
                double d1 = entityendercrystal1.func_70068_e((Entity)this);
                if (!(d1 < d0)) continue;
                d0 = d1;
                entityendercrystal = entityendercrystal1;
                entityendercrystal1.owner = this;
            }
            this.healingEnderCrystal = entityendercrystal;
        }
    }

    @Override
    public int getRegenTime() {
        return 5;
    }

    @Override
    public float getRegen() {
        return 10.0f;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(18, (Object)new Byte(0));
    }

    @Override
    public int getParticleCount() {
        return 60;
    }

    @Override
    public String getParticles() {
        return "portal";
    }

    protected void func_70069_a(float p_70069_1_) {
        if ((p_70069_1_ = ForgeHooks.onLivingFall((EntityLivingBase)this, (float)p_70069_1_)) <= 0.0f) {
            return;
        }
        super.func_70069_a(p_70069_1_);
        PotionEffect potioneffect = this.func_70660_b(Potion.field_76430_j);
        float f1 = potioneffect != null ? (float)(potioneffect.func_76458_c() + 1) : 0.0f;
        int i = MathHelper.func_76123_f((float)(p_70069_1_ - 12.0f - f1));
        if (i > 0) {
            int l;
            int k;
            int j;
            Block block;
            this.func_85030_a("thetitans:groundSmash", 20.0f, 0.9f);
            this.func_85030_a("thetitans:titanland", 10000.0f, 1.0f);
            this.destroyBlocksInAABB(this.field_70121_D.func_72314_b(16.0, 2.0, 16.0));
            List list11 = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(48.0, 2.0, 48.0));
            if (list11 != null && !list11.isEmpty()) {
                for (int i1 = 0; i1 < list11.size(); ++i1) {
                    Entity entity = (Entity)list11.get(i1);
                    if (!(entity instanceof EntityLivingBase) || entity instanceof EntityDragonPart || !this.func_70686_a(entity.getClass()) || entity instanceof EntityTitan) continue;
                    float smash = 50.0f - this.func_70032_d(entity);
                    if (smash <= 1.0f) {
                        smash = 1.0f;
                    }
                    entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), smash * 4.0f);
                    double d0 = this.field_70121_D.field_72340_a + this.field_70121_D.field_72336_d;
                    double d1 = this.field_70121_D.field_72339_c + this.field_70121_D.field_72334_f;
                    double d2 = entity.field_70165_t - d0;
                    double d3 = entity.field_70161_v - d1;
                    double d4 = d2 * d2 + d3 * d3;
                    entity.func_70024_g(d2 / d4 * 8.0, 1.0, d3 / d4 * 8.0);
                }
            }
            if ((block = this.field_70170_p.func_147439_a(j = MathHelper.func_76128_c((double)this.field_70165_t), k = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f - (double)this.field_70129_M)), l = MathHelper.func_76128_c((double)this.field_70161_v))).func_149688_o() != Material.field_151579_a) {
                Block.SoundType soundtype = block.field_149762_H;
                this.func_85030_a(soundtype.func_150498_e(), soundtype.func_150497_c() * 0.5f, soundtype.func_150494_d() * 0.75f);
            }
        }
    }

    protected void func_70076_C() {
        this.func_85030_a("mob.endermen.portal", 100.0f, 0.6f);
        if (this.field_70170_p.field_73011_w instanceof WorldProviderEnd || this.field_70170_p.field_73011_w instanceof WorldProviderVoid) {
            this.func_70107_b(0.0, 128.0, 0.0);
        } else if (!(this.field_70170_p.field_73011_w instanceof WorldProviderEnd) && !(this.field_70170_p.field_73011_w instanceof WorldProviderVoid)) {
            this.func_70107_b(this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 48.0, 128.0, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 48.0);
        }
    }

    @Override
    protected int func_70682_h(int p_70682_1_) {
        return p_70682_1_;
    }

    protected Entity findPlayerToLookAt() {
        EntityPlayer entityplayer = this.field_70170_p.func_72890_a((Entity)this, -1.0);
        if (entityplayer != null && !this.field_70170_p.field_72995_K && entityplayer.func_70089_S() && this.func_70089_S() && this.isPlayerRegistered(entityplayer)) {
            this.func_70671_ap().func_75651_a((Entity)entityplayer, 180.0f, 30.0f);
            this.func_70624_b((EntityLivingBase)entityplayer);
            if (entityplayer.func_70694_bm() != null && entityplayer.func_70694_bm().func_77973_b() == TitanItems.ultimaBlade) {
                this.func_70097_a(DamageSourceExtra.causeArmorPiercingMobDamage((Entity)entityplayer), 600.0f);
                this.field_70172_ad = 0;
                this.field_70181_x = 1.0;
                this.field_70170_p.func_72885_a((Entity)entityplayer, this.field_70165_t, this.field_70163_u, this.field_70161_v, 8.0f, true, this.field_70170_p.func_82736_K().func_82766_b("mobGriefing"));
            } else {
                this.attackChoosenEntity((Entity)entityplayer, 20.0f, 100);
                entityplayer.field_70181_x = 1.0;
                entityplayer.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 400, 1));
                entityplayer.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 400, 99));
                entityplayer.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 400, 1));
                this.func_70624_b((EntityLivingBase)entityplayer);
                this.field_70170_p.func_72885_a((Entity)this, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, 8.0f, true, this.field_70170_p.func_82736_K().func_82766_b("mobGriefing"));
                this.func_85030_a("thetitans:titanEnderColossusStare", Float.MAX_VALUE, 1.0f);
                this.func_85030_a("thetitans:titanEnderColossusStare", Float.MAX_VALUE, 1.0f);
                this.func_85030_a("thetitans:titanEnderColossusStare", Float.MAX_VALUE, 1.0f);
                this.func_85030_a("thetitans:titanEnderColossusStare", Float.MAX_VALUE, 1.0f);
                this.func_85030_a("thetitans:titanEnderColossusStare", Float.MAX_VALUE, 1.0f);
                this.func_85030_a("thetitans:titanEnderColossusStare", Float.MAX_VALUE, 1.0f);
                this.func_85030_a("thetitans:titanEnderColossusStare", Float.MAX_VALUE, 1.0f);
                this.func_85030_a("thetitans:titanEnderColossusStare", Float.MAX_VALUE, 1.0f);
            }
        }
        return null;
    }

    protected boolean isPlayerRegistered(EntityPlayer p_70821_1_) {
        Vec3 vec3 = p_70821_1_.func_70676_i(1.0f).func_72432_b();
        Vec3 vec31 = Vec3.func_72443_a((double)(this.field_70165_t + (this.field_70146_Z.nextDouble() * 8.0 - 4.0) - p_70821_1_.field_70165_t), (double)(this.field_70121_D.field_72338_b + ((double)this.func_70047_e() + (this.field_70146_Z.nextDouble() * 8.0 - 4.0)) - (p_70821_1_.field_70163_u + (double)p_70821_1_.func_70047_e())), (double)(this.field_70161_v + (this.field_70146_Z.nextDouble() * 8.0 - 4.0) - p_70821_1_.field_70161_v));
        double d0 = vec31.func_72433_c();
        double d1 = vec3.func_72430_b(vec31 = vec31.func_72432_b());
        return d1 > 1.0 - 0.025 / d0 ? p_70821_1_.func_70685_l((Entity)this) : false;
    }

    @Override
    public double getSpeed() {
        return 0.4;
    }

    @Override
    public boolean shouldMove() {
        return this.animID == 0 && !this.isStunned && this.func_70638_az() != null ? super.shouldMove() : false;
    }

    @Override
    public boolean func_70652_k(Entity p_70652_1_) {
        return false;
    }

    @Override
    public void func_70636_d() {
        List list1111;
        int k;
        int i11;
        List list1;
        int i1;
        float da;
        double dz;
        float fl;
        super.func_70636_d();
        if (this.animID == 10) {
            if (this.animTick == 30 || this.animTick == 70) {
                this.func_85030_a("thetitans:titanStep", 10.0f, 1.0f);
            }
            if (this.animTick == 150 || this.animTick == 230) {
                this.func_85030_a("thetitans:titanFall", 20.0f, 1.0f);
                this.collideWithEntities(this.leftLeg, this.field_70170_p.func_72839_b((Entity)this, this.leftLeg.field_70121_D.func_72314_b(16.0, 1.0, 16.0)));
                this.collideWithEntities(this.rightLeg, this.field_70170_p.func_72839_b((Entity)this, this.rightLeg.field_70121_D.func_72314_b(16.0, 1.0, 16.0)));
            }
            if (this.animTick == 240) {
                this.func_85030_a("thetitans:distantLargeFall", 10000.0f, 1.0f);
            }
        }
        if (this.field_70173_aa % 120 == 0 && this.func_70089_S()) {
            this.func_85030_a("thetitans:titanEnderColossusLiving", this.func_70599_aP(), this.func_70647_i());
        }
        if (this.numOfCrystals < 0) {
            this.numOfCrystals = 0;
        }
        for (int i = 0; i < this.getParticleCount() * 5; ++i) {
            this.findPlayerToLookAt();
            this.field_70170_p.func_72869_a(this.getParticles(), this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 3.0, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 3.0, 0.0, 0.25, 0.0);
        }
        float f = this.field_70761_aq * (float)Math.PI / 180.0f;
        float f1 = MathHelper.func_76126_a((float)f);
        float f2 = MathHelper.func_76134_b((float)f);
        if (this.animID != 0) {
            ++this.animTick;
        }
        this.head.func_70071_h_();
        this.head.func_70012_b(this.field_70165_t, this.field_70163_u + 54.0, this.field_70161_v, 0.0f, 0.0f);
        this.body.func_70071_h_();
        this.body.func_70012_b(this.field_70165_t, this.field_70163_u + 36.0, this.field_70161_v, 0.0f, 0.0f);
        this.rightArm.func_70071_h_();
        this.rightArm.func_70012_b(this.field_70165_t + (double)(f2 * 8.0f), this.field_70163_u + 54.0, this.field_70161_v + (double)(f1 * 8.0f), 0.0f, 0.0f);
        this.leftArm.func_70071_h_();
        this.leftArm.func_70012_b(this.field_70165_t - (double)(f2 * 8.0f), this.field_70163_u + 54.0, this.field_70161_v - (double)(f1 * 8.0f), 0.0f, 0.0f);
        this.rightLeg.func_70071_h_();
        this.rightLeg.func_70012_b(this.field_70165_t + (double)(f2 * 2.5f), this.field_70163_u, this.field_70161_v + (double)(f1 * 2.5f), 0.0f, 0.0f);
        this.leftLeg.func_70071_h_();
        this.leftLeg.func_70012_b(this.field_70165_t - (double)(f2 * 2.5f), this.field_70163_u, this.field_70161_v - (double)(f1 * 2.5f), 0.0f, 0.0f);
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            this.collideWithEntities(this.head, this.field_70170_p.func_72839_b((Entity)this, this.head.field_70121_D.func_72314_b(1.0, 1.0, 1.0)));
            this.collideWithEntities(this.body, this.field_70170_p.func_72839_b((Entity)this, this.body.field_70121_D.func_72314_b(1.0, 1.0, 1.0)));
            this.collideWithEntities(this.rightArm, this.field_70170_p.func_72839_b((Entity)this, this.rightArm.field_70121_D.func_72314_b(1.0, 1.0, 1.0)));
            this.collideWithEntities(this.leftArm, this.field_70170_p.func_72839_b((Entity)this, this.leftArm.field_70121_D.func_72314_b(1.0, 1.0, 1.0)));
            this.collideWithEntities(this.leftLeg, this.field_70170_p.func_72839_b((Entity)this, this.leftLeg.field_70121_D.func_72314_b(1.0, 1.0, 1.0)));
            this.collideWithEntities(this.rightLeg, this.field_70170_p.func_72839_b((Entity)this, this.rightLeg.field_70121_D.func_72314_b(1.0, 1.0, 1.0)));
        }
        this.destroyBlocksInAABB(this.head.field_70121_D);
        this.destroyBlocksInAABB(this.body.field_70121_D);
        this.destroyBlocksInAABB(this.rightArm.field_70121_D);
        this.destroyBlocksInAABB(this.leftArm.field_70121_D);
        if (this.func_70089_S()) {
            this.updateEnderColossusEnderCrystal();
        }
        if ((fl = this.func_70013_c(1.0f)) > 0.5f && !this.field_70170_p.field_73011_w.field_76576_e && this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K && this.field_70173_aa % 1 == 0) {
            this.field_70125_A = this.field_70759_as / 6.0f;
            this.field_70759_as = -90.0f;
        }
        this.meleeTitan = true;
        if (this.getAnimID() != 0 || this.isStunned) {
            this.field_70159_w *= 0.0;
            this.field_70179_y *= 0.0;
        }
        if (this.getAnimID() == 13 && this.getAnimTick() <= 46 && this.getAnimTick() >= 26 && this.func_70638_az() != null) {
            float ex = 20.0f;
            float fll = this.field_70761_aq * (float)Math.PI / 180.0f;
            float fl1 = MathHelper.func_76126_a((float)fll);
            float fl2 = MathHelper.func_76134_b((float)fll);
            this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t - (double)(fl2 * ex), this.field_70163_u + 54.0, this.field_70161_v - (double)(fl1 * ex)));
        }
        if (this.getAnimID() == 3 && this.getAnimTick() == 64 && this.func_70638_az() != null && !this.field_70170_p.field_72995_K) {
            double d8 = 24.0;
            Vec3 vec3 = this.func_70676_i(1.0f);
            double dx = vec3.field_72450_a * d8;
            dz = vec3.field_72449_c * d8;
            da = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            i1 = this.getKnockbackAmount();
            this.attackChoosenEntity((Entity)this.func_70638_az(), da * 3.0f, i1);
            this.func_70638_az().field_70181_x += (double)(1.0f + this.field_70146_Z.nextFloat());
            this.field_70170_p.func_72885_a((Entity)this, this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v, 2.0f, false, false);
            this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t + dx, this.field_70163_u + 26.0, this.field_70161_v + dz, 1.0f, false, false);
            this.func_70638_az().func_70097_a(DamageSourceExtra.lightningBolt, da);
            this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t + dx, this.field_70163_u + (this.func_70631_g_() ? 9.0 : 18.0), this.field_70161_v + dz));
            this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t + dx, this.field_70163_u + (this.func_70631_g_() ? 9.0 : 18.0), this.field_70161_v + dz));
            this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t + dx, this.field_70163_u + (this.func_70631_g_() ? 9.0 : 18.0), this.field_70161_v + dz));
            this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t + dx, this.field_70163_u + (this.func_70631_g_() ? 9.0 : 18.0), this.field_70161_v + dz));
            this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v));
            list1 = this.field_70170_p.func_72839_b((Entity)this.func_70638_az(), this.func_70638_az().field_70121_D.func_72314_b(12.0, 12.0, 12.0));
            if (list1 != null && !list1.isEmpty()) {
                for (i11 = 0; i11 < list1.size(); ++i11) {
                    List list11;
                    Entity entity1 = (Entity)list1.get(i11);
                    if (!(entity1 instanceof EntityLivingBase) || !this.func_70686_a(entity1.getClass())) continue;
                    this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, entity1.field_70165_t, entity1.field_70163_u, entity1.field_70161_v));
                    this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, entity1.field_70165_t, entity1.field_70163_u, entity1.field_70161_v));
                    this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, entity1.field_70165_t, entity1.field_70163_u, entity1.field_70161_v));
                    this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, entity1.field_70165_t, entity1.field_70163_u, entity1.field_70161_v));
                    this.attackChoosenEntity(entity1, da, 0);
                    if (!(entity1 instanceof EntityTitan)) {
                        entity1.field_70181_x += (double)(1.0f + this.field_70146_Z.nextFloat());
                    }
                    if ((list11 = this.field_70170_p.func_72839_b(entity1, entity1.field_70121_D.func_72314_b(12.0, 12.0, 12.0))) == null || list11.isEmpty()) continue;
                    for (int i111 = 0; i111 < list11.size(); ++i111) {
                        List list111;
                        Entity entity11 = (Entity)list11.get(i111);
                        if (entity11 == entity1 || !(entity11 instanceof EntityLivingBase) || !this.func_70686_a(entity11.getClass())) continue;
                        this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, entity11.field_70165_t, entity11.field_70163_u, entity11.field_70161_v));
                        this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, entity11.field_70165_t, entity11.field_70163_u, entity11.field_70161_v));
                        this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, entity11.field_70165_t, entity11.field_70163_u, entity11.field_70161_v));
                        this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, entity11.field_70165_t, entity11.field_70163_u, entity11.field_70161_v));
                        this.attackChoosenEntity(entity11, da, 0);
                        if (!(entity11 instanceof EntityTitan)) {
                            entity11.field_70181_x += (double)(1.0f + this.field_70146_Z.nextFloat());
                        }
                        if ((list111 = this.field_70170_p.func_72839_b(entity11, entity11.field_70121_D.func_72314_b(12.0, 12.0, 12.0))) == null || list111.isEmpty()) continue;
                        for (int i1111 = 0; i1111 < list111.size(); ++i1111) {
                            Entity entity111 = (Entity)list111.get(i1111);
                            if (entity111 == entity11 || !(entity111 instanceof EntityLivingBase) || !this.func_70686_a(entity111.getClass())) continue;
                            this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, entity111.field_70165_t, entity111.field_70163_u, entity111.field_70161_v));
                            this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, entity111.field_70165_t, entity111.field_70163_u, entity111.field_70161_v));
                            this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, entity111.field_70165_t, entity111.field_70163_u, entity111.field_70161_v));
                            this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, entity111.field_70165_t, entity111.field_70163_u, entity111.field_70161_v));
                            this.attackChoosenEntity(entity111, da, 0);
                            if (entity111 instanceof EntityTitan) continue;
                            entity111.field_70181_x += (double)(1.0f + this.field_70146_Z.nextFloat());
                        }
                    }
                }
            }
        }
        if (this.getAnimID() == 4 && this.getAnimTick() == 50 && this.func_70638_az() != null && !this.field_70170_p.field_72995_K) {
            double d8 = 24.0;
            Vec3 vec3 = this.func_70676_i(1.0f);
            double dx = vec3.field_72450_a * d8;
            dz = vec3.field_72449_c * d8;
            this.field_70170_p.func_72885_a((Entity)this, this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v, 2.0f, false, false);
            this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t + dx, this.field_70163_u + d8, this.field_70161_v + dz, 1.0f, false, false);
            this.func_70638_az().func_70097_a(DamageSourceExtra.lightningBolt, 100.0f);
            this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t + dx, this.field_70163_u + d8, this.field_70161_v + dz));
            this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t + dx, this.field_70163_u + d8, this.field_70161_v + dz));
            this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t + dx, this.field_70163_u + d8, this.field_70161_v + dz));
            this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t + dx, this.field_70163_u + d8, this.field_70161_v + dz));
            this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v));
            double d5 = this.func_70638_az().field_70165_t - this.field_70165_t;
            double d6 = this.func_70638_az().field_70163_u - d8 - this.field_70163_u;
            double d7 = this.func_70638_az().field_70161_v - this.field_70161_v;
            EntityLightningBall entitylargefireball = new EntityLightningBall(this.field_70170_p, (EntityLivingBase)this, d5, d6, d7);
            entitylargefireball.field_70165_t = this.field_70165_t + vec3.field_72450_a * d8;
            entitylargefireball.field_70163_u = this.field_70163_u + d8;
            entitylargefireball.field_70161_v = this.field_70161_v + vec3.field_72449_c * d8;
            this.field_70170_p.func_72838_d((Entity)entitylargefireball);
        }
        if (this.getAnimID() == 11 && this.getAnimTick() == 50 && this.func_70638_az() != null && !this.field_70170_p.field_72995_K) {
            double d8 = 24.0;
            Vec3 vec3 = this.func_70676_i(1.0f);
            double dx = vec3.field_72450_a * d8;
            dz = vec3.field_72449_c * d8;
            this.field_70170_p.func_72885_a((Entity)this, this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v, 2.0f, false, false);
            this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t + dx, this.field_70163_u + d8, this.field_70161_v + dz, 1.0f, false, false);
            this.func_70638_az().func_70097_a(DamageSourceExtra.lightningBolt, 100.0f);
            this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t + dx, this.field_70163_u + d8, this.field_70161_v + dz));
            this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t + dx, this.field_70163_u + d8, this.field_70161_v + dz));
            this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t + dx, this.field_70163_u + d8, this.field_70161_v + dz));
            this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t + dx, this.field_70163_u + d8, this.field_70161_v + dz));
            this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v));
            EntityDragonMinion entitychicken = new EntityDragonMinion(this.field_70170_p);
            entitychicken.forceNewTarget = false;
            entitychicken.targetX = this.func_70638_az().field_70165_t;
            entitychicken.targetY = this.func_70638_az().field_70163_u;
            entitychicken.targetZ = this.func_70638_az().field_70161_v;
            entitychicken.func_70012_b(this.field_70165_t + dx, this.field_70163_u + d8, this.field_70161_v + dz, this.field_70177_z, 0.0f);
            entitychicken.func_70024_g(vec3.field_72450_a * 10.0, vec3.field_72448_b * 10.0, vec3.field_72449_c * 10.0);
            entitychicken.func_110161_a(null);
            entitychicken.func_70624_b(this.func_70638_az());
            this.field_70170_p.func_72838_d((Entity)entitychicken);
            entitychicken.master = this;
            entitychicken.func_85030_a("mob.enderdragon.growl", 10.0f, 1.0f);
            entitychicken.func_85030_a("mob.enderdragon.growl", 10.0f, 1.0f);
            entitychicken.func_85030_a("mob.enderdragon.growl", 10.0f, 1.0f);
            entitychicken.func_85030_a("mob.enderdragon.growl", 10.0f, 1.0f);
            entitychicken.func_85030_a("mob.enderdragon.growl", 10.0f, 1.0f);
            entitychicken.func_85030_a("mob.enderdragon.growl", 10.0f, 1.0f);
            entitychicken.func_85030_a("mob.enderdragon.growl", 10.0f, 1.0f);
            entitychicken.func_85030_a("mob.enderdragon.growl", 10.0f, 1.0f);
            ++this.numSpecialMinions;
        }
        if (this.getAnimID() == 13 && this.getAnimTick() == 64 && this.func_70638_az() != null && !this.field_70170_p.field_72995_K) {
            double d8 = 24.0;
            Vec3 vec3 = this.func_70676_i(1.0f);
            double dx = vec3.field_72450_a * d8;
            dz = vec3.field_72449_c * d8;
            da = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            i1 = this.getKnockbackAmount();
            this.attackChoosenEntity((Entity)this.func_70638_az(), da * 3.0f, i1);
            this.func_70638_az().field_70181_x += (double)(1.0f + this.field_70146_Z.nextFloat());
            this.field_70170_p.func_72885_a((Entity)this, this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v, 2.0f, false, false);
            this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t + dx, this.field_70163_u + 26.0, this.field_70161_v + dz, 1.0f, false, false);
            this.func_70638_az().func_70097_a(DamageSourceExtra.lightningBolt, da);
            this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t + dx, this.field_70163_u + (this.func_70631_g_() ? 9.0 : 18.0), this.field_70161_v + dz));
            this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t + dx, this.field_70163_u + (this.func_70631_g_() ? 9.0 : 18.0), this.field_70161_v + dz));
            this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t + dx, this.field_70163_u + (this.func_70631_g_() ? 9.0 : 18.0), this.field_70161_v + dz));
            this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t + dx, this.field_70163_u + (this.func_70631_g_() ? 9.0 : 18.0), this.field_70161_v + dz));
            this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v));
            list1 = this.field_70170_p.func_72839_b((Entity)this.func_70638_az(), this.func_70638_az().field_70121_D.func_72314_b(12.0, 12.0, 12.0));
            if (list1 != null && !list1.isEmpty()) {
                for (i11 = 0; i11 < list1.size(); ++i11) {
                    Entity entity1 = (Entity)list1.get(i11);
                    if (!(entity1 instanceof EntityLivingBase) || !this.func_70686_a(entity1.getClass())) continue;
                    this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, entity1.field_70165_t, entity1.field_70163_u, entity1.field_70161_v));
                    this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, entity1.field_70165_t, entity1.field_70163_u, entity1.field_70161_v));
                    this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, entity1.field_70165_t, entity1.field_70163_u, entity1.field_70161_v));
                    this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, entity1.field_70165_t, entity1.field_70163_u, entity1.field_70161_v));
                    this.attackChoosenEntity(entity1, da, 0);
                    if (entity1 instanceof EntityTitan) continue;
                    entity1.field_70181_x += (double)(1.0f + this.field_70146_Z.nextFloat());
                }
            }
        }
        if (!AnimationAPI.isEffectiveClient() && this.func_70638_az() != null && !this.isStunned && this.getAnimID() == 0) {
            double d0 = this.func_70068_e((Entity)this.func_70638_az());
            if (d0 < (double)(this.field_70130_N * this.field_70130_N + this.func_70638_az().field_70130_N * this.func_70638_az().field_70130_N) + 2000.0) {
                if (this.func_70638_az() instanceof EntityTitan || this.func_70638_az().field_70131_O >= 6.0f || this.func_70638_az().field_70163_u > this.field_70163_u + 6.0) {
                    switch (this.field_70146_Z.nextInt(2)) {
                        case 0: {
                            AnimationAPI.sendAnimPacket(this, 1);
                            this.setAnimID(1);
                            this.setAnimTick(0);
                            this.setScreaming(false);
                            break;
                        }
                        case 1: {
                            AnimationAPI.sendAnimPacket(this, 2);
                            this.setAnimID(2);
                            this.setAnimTick(0);
                        }
                    }
                } else {
                    switch (this.field_70146_Z.nextInt(3)) {
                        case 0: {
                            AnimationAPI.sendAnimPacket(this, 6);
                            this.setAnimID(6);
                            this.setAnimTick(0);
                            break;
                        }
                        case 1: {
                            AnimationAPI.sendAnimPacket(this, 7);
                            this.setAnimID(7);
                            this.setAnimTick(0);
                            break;
                        }
                        case 2: {
                            AnimationAPI.sendAnimPacket(this, 8);
                            this.setAnimID(8);
                            this.setAnimTick(0);
                        }
                    }
                }
            } else if (this.func_70681_au().nextInt(80) == 0) {
                switch (this.field_70146_Z.nextInt(5)) {
                    case 0: {
                        AnimationAPI.sendAnimPacket(this, 4);
                        this.setAnimID(4);
                        this.setAnimTick(0);
                        break;
                    }
                    case 1: {
                        if (this.field_70146_Z.nextInt(5) == 0) {
                            AnimationAPI.sendAnimPacket(this, 5);
                            this.setAnimID(5);
                        } else {
                            AnimationAPI.sendAnimPacket(this, 4);
                            this.setAnimID(4);
                        }
                        this.setAnimTick(0);
                        break;
                    }
                    case 2: {
                        AnimationAPI.sendAnimPacket(this, 3);
                        this.setAnimID(3);
                        this.setAnimTick(0);
                        break;
                    }
                    case 3: {
                        AnimationAPI.sendAnimPacket(this, 11);
                        this.setAnimID(11);
                        this.setAnimTick(0);
                        break;
                    }
                    case 4: {
                        AnimationAPI.sendAnimPacket(this, 13);
                        this.setAnimID(13);
                        this.setAnimTick(0);
                    }
                }
            }
        }
        if (TheTitans.NightmareMode) {
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6000.0);
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(300000.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2000.0);
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(150000.0);
        }
        if (this.field_70170_p.field_72995_K && this.isScreaming()) {
            this.func_70105_a(10.0f, 66.0f);
        } else if (this.field_70170_p.field_72995_K && !this.isScreaming()) {
            this.func_70105_a(10.0f, 60.0f);
        }
        if (this.field_70153_n != null && this.field_70153_n instanceof EntityDragon) {
            this.field_70177_z = this.field_70759_as = this.field_70153_n.field_70177_z;
            this.field_70761_aq = this.field_70759_as;
            if (!this.field_70153_n.func_70089_S()) {
                this.field_70154_o = null;
            }
        }
        if (this.func_70026_G() && this.field_70173_aa % 100 == 0) {
            this.func_70097_a(DamageSourceExtra.radiation, 25.0f);
        }
        this.func_70062_b(0, new ItemStack(Blocks.field_150380_bt));
        if (this.isRevealed) {
            this.func_94058_c(StatCollector.func_74838_a((String)"entity.EndermanTitan.realname"));
        } else {
            this.func_94058_c(StatCollector.func_74838_a((String)"entity.EndermanTitan.name"));
        }
        EntityPlayer entity = this.field_70170_p.func_72890_a((Entity)this, -1.0);
        if (entity instanceof EntityPlayer && entity != null && entity == this.func_70638_az() && this.func_70638_az() != null) {
            if (this.field_70146_Z.nextInt(200) == 0 && this.func_70638_az() != null && this.func_110143_aJ() <= this.func_110138_aP() / 100.0f) {
                entity.func_70097_a(DamageSourceExtra.mindCrush, Float.MAX_VALUE);
            }
            if (this.field_70146_Z.nextInt(200) == 0 && this.func_70638_az() != null) {
                entity.func_70107_b(entity.field_70165_t, -10.0, entity.field_70161_v);
                this.func_85030_a("mob.endermen.portal", 100.0f, 0.6f);
            }
            if (entity.func_110139_bj() <= 0.0f && this.field_70173_aa % 10 == 0) {
                entity.func_70097_a(DamageSourceExtra.mindCrush, 5.0f);
                entity.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 400, 1));
                if (entity.func_110143_aJ() <= 15.0f) {
                    entity.field_70181_x = 1.0;
                    entity.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 400, 9));
                }
                if (entity.func_110143_aJ() <= 5.0f) {
                    entity.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 400, 1));
                }
            } else if (entity.func_110139_bj() >= 0.0f && this.field_70173_aa % 20 == 0) {
                entity.func_70097_a(DamageSourceExtra.mindCrush, 5.0f);
            }
        }
        if (this.field_70154_o != null && this.field_70154_o instanceof EntityDragon) {
            this.field_70761_aq = this.field_70177_z = this.field_70154_o.field_70177_z - 180.0f;
        }
        if (this.field_70146_Z.nextInt(400) == 0 && this.field_70154_o == null && this.func_70638_az() != null && this.func_110143_aJ() <= this.func_110138_aP() / 100.0f) {
            EntityDragon entitydragon = new EntityDragon(this.field_70170_p);
            int i = MathHelper.func_76128_c((double)this.field_70165_t);
            int j = MathHelper.func_76128_c((double)this.field_70163_u);
            k = MathHelper.func_76128_c((double)this.field_70161_v);
            entitydragon.func_70012_b((double)i + 0.5, (double)j, (double)k + 0.5, this.field_70177_z, 0.0f);
            entitydragon.func_110161_a((IEntityLivingData)null);
            this.field_70170_p.func_72838_d((Entity)entitydragon);
            entitydragon.func_85030_a("mob.enderdragon.growl", 10.0f, 1.0f);
            entitydragon.func_85030_a("mob.enderdragon.growl", 10.0f, 1.0f);
            entitydragon.func_85030_a("mob.enderdragon.growl", 10.0f, 1.0f);
            entitydragon.func_85030_a("mob.enderdragon.growl", 10.0f, 1.0f);
            entitydragon.func_85030_a("mob.enderdragon.growl", 10.0f, 1.0f);
            entitydragon.func_85030_a("mob.enderdragon.growl", 10.0f, 1.0f);
            entitydragon.func_85030_a("mob.enderdragon.growl", 10.0f, 1.0f);
            entitydragon.func_85030_a("mob.enderdragon.growl", 10.0f, 1.0f);
            this.func_70078_a((Entity)entitydragon);
        }
        if ((list1111 = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(256.0, 256.0, 256.0))) != null && !list1111.isEmpty()) {
            for (int i12 = 0; i12 < list1111.size(); ++i12) {
                Entity entity1 = (Entity)list1111.get(i12);
                if (entity1 != null && this.func_70638_az() != null && entity1 instanceof EntityDragon) {
                    ((EntityDragon)entity1).field_70980_b = this.func_70638_az().field_70165_t;
                    ((EntityDragon)entity1).field_70981_c = this.func_70638_az().field_70163_u;
                    ((EntityDragon)entity1).field_70978_d = this.func_70638_az().field_70161_v;
                    continue;
                }
                if (entity1 == null || this.func_70638_az() != null || !(entity1 instanceof EntityDragon) || entity1.field_70153_n != null) continue;
                ((EntityDragon)entity1).field_70980_b = this.field_70165_t;
                ((EntityDragon)entity1).field_70981_c = this.field_70163_u + 60.0;
                ((EntityDragon)entity1).field_70978_d = this.field_70161_v;
            }
        }
        if (this.func_70089_S()) {
            ++this.roarcooldownTimer;
        }
        if (this.roarcooldownTimer == 0) {
            this.setScreaming(true);
            if (this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72877_b(this.field_70170_p.func_72820_D() + 14000L);
            }
        }
        if (this.roarcooldownTimer >= 60 || !this.func_70089_S()) {
            this.roarcooldownTimer = -(400 - this.field_70146_Z.nextInt(200));
            this.setScreaming(false);
        }
        if (this.field_70146_Z.nextInt(this.getMinionSpawnRate()) == 0 && this.func_110143_aJ() > 0.0f && !this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL) {
            if (this.numSpecialMinions < this.getSpecialMinionCap() && this.field_70146_Z.nextInt(100) == 0) {
                EntityDragonMinion entitychicken = new EntityDragonMinion(this.field_70170_p);
                int i = MathHelper.func_76128_c((double)this.field_70165_t) + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)15, (int)30) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1);
                k = MathHelper.func_76128_c((double)this.field_70161_v) + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)15, (int)30) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1);
                int j = this.field_70170_p.func_72825_h(i, k) - 8;
                entitychicken.func_70012_b((double)i + 0.5, j, (double)k + 0.5, this.field_70177_z, 0.0f);
                entitychicken.func_70024_g(0.0, 1.0, 0.0);
                entitychicken.func_110161_a(null);
                this.field_70170_p.func_72838_d((Entity)entitychicken);
                entitychicken.master = this;
                entitychicken.func_85030_a("mob.enderdragon.growl", 10.0f, 1.0f);
                entitychicken.func_85030_a("mob.enderdragon.growl", 10.0f, 1.0f);
                entitychicken.func_85030_a("mob.enderdragon.growl", 10.0f, 1.0f);
                entitychicken.func_85030_a("mob.enderdragon.growl", 10.0f, 1.0f);
                entitychicken.func_85030_a("mob.enderdragon.growl", 10.0f, 1.0f);
                entitychicken.func_85030_a("mob.enderdragon.growl", 10.0f, 1.0f);
                entitychicken.func_85030_a("mob.enderdragon.growl", 10.0f, 1.0f);
                entitychicken.func_85030_a("mob.enderdragon.growl", 10.0f, 1.0f);
                ++this.numSpecialMinions;
            } else if (this.numMinions < this.getMinionCap()) {
                EntityEndermanLoyalist entitychicken = new EntityEndermanLoyalist(this.field_70170_p);
                int i = MathHelper.func_76128_c((double)this.field_70165_t) + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)15, (int)30) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1);
                k = MathHelper.func_76128_c((double)this.field_70161_v) + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)15, (int)30) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1);
                int j = this.field_70170_p.func_72825_h(i, k);
                entitychicken.func_70012_b((double)i + 0.5, j, (double)k + 0.5, this.field_70177_z, 0.0f);
                entitychicken.func_110161_a(null);
                this.field_70170_p.func_72838_d((Entity)entitychicken);
                entitychicken.func_85030_a("mob.endermen.portal", 1.0f, 1.0f);
                ++this.numMinions;
                if (TheTitans.NightmareMode) {
                    entitychicken.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(200.0);
                    entitychicken.func_70606_j(200.0f);
                    entitychicken.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(20.0);
                }
            }
        }
        if (this.field_70146_Z.nextInt(this.getMinionSpawnRate() * 2) == 0 && this.func_110143_aJ() > 0.0f && !this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL) {
            if (this.numSpecialMinions < this.getSpecialMinionCap() && this.field_70146_Z.nextInt(100) == 0) {
                EntityDragonMinion entitychicken = new EntityDragonMinion(this.field_70170_p);
                int i = MathHelper.func_76128_c((double)this.field_70165_t) + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)15, (int)30) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1);
                k = MathHelper.func_76128_c((double)this.field_70161_v) + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)15, (int)30) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1);
                int j = this.field_70170_p.func_72825_h(i, k) - 8;
                entitychicken.func_70012_b((double)i + 0.5, j, (double)k + 0.5, this.field_70177_z, 0.0f);
                entitychicken.func_70024_g(0.0, 1.0, 0.0);
                entitychicken.func_110161_a(null);
                this.field_70170_p.func_72838_d((Entity)entitychicken);
                entitychicken.master = this;
                entitychicken.func_85030_a("mob.enderdragon.growl", 10.0f, 1.0f);
                entitychicken.func_85030_a("mob.enderdragon.growl", 10.0f, 1.0f);
                entitychicken.func_85030_a("mob.enderdragon.growl", 10.0f, 1.0f);
                entitychicken.func_85030_a("mob.enderdragon.growl", 10.0f, 1.0f);
                entitychicken.func_85030_a("mob.enderdragon.growl", 10.0f, 1.0f);
                entitychicken.func_85030_a("mob.enderdragon.growl", 10.0f, 1.0f);
                entitychicken.func_85030_a("mob.enderdragon.growl", 10.0f, 1.0f);
                entitychicken.func_85030_a("mob.enderdragon.growl", 10.0f, 1.0f);
                ++this.numSpecialMinions;
            } else if (this.numPriests < this.getPriestCap()) {
                EntityEndermanPriest entitychicken = new EntityEndermanPriest(this.field_70170_p);
                int i = MathHelper.func_76128_c((double)this.field_70165_t) + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)15, (int)30) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1);
                k = MathHelper.func_76128_c((double)this.field_70161_v) + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)15, (int)30) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1);
                int j = this.field_70170_p.func_72825_h(i, k);
                entitychicken.func_70012_b((double)i + 0.5, j, (double)k + 0.5, this.field_70177_z, 0.0f);
                entitychicken.func_110161_a(null);
                this.field_70170_p.func_72838_d((Entity)entitychicken);
                entitychicken.func_85030_a("mob.endermen.portal", 1.0f, 1.0f);
                ++this.numPriests;
                if (TheTitans.NightmareMode) {
                    entitychicken.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(300.0);
                    entitychicken.func_70606_j(300.0f);
                    entitychicken.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(25.0);
                }
            }
        }
        if (this.field_70146_Z.nextInt(this.getMinionSpawnRate() * 5) == 0 && this.func_110143_aJ() > 0.0f && !this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL) {
            if (this.numSpecialMinions < this.getSpecialMinionCap() && this.field_70146_Z.nextInt(100) == 0) {
                EntityDragonMinion entitychicken = new EntityDragonMinion(this.field_70170_p);
                int i = MathHelper.func_76128_c((double)this.field_70165_t) + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)15, (int)30) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1);
                k = MathHelper.func_76128_c((double)this.field_70161_v) + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)15, (int)30) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1);
                int j = this.field_70170_p.func_72825_h(i, k) - 8;
                entitychicken.func_70012_b((double)i + 0.5, j, (double)k + 0.5, this.field_70177_z, 0.0f);
                entitychicken.func_70024_g(0.0, 1.0, 0.0);
                entitychicken.func_110161_a(null);
                this.field_70170_p.func_72838_d((Entity)entitychicken);
                entitychicken.master = this;
                entitychicken.func_85030_a("mob.enderdragon.growl", 10.0f, 1.0f);
                entitychicken.func_85030_a("mob.enderdragon.growl", 10.0f, 1.0f);
                entitychicken.func_85030_a("mob.enderdragon.growl", 10.0f, 1.0f);
                entitychicken.func_85030_a("mob.enderdragon.growl", 10.0f, 1.0f);
                entitychicken.func_85030_a("mob.enderdragon.growl", 10.0f, 1.0f);
                entitychicken.func_85030_a("mob.enderdragon.growl", 10.0f, 1.0f);
                entitychicken.func_85030_a("mob.enderdragon.growl", 10.0f, 1.0f);
                entitychicken.func_85030_a("mob.enderdragon.growl", 10.0f, 1.0f);
                ++this.numSpecialMinions;
            } else if (this.numZealots < this.getZealotCap()) {
                EntityEndermanZealot entitychicken = new EntityEndermanZealot(this.field_70170_p);
                int i = MathHelper.func_76128_c((double)this.field_70165_t) + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)15, (int)30) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1);
                k = MathHelper.func_76128_c((double)this.field_70161_v) + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)15, (int)30) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1);
                int j = this.field_70170_p.func_72825_h(i, k);
                entitychicken.func_70012_b((double)i + 0.5, j, (double)k + 0.5, this.field_70177_z, 0.0f);
                entitychicken.func_110161_a(null);
                this.field_70170_p.func_72838_d((Entity)entitychicken);
                entitychicken.func_85030_a("mob.endermen.portal", 1.0f, 1.0f);
                ++this.numZealots;
                if (TheTitans.NightmareMode) {
                    entitychicken.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(1000.0);
                    entitychicken.func_70606_j(1000.0f);
                    entitychicken.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(50.0);
                }
            }
        }
        if (this.field_70146_Z.nextInt(this.getMinionSpawnRate() * 10) == 0 && this.func_110143_aJ() > 0.0f && !this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL) {
            if (this.numSpecialMinions < this.getSpecialMinionCap() && this.field_70146_Z.nextInt(100) == 0) {
                EntityDragonMinion entitychicken = new EntityDragonMinion(this.field_70170_p);
                int i = MathHelper.func_76128_c((double)this.field_70165_t) + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)15, (int)30) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1);
                k = MathHelper.func_76128_c((double)this.field_70161_v) + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)15, (int)30) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1);
                int j = this.field_70170_p.func_72825_h(i, k) - 8;
                entitychicken.func_70012_b((double)i + 0.5, j, (double)k + 0.5, this.field_70177_z, 0.0f);
                entitychicken.func_70024_g(0.0, 1.0, 0.0);
                entitychicken.func_110161_a(null);
                this.field_70170_p.func_72838_d((Entity)entitychicken);
                entitychicken.master = this;
                entitychicken.func_85030_a("mob.enderdragon.growl", 10.0f, 1.0f);
                entitychicken.func_85030_a("mob.enderdragon.growl", 10.0f, 1.0f);
                entitychicken.func_85030_a("mob.enderdragon.growl", 10.0f, 1.0f);
                entitychicken.func_85030_a("mob.enderdragon.growl", 10.0f, 1.0f);
                entitychicken.func_85030_a("mob.enderdragon.growl", 10.0f, 1.0f);
                entitychicken.func_85030_a("mob.enderdragon.growl", 10.0f, 1.0f);
                entitychicken.func_85030_a("mob.enderdragon.growl", 10.0f, 1.0f);
                entitychicken.func_85030_a("mob.enderdragon.growl", 10.0f, 1.0f);
                ++this.numSpecialMinions;
            } else if (this.numTemplar < this.getTemplarCap()) {
                EntityEndermanTemplar entitychicken = new EntityEndermanTemplar(this.field_70170_p);
                int i = MathHelper.func_76128_c((double)this.field_70165_t) + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)15, (int)30) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1);
                k = MathHelper.func_76128_c((double)this.field_70161_v) + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)15, (int)30) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1);
                int j = this.field_70170_p.func_72825_h(i, k);
                entitychicken.func_70012_b((double)i + 0.5, j, (double)k + 0.5, this.field_70177_z, 0.0f);
                entitychicken.func_110161_a(null);
                this.field_70170_p.func_72838_d((Entity)entitychicken);
                entitychicken.func_85030_a("mob.endermen.portal", 1.0f, 1.0f);
                ++this.numTemplar;
                if (TheTitans.NightmareMode) {
                    entitychicken.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(3000.0);
                    entitychicken.func_70606_j(3000.0f);
                    entitychicken.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(100.0);
                }
            }
        }
    }

    @Override
    protected void func_70619_bc() {
        List list11 = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D);
        if (list11 != null && !list11.isEmpty()) {
            for (int i1 = 0; i1 < list11.size(); ++i1) {
                Entity entity = (Entity)list11.get(i1);
                if (!(entity instanceof EntityLivingBase) || !entity.field_70122_E || entity instanceof EntityTitan) continue;
                float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
                entity.func_70097_a(DamageSourceExtra.causeSquishingDamage((Entity)this), f / 2.0f);
            }
        }
        if (this.field_70173_aa % 80 == 0 && !this.isStunned && this.numOfCrystals < this.maxNumOfCrystals && !this.field_70170_p.field_72995_K) {
            EntityEnderColossusCrystal entitychicken = new EntityEnderColossusCrystal(this.field_70170_p);
            int i = MathHelper.func_76128_c((double)this.field_70165_t);
            int j = MathHelper.func_76128_c((double)(this.field_70163_u + (double)this.func_70047_e()));
            int k = MathHelper.func_76128_c((double)this.field_70161_v);
            entitychicken.func_70012_b(i, j, k, this.field_70759_as, 0.0f);
            entitychicken.func_110161_a(null);
            this.field_70170_p.func_72838_d((Entity)entitychicken);
            ++this.numOfCrystals;
            entitychicken.owner = this;
            entitychicken.field_70181_x = 0.6f;
        }
        super.func_70619_bc();
    }

    protected String getRoarSound() {
        return "thetitans:titanEnderColossusRoar";
    }

    protected String func_70639_aQ() {
        return null;
    }

    @Override
    protected String func_70621_aR() {
        return "thetitans:titanEnderColossusGrunt";
    }

    @Override
    protected String func_70673_aS() {
        return "thetitans:titanEnderColossusDeath";
    }

    protected void func_145780_a(int p_145780_1_, int p_145780_2_, int p_145780_3_, Block p_145780_4_) {
        this.func_85030_a("thetitans:titanStep", 10.0f, 0.85f);
        float f3 = this.field_70177_z * (float)Math.PI / 180.0f;
        float f11 = MathHelper.func_76126_a((float)f3);
        float f4 = MathHelper.func_76134_b((float)f3);
        this.collideWithEntities(this.leftLeg, this.field_70170_p.func_72839_b((Entity)this, this.leftLeg.field_70121_D.func_72314_b(1.0, 1.0, 1.0).func_72317_d((double)(f11 * 10.0f), 0.0, (double)(f4 * 10.0f))));
        this.collideWithEntities(this.rightLeg, this.field_70170_p.func_72839_b((Entity)this, this.rightLeg.field_70121_D.func_72314_b(1.0, 1.0, 1.0).func_72317_d((double)(f11 * 10.0f), 0.0, (double)(f4 * 10.0f))));
    }

    protected Item func_146068_u() {
        return Items.field_151061_bv;
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        if (this.deathTicks > 0) {
            EntityItem entityitem;
            int l;
            for (l = 0; l < 512 + this.field_70146_Z.nextInt(512 + p_70628_2_) + p_70628_2_; ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151061_bv));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 128 + this.field_70146_Z.nextInt(128 + p_70628_2_) + p_70628_2_; ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151079_bi));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 256 + this.field_70146_Z.nextInt(256 + p_70628_2_) + p_70628_2_; ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151044_h));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 256 + this.field_70146_Z.nextInt(256 + p_70628_2_) + p_70628_2_; ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Blocks.field_150339_S));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 256 + this.field_70146_Z.nextInt(256 + p_70628_2_) + p_70628_2_; ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Blocks.field_150340_R));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 128 + this.field_70146_Z.nextInt(128 + p_70628_2_); ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Blocks.field_150475_bE));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 128 + this.field_70146_Z.nextInt(128 + p_70628_2_); ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Blocks.field_150484_ah));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 64 + this.field_70146_Z.nextInt(64 + p_70628_2_); ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(TitanItems.harcadium));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 32 + this.field_70146_Z.nextInt(32 + p_70628_2_); ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(TitanItems.voidItem));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 16 + this.field_70146_Z.nextInt(16 + p_70628_2_); ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Blocks.field_150357_h));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 64 + this.field_70146_Z.nextInt(64 + p_70628_2_); ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Blocks.field_150380_bt));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 60; ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Blocks.field_150378_br));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            EntityItem entityitem2 = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(TitanItems.voidSword));
            entityitem2.field_145804_b = 40;
            this.field_70170_p.func_72838_d((Entity)entityitem2);
        }
    }

    protected void func_70600_l(int p_70600_1_) {
        switch (this.field_70146_Z.nextInt(3)) {
            case 0: {
                this.func_70099_a(new ItemStack(Items.field_151153_ao, 64, 1), 0.0f);
                break;
            }
            case 1: {
                this.func_145779_a(Items.field_151048_u, 64);
                break;
            }
            case 2: {
                this.func_145779_a(Items.field_151057_cb, 64);
            }
        }
    }

    public void func_82206_m() {
        this.setInvulTime(1100);
        this.setTitanHealth(this.func_110138_aP() / 10.0f);
    }

    @Override
    public StatBase getAchievement() {
        return TitansAchievments.endercolossus;
    }

    public float func_70047_e() {
        if (this.isScreaming()) {
            return 60.0f;
        }
        return 54.0f;
    }

    public boolean isScreaming() {
        return this.field_70180_af.func_75683_a(18) > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float p_70070_1_) {
        return 0xF000F0;
    }

    public float func_70013_c(float p_70013_1_) {
        return 1.0f;
    }

    public void setScreaming(boolean p_70819_1_) {
        this.field_70180_af.func_75692_b(18, (Object)((byte)(p_70819_1_ ? 1 : 0)));
        if (p_70819_1_) {
            this.func_85030_a(this.getRoarSound(), this.func_70599_aP(), 1.0f);
        }
    }

    @Override
    public IEntityLivingData func_110161_a(IEntityLivingData p_180482_2_) {
        IEntityLivingData p_180482_2_1 = super.func_110161_a(p_180482_2_);
        this.func_85030_a(this.getRoarSound(), this.func_70599_aP(), 1.0f);
        this.setScreaming(true);
        this.setRoarCooldownTimer(-20 - this.field_70146_Z.nextInt(20));
        List list11 = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(256.0, 256.0, 256.0));
        if (list11 != null && !list11.isEmpty()) {
            for (int i1 = 0; i1 < list11.size(); ++i1) {
                List list111;
                Entity entity = (Entity)list11.get(i1);
                if (entity == null || !(entity instanceof EntityWitherzilla) || (list111 = this.field_70170_p.func_72839_b(entity, entity.field_70121_D.func_72314_b(256.0, 256.0, 256.0))) == null || list111.isEmpty()) continue;
                for (int i11 = 0; i11 < list111.size(); ++i11) {
                    Entity entity1 = (Entity)list111.get(i11);
                    if (entity1 == null || !(entity1 instanceof EntityPlayer)) continue;
                    ((EntityPlayer)entity1).func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"dialog.witherzilla.endercolossus")));
                }
            }
        }
        return p_180482_2_1;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void collideWithEntities(EntityDragonPart part, List p_70970_1_) {
        double d0 = (part.field_70121_D.field_72340_a + part.field_70121_D.field_72336_d) / 2.0;
        double d1 = (part.field_70121_D.field_72339_c + part.field_70121_D.field_72334_f) / 2.0;
        for (Entity entity : p_70970_1_) {
            if (entity == null || !(entity instanceof EntityLivingBase) || entity instanceof EntityTitan || entity instanceof EntityTitanSpirit || !this.func_70686_a(entity.getClass()) || !entity.func_70067_L()) continue;
            double d2 = entity.field_70165_t - d0;
            double d3 = entity.field_70161_v - d1;
            double d4 = d2 * d2 + d3 * d3;
            entity.func_70024_g(d2 / d4 * 0.75, 0.25, d3 / d4 * 0.75);
            entity.func_70097_a(DamageSource.func_92087_a((Entity)this), 30.0f);
        }
    }

    public double func_70033_W() {
        return super.func_70033_W() - 1.0;
    }

    @Override
    protected void inactDeathAction() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
                this.func_70628_a(true, 0);
                this.func_82160_b(true, 0);
                this.func_70600_l(1);
            }
            EntityTitanSpirit entitytitan = new EntityTitanSpirit(this.field_70170_p);
            entitytitan.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
            this.field_70170_p.func_72838_d((Entity)entitytitan);
            entitytitan.setVesselHunting(false);
            entitytitan.setSpiritType(10);
        }
    }

    @Override
    protected void onTitanDeathUpdate() {
        this.field_70180_af.func_75692_b(6, (Object)Float.valueOf(MathHelper.func_76131_a((float)this.field_70180_af.func_111145_d(5), (float)0.0f, (float)this.func_110138_aP())));
        if (this.field_70180_af.func_111145_d(5) <= 0.0f) {
            ++this.deathTicks;
            AnimationAPI.sendAnimPacket(this, 10);
            this.setAnimID(10);
            this.setTitanHealth(0.0f);
        } else {
            this.func_70097_a(DamageSource.field_76380_i, 25.0f);
            this.setTitanHealth(this.field_70180_af.func_111145_d(5));
            this.func_70606_j(this.field_70180_af.func_111145_d(5));
            this.deathTicks = 0;
            if (this.animID == 10) {
                this.animID = 0;
            }
        }
        this.field_70159_w *= 0.0;
        this.field_70179_y *= 0.0;
        this.func_70624_b(null);
        if (this.deathTicks == 1 && !this.field_70170_p.field_72995_K) {
            this.func_85030_a(this.func_70673_aS(), this.func_70599_aP(), this.func_70647_i());
            ArrayList listp = Lists.newArrayList((Iterable)this.field_70170_p.field_73010_i);
            if (listp != null && !listp.isEmpty()) {
                for (int i1 = 0; i1 < listp.size(); ++i1) {
                    Entity entity = (Entity)listp.get(i1);
                    if (entity == null || !(entity instanceof EntityPlayer)) continue;
                    ((EntityPlayer)entity).func_71029_a(this.getAchievement());
                }
            }
        }
        if (this.deathTicks == 1) {
            this.setAnimTick(1);
        }
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot") && this.deathTicks >= 500 && this.deathTicks % 10 == 0) {
            int j;
            for (int i = this.func_70693_a(this.field_70717_bb) / 10; i > 0; i -= j) {
                j = EntityXPOrb.func_70527_a((int)i);
                this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u + 64.0, this.field_70161_v, j));
            }
        }
        if (this.deathTicks >= 500) {
            this.setInvulTime(this.getInvulTime() + 8);
            --this.animTick;
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 12.0f;
            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 3.0f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 12.0f;
            this.field_70170_p.func_72869_a("hugeexplosion", this.field_70165_t + (double)f, this.field_70163_u + 2.0 + (double)f1, this.field_70161_v + (double)f2, 0.0, 0.0, 0.0);
        }
        if (this.getInvulTime() >= this.getThreashHold()) {
            this.func_70106_y();
        }
    }

    @Override
    public int getThreashHold() {
        return 1100;
    }

    public int getRoarCooldownTimer() {
        return this.roarcooldownTimer;
    }

    public void setRoarCooldownTimer(int roarcooldownTimer) {
        this.roarcooldownTimer = roarcooldownTimer;
    }

    @Override
    public void setAnimID(int id) {
        this.animID = id;
    }

    @Override
    public void setAnimTick(int tick) {
        this.animTick = tick;
    }

    @Override
    public int getAnimID() {
        return this.animID;
    }

    @Override
    public int getAnimTick() {
        return this.animTick;
    }

    public boolean attackEndermanFrom(DamageSource source, float amount) {
        if (source.func_76346_g() instanceof EntityPlayer && !this.field_70170_p.field_72995_K) {
            this.func_70624_b((EntityLivingBase)source.func_76346_g());
            this.func_70604_c((EntityLivingBase)source.func_76346_g());
        }
        if (this.func_85032_ar()) {
            return false;
        }
        if (source.func_76346_g() instanceof EntityEndermanLoyalist || source.func_76346_g() instanceof EntityEnderColossus || source.func_76346_g() instanceof EntityDragon || source.func_76346_g() instanceof EntityDragonMinion) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70067_L() {
        return false;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        return this.attackEndermanFrom(source, amount);
    }

    public Entity[] func_70021_al() {
        return this.partArray;
    }

    public boolean func_70965_a(EntityDragonPart p_70965_1_, DamageSource source, float amount) {
        if (p_70965_1_ != this.head) {
            amount /= 3.0f;
        }
        this.func_82195_e(source, amount);
        if (source == DamageSourceExtra.lightningBolt || source.func_76346_g() instanceof EntityCreeperLoyalist || source.func_76346_g() instanceof EntityCreeperTitan || source.func_94541_c() && !(source.func_76346_g() instanceof EntityWitherTurret)) {
            this.func_70691_i(amount);
            return false;
        }
        return true;
    }

    protected boolean func_82195_e(DamageSource p_82195_1_, float p_82195_2_) {
        return this.attackEndermanFrom(p_82195_1_, p_82195_2_);
    }

    public World func_82194_d() {
        return this.field_70170_p;
    }
}

