----------------------------------------------------------------------
-- 	Leatrix Maps Locale (www.leatrix.com)
----------------------------------------------------------------------

-- Create locale structure
local GameLocale = GetLocale()
local void, Leatrix_Maps = ...
local function localeFunc(L, key) return key end
local L = setmetatable({}, {__index = localeFunc})
Leatrix_Maps.L = L

-- Locale override (enUS, zhCN, zhTW, ruRU, koKR, deDE, esMX, frFR, itIT, ptBR)
-- GameLocale = "enUS"

-- zhCN: Simplified Chinese (People's Republic of China)
if GameLocale == "zhCN" then
L["/ltm help - Show this information."] = "/ltm help - 显示帮助信息"
L["/ltm reset - Reset the panel position."] = "/ltm reset - 重置面板位置"
L["/ltm wipe - Wipe all settings and reload."] = "/ltm wipe - 清空所有设置并重载插件"
L["A stop error has occurred but no need to worry.  It can happen from time to time.  Click the reload button to resolve it."] = "出现了一个无关痛痒的报错，它并不会影响到你的体验，你可以点击重载按钮来解决这个问题。"
L["Alpha"] = "透明"
L["Astravar Harbor"] = "阿斯塔瓦港"
L["Auchenai Crypts"] = "奥金尼地穴"
L["Auchindoun"] = "奥金顿"
L["Azjol-Nerub"] = "艾卓-尼鲁布"
L["Back to Main Menu"] = "返回主菜单"
L["Baradin Hold"] = "巴拉丁监狱"
L["Black Morass"] = "幽暗沼泽"
L["Black Temple"] = "黑暗神殿"
L["Blackfathom Deeps"] = "黑暗深渊"
L["Blackrock Caverns"] = "黑石岩窟"
L["Blackrock Depths"] = "黑石深渊"
L["Blackrock Foundry"] = "黑石铸造厂"
L["Blackrock Mountain"] = "黑石山"
L["Blackrock Spire"] = "黑石塔"
L["Blackwing Descent"] = "黑翼血环"
L["Blackwing Lair"] = "黑翼之巢"
L["Bloodmaul Slag Mines"] = "血槌炉渣矿井"
L["Blue"] = "蓝色"
L["Caverns of Time"] = "时光之穴"
L["Coilfang Reservoir"] = "盘牙水库"
L["Configuration Panel"] = "设置面板"
L["Culling of Stratholme"] = "净化斯坦索姆"
L["Darnassus"] = "达纳苏斯"
L["Dire Maul"] = "厄运之槌"
L["Dire Maul: Capital Gardens"] = "厄运之槌：中心花园"
L["Dire Maul: Gordok Commons"] = "厄运之槌：戈多克议会"
L["Dire Maul: Warpwood Quarter"] = "厄运之槌：扭木广场"
L["Disable map fade while moving"] = "禁用地图的移动时淡化"
L["Disable reading emote when opening the map"] = "禁用阅读地图时的表情动作"
L["Dragon Soul"] = "巨龙之魂"
L["Drak'Tharon Keep"] = "达克萨隆要塞"
L["Dungeon"] = "地下城"
L["End Time"] = "时光之末"
L["Eternal Guardian"] = "永恒守护者"
L["Evermoon Terrace"] = "永月平台"
L["Eye of Azshara"] = "艾萨拉之眼"
L["Falanaar"] = "法兰纳尔"
L["Felsoul Hold"] = "邪魂堡垒"
L["Firelands"] = "火焰之地"
L["Gate of the Setting Sun"] = "残阳关"
L["Gnomeregan"] = "诺莫瑞根"
L["Green"] = "绿色"
L["Grim Batol"] = "格瑞姆巴托"
L["Grimrail Depot"] = "恐轨车站"
L["Gruul's Lair"] = "格鲁尔的巢穴"
L["Gundrak"] = "古达克"
L["Gundrak (rear entrance)"] = "古达克（后门）"
L["Halls of Lightning"] = "闪电大厅"
L["Halls of Origination"] = "起源大厅"
L["Halls of Stone"] = "岩石大厅"
L["Halls of Valor"] = "勇气大厅"
L["Heart of Fear"] = "恐惧之心"
L["Hellfire Citadel"] = "地狱火堡垒"
L["Hellfire Ramparts"] = "地狱火城墙"
L["Highmaul"] = "悬槌堡"
L["Hour of Twilight"] = "暮光之刻"
L["Hyjal Summit"] = "海加尔山"
L["Icecrown"] = "冰冠冰川"
L["Icecrown Citadel"] = "冰冠堡垒"
L["Icons"] = "图标"
L["Invalid command.  Enter /ltm help for help."] = "无效的命令。输入/ltm help来获取帮助信息。"
L["Iron Docks"] = "钢铁码头"
L["Ironforge"] = "铁炉堡"
L["Karazhan"] = "卡拉赞"
L["Large Scarab Coffer"] = "大型圣甲虫箱"
L["Lion's Watch"] = "雄狮岗哨"
L["Lost City of the Tol'vir"] = "托维尔失落之城"
L["Lower Blackrock Spire"] = "黑石塔下层"
L["Lunastre Estate"] = "月郡庄园"
L["Magisters' Terrace"] = "魔导师平台"
L["Magtheridon's Lair"] = "玛瑟里顿的巢穴"
L["Mana-Tombs"] = "法力陵墓"
L["Maraudon"] = "玛拉顿"
L["Maraudon: Earth Song Falls"] = "玛拉顿：毒水瀑布"
L["Maraudon: Foulspore Cavern"] = "玛拉顿：毒菇洞穴"
L["Maraudon: The Wicked Grotto"] = "玛拉顿：邪恶洞穴"
L["Miscellaneous"] = "杂项"
L["Mogu'shan Palace"] = "魔古山宫殿"
L["Mogu'shan Vaults"] = "魔古山宝库"
L["Molten Core"] = "熔火之心"
L["Moon Guard Stronghold"] = "护月堡垒"
L["Mount Hyjal"] = "海加尔山"
L["Naxxramas"] = "纳克萨玛斯"
L["NOTICE!|nYou must fully restart your game client before you can use this version of Leatrix Maps."] = "注意！|n你必须重新启动你的游戏客户端才能正确加载新版本的Leatrix Maps。"
L["Old Hillsbrad Foothills"] = "旧希尔斯布莱德丘陵"
L["Onyxia's Lair"] = "奥妮克希亚的巢穴"
L["Orgrimmar"] = "奥格瑞玛"
L["Portal"] = "传送门"
L["Portal from Zephyr"] = "塞菲尔的传送门"
L["Preview"] = "预览"
L["Ragefire Chasm"] = "怒焰裂谷"
L["Raid"] = "团队副本"
L["Razorfen Downs"] = "剃刀高地"
L["Razorfen Kraul"] = "剃刀沼泽"
L["Red"] = "红色"
L["Reset"] = "重置"
L["Return to Karazhan"] = "重返卡拉赞"
L["Reveal"] = "去除迷雾"
L["Reveal Map"] = "去除迷雾"
L["Reveal unexplored areas of the map"] = "显示地图的未探索区域"
L["Ruins of Ahn'Qiraj"] = "安其拉废墟"
L["Ruins of Elune'eth"] = "艾露尼斯废墟"
L["Sanctum of Order"] = "秩序大殿"
L["Scarlet Halls"] = "血色大厅"
L["Scarlet Monastery"] = "血色修道院"
L["Scholomance"] = "通灵学院"
L["Serpentshrine Cavern"] = "毒蛇神殿"
L["Sethekk Halls"] = "塞泰克大厅"
L["Settings"] = "设置"
L["Shado-Pan Monastery"] = "影踪修道院"
L["Shadow Labyrinth"] = "暗影迷宫"
L["Shadowfang Keep"] = "影牙城堡"
L["Shadowmoon Burial Grounds"] = "影月墓地"
L["Shal'Aran"] = "沙尔艾兰"
L["Show map reveal toggle button"] = "显示去除地图迷雾的按钮"
L["Siege of Niuzao Temple"] = "围攻砮皂寺"
L["Siege of Orgrimmar"] = "决战奥格瑞玛"
L["Skyreach"] = "通天峰"
L["Slave Pens"] = "奴隶围栏"
L["Steamvault"] = "蒸汽地窟"
L["Stormstout Brewery"] = "风暴酿酒厂"
L["Stormwind"] = "暴风城"
L["Stratholme: Crusader's Square"] = "斯坦索姆：十字军广场"
L["Stratholme: The Gauntlet"] = "斯坦索姆：后门"
L["Sunwell Plateau"] = "太阳之井高地"
L["Tel'anor"] = "泰安诺"
L["Tempest Keep"] = "风暴要塞"
L["Temple of Ahn'Qiraj"] = "安其拉神殿"
L["Temple of Atal'Hakkar"] = "阿塔哈卡神庙"
L["Temple of the Jade Serpent"] = "青龙寺"
L["Terrace of Endless Spring"] = "永春台"
L["The Arcatraz"] = "禁魔监狱"
L["The Bastion of Twilight"] = "暮光堡垒"
L["The Black Morass"] = "黑色沼泽"
L["The Blood Furnace"] = "鲜血熔炉"
L["The Botanica"] = "生态船"
L["The Culling of Stratholme"] = "净化斯坦索姆"
L["The Deadmines"] = "死亡矿井"
L["The Dragon Soul"] = "巨龙之魂"
L["The Everbloom"] = "永茂林地"
L["The Eye"] = "风暴要塞"
L["The Eye of Eternity"] = "永恒之眼"
L["The Forge of Souls"] = "灵魂洪炉"
L["The Frozen Halls"] = "冰封大殿"
L["The Halls of Reflection"] = "倒映大厅"
L["The Mechanar"] = "能源舰"
L["The Nexus"] = "魔枢"
L["The Obsidian Sanctum"] = "黑曜石圣殿"
L["The Oculus"] = "魔环"
L["The Old Kingdom"] = "古代王国"
L["The Pit of Saron"] = "萨隆矿坑"
L["The Ruby Sanctum"] = "红玉圣殿"
L["The Shattered Halls"] = "破碎大厅"
L["The Stockade"] = "监狱"
L["The Stonecore"] = "巨石之核"
L["The Violet Hold"] = "紫罗兰监狱"
L["The Vortex Pinnacle"] = "旋云之巅"
L["The Waning Crescent"] = "残月酒馆"
L["Throne of the Four Winds"] = "风神王座"
L["Throne of the Tides"] = "海潮王座"
L["Throne of Thunder"] = "雷电王座"
L["Thunder Bluff"] = "雷霆崖"
L["Tint unexplored areas"] = "未探索区域染色"
L["Tomb of Sargeras"] = "萨格拉斯之墓"
L["Transparency"] = "透明度"
L["Trial of the Champion"] = "冠军的试炼"
L["Trial of the Crusader"] = "十字军的试炼"
L["Twilight Vineyards"] = "暮光酒庄"
L["Uldaman"] = "奥达曼"
L["Ulduar"] = "奥杜尔"
L["Underbog"] = "幽暗沼泽"
L["Undercity"] = "幽暗城"
L["Upper Blackrock Spire"] = "黑石塔上层"
L["Utgarde Keep"] = "乌特加德城堡"
L["Utgarde Pinnacle"] = "乌特加德之巅"
L["Vault of Archavon"] = "阿尔卡冯的宝库"
L["Version"] = "版本"
L["Vol'mar"] = "沃玛尔"
L["Wailing Caverns"] = "哀嚎洞穴"
L["Well of Eternity"] = "永恒之井"
L["Wyrmrest Temple"] = "龙眠神殿"
L["Your UI needs to be reloaded."] = "插件需要重新载入。"
L["Zul'Aman"] = "祖阿曼"
L["Zul'Farrak"] = "祖尔法拉克"
L["Zul'Gurub"] = "祖尔格拉布"

end

-- zhTW: Traditional Chinese (Taiwan)
if GameLocale == "zhTW" then
L["/ltm help - Show this information."] = "/ltm help - 顯示插件資訊。"
L["/ltm reset - Reset the panel position."] = "/ltm reset - 重設面板位置。"
L["/ltm wipe - Wipe all settings and reload."] = "/ltm wipe - 清除所有設定並重載。"
L["A stop error has occurred but no need to worry.  It can happen from time to time.  Click the reload button to resolve it."] = "一個停止錯誤發生了，但無需擔心，三不五時會發生，請點擊重載按鈕來解決它。"
L["Alpha"] = "透明"
L["Astravar Harbor"] = "艾斯特瓦港"
L["Auchenai Crypts"] = "奧奇奈地穴"
L["Auchindoun"] = "奧齊頓"
L["Azjol-Nerub"] = "阿茲歐-奈幽"
L["Back to Main Menu"] = "回到主選單"
L["Baradin Hold"] = "巴拉丁堡"
L["Black Morass"] = "黑色沼澤"
L["Black Temple"] = "黑暗神廟"
L["Blackfathom Deeps"] = "黑澗深淵"
L["Blackrock Caverns"] = "黑石洞穴"
L["Blackrock Depths"] = "黑石深淵"
L["Blackrock Foundry"] = "黑石鑄造廠"
L["Blackrock Mountain"] = "黑石山"
L["Blackrock Spire"] = "黑石塔"
L["Blackwing Descent"] = "黑翼陷窟"
L["Blackwing Lair"] = "黑翼之巢"
L["Bloodmaul Slag Mines"] = "血槌熔渣礦場"
L["Blue"] = "藍色"
L["Caverns of Time"] = "時光之穴"
L["Classic"] = "經典"
L["Coilfang Reservoir"] = "盤牙蓄湖"
L["Configuration Panel"] = "設置面板"
L["Culling of Stratholme"] = "斯坦索姆的抉擇"
L["Cursor"] = "鼠標"
L["Darnassus"] = "達納蘇斯"
L["Dire Maul"] = "厄運之槌"
L["Dire Maul: Capital Gardens"] = "厄運之槌：中心花園"
L["Dire Maul: Gordok Commons"] = "厄運之槌：戈多克平民區"
L["Dire Maul: Warpwood Quarter"] = "厄運之槌：杻木廣場"
L["Disable map fade while moving"] = "當移動時取消地圖淡出"
L["Disable reading emote when opening the map"] = "當開啟地圖時取消閱讀表情"
L["Dragon Soul"] = "巨龍之魂"
L["Drak'Tharon Keep"] = "德拉克薩隆要塞"
L["Dungeon"] = "地城"
L["End Time"] = "終焉之刻"
L["Eternal Guardian"] = "永恆守護者"
L["Evermoon Terrace"] = "永月露臺"
L["Eye of Azshara"] = "艾薩拉之眼"
L["Fade Frame"] = "淡出框架"
L["Fade map while moving"] = "當移動時淡出地圖"
L["Falanaar"] = "法拉納爾"
L["Felsoul Hold"] = "魔魂堡"
L["Firelands"] = "火源之界"
L["Gate of the Setting Sun"] = "落陽關"
L["Gnomeregan"] = "諾姆瑞根"
L["Green"] = "綠色"
L["Grim Batol"] = "格瑞姆巴托"
L["Grimrail Depot"] = "恐軌車站"
L["Gruul's Lair"] = "戈魯爾之巢"
L["Gundrak"] = "剛德拉克"
L["Gundrak (rear entrance)"] = "剛德拉克（後方入口）"
L["Halls of Lightning"] = "雷光大廳"
L["Halls of Origination"] = "起源大廳"
L["Halls of Stone"] = "石之大廳"
L["Halls of Valor"] = "英靈殿"
L["Heart of Fear"] = "恐懼之心"
L["Hellfire Citadel"] = "地獄火堡壘"
L["Hellfire Ramparts"] = "地獄火壁壘"
L["Highmaul"] = "天槌"
L["Hour of Twilight"] = "暮光之時"
L["Hyjal Summit"] = "海加爾山之戰"
L["Icecrown"] = "寒冰皇冠"
L["Icecrown Citadel"] = "冰冠城寨"
L["Icons"] = "圖示"
L["Invalid command.  Enter /ltm help for help."] = "無效的指令。輸入 /ltm help 取得幫助。"
L["Iron Docks"] = "鋼鐵碼頭"
L["Ironforge"] = "鐵爐堡"
L["Karazhan"] = "卡拉贊"
L["Large Scarab Coffer"] = "大型聖甲蟲箱"
L["Lion's Watch"] = "雄獅堡"
L["Lost City of the Tol'vir"] = "托維爾的失落之城"
L["Lower Blackrock Spire"] = "黑石塔下層"
L["Lunastre Estate"] = "路納斯特莊園"
L["Magisters' Terrace"] = "博學者殿堂"
L["Magtheridon's Lair"] = "瑪瑟里頓的巢穴"
L["Mana-Tombs"] = "法力墓地"
L["Map frame scale"] = "地圖框架縮放"
L["Map opacity while moving"] = "當移動時的地圖透明度"
L["Maraudon"] = "瑪拉頓"
L["Maraudon: Earth Song Falls"] = "瑪拉頓：毒水瀑布"
L["Maraudon: Foulspore Cavern"] = "瑪拉頓：毒菇洞穴"
L["Maraudon: The Wicked Grotto"] = "瑪拉頓：邪惡洞穴"
L["Memory Usage"] = "記憶體使用量"
L["Miscellaneous"] = "雜項"
L["Mogu'shan Palace"] = "魔古山宮"
L["Mogu'shan Vaults"] = "魔古山寶庫"
L["Molten Core"] = "熔火之心"
L["Moon Guard Stronghold"] = "月之守衛要塞"
L["Mount Hyjal"] = "海加爾山"
L["Naxxramas"] = "納克薩瑪斯"
L["NOTICE!|nYou must fully restart your game client before you can use this version of Leatrix Maps."] = "注意！|n您必須完全重新啟動遊戲客戶端才能使用此版本的Leatrix Maps。"
L["Old Hillsbrad Foothills"] = "希爾斯布萊德丘陵舊址"
L["Onyxia's Lair"] = "奧妮克希亞的巢穴"
L["Opacity"] = "透明度"
L["Orgrimmar"] = "奧格瑪"
L["Player"] = "玩家"
L["Portal"] = "傳送門"
L["Portal from Zephyr"] = "賽非爾的傳送門"
L["Preview"] = "預覽"
L["Ragefire Chasm"] = "怒焰裂谷"
L["Raid"] = "團隊副本"
L["Razorfen Downs"] = "剃刀高地"
L["Razorfen Kraul"] = "剃刀沼澤"
L["Red"] = "紅色"
L["Remember zoom level"] = "記憶縮放等級"
L["Rescale Map"] = "重新縮放地圖"
L["Rescale map frame"] = "重新縮放地圖框架"
L["Reset"] = "重置"
L["Reset Map Position"] = "重設地圖位置"
L["Return to Karazhan"] = "重返卡拉贊"
L["Reveal"] = "顯露"
L["Reveal Map"] = "揭露地圖"
L["Reveal unexplored areas of the map"] = "顯露地圖的未探索區域"
L["Ruins of Ahn'Qiraj"] = "安琪拉廢墟"
L["Ruins of Elune'eth"] = "伊露恩斯遺址"
L["Sanctum of Order"] = "秩序聖所"
L["Scale"] = "縮放比例"
L["Scarlet Halls"] = "血色大廳"
L["Scarlet Monastery"] = "血色修道院"
L["Scholomance"] = "通靈學院"
L["Serpentshrine Cavern"] = "毒蛇神殿洞穴"
L["Sethekk Halls"] = "塞司克大廳"
L["Settings"] = "設置"
L["Shado-Pan Monastery"] = "影潘僧院"
L["Shadow Labyrinth"] = "暗影迷宮"
L["Shadowfang Keep"] = "影牙城堡"
L["Shadowmoon Burial Grounds"] = "影月墓地"
L["Shal'Aran"] = "沙亞蘭"
L["Show coordinates"] = "顯示座標"
L["Show dungeon location icons"] = "顯示地城位置圖示"
L["Show map reveal toggle button"] = "顯示地圖顯露切換按紐"
L["Siege of Niuzao Temple"] = "圍攻怒兆寺"
L["Siege of Orgrimmar"] = "圍攻奧格瑪"
L["Skyreach"] = "擎天峰"
L["Slave Pens"] = "奴隸監牢"
L["Steamvault"] = "蒸氣洞窟"
L["Stormstout Brewery"] = "風暴烈酒酒坊"
L["Stormwind"] = "暴風城"
L["Stratholme: Crusader's Square"] = "斯坦索姆：十字軍廣場"
L["Stratholme: The Gauntlet"] = "斯坦索姆：The Gauntlet"
L["Sunwell Plateau"] = "太陽之井高地"
L["Tel'anor"] = "泰爾亞諾"
L["Tempest Keep"] = "風暴要塞"
L["Temple of Ahn'Qiraj"] = "安琪拉神廟"
L["Temple of Atal'Hakkar"] = "阿塔哈卡神廟"
L["Temple of the Jade Serpent"] = "玉蛟寺"
L["Terrace of Endless Spring"] = "豐泉台"
L["The Arcatraz"] = "亞克崔茲"
L["The Bastion of Twilight"] = "暮光堡壘"
L["The Black Morass"] = "黑色沼澤"
L["The Blood Furnace"] = "血熔爐"
L["The Botanica"] = "波塔尼卡"
L["The Culling of Stratholme"] = "斯坦索姆的抉擇"
L["The Deadmines"] = "死亡礦坑"
L["The Dragon Soul"] = "巨龍之魂"
L["The Everbloom"] = "永茂林"
L["The Eye"] = "暴風之眼"
L["The Eye of Eternity"] = "永恆之眼"
L["The Forge of Souls"] = "眾魂熔爐"
L["The Frozen Halls"] = "冰封大廳"
L["The Halls of Reflection"] = "鏡像大廳"
L["The Mechanar"] = "麥克納爾"
L["The Nexus"] = "奧核之心"
L["The Obsidian Sanctum"] = "黑曜聖所"
L["The Oculus"] = "奧核之眼"
L["The Old Kingdom"] = "古王國"
L["The Pit of Saron"] = "薩隆陷坑"
L["The Ruby Sanctum"] = "晶紅聖所"
L["The Shattered Halls"] = "破碎大廳"
L["The Stockade"] = "監獄"
L["The Stonecore"] = "石岩之心"
L["The Violet Hold"] = "紫羅蘭堡"
L["The Vortex Pinnacle"] = "漩渦尖塔"
L["The Waning Crescent"] = "弦月旅店"
L["Throne of the Four Winds"] = "四風王座"
L["Throne of the Tides"] = "海潮王座"
L["Throne of Thunder"] = "雷霆王座"
L["Thunder Bluff"] = "雷霆崖"
L["Tint unexplored areas"] = "未探索區域色調"
L["Tomb of Sargeras"] = "薩格拉斯之墓"
L["Transparency"] = "透明度"
L["Trial of the Champion"] = "勇士試煉"
L["Trial of the Crusader"] = "十字軍試煉"
L["Twilight Vineyards"] = "暮光葡萄園"
L["Uldaman"] = "奧達曼"
L["Ulduar"] = "奧杜亞"
L["Underbog"] = "幽暗沼澤"
L["Undercity"] = "幽暗城"
L["Upper Blackrock Spire"] = "黑石塔上層"
L["Utgarde Keep"] = "俄特加德要塞"
L["Utgarde Pinnacle"] = "俄特加德之巔"
L["Vault of Archavon"] = "亞夏梵穹殿"
L["Version"] = "版本"
L["Vol'mar"] = "沃爾瑪"
L["Wailing Caverns"] = "哀嚎洞穴"
L["Well of Eternity"] = "永恆之井"
L["Wyrmrest Temple"] = "龍眠神殿"
L["Your UI needs to be reloaded."] = "您的UI需要重載。"
L["Zul'Aman"] = "祖阿曼"
L["Zul'Farrak"] = "祖爾法拉克"
L["Zul'Gurub"] = "祖爾格拉布"

end

-- ruRU: Russian
if GameLocale == "ruRU" then
L["Astravar Harbor"] = "Гавань Астравар"
L["Auchenai Crypts"] = "Аукенайские гробницы"
L["Auchindoun"] = "Аукиндон"
L["Azjol-Nerub"] = "Азжол-Неруб"
L["Baradin Hold"] = "Крепость Барадин"
L["Black Morass"] = "Черные топи"
L["Black Temple"] = "Черный храм"
L["Blackfathom Deeps"] = "Непроглядная Пучина"
L["Blackrock Caverns"] = "Пещеры Черной горы"
L["Blackrock Depths"] = "Глубины Черной горы"
L["Blackrock Foundry"] = "Литейная клана Черной горы"
L["Blackrock Mountain"] = "Черная гора"
L["Blackrock Spire"] = "Пик Черной горы"
L["Blackwing Descent"] = "Твердыня Крыла Тьмы"
L["Blackwing Lair"] = "Логово Крыла Тьмы"
L["Bloodmaul Slag Mines"] = "Шлаковые шахты Кровавого Молота"
L["Caverns of Time"] = "Пещеры Времени"
L["Coilfang Reservoir"] = "Резервуар Кривого Клыка"
L["Culling of Stratholme"] = "Очищение Стратхольма"
L["Darnassus"] = "Дарнас"
L["Dire Maul"] = "Забытый Город"
L["Dire Maul: Capital Gardens"] = "Забытый Город (Центральный сад)"
L["Dire Maul: Gordok Commons"] = "Забытый Город (Палаты Гордока)"
L["Dire Maul: Warpwood Quarter"] = "Забытый Город (Квартал Криводревов)"
L["Dragon Soul"] = "Душа Дракона"
L["Drak'Tharon Keep"] = "Крепость Драк'Тарон"
L["End Time"] = "Конец Времен"
L["Eternal Guardian"] = "Вечный страж"
L["Evermoon Terrace"] = "терраса Вечной Луны"
L["Eye of Azshara"] = "Око Азшары"
L["Falanaar"] = "Фаланаар"
L["Felsoul Hold"] = "оплот Оскверненной Души"
L["Firelands"] = "Огненные Просторы"
L["Gate of the Setting Sun"] = "Врата Заходящего Солнца"
L["Gnomeregan"] = "Гномреган"
L["Grim Batol"] = "Грим Батол"
L["Grimrail Depot"] = "Депо Мрачных Путей"
L["Gruul's Lair"] = "Логово Груула"
L["Gundrak"] = "Гундрак"
L["Gundrak (rear entrance)"] = "Гундрак: черный ход"
L["Halls of Lightning"] = "Чертоги Молний"
L["Halls of Origination"] = "Чертоги Созидания"
L["Halls of Stone"] = "Чертоги Камня"
L["Halls of Valor"] = "Чертоги Доблести"
L["Heart of Fear"] = "Сердце Страха"
L["Hellfire Citadel"] = "Цитадель Адского Пламени"
L["Hellfire Ramparts"] = "Бастионы Адского Пламени"
L["Highmaul"] = "Земли клана Верховного Молота"
L["Hour of Twilight"] = "Время Сумерек"
L["Hyjal Summit"] = "Вершина Хиджала"
L["Icecrown"] = "Ледяная Корона"
L["Icecrown Citadel"] = "Цитадель Ледяной Короны"
L["Iron Docks"] = "Железные доки"
L["Ironforge"] = "Стальгорн"
L["Karazhan"] = "Каражан"
L["Lion's Watch"] = "Львиный дозор"
L["Lost City of the Tol'vir"] = "Затерянный город Тол'вир"
L["Lower Blackrock Spire"] = "Нижняя часть пика Черной горы"
L["Lunastre Estate"] = "поместья Лунархов"
L["Magisters' Terrace"] = "Терраса Магистров"
L["Magtheridon's Lair"] = "Логово Магтеридона"
L["Mana-Tombs"] = "Гробницы Маны"
L["Maraudon"] = "Мародон"
L["Maraudon: Earth Song Falls"] = "Мародон (Поющие водопады)"
L["Maraudon: Foulspore Cavern"] = "Мародон (Зловонная пещера)"
L["Maraudon: The Wicked Grotto"] = "Мародон (Оскверненный грот)"
L["Mogu'shan Palace"] = "Дворец Могу'шан"
L["Mogu'shan Vaults"] = "Подземелья Могу'шан"
L["Molten Core"] = "Огненные Недра"
L["Mount Hyjal"] = "Гора Хиджал"
L["Naxxramas"] = "Наксрамас"
L["Old Hillsbrad Foothills"] = "Старые предгорья Хилсбрада"
L["Onyxia's Lair"] = "Логово Ониксии"
L["Orgrimmar"] = "Оргриммар"
L["Portal"] = "Портал"
L["Ragefire Chasm"] = "Огненная Пропасть"
L["Razorfen Downs"] = "Курганы Иглошкурых"
L["Razorfen Kraul"] = "Лабиринты Иглошкурых"
L["Return to Karazhan"] = "Транспорт: флагманский корабль Легиона"
L["Ruins of Ahn'Qiraj"] = "Руины Ан'Киража"
L["Ruins of Elune'eth"] = "руины Элун'ета"
L["Sanctum of Order"] = "Святилища Порядка"
L["Scarlet Halls"] = "Залы Алого ордена"
L["Scarlet Monastery"] = "Монастырь Алого ордена"
L["Scholomance"] = "Некроситет"
L["Serpentshrine Cavern"] = "Змеиное святилище"
L["Sethekk Halls"] = "Сетеккские залы"
L["Shado-Pan Monastery"] = "Монастырь Шадо-Пан"
L["Shadow Labyrinth"] = "Темный лабиринт"
L["Shadowfang Keep"] = "Крепость Темного Клыка"
L["Shadowmoon Burial Grounds"] = "Некрополь Призрачной Луны"
L["Shal'Aran"] = "Шал'Аран"
L["Siege of Niuzao Temple"] = "Осада храма Нюцзао"
L["Siege of Orgrimmar"] = "Осада Оргриммара"
L["Skyreach"] = "Небесный Путь"
L["Slave Pens"] = "Узилище"
L["Steamvault"] = "Паровое подземелье"
L["Stormstout Brewery"] = "Хмелеварня Буйных Портеров"
L["Stormwind"] = "Штормград"
L["Stratholme: Crusader's Square"] = "Стратхольм – Главные врата"
L["Stratholme: The Gauntlet"] = "Стратхольм – черный ход"
L["Sunwell Plateau"] = "Плато Солнечного Колодца"
L["Tel'anor"] = "Тел'анор"
L["Tempest Keep"] = "Крепость Бурь"
L["Temple of Ahn'Qiraj"] = "Храм Ан'Кираж"
L["Temple of Atal'Hakkar"] = "Затонувший храм"
L["Temple of the Jade Serpent"] = "Храм Зин-Малор"
L["Terrace of Endless Spring"] = "Терраса Вечной Весны"
L["The Arcatraz"] = "Аркатрац"
L["The Bastion of Twilight"] = "Сумеречный бастион"
L["The Black Morass"] = "Черные топи"
L["The Blood Furnace"] = "Кузня Крови"
L["The Botanica"] = "Ботаника"
L["The Culling of Stratholme"] = "Очищение Стратхольма"
L["The Deadmines"] = "Мертвые копи"
L["The Dragon Soul"] = "Душа Дракона"
L["The Everbloom"] = "Вечное Цветение"
L["The Eye"] = "Око"
L["The Eye of Eternity"] = "Око Вечности"
L["The Forge of Souls"] = "Кузня Душ"
L["The Frozen Halls"] = "Ледяные залы"
L["The Halls of Reflection"] = "Залы Отражений"
L["The Mechanar"] = "Механар"
L["The Nexus"] = "Нексус"
L["The Obsidian Sanctum"] = "Обсидиановое святилище"
L["The Oculus"] = "Окулус"
L["The Old Kingdom"] = "Ан'кахет: Старое Королевство"
L["The Pit of Saron"] = "Яма Сарона"
L["The Ruby Sanctum"] = "Рубиновое святилище"
L["The Shattered Halls"] = "Разрушенные залы"
L["The Stockade"] = "Тюрьма"
L["The Stonecore"] = "Каменные Недра"
L["The Violet Hold"] = "Аметистовая крепость"
L["The Vortex Pinnacle"] = "Вершина Смерча"
L["The Waning Crescent"] = "Лунный полумрак"
L["Throne of the Four Winds"] = "Трон Четырех Ветров"
L["Throne of the Tides"] = "Трон Приливов"
L["Throne of Thunder"] = "Престол Гроз"
L["Thunder Bluff"] = "Громовой Утес"
L["Tomb of Sargeras"] = "Гробница Саргераса"
L["Trial of the Champion"] = "Испытание чемпиона"
L["Trial of the Crusader"] = "Испытание крестоносца"
L["Twilight Vineyards"] = "Сумеречные виноградники"
L["Uldaman"] = "Ульдаман"
L["Ulduar"] = "Ульдуар"
L["Underbog"] = "Нижетопь"
L["Undercity"] = "Подгород"
L["Upper Blackrock Spire"] = "Верхняя часть пика Черной горы"
L["Utgarde Keep"] = "Крепость Утгард"
L["Utgarde Pinnacle"] = "Вершина Утгард"
L["Vault of Archavon"] = "Склеп Аркавона"
L["Vol'mar"] = "Вол'мар"
L["Wailing Caverns"] = "Пещеры Стенаний"
L["Well of Eternity"] = "Источник Вечности"
L["Wyrmrest Temple"] = "Храм Драконьего Покоя"
L["Zul'Aman"] = "Зул'Аман"
L["Zul'Farrak"] = "Зул'Фаррак"
L["Zul'Gurub"] = "Зул'Гуруб"

end

-- koKR: Korean
if GameLocale == "koKR" then
L["/ltm help - Show this information."] = "/ltm help - 정보 표시."
L["/ltm reset - Reset the panel position."] = "/ltm reset - 패널 위치 재설정."
L["/ltm wipe - Wipe all settings and reload."] = "/ltm wipe - 모든 설정 지우고 리로드."
L["A stop error has occurred but no need to worry.  It can happen from time to time.  Click the reload button to resolve it."] = "정지 오류가 발생했지만 걱정할 필요가 없습니다. 때때로 발생할 수 있습니다. 문제를 해결하려면 리로드 버튼을 클릭하십시오."
L["Alpha"] = "투명도"
L["Astravar Harbor"] = "아스트라바르 항구"
L["Auchenai Crypts"] = "아키나이 납골당"
L["Auchindoun"] = "아킨둔"
L["Azjol-Nerub"] = "아졸네룹"
L["Back to Main Menu"] = "주 메뉴로 돌아가기"
L["Baradin Hold"] = "바라딘 요새"
L["Black Morass"] = "검은늪"
L["Black Temple"] = "검은 사원"
L["Blackfathom Deeps"] = "검은 심연 나락"
L["Blackrock Caverns"] = "검은바위 동굴"
L["Blackrock Depths"] = "검은바위 나락"
L["Blackrock Foundry"] = "검은바위 용광로"
L["Blackrock Mountain"] = "검은바위 산"
L["Blackrock Spire"] = "검은바위 첨탑"
L["Blackwing Descent"] = "검은날개 강림지"
L["Blackwing Lair"] = "검은날개 둥지"
L["Bloodmaul Slag Mines"] = "피망치 잿가루 광산"
L["Blue"] = "블루"
L["Caverns of Time"] = "시간의 동굴"
L["Classic"] = "클래식"
L["Coilfang Reservoir"] = "갈퀴 송곳니 저수지"
L["Configuration Panel"] = "설정창"
L["Culling of Stratholme"] = "옛 스트라솔름"
L["Darnassus"] = "다르나서스"
L["Dire Maul"] = "혈투의 전장"
L["Dire Maul: Capital Gardens"] = "혈투의 전장:수도정원"
L["Dire Maul: Gordok Commons"] = "혈투의 전장:고르독 광장"
L["Dire Maul: Warpwood Quarter"] = "혈투의 전장:굽이나무 지구"
L["Disable map fade while moving"] = "이동시 지도 사라짐 사용안함."
L["Disable reading emote when opening the map"] = "지도 볼때 감정표현(모션) 사용안함"
L["Dragon Soul"] = "용의 영혼"
L["Drak'Tharon Keep"] = "드락타론 성채"
L["Dungeon"] = "던전"
L["End Time"] = "시간의 끝"
L["Eternal Guardian"] = "영원의 수호자"
L["Evermoon Terrace"] = "영원달 정원"
L["Eye of Azshara"] = "아즈샤라의 눈"
L["Falanaar"] = "팔라나아르"
L["Felsoul Hold"] = "지옥영혼 요새"
L["Firelands"] = "불의 땅"
L["Gate of the Setting Sun"] = "석양문"
L["Gnomeregan"] = "놈리건"
L["Green"] = "그린"
L["Grim Batol"] = "그림 바톨"
L["Grimrail Depot"] = "파멸철로 정비소"
L["Gruul's Lair"] = "그룰의 둥지"
L["Gundrak"] = "군드락"
L["Gundrak (rear entrance)"] = "군드락(후문)"
L["Halls of Lightning"] = "번개의 전당"
L["Halls of Origination"] = "시초의 전당"
L["Halls of Stone"] = "돌의 전당"
L["Halls of Valor"] = "용맹의 전당"
L["Heart of Fear"] = "공포의 심장"
L["Hellfire Citadel"] = "지옥불 성채"
L["Hellfire Ramparts"] = "지옥불 성루"
L["Highmaul"] = "높은 망치"
L["Hour of Twilight"] = "황혼의 시간"
L["Hyjal Summit"] = "하이잘 정상"
L["Icecrown"] = "얼음왕관"
L["Icecrown Citadel"] = "얼음왕관 성채"
L["Icons"] = "아이콘"
L["Invalid command.  Enter /ltm help for help."] = "잘못된 명령입니다.도움말을 확인하세요. /ltm help"
L["Iron Docks"] = "강철 선착장"
L["Ironforge"] = "아이언포지"
L["Karazhan"] = "카라잔"
L["Large Scarab Coffer"] = "큰 스카라베 상자"
L["Lion's Watch"] = "사자의 감시터"
L["Lost City of the Tol'vir"] = "토비르의 잃어버린 도시"
L["Lower Blackrock Spire"] = "검은바위 첨탑 하층"
L["Lunastre Estate"] = "루나스트르 장원"
L["Magisters' Terrace"] = "마법학자의 정원"
L["Magtheridon's Lair"] = "마그테리돈의 둥지"
L["Mana-Tombs"] = "마나 무덤"
L["Maraudon"] = "마라우돈"
L["Maraudon: Earth Song Falls"] = "마라우돈:대지노래 폭포"
L["Maraudon: Foulspore Cavern"] = "마라우돈:썩은포자 동굴"
L["Maraudon: The Wicked Grotto"] = "마라우돈:악의 동굴"
L["Miscellaneous"] = "기타"
L["Mogu'shan Palace"] = "모구샨 궁전"
L["Mogu'shan Vaults"] = "모구샨 금고"
L["Molten Core"] = "화산 심장부"
L["Moon Guard Stronghold"] = "달빛 수호자 성채"
L["Mount Hyjal"] = "하이잘 산"
L["Naxxramas"] = "낙스라마스"
L["NOTICE!|nYou must fully restart your game client before you can use this version of Leatrix Maps."] = "주의!|nLeatrix Maps 이 버전을 적용하려면 게임 클라이언트를 다시 시작해야합니다."
L["Old Hillsbrad Foothills"] = "옛 언덕마루 구릉지"
L["Onyxia's Lair"] = "오닉시아의 둥지"
L["Orgrimmar"] = "오그리마"
L["Portal"] = "차원문"
L["Portal from Zephyr"] = "제피르의 포탈"
L["Preview"] = "미리보기"
L["Ragefire Chasm"] = "성난불길 협곡"
L["Raid"] = "공격대"
L["Razorfen Downs"] = "가시덩굴 구릉"
L["Razorfen Kraul"] = "가시덩굴 우리"
L["Red"] = "레드"
L["Reset"] = "리셋"
L["Return to Karazhan"] = "다시 찾은 카라잔"
L["Reveal"] = "미탐험 지역"
L["Reveal Map"] = "미탐험 지역"
L["Reveal unexplored areas of the map"] = "미탐험 지역 밝힘"
L["Ruins of Ahn'Qiraj"] = "안퀴라즈 폐허"
L["Ruins of Elune'eth"] = "엘룬에스의 페허"
L["Sanctum of Order"] = "질서의 성소"
L["Scarlet Halls"] = "붉은십자군 전당"
L["Scarlet Monastery"] = "붉은십자군 수도원"
L["Scholomance"] = "스칼로맨스"
L["Serpentshrine Cavern"] = "불뱀 제단"
L["Sethekk Halls"] = "세데크 전당"
L["Settings"] = "설정"
L["Shado-Pan Monastery"] = "음영파 수도원"
L["Shadow Labyrinth"] = "어둠의 미궁"
L["Shadowfang Keep"] = "그림자송곳니 성채"
L["Shadowmoon Burial Grounds"] = "어둠달 지하묘지"
L["Shal'Aran"] = "샬아란"
L["Show map reveal toggle button"] = "미탐험 지역 밝힘 버튼 표시"
L["Siege of Niuzao Temple"] = "니우짜오 사원 공성전투"
L["Siege of Orgrimmar"] = "오그리마 공성전"
L["Skyreach"] = "하늘탑"
L["Slave Pens"] = "강제 노역소"
L["Steamvault"] = "증기 저장고"
L["Stormstout Brewery"] = "스톰스타우트 양조장"
L["Stormwind"] = "스톰윈드"
L["Stratholme: Crusader's Square"] = "스트라솔름:십자군 광장"
L["Stratholme: The Gauntlet"] = "스트라솔름:투쟁의 거리"
L["Sunwell Plateau"] = "태양샘 고원"
L["Tel'anor"] = "텔아노르"
L["Tempest Keep"] = "폭풍우 요새"
L["Temple of Ahn'Qiraj"] = "안퀴라즈"
L["Temple of Atal'Hakkar"] = "아탈학카르 신전"
L["Temple of the Jade Serpent"] = "옥룡사"
L["Terrace of Endless Spring"] = "영원한 봄의 정원"
L["The Arcatraz"] = "알카트라즈"
L["The Bastion of Twilight"] = "황혼의 요새"
L["The Black Morass"] = "검은늪"
L["The Blood Furnace"] = "피의 용광로"
L["The Botanica"] = "신록의 정원"
L["The Culling of Stratholme"] = "옛 스트라솔름"
L["The Deadmines"] = "죽음의 폐광"
L["The Dragon Soul"] = "용의 영혼"
L["The Everbloom"] = "상록숲"
L["The Eye"] = "폭풍우 요새"
L["The Eye of Eternity"] = "영원의 눈"
L["The Forge of Souls"] = "영혼의 제련소"
L["The Frozen Halls"] = "얼어붙은 전당"
L["The Halls of Reflection"] = "투영의 전당"
L["The Mechanar"] = "메카나르"
L["The Nexus"] = "마력의 탑"
L["The Obsidian Sanctum"] = "흑요석 성소"
L["The Oculus"] = "마력의 눈"
L["The Old Kingdom"] = "고대 왕국"
L["The Pit of Saron"] = "사론의 구덩이"
L["The Ruby Sanctum"] = "루비 성소"
L["The Shattered Halls"] = "으스러진 손의 전당"
L["The Stockade"] = "지하감옥"
L["The Stonecore"] = "바위심장부"
L["The Violet Hold"] = "보랏빛 요새"
L["The Vortex Pinnacle"] = "소용돌이 누각"
L["The Waning Crescent"] = "기우는 초승달"
L["Throne of the Four Winds"] = "네 바람의 왕좌"
L["Throne of the Tides"] = "파도의 왕좌"
L["Throne of Thunder"] = "천둥의 왕좌"
L["Thunder Bluff"] = "썬더 블러프"
L["Tint unexplored areas"] = "미탐험지역 색상"
L["Tomb of Sargeras"] = "살게라스의 무덤"
L["Transparency"] = "투명도"
L["Trial of the Champion"] = "용사의 시험장"
L["Trial of the Crusader"] = "십자군의 시험장"
L["Twilight Vineyards"] = "황혼의 포도원"
L["Uldaman"] = "울다만"
L["Ulduar"] = "울두아르"
L["Underbog"] = "지하수렁"
L["Undercity"] = "언더시티"
L["Upper Blackrock Spire"] = "검은바위 첨탑 상층"
L["Utgarde Keep"] = "우트가드 성채"
L["Utgarde Pinnacle"] = "우트가드 첨탑"
L["Vault of Archavon"] = "아카본 석실"
L["Version"] = "버전"
L["Vol'mar"] = "볼마르"
L["Wailing Caverns"] = "통곡의 동굴"
L["Well of Eternity"] = "영원의 샘"
L["Wyrmrest Temple"] = "고룡쉼터 사원"
L["Your UI needs to be reloaded."] = "UI를 리로드 해야 합니다."
L["Zul'Aman"] = "줄아만"
L["Zul'Farrak"] = "줄파락"
L["Zul'Gurub"] = "줄구룹"

end

-- deDE: German
if GameLocale == "deDE" then

end

-- esMX: Spanish (Mexico)
if GameLocale == "esMX" then

end

-- esES: Spanish (Spain)
if GameLocale == "esES" then

end

-- frFR: French
if GameLocale == "frFR" then

end

-- itIT: Italian
if GameLocale == "itIT" then

end

-- ptBR: Portugese (Brazil)
if GameLocale == "ptBR" then

end
