/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.iptc;

import com.drew.lang.BufferBoundsException;
import com.drew.lang.BufferReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataReader;
import com.drew.metadata.iptc.IptcDirectory;
import java.util.Date;
import java.util.GregorianCalendar;

public class IptcReader
implements MetadataReader {
    @Override
    public void extract(@NotNull BufferReader bufferReader, @NotNull Metadata metadata) {
        IptcDirectory iptcDirectory = metadata.getOrCreateDirectory(IptcDirectory.class);
        int n = 0;
        while ((long)n < bufferReader.getLength()) {
            int n2;
            short s;
            short s2;
            short s3;
            try {
                s3 = bufferReader.getUInt8(n);
            }
            catch (BufferBoundsException bufferBoundsException) {
                iptcDirectory.addError("Unable to read starting byte of IPTC tag");
                break;
            }
            if (s3 != 28) {
                iptcDirectory.addError("Invalid start to IPTC tag");
                break;
            }
            if ((long)(n + 5) >= bufferReader.getLength()) {
                iptcDirectory.addError("Too few bytes remain for a valid IPTC tag");
                break;
            }
            ++n;
            try {
                s2 = bufferReader.getUInt8(n++);
                s = bufferReader.getUInt8(n++);
                n2 = bufferReader.getUInt16(n);
            }
            catch (BufferBoundsException bufferBoundsException) {
                iptcDirectory.addError("IPTC data segment ended mid-way through tag descriptor");
                return;
            }
            if ((long)((n += 2) + n2) > bufferReader.getLength()) {
                iptcDirectory.addError("Data for tag extends beyond end of IPTC segment");
                break;
            }
            try {
                this.processTag(bufferReader, iptcDirectory, s2, s, n, n2);
            }
            catch (BufferBoundsException bufferBoundsException) {
                iptcDirectory.addError("Error processing IPTC tag");
                break;
            }
            n += n2;
        }
    }

    private void processTag(@NotNull BufferReader bufferReader, @NotNull Directory directory, int n, int n2, int n3, int n4) throws BufferBoundsException {
        String[] stringArray;
        int n5 = n2 | n << 8;
        switch (n5) {
            case 512: {
                int n6 = bufferReader.getUInt16(n3);
                directory.setInt(n5, n6);
                return;
            }
            case 522: {
                directory.setInt(n5, bufferReader.getUInt8(n3));
                return;
            }
            case 542: 
            case 567: {
                if (n4 < 8) break;
                stringArray = bufferReader.getString(n3, n4);
                try {
                    int n7 = Integer.parseInt(stringArray.substring(0, 4));
                    int n8 = Integer.parseInt(stringArray.substring(4, 6)) - 1;
                    int n9 = Integer.parseInt(stringArray.substring(6, 8));
                    Date date = new GregorianCalendar(n7, n8, n9).getTime();
                    directory.setDate(n5, date);
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        String string = n4 < 1 ? "" : bufferReader.getString(n3, n4, System.getProperty("file.encoding"));
        if (directory.containsTag(n5)) {
            String[] stringArray2;
            stringArray = directory.getStringArray(n5);
            if (stringArray == null) {
                stringArray2 = new String[1];
            } else {
                stringArray2 = new String[stringArray.length + 1];
                System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            }
            stringArray2[stringArray2.length - 1] = string;
            directory.setStringArray(n5, stringArray2);
        } else {
            directory.setString(n5, string);
        }
    }
}

