/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.weapons.ai;

import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipCommand;
import data.scripts.util.SWP_Util;
import data.scripts.weapons.ai.SWP_BaseMissile;
import java.util.List;
import org.lazywizard.lazylib.FastTrig;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lazywizard.lazylib.combat.AIUtils;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class SWP_HornetAI
extends SWP_BaseMissile {
    private static final float FIRE_INACCURACY = 3.0f;
    private static final float LEAD_GUIDANCE_FACTOR = 0.5f;
    private static final float LEAD_GUIDANCE_FACTOR_FROM_ECCM = 0.25f;
    private static final float VELOCITY_DAMPING_FACTOR = 0.25f;
    private final float inaccuracy;
    private float timeAccum = 0.0f;
    private float weaveSineAAmplitude = 22.5f;
    private final float weaveSineAPeriod;
    private final float weaveSineAPhase = (float)(Math.random() * Math.PI * 2.0);
    private float weaveSineBAmplitude = 22.5f;
    private final float weaveSineBPeriod;
    private final float weaveSineBPhase = (float)(Math.random() * Math.PI * 2.0);

    public SWP_HornetAI(MissileAPI missile, ShipAPI launchingShip) {
        super(missile, launchingShip);
        float totalAmp = this.weaveSineAAmplitude + this.weaveSineBAmplitude;
        this.weaveSineAAmplitude = MathUtils.getRandomNumberInRange((float)0.0f, (float)totalAmp);
        this.weaveSineBAmplitude = totalAmp - this.weaveSineAAmplitude;
        this.weaveSineAPeriod = MathUtils.getRandomNumberInRange((float)2.0f, (float)4.0f);
        this.weaveSineBPeriod = MathUtils.getRandomNumberInRange((float)0.5f, (float)2.0f);
        this.inaccuracy = MathUtils.getRandomNumberInRange((float)-3.0f, (float)3.0f);
    }

    @Override
    public void advance(float amount) {
        Vector2f guidedTarget;
        if (this.missile.isFizzling() || this.missile.isFading()) {
            return;
        }
        this.timeAccum += amount;
        if (!this.acquireTarget(amount)) {
            this.missile.giveCommand(ShipCommand.ACCELERATE);
            return;
        }
        float distance = MathUtils.getDistance((Vector2f)this.target.getLocation(), (Vector2f)this.missile.getLocation());
        float guidance = 0.5f;
        if (this.missile.getSource() != null) {
            guidance += Math.min(this.missile.getSource().getMutableStats().getMissileGuidance().getModifiedValue() - this.missile.getSource().getMutableStats().getMissileGuidance().getBaseValue(), 1.0f) * 0.25f;
        }
        if ((guidedTarget = SWP_HornetAI.intercept(this.missile.getLocation(), this.missile.getVelocity().length(), this.target.getLocation(), this.target.getVelocity())) == null) {
            Vector2f projection = new Vector2f((ReadableVector2f)this.target.getVelocity());
            float scalar = distance / (this.missile.getVelocity().length() + 1.0f);
            projection.scale(scalar);
            guidedTarget = Vector2f.add((Vector2f)this.target.getLocation(), (Vector2f)projection, null);
        }
        Vector2f.sub((Vector2f)guidedTarget, (Vector2f)this.target.getLocation(), (Vector2f)guidedTarget);
        guidedTarget.scale(guidance);
        Vector2f.add((Vector2f)guidedTarget, (Vector2f)this.target.getLocation(), (Vector2f)guidedTarget);
        float adjustedDistance = MathUtils.getDistance((CombatEntityAPI)this.target, (CombatEntityAPI)this.missile);
        float weaveLevel = 1.0f;
        if (adjustedDistance >= 1000.0f) {
            weaveLevel = 0.0f;
        } else if (adjustedDistance >= 500.0f) {
            weaveLevel = SWP_Util.lerp(1.0f, 0.0f, (adjustedDistance - 500.0f) / 500.0f);
        }
        float weaveSineA = this.weaveSineAAmplitude * (float)FastTrig.sin((double)(Math.PI * 2 * (double)this.timeAccum / (double)this.weaveSineAPeriod + (double)this.weaveSineAPhase));
        float weaveSineB = this.weaveSineBAmplitude * (float)FastTrig.sin((double)(Math.PI * 2 * (double)this.timeAccum / (double)this.weaveSineBPeriod + (double)this.weaveSineBPhase));
        float weaveOffset = (weaveSineA + weaveSineB) * weaveLevel;
        float angularDistance = MathUtils.getShortestRotation((float)this.missile.getFacing(), (float)MathUtils.clampAngle((float)(VectorUtils.getAngle((Vector2f)this.missile.getLocation(), (Vector2f)guidedTarget) + weaveOffset + (1.0f - weaveLevel) * this.inaccuracy)));
        float absDAng = Math.abs(angularDistance);
        this.missile.giveCommand(angularDistance < 0.0f ? ShipCommand.TURN_RIGHT : ShipCommand.TURN_LEFT);
        this.missile.giveCommand(ShipCommand.ACCELERATE);
        if (absDAng < Math.abs(this.missile.getAngularVelocity()) * 0.25f * (1.0f - weaveLevel) && 1.0f - weaveLevel > 0.01f) {
            this.missile.setAngularVelocity(angularDistance / (0.25f * (1.0f - weaveLevel)));
        }
    }

    protected ShipAPI findBestTarget() {
        ShipAPI best = null;
        float bestWeight = 0.0f;
        List ships = AIUtils.getEnemiesOnMap((CombatEntityAPI)this.missile);
        float maxDistance = this.getRemainingRange() + this.missile.getMaxSpeed() * 2.0f;
        int size = ships.size();
        for (int i = 0; i < size; ++i) {
            float weight;
            float mod;
            ShipAPI tmp = (ShipAPI)ships.get(i);
            if (!this.isTargetValid((CombatEntityAPI)tmp)) {
                mod = 0.0f;
            } else {
                switch (tmp.getHullSize()) {
                    case FIGHTER: {
                        mod = 1.0f;
                        break;
                    }
                    case FRIGATE: {
                        mod = 15.0f;
                        break;
                    }
                    case DESTROYER: {
                        mod = 13.0f;
                        break;
                    }
                    case CRUISER: {
                        mod = 12.0f;
                        break;
                    }
                    case CAPITAL_SHIP: {
                        mod = 10.0f;
                        break;
                    }
                    default: {
                        mod = 0.0f;
                    }
                }
            }
            float distance = MathUtils.getDistance((CombatEntityAPI)tmp, (Vector2f)this.missile.getLocation());
            if (distance > maxDistance || !((weight = 2500.0f / Math.max(distance, 250.0f) * mod) > bestWeight)) continue;
            best = tmp;
            bestWeight = weight;
        }
        return best;
    }
}

