/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.weapons.ai;

import com.fs.starfarer.api.combat.AutofireAIPlugin;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import java.util.List;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lwjgl.util.vector.Vector2f;

public class SWP_FlareGunWeaponAI
implements AutofireAIPlugin {
    private static final float AIMING_RANGE = 600.0f;
    private static final float OPTIMAL_RANGE = 400.0f;
    private boolean shouldFire = false;
    private CombatEntityAPI target = null;
    private final WeaponAPI weapon;

    public SWP_FlareGunWeaponAI(WeaponAPI weapon) {
        this.weapon = weapon;
    }

    public void advance(float amount) {
        float aimingRange = this.weapon.getShip().getMutableStats().getMissileWeaponRangeBonus().computeEffective(600.0f);
        this.shouldFire = false;
        if (this.weapon.getAmmo() <= 0) {
            return;
        }
        float totalWeight = 0.0f;
        float bestWeight = 0.0f;
        MissileAPI bestMissile = null;
        List missiles = CombatUtils.getMissilesWithinRange((Vector2f)this.weapon.getLocation(), (float)aimingRange);
        for (MissileAPI missile : missiles) {
            if (missile.getOwner() == this.weapon.getShip().getOwner()) continue;
            float distanceFromArc = this.weapon.distanceFromArc(missile.getLocation());
            float distance = MathUtils.getDistance((CombatEntityAPI)missile, (Vector2f)this.weapon.getLocation());
            float weight = (240.0f - distanceFromArc) / 240.0f;
            if (!((weight *= (400.0f - Math.abs(distance - 400.0f)) / 400.0f) > 0.0f)) continue;
            if (missile.isFlare()) {
                totalWeight += (weight *= 200.0f);
                if (!(weight > bestWeight)) continue;
                bestMissile = missile;
                bestWeight = weight;
                continue;
            }
            totalWeight += (weight *= (missile.getDamageType() == DamageType.FRAGMENTATION ? 0.25f : 1.0f) * missile.getDamageAmount() + 0.5f * missile.getEmpAmount());
            if (!(weight > bestWeight)) continue;
            bestMissile = missile;
            bestWeight = weight;
        }
        if (bestWeight >= 200.0f || totalWeight >= 750.0f) {
            this.target = bestMissile;
            if (bestMissile != null && (MathUtils.getShortestRotation((float)this.weapon.getCurrAngle(), (float)VectorUtils.getAngle((Vector2f)this.weapon.getLocation(), (Vector2f)bestMissile.getLocation())) <= 30.0f || this.weapon.getSlot().isHardpoint())) {
                this.shouldFire = true;
            }
        }
    }

    public void forceOff() {
        this.shouldFire = false;
    }

    public Vector2f getTarget() {
        if (this.target == null) {
            return null;
        }
        return this.target.getLocation();
    }

    public ShipAPI getTargetShip() {
        return null;
    }

    public WeaponAPI getWeapon() {
        return this.weapon;
    }

    public boolean shouldFire() {
        return this.shouldFire;
    }
}

