/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.weapons.ai;

import com.fs.starfarer.api.combat.AutofireAIPlugin;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import java.util.List;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lwjgl.util.vector.Vector2f;

public class SWP_FlareBurstWeaponAI
implements AutofireAIPlugin {
    private static final float AIMING_RANGE = 2000.0f;
    private static final float OPTIMAL_RANGE = 1000.0f;
    private boolean shouldFire = false;
    private CombatEntityAPI target = null;
    private final WeaponAPI weapon;

    public SWP_FlareBurstWeaponAI(WeaponAPI weapon) {
        this.weapon = weapon;
    }

    public void advance(float amount) {
        float aimingRange = this.weapon.getShip().getMutableStats().getMissileWeaponRangeBonus().computeEffective(2000.0f);
        this.shouldFire = false;
        if (this.weapon.getAmmo() <= 0) {
            return;
        }
        float totalWeight = 0.0f;
        float bestWeight = 0.0f;
        MissileAPI bestMissile = null;
        List missiles = CombatUtils.getMissilesWithinRange((Vector2f)this.weapon.getLocation(), (float)aimingRange);
        for (MissileAPI missile : missiles) {
            if (missile.getOwner() == this.weapon.getShip().getOwner()) continue;
            float distanceFromArc = this.weapon.distanceFromArc(missile.getLocation());
            float distance = MathUtils.getDistance((CombatEntityAPI)missile, (Vector2f)this.weapon.getLocation());
            float weight = (480.0f - distanceFromArc) / 480.0f;
            if (!((weight *= (1000.0f - Math.abs(distance - 1000.0f)) / 1000.0f) > 0.0f)) continue;
            if (missile.isFlare()) {
                totalWeight += (weight *= (float)Math.sqrt(200.0));
                if (!(weight > bestWeight)) continue;
                bestMissile = missile;
                bestWeight = weight;
                continue;
            }
            totalWeight += (weight *= (missile.getDamageType() == DamageType.FRAGMENTATION ? 0.25f : 1.0f) * missile.getDamageAmount() + 0.5f * missile.getEmpAmount());
            if (!(weight > bestWeight)) continue;
            bestMissile = missile;
            bestWeight = weight;
        }
        if (bestWeight >= 400.0f || totalWeight >= 1500.0f) {
            this.target = bestMissile;
            if (bestMissile != null && (MathUtils.getShortestRotation((float)this.weapon.getCurrAngle(), (float)VectorUtils.getAngle((Vector2f)this.weapon.getLocation(), (Vector2f)bestMissile.getLocation())) <= 30.0f || this.weapon.getSlot().isHardpoint())) {
                this.shouldFire = true;
            }
        }
    }

    public void forceOff() {
        this.shouldFire = false;
    }

    public Vector2f getTarget() {
        if (this.target == null) {
            return null;
        }
        return this.target.getLocation();
    }

    public ShipAPI getTargetShip() {
        return null;
    }

    public WeaponAPI getWeapon() {
        return this.weapon;
    }

    public boolean shouldFire() {
        return this.shouldFire;
    }
}

