/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.weapons.ai;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipCommand;
import com.fs.starfarer.api.util.IntervalUtil;
import data.scripts.weapons.ai.SWP_BaseMissile;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.dark.shaders.light.LightAPI;
import org.dark.shaders.light.LightShader;
import org.dark.shaders.light.StandardLight;
import org.lazywizard.lazylib.CollectionUtils;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lazywizard.lazylib.combat.AIUtils;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class SWP_FlareBurstAI
extends SWP_BaseMissile {
    private static final Color EXPLOSION_COLOR = new Color(100, 255, 100, 255);
    private static final float MIN_TRAVEL_TIME = 0.5f;
    private static final int NUM_PARTICLES = 30;
    private static final Color PARTICLE_COLOR = new Color(150, 255, 150, 255);
    private static final float PROXIMITY_RANGE = 500.0f;
    private static final String SOUND_FILE = "explosion_flak";
    private static final String SOUND_FILE_2 = "hit_heavy_energy";
    private static final String SOUND_FILE_3 = "swp_flareburst_explode";
    private static final float TARGET_ACQUISITION_RANGE = 1800.0f;
    private static final float VELOCITY_DAMPING_FACTOR = 0.05f;
    private static final Vector2f ZERO = new Vector2f();
    private float currentTime = 0.0f;
    private final IntervalUtil interval = new IntervalUtil(0.1f, 0.1f);

    private static void explode(DamagingProjectileAPI projectile, Vector2f point, CombatEngineAPI engine) {
        float visualArea = 200.0f;
        engine.spawnExplosion(point, ZERO, EXPLOSION_COLOR, visualArea / 2.0f, 0.1f);
        engine.addSmoothParticle(point, ZERO, visualArea * 1.5f, 0.75f, 1.0f, EXPLOSION_COLOR);
        engine.addHitParticle(point, ZERO, visualArea * 1.25f, 0.5f, 0.75f, EXPLOSION_COLOR);
        float speed = 400.0f;
        for (int x = 0; x < 30; ++x) {
            engine.addHitParticle(point, MathUtils.getPointOnCircumference(null, (float)MathUtils.getRandomNumberInRange((float)(speed * 0.05f), (float)(speed * 0.3f)), (float)((float)Math.random() * 360.0f)), 14.0f, 1.0f, MathUtils.getRandomNumberInRange((float)0.5f, (float)1.2f), PARTICLE_COLOR);
        }
        if (!projectile.didDamage()) {
            StandardLight light = new StandardLight(point, ZERO, ZERO, null);
            light.setColor(EXPLOSION_COLOR);
            light.setSize(visualArea * 1.5f);
            light.setIntensity(0.3f);
            light.fadeOut(0.5f);
            LightShader.addLight((LightAPI)light);
        }
        for (int i = 0; i < 10; ++i) {
            float angle = projectile.getFacing() + (float)i * 36.0f - 162.0f + (float)Math.random() * 45.0f;
            if (angle < 0.0f) {
                angle += 360.0f;
            } else if (angle >= 360.0f) {
                angle -= 360.0f;
            }
            Vector2f location = MathUtils.getPointOnCircumference((Vector2f)projectile.getLocation(), (float)5.0f, (float)angle);
            DamagingProjectileAPI newProj = (DamagingProjectileAPI)Global.getCombatEngine().spawnProjectile(projectile.getSource(), projectile.getWeapon(), "ssp_burstflare_wpn", location, angle, MathUtils.getPointOnCircumference(null, (float)((float)Math.random() * 50.0f + 50.0f), (float)((float)Math.random() * 360.0f)));
            newProj.setFromMissile(true);
        }
        Global.getSoundPlayer().playSound(SOUND_FILE, 1.0f, 1.0f, point, ZERO);
        Global.getSoundPlayer().playSound(SOUND_FILE_2, 1.0f, 1.0f, point, ZERO);
        Global.getSoundPlayer().playSound(SOUND_FILE_3, 1.0f, 1.0f, point, ZERO);
    }

    private static List<MissileAPI> getSortedDirectMissileTargets(ShipAPI launchingShip) {
        List directTargets = CombatUtils.getMissilesWithinRange((Vector2f)launchingShip.getMouseTarget(), (float)300.0f);
        if (!directTargets.isEmpty()) {
            Collections.sort(directTargets, new CollectionUtils.SortEntitiesByDistance(launchingShip.getMouseTarget()));
        }
        return directTargets;
    }

    public SWP_FlareBurstAI(MissileAPI missile, ShipAPI launchingShip) {
        super(missile, launchingShip);
    }

    @Override
    public void advance(float amount) {
        Vector2f guidedTarget;
        this.currentTime += amount;
        if (this.missile.isFizzling() || this.missile.isFading()) {
            SWP_FlareBurstAI.explode((DamagingProjectileAPI)this.missile, this.missile.getLocation(), Global.getCombatEngine());
            Global.getCombatEngine().applyDamage((CombatEntityAPI)this.missile, this.missile.getLocation(), this.missile.getHitpoints() * 2.0f, DamageType.FRAGMENTATION, 0.0f, false, false, (Object)this.missile);
            return;
        }
        this.interval.advance(amount);
        if (!this.acquireTarget(amount)) {
            this.missile.giveCommand(ShipCommand.ACCELERATE);
            return;
        }
        float distance = MathUtils.getDistance((Vector2f)this.target.getLocation(), (Vector2f)this.missile.getLocation()) - this.target.getCollisionRadius();
        if (distance <= 500.0f && this.target instanceof MissileAPI && this.currentTime >= 0.5f) {
            SWP_FlareBurstAI.explode((DamagingProjectileAPI)this.missile, this.missile.getLocation(), Global.getCombatEngine());
            Global.getCombatEngine().applyDamage((CombatEntityAPI)this.missile, this.missile.getLocation(), this.missile.getHitpoints() * 2.0f, DamageType.FRAGMENTATION, 0.0f, false, false, (Object)this.missile);
            return;
        }
        distance = MathUtils.getDistance((Vector2f)this.target.getLocation(), (Vector2f)this.missile.getLocation());
        float acceleration = this.missile.getAcceleration();
        float maxSpeed = this.missile.getMaxSpeed();
        float guidance = 0.5f;
        if (this.missile.getSource() != null) {
            guidance += Math.min(this.missile.getSource().getMutableStats().getMissileGuidance().getModifiedValue() - this.missile.getSource().getMutableStats().getMissileGuidance().getBaseValue(), 1.0f) * 0.5f;
        }
        if ((guidedTarget = SWP_FlareBurstAI.interceptAdvanced(this.missile.getLocation(), this.missile.getVelocity().length(), acceleration, maxSpeed, this.target.getLocation(), this.target.getVelocity())) == null) {
            Vector2f projection = new Vector2f((ReadableVector2f)this.target.getVelocity());
            float scalar = distance / (this.missile.getVelocity().length() + 1.0f);
            projection.scale(scalar);
            guidedTarget = Vector2f.add((Vector2f)this.target.getLocation(), (Vector2f)projection, null);
        }
        Vector2f.sub((Vector2f)guidedTarget, (Vector2f)this.target.getLocation(), (Vector2f)guidedTarget);
        guidedTarget.scale(guidance);
        Vector2f.add((Vector2f)guidedTarget, (Vector2f)this.target.getLocation(), (Vector2f)guidedTarget);
        float velocityFacing = VectorUtils.getFacing((Vector2f)this.missile.getVelocity());
        float absoluteDistance = MathUtils.getShortestRotation((float)velocityFacing, (float)VectorUtils.getAngle((Vector2f)this.missile.getLocation(), (Vector2f)guidedTarget));
        float angularDistance = MathUtils.getShortestRotation((float)this.missile.getFacing(), (float)VectorUtils.getAngle((Vector2f)this.missile.getLocation(), (Vector2f)guidedTarget));
        float compensationDifference = MathUtils.getShortestRotation((float)angularDistance, (float)absoluteDistance);
        if (Math.abs(compensationDifference) <= 75.0f) {
            angularDistance += 0.5f * compensationDifference;
        }
        float absDVel = Math.abs(absoluteDistance);
        float absDAng = Math.abs(angularDistance);
        this.missile.giveCommand(angularDistance < 0.0f ? ShipCommand.TURN_RIGHT : ShipCommand.TURN_LEFT);
        if (absDVel >= 135.0f || absDVel <= 90.0f && (absDVel <= 45.0f || distance >= 500.0f) || this.missile.getVelocity().length() <= maxSpeed * 0.75f) {
            this.missile.giveCommand(ShipCommand.ACCELERATE);
        }
        if (absDAng < 5.0f) {
            float MFlightAng = VectorUtils.getAngle((Vector2f)new Vector2f(0.0f, 0.0f), (Vector2f)this.missile.getVelocity());
            float MFlightCC = MathUtils.getShortestRotation((float)this.missile.getFacing(), (float)MFlightAng);
            if (Math.abs(MFlightCC) > 20.0f) {
                this.missile.giveCommand(MFlightCC < 0.0f ? ShipCommand.STRAFE_LEFT : ShipCommand.STRAFE_RIGHT);
            }
        }
        if (absDAng < Math.abs(this.missile.getAngularVelocity()) * 0.05f) {
            this.missile.setAngularVelocity(angularDistance / 0.05f);
        }
    }

    @Override
    protected void assignMissileToShipTarget(ShipAPI launchingShip) {
    }

    @Override
    protected CombatEntityAPI findBestTarget() {
        MissileAPI closest = null;
        float closestDistance = 1800.0f;
        List missiles = AIUtils.getEnemyMissilesOnMap((CombatEntityAPI)this.missile);
        int missilesSize = missiles.size();
        for (int i = 0; i < missilesSize; ++i) {
            float distance;
            MissileAPI tmp = (MissileAPI)missiles.get(i);
            if (!this.isTargetValid((CombatEntityAPI)tmp)) continue;
            float damage = (float)Math.sqrt(tmp.getDamageAmount() * (tmp.getDamageType() == DamageType.FRAGMENTATION ? 0.25f : 1.0f));
            if (damage <= 0.0f) {
                damage = 1.0f;
            }
            if (!((distance = MathUtils.getDistance((CombatEntityAPI)tmp, (Vector2f)this.missile.getLocation()) / damage) < closestDistance)) continue;
            closest = tmp;
            closestDistance = distance;
        }
        return closest;
    }

    @Override
    protected CombatEntityAPI getMouseTarget(ShipAPI launchingShip) {
        ListIterator<MissileAPI> iter = SWP_FlareBurstAI.getSortedDirectMissileTargets(launchingShip).listIterator();
        while (iter.hasNext()) {
            MissileAPI tmp = iter.next();
            if (!this.isTargetValid((CombatEntityAPI)tmp)) continue;
            return tmp;
        }
        return null;
    }

    @Override
    protected boolean isTargetValid(CombatEntityAPI target) {
        if (target instanceof MissileAPI) {
            MissileAPI msl = (MissileAPI)target;
            return !msl.isFlare() && !msl.isFizzling() && !msl.isFading() && msl.getOwner() != this.missile.getOwner();
        }
        return false;
    }
}

