/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.weapons.ai;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.GuidedMissileAI;
import com.fs.starfarer.api.combat.MissileAIPlugin;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.lazywizard.lazylib.CollectionUtils;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.combat.AIUtils;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lwjgl.util.vector.Vector2f;

public class SWP_BaseMissile
implements MissileAIPlugin,
GuidedMissileAI {
    protected ShipAPI launchingShip;
    protected MissileAPI missile;
    protected CombatEntityAPI target;

    private static Vector2f quad(float a, float b, float c) {
        Vector2f solution = null;
        if (Float.compare(Math.abs(a), 0.0f) == 0) {
            solution = Float.compare(Math.abs(b), 0.0f) == 0 ? (Float.compare(Math.abs(c), 0.0f) == 0 ? new Vector2f(0.0f, 0.0f) : null) : new Vector2f(-c / b, -c / b);
        } else {
            float d = b * b - 4.0f * a * c;
            if (d >= 0.0f) {
                d = (float)Math.sqrt(d);
                float e = 2.0f * a;
                solution = new Vector2f((-b - d) / e, (-b + d) / e);
            }
        }
        return solution;
    }

    static List<ShipAPI> getSortedDirectTargets(ShipAPI launchingShip) {
        List directTargets = CombatUtils.getShipsWithinRange((Vector2f)launchingShip.getMouseTarget(), (float)300.0f);
        if (!directTargets.isEmpty()) {
            Collections.sort(directTargets, new CollectionUtils.SortEntitiesByDistance(launchingShip.getMouseTarget()));
        }
        return directTargets;
    }

    static Vector2f intercept(Vector2f point, float speed, Vector2f target, Vector2f targetVel) {
        Vector2f difference = new Vector2f(target.x - point.x, target.y - point.y);
        float a = targetVel.x * targetVel.x + targetVel.y * targetVel.y - speed * speed;
        float b = 2.0f * (targetVel.x * difference.x + targetVel.y * difference.y);
        float c = difference.x * difference.x + difference.y * difference.y;
        Vector2f solutionSet = SWP_BaseMissile.quad(a, b, c);
        Vector2f intercept = null;
        if (solutionSet != null) {
            float bestFit = Math.min(solutionSet.x, solutionSet.y);
            if (bestFit < 0.0f) {
                bestFit = Math.max(solutionSet.x, solutionSet.y);
            }
            if (bestFit > 0.0f) {
                intercept = new Vector2f(target.x + targetVel.x * bestFit, target.y + targetVel.y * bestFit);
            }
        }
        return intercept;
    }

    static Vector2f interceptAdvanced(Vector2f point, float speed, float acceleration, float maxspeed, Vector2f target, Vector2f targetVel) {
        Vector2f difference = new Vector2f(target.x - point.x, target.y - point.y);
        float s = speed;
        float a = acceleration / 2.0f;
        float b = speed;
        float c = difference.length();
        Vector2f solutionSet = SWP_BaseMissile.quad(a, b, c);
        if (solutionSet != null) {
            float t = Math.min(solutionSet.x, solutionSet.y);
            if (t < 0.0f) {
                t = Math.max(solutionSet.x, solutionSet.y);
            }
            if (t > 0.0f) {
                s = acceleration * t;
                s = s / 2.0f + speed;
                s = Math.min(s, maxspeed);
            }
        }
        a = targetVel.x * targetVel.x + targetVel.y * targetVel.y - s * s;
        b = 2.0f * (targetVel.x * difference.x + targetVel.y * difference.y);
        c = difference.x * difference.x + difference.y * difference.y;
        solutionSet = SWP_BaseMissile.quad(a, b, c);
        Vector2f intercept = null;
        if (solutionSet != null) {
            float bestFit = Math.min(solutionSet.x, solutionSet.y);
            if (bestFit < 0.0f) {
                bestFit = Math.max(solutionSet.x, solutionSet.y);
            }
            if (bestFit > 0.0f) {
                intercept = new Vector2f(target.x + targetVel.x * bestFit, target.y + targetVel.y * bestFit);
            }
        }
        return intercept;
    }

    public SWP_BaseMissile(MissileAPI missile, ShipAPI launchingShip) {
        this.missile = missile;
        this.launchingShip = launchingShip;
        this.defaultInitialTargetingBehavior(launchingShip);
    }

    public void advance(float amount) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public CombatEntityAPI getTarget() {
        return this.target;
    }

    public final void setTarget(CombatEntityAPI target) {
        this.target = target;
    }

    private void defaultInitialTargetingBehavior(ShipAPI launchingShip) {
        this.assignMissileToShipTarget(launchingShip);
        if (this.target == null) {
            this.setTarget(this.getMouseTarget(launchingShip));
        }
        if (this.target == null) {
            this.setTarget(this.findBestTarget());
        }
    }

    protected boolean acquireTarget(float amount) {
        if (!this.isTargetValid(this.target)) {
            ShipAPI ship;
            if (this.target instanceof ShipAPI && (ship = (ShipAPI)this.target).isPhased() && ship.isAlive()) {
                return false;
            }
            this.setTarget(this.findBestTarget());
            if (this.target == null) {
                return false;
            }
        }
        return true;
    }

    protected void assignMissileToShipTarget(ShipAPI launchingShip) {
        if (this.isTargetValid((CombatEntityAPI)launchingShip.getShipTarget())) {
            this.setTarget((CombatEntityAPI)launchingShip.getShipTarget());
        }
    }

    protected CombatEntityAPI findBestTarget() {
        ShipAPI closest = null;
        float range = this.getRemainingRange() + this.missile.getMaxSpeed() * 2.0f;
        float closestDistance = this.getRemainingRange() + this.missile.getMaxSpeed() * 2.0f;
        List ships = AIUtils.getEnemiesOnMap((CombatEntityAPI)this.missile);
        int size = ships.size();
        for (int i = 0; i < size; ++i) {
            float distance;
            ShipAPI tmp = (ShipAPI)ships.get(i);
            float mod = 0.0f;
            if (tmp.isFighter() || tmp.isDrone()) {
                mod = range / 2.0f;
            }
            if (!this.isTargetValid((CombatEntityAPI)tmp)) {
                mod = range;
            }
            if (!((distance = MathUtils.getDistance((CombatEntityAPI)tmp, (Vector2f)this.missile.getLocation()) + mod) < closestDistance)) continue;
            closest = tmp;
            closestDistance = distance;
        }
        return closest;
    }

    protected CombatEntityAPI getMouseTarget(ShipAPI launchingShip) {
        ListIterator<ShipAPI> iter = SWP_BaseMissile.getSortedDirectTargets(launchingShip).listIterator();
        while (iter.hasNext()) {
            ShipAPI tmp = iter.next();
            if (!this.isTargetValid((CombatEntityAPI)tmp)) continue;
            return tmp;
        }
        return null;
    }

    protected float getRange() {
        float maxTime = this.missile.getMaxFlightTime();
        float speed = this.missile.getMaxSpeed();
        return speed * maxTime;
    }

    protected float getRemainingRange() {
        float time = this.missile.getMaxFlightTime() - this.missile.getFlightTime();
        float speed = this.missile.getMaxSpeed();
        return speed * time;
    }

    protected boolean isTargetValid(CombatEntityAPI target) {
        ShipAPI ship;
        if (target == null || this.missile.getOwner() == target.getOwner() || !Global.getCombatEngine().isEntityInPlay(target)) {
            return false;
        }
        return !(target instanceof ShipAPI ? (ship = (ShipAPI)target).isPhased() || !ship.isAlive() : target.getCollisionClass() == CollisionClass.NONE);
    }
}

