/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.weapons;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.EveryFrameWeaponEffectPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import java.awt.Color;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lazywizard.lazylib.combat.entities.SimpleEntity;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class SWP_ZeroBeam
implements EveryFrameWeaponEffectPlugin {
    private static final Color COLOR1 = new Color(255, 0, 0);
    private static final Color COLOR2 = new Color(255, 255, 255);
    private static final Color COLOR3 = new Color(255, 25, 25);
    private static final Vector2f ZERO = new Vector2f();
    private boolean charging = false;
    private boolean firing = false;
    private final IntervalUtil interval = new IntervalUtil(0.015f, 0.015f);

    public void advance(float amount, CombatEngineAPI engine, WeaponAPI weapon) {
        if (Global.getCombatEngine().isPaused()) {
            return;
        }
        Vector2f origin = new Vector2f((ReadableVector2f)weapon.getLocation());
        ShipAPI ship = weapon.getShip();
        if (this.firing) {
            if (weapon.getChargeLevel() >= 1.0f) {
                ShipAPI target = engine.getPlayerShip();
                if (ship != engine.getPlayerShip() && target != null) {
                    this.faceTarget(ship, target);
                }
                this.interval.advance(amount);
                if (this.interval.intervalElapsed()) {
                    int amountscalar;
                    engine.addHitParticle(origin, ZERO, (float)Math.random() * 250.0f + 350.0f, 0.2f, 0.2f, COLOR1);
                    engine.addHitParticle(origin, ZERO, (float)Math.random() * 150.0f + 250.0f, 0.2f, 0.2f, COLOR2);
                    switch (ship.getHullSpec().getBaseHullId()) {
                        case "ssp_hyperzero": {
                            amountscalar = 3;
                            break;
                        }
                        case "ssp_superzero": {
                            amountscalar = 2;
                            break;
                        }
                        default: {
                            amountscalar = 1;
                        }
                    }
                    for (int i = 0; i < 1 * amountscalar; ++i) {
                        if (!(Math.random() > 0.25)) continue;
                        float angle = (float)Math.random() * 360.0f;
                        float distance = (float)Math.random() * 150.0f + 50.0f;
                        switch (weapon.getShip().getHullSpec().getBaseHullId()) {
                            case "ssp_hyperzero": {
                                distance *= 2.0f;
                                break;
                            }
                            case "ssp_superzero": {
                                distance *= 1.5f;
                                break;
                            }
                        }
                        Vector2f point1 = MathUtils.getPointOnCircumference((Vector2f)origin, (float)distance, (float)angle);
                        Vector2f point2 = MathUtils.getPointOnCircumference((Vector2f)origin, (float)distance, (float)(angle + 45.0f * (float)Math.random()));
                        engine.spawnEmpArc(ship, point1, (CombatEntityAPI)new SimpleEntity(point1), (CombatEntityAPI)new SimpleEntity(point2), DamageType.ENERGY, 0.0f, 0.0f, 1000.0f, null, 40.0f, COLOR1, COLOR2);
                    }
                }
            } else if (weapon.getCooldownRemaining() <= 0.0f) {
                this.firing = false;
                this.charging = false;
            }
        } else if (weapon.getChargeLevel() >= 1.0f) {
            this.firing = true;
            Global.getSoundPlayer().playSound("zerobeam_fire", 1.0f, 0.75f, origin, ZERO);
            engine.addHitParticle(origin, ZERO, 1000.0f, 5.0f, 0.5f, COLOR3);
            engine.addHitParticle(origin, ZERO, 500.0f, 5.0f, 0.2f, COLOR2);
        } else if (weapon.getChargeLevel() > 0.0f) {
            if (!this.charging) {
                this.charging = true;
                Global.getSoundPlayer().playSound("zerobeam_charge", 1.0f, 0.6f, origin, ZERO);
            }
            ShipAPI target = engine.getPlayerShip();
            if (ship != engine.getPlayerShip() && target != null) {
                this.faceTarget(ship, target);
            }
            this.interval.advance(amount);
            if (this.interval.intervalElapsed()) {
                engine.addHitParticle(origin, ZERO, (float)Math.random() * weapon.getChargeLevel() * 225.0f + 75.0f, 5.0f, 0.035f, COLOR3);
                engine.addHitParticle(origin, ZERO, (float)Math.random() * weapon.getChargeLevel() * 125.0f + 50.0f, 1.0f, 0.035f, COLOR2);
                if (Math.random() > 0.25) {
                    float distmod;
                    switch (weapon.getShip().getHullSpec().getBaseHullId()) {
                        case "ssp_hyperzero": {
                            distmod = 2.0f;
                            break;
                        }
                        case "ssp_superzero": {
                            distmod = 1.5f;
                            break;
                        }
                        default: {
                            distmod = 1.0f;
                        }
                    }
                    Vector2f point1 = MathUtils.getRandomPointInCircle((Vector2f)origin, (float)((float)Math.random() * weapon.getChargeLevel() * 250.0f * distmod));
                    engine.spawnEmpArc(ship, origin, (CombatEntityAPI)new SimpleEntity(origin), (CombatEntityAPI)new SimpleEntity(point1), DamageType.ENERGY, 0.0f, 0.0f, 1000.0f, null, weapon.getChargeLevel() * 20.0f + 10.0f, COLOR1, COLOR2);
                }
            }
        }
    }

    private void faceTarget(ShipAPI ship, ShipAPI target) {
        float angle = VectorUtils.getAngle((Vector2f)ship.getLocation(), (Vector2f)target.getLocation());
        ship.setFacing(angle);
    }
}

