/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.weapons;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.EveryFrameWeaponEffectPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import java.awt.Color;
import java.util.List;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lazywizard.lazylib.combat.entities.SimpleEntity;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class SWP_ZeroAnnihilator
implements EveryFrameWeaponEffectPlugin {
    private static final Color COLOR1 = new Color(100, 150, 255);
    private static final Color COLOR2 = new Color(150, 200, 255);
    private static final Color HYPER_COLOR1 = new Color(150, 150, 150);
    private static final Color HYPER_COLOR2 = new Color(255, 255, 255);
    private static final Color SUPER_COLOR1 = new Color(255, 100, 100);
    private static final Color SUPER_COLOR2 = new Color(255, 200, 200);
    private static final Color SUPER_COLOR3 = new Color(255, 50, 50);
    private static final Vector2f ZERO = new Vector2f();
    private boolean charging = false;
    private boolean firing = false;
    private final IntervalUtil interval = new IntervalUtil(0.04f, 0.04f);
    private final IntervalUtil interval2 = new IntervalUtil(0.015f, 0.015f);
    private Vector2f novaLocation = null;
    private float novaTime = -1.0f;

    public void advance(float amount, CombatEngineAPI engine, WeaponAPI weapon) {
        if (Global.getCombatEngine().isPaused()) {
            return;
        }
        Vector2f origin = new Vector2f((ReadableVector2f)weapon.getLocation());
        if (this.firing) {
            if (weapon.getChargeLevel() >= 1.0f) {
                this.interval2.advance(amount);
                if (this.interval2.intervalElapsed()) {
                    switch (weapon.getShip().getHullSpec().getBaseHullId()) {
                        case "ssp_hyperzero": {
                            engine.addHitParticle(origin, ZERO, (float)Math.random() * 100.0f + 200.0f, 0.2f, 0.2f, HYPER_COLOR1);
                            engine.addHitParticle(origin, ZERO, (float)Math.random() * 50.0f + 150.0f, 0.2f, 0.2f, HYPER_COLOR2);
                            break;
                        }
                        case "ssp_superzero": {
                            engine.addHitParticle(origin, ZERO, (float)Math.random() * 100.0f + 200.0f, 0.2f, 0.2f, SUPER_COLOR1);
                            engine.addHitParticle(origin, ZERO, (float)Math.random() * 50.0f + 150.0f, 0.2f, 0.2f, SUPER_COLOR2);
                            break;
                        }
                        default: {
                            engine.addHitParticle(origin, ZERO, (float)Math.random() * 100.0f + 200.0f, 0.2f, 0.2f, COLOR1);
                            engine.addHitParticle(origin, ZERO, (float)Math.random() * 50.0f + 150.0f, 0.2f, 0.2f, COLOR2);
                            break;
                        }
                    }
                }
            } else if (weapon.getCooldownRemaining() <= 0.0f) {
                this.firing = false;
            } else if (this.charging) {
                this.charging = false;
                if (weapon.getShip().getHullLevel() <= 0.33f) {
                    this.novaLocation = origin;
                    this.novaTime = 0.0f;
                    switch (weapon.getShip().getHullSpec().getBaseHullId()) {
                        case "ssp_hyperzero": {
                            engine.addHitParticle(origin, ZERO, 500.0f, 1.0f, 0.3f, HYPER_COLOR1);
                            engine.addHitParticle(origin, ZERO, 300.0f, 1.0f, 0.3f, HYPER_COLOR2);
                            engine.spawnExplosion(origin, ZERO, HYPER_COLOR2, 1000.0f, 0.15f);
                            break;
                        }
                        case "ssp_superzero": {
                            engine.addHitParticle(origin, ZERO, 500.0f, 1.0f, 0.3f, SUPER_COLOR1);
                            engine.addHitParticle(origin, ZERO, 300.0f, 1.0f, 0.3f, SUPER_COLOR2);
                            engine.spawnExplosion(origin, ZERO, SUPER_COLOR2, 1000.0f, 0.15f);
                            break;
                        }
                        default: {
                            engine.addHitParticle(origin, ZERO, 500.0f, 1.0f, 0.3f, COLOR1);
                            engine.addHitParticle(origin, ZERO, 300.0f, 1.0f, 0.3f, COLOR2);
                            engine.spawnExplosion(origin, ZERO, COLOR2, 1000.0f, 0.15f);
                        }
                    }
                    Global.getSoundPlayer().playSound("zeroannihilator_blast", 1.0f, 2.0f, origin, ZERO);
                }
            }
        } else if (weapon.getChargeLevel() >= 1.0f) {
            this.firing = true;
            Global.getSoundPlayer().playSound("zeroannihilator_fire", 1.0f, 2.0f, origin, ZERO);
            switch (weapon.getShip().getHullSpec().getBaseHullId()) {
                case "ssp_hyperzero": {
                    engine.addHitParticle(origin, ZERO, 750.0f, 5.0f, 0.5f, HYPER_COLOR1);
                    engine.addHitParticle(origin, ZERO, 200.0f, 5.0f, 0.25f, HYPER_COLOR2);
                    break;
                }
                case "ssp_superzero": {
                    engine.addHitParticle(origin, ZERO, 750.0f, 5.0f, 0.5f, SUPER_COLOR1);
                    engine.addHitParticle(origin, ZERO, 200.0f, 5.0f, 0.25f, SUPER_COLOR2);
                    break;
                }
                default: {
                    engine.addHitParticle(origin, ZERO, 750.0f, 5.0f, 0.5f, COLOR1);
                    engine.addHitParticle(origin, ZERO, 200.0f, 5.0f, 0.25f, COLOR2);
                    break;
                }
            }
        } else if (weapon.getChargeLevel() > 0.0f) {
            if (!this.charging) {
                this.charging = true;
                Global.getSoundPlayer().playSound("zeroannihilator_charge", 1.0f, 2.0f, origin, ZERO);
            }
            this.interval2.advance(amount);
            if (this.interval2.intervalElapsed()) {
                switch (weapon.getShip().getHullSpec().getBaseHullId()) {
                    case "ssp_hyperzero": {
                        engine.addHitParticle(origin, ZERO, weapon.getChargeLevel() * 150.0f + 50.0f, 5.0f, 0.035f, HYPER_COLOR1);
                        engine.addHitParticle(origin, ZERO, weapon.getChargeLevel() * 100.0f + 25.0f, 1.0f, 0.035f, HYPER_COLOR2);
                        break;
                    }
                    case "ssp_superzero": {
                        engine.addHitParticle(origin, ZERO, weapon.getChargeLevel() * 150.0f + 50.0f, 5.0f, 0.035f, SUPER_COLOR1);
                        engine.addHitParticle(origin, ZERO, weapon.getChargeLevel() * 100.0f + 25.0f, 1.0f, 0.035f, SUPER_COLOR2);
                        break;
                    }
                    default: {
                        engine.addHitParticle(origin, ZERO, weapon.getChargeLevel() * 150.0f + 50.0f, 5.0f, 0.035f, COLOR1);
                        engine.addHitParticle(origin, ZERO, weapon.getChargeLevel() * 100.0f + 25.0f, 1.0f, 0.035f, COLOR2);
                    }
                }
            }
        }
        if (this.novaTime >= 0.0f) {
            float boost;
            this.novaTime += amount;
            this.interval.advance(amount);
            switch (weapon.getShip().getHullSpec().getBaseHullId()) {
                case "ssp_hyperzero": {
                    boost = 2.0f;
                    break;
                }
                case "ssp_superzero": {
                    boost = 1.5f;
                    break;
                }
                default: {
                    boost = 1.0f;
                }
            }
            if (this.interval.intervalElapsed()) {
                float offset = (float)Math.random() * 360.0f;
                block48: for (int i = 0; i < (int)(this.novaTime * 5.0f * boost) + 4; ++i) {
                    float angle = (float)i / (this.novaTime * 5.0f * boost + 4.0f) * 360.0f + offset;
                    if (angle >= 360.0f) {
                        angle -= 360.0f;
                    }
                    float distance = (float)Math.random() * 50.0f + this.novaTime * 750.0f * boost;
                    Vector2f point1 = MathUtils.getPointOnCircumference((Vector2f)this.novaLocation, (float)distance, (float)angle);
                    Vector2f point2 = MathUtils.getPointOnCircumference((Vector2f)this.novaLocation, (float)distance, (float)(angle + 360.0f / (this.novaTime * 5.0f * boost + 4.0f) * ((float)Math.random() + 1.0f)));
                    switch (weapon.getShip().getHullSpec().getBaseHullId()) {
                        case "ssp_superzero": {
                            engine.spawnEmpArc(weapon.getShip(), point1, (CombatEntityAPI)new SimpleEntity(point1), (CombatEntityAPI)new SimpleEntity(point2), DamageType.ENERGY, 0.0f, 0.0f, 10000.0f, null, 40.0f, SUPER_COLOR3, SUPER_COLOR1);
                            continue block48;
                        }
                        case "ssp_hyperzero": {
                            engine.spawnEmpArc(weapon.getShip(), point1, (CombatEntityAPI)new SimpleEntity(point1), (CombatEntityAPI)new SimpleEntity(point2), DamageType.ENERGY, 0.0f, 0.0f, 10000.0f, null, 40.0f, HYPER_COLOR1, HYPER_COLOR2);
                            continue block48;
                        }
                        default: {
                            engine.spawnEmpArc(weapon.getShip(), point1, (CombatEntityAPI)new SimpleEntity(point1), (CombatEntityAPI)new SimpleEntity(point2), DamageType.ENERGY, 0.0f, 0.0f, 10000.0f, null, 40.0f, COLOR1, COLOR2);
                        }
                    }
                }
                List targets = CombatUtils.getShipsWithinRange((Vector2f)this.novaLocation, (float)(this.novaTime * 750.0f * boost + 25.0f));
                for (ShipAPI target : targets) {
                    if (target == weapon.getShip()) continue;
                    float dist = MathUtils.getDistance((Vector2f)this.novaLocation, (Vector2f)target.getLocation());
                    float dist2 = this.novaTime * 750.0f * boost + 25.0f;
                    if (!(dist - (target.getCollisionRadius() + 50.0f * boost) <= dist2) || !(target.getCollisionRadius() + 50.0f * boost >= dist2)) continue;
                    if (target.getOwner() == weapon.getShip().getOwner()) {
                        engine.applyDamage((CombatEntityAPI)target, MathUtils.getRandomPointInCircle((Vector2f)target.getLocation(), (float)target.getCollisionRadius()), 400.0f * boost * boost, DamageType.ENERGY, 200.0f, false, false, (Object)weapon.getShip());
                        continue;
                    }
                    engine.applyDamage((CombatEntityAPI)target, MathUtils.getRandomPointInCircle((Vector2f)target.getLocation(), (float)target.getCollisionRadius()), 8000.0f * boost * boost, DamageType.ENERGY, 4000.0f, false, false, (Object)weapon.getShip());
                }
            }
            if (this.novaTime >= 2.5f) {
                this.novaTime = -1.0f;
            }
        }
    }
}

