/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.weapons;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.OnHitEffectPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import java.awt.Color;
import java.util.Iterator;
import java.util.List;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lazywizard.lazylib.combat.entities.SimpleEntity;
import org.lwjgl.util.vector.Vector2f;

public class SWP_TrebuchetOnHitEffect
implements OnHitEffectPlugin {
    private static final float AREA_EFFECT = 250.0f;
    private static final float AREA_EFFECT_INNER = 50.0f;
    private static final Color COLOR1 = new Color(25, 100, 155);
    private static final Color COLOR2 = new Color(255, 255, 255);
    private static final Vector2f ZERO = new Vector2f();

    public void onHit(DamagingProjectileAPI projectile, CombatEntityAPI target, Vector2f point, boolean shieldHit, CombatEngineAPI engine) {
        if (target == null || point == null) {
            return;
        }
        float emp = projectile.getEmpAmount();
        float dam = projectile.getDamageAmount();
        List targets = CombatUtils.getShipsWithinRange((Vector2f)point, (float)250.0f);
        Iterator iter = targets.iterator();
        while (iter.hasNext()) {
            ShipAPI entity = (ShipAPI)iter.next();
            if (entity.getCollisionClass() == CollisionClass.NONE) {
                iter.remove();
                continue;
            }
            boolean remove = false;
            for (ShipAPI ship : targets) {
                if (ship.getShield() == null || ship == entity || !ship.getShield().isWithinArc(entity.getLocation()) || !ship.getShield().isOn()) continue;
                remove = true;
                break;
            }
            if (!remove) continue;
            iter.remove();
        }
        if (target instanceof ShipAPI) {
            ShipAPI ship = (ShipAPI)target;
            targets.remove(ship);
            engine.spawnEmpArc(projectile.getSource(), point, null, target, DamageType.ENERGY, 0.0f, emp, 100000.0f, "tachyon_lance_emp_impact", 40.0f, COLOR1, COLOR2);
        }
        for (ShipAPI ship : targets) {
            float distance = MathUtils.getDistance((Vector2f)ship.getLocation(), (Vector2f)point);
            float reduction = 1.0f;
            if (distance > 50.0f + ship.getCollisionRadius()) {
                reduction = (250.0f - distance) / 200.0f;
            }
            engine.spawnEmpArc(projectile.getSource(), point, null, (CombatEntityAPI)ship, DamageType.ENERGY, dam * reduction, emp * reduction, 500.0f, "tachyon_lance_emp_impact", 40.0f, COLOR1, COLOR2);
        }
        for (int i = 0; i < 6; ++i) {
            Vector2f location = new Vector2f(projectile.getLocation().x + (float)Math.random() * 200.0f + 100.0f, projectile.getLocation().y);
            location = VectorUtils.rotateAroundPivot((Vector2f)location, (Vector2f)projectile.getLocation(), (float)((float)Math.random() * 360.0f), (Vector2f)location);
            engine.spawnEmpArc(projectile.getSource(), point, null, (CombatEntityAPI)new SimpleEntity(location), DamageType.ENERGY, 0.0f, 0.0f, 100000.0f, "tachyon_lance_emp_impact", 20.0f, COLOR1, COLOR2);
        }
        Global.getSoundPlayer().playSound("disabled_large", 0.75f, 0.8f, point, ZERO);
    }
}

