/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.weapons;

import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.EveryFrameWeaponEffectPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import java.awt.Color;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class SWP_PlasmaFlameEveryFrameEffect
implements EveryFrameWeaponEffectPlugin {
    private static final Color MUZZLE_FLASH_COLOR = new Color(255, 200, 100, 50);
    private static final Color MUZZLE_FLASH_COLOR_ALT = new Color(100, 100, 255, 100);
    private static final Color MUZZLE_FLASH_COLOR_GLOW = new Color(255, 75, 0, 50);
    private static final float MUZZLE_FLASH_DURATION = 0.15f;
    private static final float MUZZLE_FLASH_SIZE = 50.0f;
    private static final Vector2f MUZZLE_OFFSET_HARDPOINT = new Vector2f(37.0f, -4.5f);
    private static final Vector2f MUZZLE_OFFSET_TURRET = new Vector2f(35.0f, -4.5f);
    private int lastWeaponAmmo = 0;

    public void advance(float amount, CombatEngineAPI engine, WeaponAPI weapon) {
        if (engine.isPaused()) {
            return;
        }
        int weaponAmmo = weapon.getAmmo();
        if (weaponAmmo < this.lastWeaponAmmo) {
            Vector2f weaponLocation = weapon.getLocation();
            ShipAPI ship = weapon.getShip();
            float weaponFacing = weapon.getCurrAngle();
            Vector2f muzzleLocation = new Vector2f((ReadableVector2f)(weapon.getSlot().isHardpoint() ? MUZZLE_OFFSET_HARDPOINT : MUZZLE_OFFSET_TURRET));
            VectorUtils.rotate((Vector2f)muzzleLocation, (float)weaponFacing, (Vector2f)muzzleLocation);
            Vector2f.add((Vector2f)muzzleLocation, (Vector2f)weaponLocation, (Vector2f)muzzleLocation);
            if (weaponAmmo < this.lastWeaponAmmo) {
                Vector2f shipVelocity = MathUtils.getPointOnCircumference((Vector2f)ship.getVelocity(), (float)((float)Math.random() * 20.0f), (float)(weaponFacing + 90.0f - (float)Math.random() * 180.0f));
                if (Math.random() > 0.75) {
                    engine.spawnExplosion(muzzleLocation, shipVelocity, MUZZLE_FLASH_COLOR_ALT, 25.0f, 0.15f);
                } else {
                    engine.spawnExplosion(muzzleLocation, shipVelocity, MUZZLE_FLASH_COLOR, 50.0f, 0.15f);
                }
                engine.addSmoothParticle(muzzleLocation, shipVelocity, 150.0f, 1.0f, 0.3f, MUZZLE_FLASH_COLOR_GLOW);
            }
        }
        this.lastWeaponAmmo = weaponAmmo;
    }
}

