/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.weapons;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.OnHitEffectPlugin;
import java.awt.Color;
import org.dark.shaders.light.LightAPI;
import org.dark.shaders.light.LightShader;
import org.dark.shaders.light.StandardLight;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.combat.entities.SimpleEntity;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class SWP_LightningGunOnHitEffect
implements OnHitEffectPlugin {
    private static final Vector2f ZERO = new Vector2f();

    public void onHit(DamagingProjectileAPI projectile, CombatEntityAPI target, Vector2f point, boolean shieldHit, CombatEngineAPI engine) {
        float range;
        if (point == null) {
            return;
        }
        if (projectile.getWeapon() == null) {
            return;
        }
        Vector2f origin = new Vector2f((ReadableVector2f)projectile.getWeapon().getLocation());
        Vector2f slope = new Vector2f();
        slope.x = point.x - origin.x;
        slope.y = point.y - origin.y;
        slope.normalise();
        origin.x += slope.x * 5.0f;
        origin.y += slope.y * 5.0f;
        float distance = MathUtils.getDistance((Vector2f)origin, (Vector2f)point);
        if (distance < 0.1f) {
            distance = 10.0f;
        }
        if (distance > (range = projectile.getWeapon().getRange() * 2.0f)) {
            point.x = origin.x + (point.x - origin.x) * range / distance;
            point.y = origin.y + (point.y - origin.y) * range / distance;
        }
        int brightness = (int)(255.0f * Math.max(Math.min((range - distance) / distance, 0.0f), 1.0f));
        Global.getSoundPlayer().playSound("swp_lightning_gun_arc", 1.0f, 0.55f, point, ZERO);
        StandardLight light = new StandardLight(origin, point, ZERO, ZERO, null);
        light.setIntensity(0.65f);
        light.setSize(80.0f);
        light.setColor(0.65f, 0.75f, 0.9f);
        light.fadeOut(0.75f);
        LightShader.addLight((LightAPI)light);
        engine.spawnEmpArc(projectile.getSource(), origin, null, (CombatEntityAPI)new SimpleEntity(point), DamageType.ENERGY, 0.0f, 0.0f, 100000.0f, null, 20.0f * Math.max(Math.min((range - distance) / distance, 0.0f), 1.0f), new Color(100, 125, 200, brightness), new Color(240, 250, 255, brightness));
    }
}

