/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.weapons;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.OnHitEffectPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import data.scripts.SWPModPlugin;
import data.scripts.hullmods.TEM_LatticeShield;
import java.awt.Color;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.combat.entities.SimpleEntity;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class SWP_IonTorpedoOnHitEffect
implements OnHitEffectPlugin {
    private static final Color EXPLOSION_COLOR = new Color(150, 175, 255, 150);
    private static final float HARD_FLUX = 1000.0f;
    private static final Color PARTICLE_COLOR = new Color(175, 200, 255, 150);
    private static final Vector2f ZERO = new Vector2f();

    public void onHit(DamagingProjectileAPI projectile, CombatEntityAPI target, Vector2f point, boolean shieldHit, CombatEngineAPI engine) {
        boolean hitShields = shieldHit;
        if (point == null) {
            return;
        }
        if (target instanceof ShipAPI) {
            ShipAPI ship = (ShipAPI)target;
            if (!hitShields && SWPModPlugin.templarsExists && ship.getVariant().getHullMods().contains("tem_latticeshield") && TEM_LatticeShield.shieldLevel((ShipAPI)ship) > 0.0f) {
                hitShields = true;
            }
            if (projectile.getSource() == null) {
                if (hitShields) {
                    ship.getFluxTracker().increaseFlux(1000.0f, true);
                }
            } else if (hitShields) {
                ship.getFluxTracker().increaseFlux(1000.0f * projectile.getSource().getMutableStats().getEnergyWeaponDamageMult().getModifiedValue(), true);
            }
            float emp = projectile.getEmpAmount() * 0.33333f;
            float dam = projectile.getDamageAmount() * 0.1f;
            for (int x = 0; x < 4; ++x) {
                boolean piercedShield;
                float pierceChance = ((ShipAPI)target).getHardFluxLevel() - 0.1f;
                boolean bl = piercedShield = hitShields && (float)Math.random() < (pierceChance *= ship.getMutableStats().getDynamic().getValue("shield_pierced_mult"));
                if (hitShields && !piercedShield) continue;
                ShipAPI empTarget = ship;
                engine.spawnEmpArcPierceShields(projectile.getSource(), point, (CombatEntityAPI)empTarget, (CombatEntityAPI)empTarget, DamageType.FRAGMENTATION, dam, emp, 100000.0f, null, 20.0f, PARTICLE_COLOR, EXPLOSION_COLOR);
            }
        }
        if (hitShields) {
            Global.getSoundPlayer().playSound("swp_ionblaster_hit", 1.1f, 0.6f, point, ZERO);
        } else {
            Global.getSoundPlayer().playSound("swp_ionblaster_hit", 0.9f, 0.7f, point, ZERO);
        }
        for (int x = 0; x < 3; ++x) {
            float angle = (float)Math.random() * 360.0f;
            float distance = (float)Math.random() * 100.0f + 150.0f;
            Vector2f point1 = MathUtils.getPointOnCircumference((Vector2f)point, (float)distance, (float)angle);
            Vector2f point2 = new Vector2f((ReadableVector2f)point);
            engine.spawnEmpArc(projectile.getSource(), point1, (CombatEntityAPI)new SimpleEntity(point1), (CombatEntityAPI)new SimpleEntity(point2), DamageType.ENERGY, 0.0f, 0.0f, 1000.0f, null, 15.0f, EXPLOSION_COLOR, PARTICLE_COLOR);
        }
    }
}

