/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.weapons;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.OnHitEffectPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import data.scripts.SWPModPlugin;
import data.scripts.hullmods.TEM_LatticeShield;
import java.awt.Color;
import org.lwjgl.util.vector.Vector2f;

public class SWP_IonBlasterOnHitEffect
implements OnHitEffectPlugin {
    private static final Color COLOR1 = new Color(100, 255, 200);
    private static final Color COLOR2 = new Color(200, 255, 255);
    private static final Vector2f ZERO = new Vector2f();

    public void onHit(DamagingProjectileAPI projectile, CombatEntityAPI target, Vector2f point, boolean shieldHit, CombatEngineAPI engine) {
        boolean hitShields = shieldHit;
        if (point == null) {
            return;
        }
        if (target instanceof ShipAPI) {
            ShipAPI ship = (ShipAPI)target;
            if (!hitShields && SWPModPlugin.templarsExists && ship.getVariant().getHullMods().contains("tem_latticeshield") && TEM_LatticeShield.shieldLevel((ShipAPI)ship) > 0.0f) {
                hitShields = true;
            }
            float hitLevel = 0.0f;
            float emp = projectile.getEmpAmount() * 0.33f;
            float dam = projectile.getDamageAmount() * 0.05f;
            for (int x = 0; x < 4; ++x) {
                boolean piercedShield;
                float pierceChance = ((ShipAPI)target).getHardFluxLevel() - 0.1f;
                boolean bl = piercedShield = hitShields && (float)Math.random() < (pierceChance *= ship.getMutableStats().getDynamic().getValue("shield_pierced_mult"));
                if (hitShields && !piercedShield) continue;
                hitLevel += 0.25f;
                ShipAPI empTarget = ship;
                engine.spawnEmpArcPierceShields(projectile.getSource(), point, (CombatEntityAPI)empTarget, (CombatEntityAPI)empTarget, DamageType.ENERGY, dam, emp, 100000.0f, null, 20.0f, COLOR1, COLOR2);
            }
            if (hitLevel > 0.0f) {
                engine.addSmoothParticle(point, ZERO, 300.0f * hitLevel, hitLevel, 0.75f, COLOR1);
                Global.getSoundPlayer().playSound("swp_ionblaster_hit", 1.0f, 1.0f * hitLevel, point, ZERO);
            }
        }
    }
}

