/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.weapons;

import com.fs.starfarer.api.combat.BeamAPI;
import com.fs.starfarer.api.combat.BeamEffectPlugin;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import data.scripts.SWPModPlugin;
import data.scripts.hullmods.TEM_LatticeShield;
import org.lwjgl.util.vector.Vector2f;

public class SWP_IonBeamEffect
implements BeamEffectPlugin {
    private final IntervalUtil fireInterval = new IntervalUtil(0.25f, 1.75f);
    private boolean wasZero = true;

    public void advance(float amount, CombatEngineAPI engine, BeamAPI beam) {
        CombatEntityAPI target = beam.getDamageTarget();
        if (target instanceof ShipAPI && beam.getBrightness() >= 1.0f) {
            float dur = beam.getDamage().getDpsDuration();
            if (!this.wasZero) {
                dur = 0.0f;
            }
            this.wasZero = beam.getDamage().getDpsDuration() <= 0.0f;
            this.fireInterval.advance(dur);
            if (this.fireInterval.intervalElapsed()) {
                boolean piercedShield;
                boolean hitShield;
                ShipAPI ship = (ShipAPI)target;
                boolean bl = hitShield = target.getShield() != null && target.getShield().isWithinArc(beam.getTo());
                if (!hitShield && SWPModPlugin.templarsExists && ship.getVariant().getHullMods().contains("tem_latticeshield") && TEM_LatticeShield.shieldLevel((ShipAPI)ship) > 0.0f) {
                    hitShield = true;
                }
                float pierceChance = ((ShipAPI)target).getHardFluxLevel() - 0.1f;
                boolean bl2 = piercedShield = hitShield && (float)Math.random() < (pierceChance *= ship.getMutableStats().getDynamic().getValue("shield_pierced_mult"));
                if (!hitShield || piercedShield) {
                    Vector2f dir = Vector2f.sub((Vector2f)beam.getTo(), (Vector2f)beam.getFrom(), (Vector2f)new Vector2f());
                    if (dir.lengthSquared() > 0.0f) {
                        dir.normalise();
                    }
                    dir.scale(50.0f);
                    Vector2f point = Vector2f.sub((Vector2f)beam.getTo(), (Vector2f)dir, (Vector2f)new Vector2f());
                    float emp = beam.getDamage().getFluxComponent() * 1.0f;
                    float dam = beam.getDamage().getDamage() * 1.0f;
                    ShipAPI empTarget = ship;
                    engine.spawnEmpArcPierceShields(beam.getSource(), point, (CombatEntityAPI)empTarget, (CombatEntityAPI)empTarget, DamageType.ENERGY, dam, emp, 100000.0f, "tachyon_lance_emp_impact", beam.getWidth() + 9.0f, beam.getFringeColor(), beam.getCoreColor());
                }
            }
        }
    }
}

