/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.weapons;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.EveryFrameWeaponEffectPlugin;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import data.scripts.util.SWP_Util;
import java.awt.Color;
import org.dark.shaders.light.LightAPI;
import org.dark.shaders.light.LightShader;
import org.dark.shaders.light.StandardLight;
import org.lazywizard.lazylib.MathUtils;
import org.lwjgl.util.vector.Vector2f;

public class SWP_GodMode
implements EveryFrameWeaponEffectPlugin {
    private static final Color MAIN_COLOR = new Color(175, 225, 255);
    private static final Vector2f ZERO = new Vector2f();
    private final IntervalUtil interval = new IntervalUtil(0.015f, 0.015f);
    private float timer = 0.0f;
    private boolean used = false;

    public void advance(float amount, CombatEngineAPI engine, WeaponAPI weapon) {
        MutableShipStatsAPI stats;
        if (weapon.getCooldownRemaining() > 0.0f && !this.used) {
            this.used = true;
            Global.getSoundPlayer().playSound("godmode_activate", 1.0f, 2.0f, weapon.getShip().getLocation(), weapon.getShip().getVelocity());
            stats = weapon.getShip().getMutableStats();
            stats.getShieldDamageTakenMult().modifyMult(weapon.getId(), 0.0f);
            stats.getHullDamageTakenMult().modifyMult(weapon.getId(), 0.0f);
            stats.getEmpDamageTakenMult().modifyMult(weapon.getId(), 0.0f);
            stats.getArmorDamageTakenMult().modifyMult(weapon.getId(), 1.0E-5f);
            weapon.getShip().getFluxTracker().setHardFlux(0.0f);
            weapon.getShip().getFluxTracker().setCurrFlux(weapon.getShip().getFluxTracker().getCurrFlux() / 2.0f);
            StandardLight light = new StandardLight(ZERO, ZERO, ZERO, (CombatEntityAPI)weapon.getShip());
            light.setIntensity(1.0f);
            light.setSize(200.0f);
            light.setColor(MAIN_COLOR);
            light.fadeIn(0.33f);
            light.setLifetime(9.34f);
            light.setAutoFadeOutTime(0.33f);
            LightShader.addLight((LightAPI)light);
            this.timer = 10.0f;
        }
        if (this.timer > 0.0f) {
            this.timer -= amount;
            if (this.timer <= 0.0f) {
                stats = weapon.getShip().getMutableStats();
                stats.getShieldDamageTakenMult().unmodify(weapon.getId());
                stats.getHullDamageTakenMult().unmodify(weapon.getId());
                stats.getEmpDamageTakenMult().unmodify(weapon.getId());
                stats.getArmorDamageTakenMult().unmodify(weapon.getId());
            }
            if (weapon.getShip() == Global.getCombatEngine().getPlayerShip()) {
                Global.getCombatEngine().maintainStatusForPlayerShip((Object)weapon, "graphics/icons/hullsys/fortress_shield.png", "Mega Shield", "Invincible", false);
            }
            Global.getSoundPlayer().playLoop("godmode_loop", (Object)weapon.getShip(), 1.0f, 1.0f, weapon.getShip().getLocation(), weapon.getShip().getVelocity());
            this.interval.advance(amount);
            if (this.interval.intervalElapsed()) {
                float shipRadius = SWP_Util.effectiveRadius(weapon.getShip());
                engine.addSmoothParticle(MathUtils.getRandomPointInCircle((Vector2f)weapon.getShip().getLocation(), (float)(shipRadius * 1.25f)), ZERO, (float)Math.random() * 5.0f + 35.0f, (float)Math.random() * 0.25f + 1.0f, 1.0f, MAIN_COLOR);
            }
        }
        if (weapon.getCooldownRemaining() <= 0.0f && this.used) {
            this.used = false;
        }
    }
}

