/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.weapons;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.EveryFrameWeaponEffectPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import data.scripts.util.SWP_Util;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dark.shaders.light.LightAPI;
import org.dark.shaders.light.LightShader;
import org.dark.shaders.light.StandardLight;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lazywizard.lazylib.combat.entities.SimpleEntity;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class SWP_EMPBomb
implements EveryFrameWeaponEffectPlugin {
    private static final Color COLOR1 = new Color(255, 255, 255);
    private static final Color COLOR2 = new Color(200, 225, 255, 150);
    private static final Vector2f ZERO = new Vector2f();
    private static final List<MegaArc> arcs = new ArrayList<MegaArc>(100);
    private static final Map<String, Float> bossShips = new HashMap<String, Float>(8);
    private static CombatEngineAPI currentEngine;
    private static final List<MegaArc> newarcs;
    private final IntervalUtil interval = new IntervalUtil(0.015f, 0.015f);
    private boolean used = false;

    public void advance(float amount, CombatEngineAPI engine, WeaponAPI weapon) {
        MegaArc arc;
        if (engine != currentEngine) {
            arcs.clear();
            newarcs.clear();
            currentEngine = engine;
            return;
        }
        if (weapon.getChargeLevel() > 0.0f && !this.used) {
            this.interval.advance(amount);
            if (this.interval.intervalElapsed()) {
                float shipRadius = SWP_Util.effectiveRadius(weapon.getShip());
                Vector2f point = MathUtils.getRandomPointOnCircumference((Vector2f)weapon.getShip().getLocation(), (float)(shipRadius * 5.0f));
                Vector2f vel = VectorUtils.getDirectionalVector((Vector2f)point, (Vector2f)weapon.getShip().getLocation());
                vel.scale((float)Math.random() * 125.0f + 150.0f);
                engine.addSmoothParticle(point, vel, (float)Math.random() * 10.0f + 10.0f, 0.5f, 1.0f, COLOR1);
            }
            Global.getSoundPlayer().playLoop("high_intensity_laser_loop", (Object)weapon.getShip(), 1.0f + weapon.getChargeLevel() * 4.0f, 3.0f, weapon.getShip().getLocation(), weapon.getShip().getVelocity());
        }
        if (weapon.getCooldownRemaining() > 0.0f && !this.used) {
            this.used = true;
            StandardLight light = new StandardLight(weapon.getShip().getLocation(), ZERO, ZERO, null);
            light.setIntensity(3.0f);
            light.setSize(3500.0f);
            light.setColor(COLOR1);
            light.fadeOut(2.0f);
            LightShader.addLight((LightAPI)light);
            for (int i = 0; i < 25; ++i) {
                Vector2f direction = new Vector2f(1.0f, 0.0f);
                VectorUtils.rotate((Vector2f)direction, (float)((float)Math.random() * 360.0f), (Vector2f)direction);
                arcs.add(new MegaArc(weapon.getShip(), weapon.getShip().getLocation(), direction, (float)Math.random() * 2000.0f + 2000.0f, (float)Math.random() * 20.0f + 15.0f, (float)Math.random() * 0.5f + 0.2f));
            }
            engine.addSmoothParticle(weapon.getShip().getLocation(), ZERO, 1250.0f, 2.0f, 2.0f, COLOR1);
            engine.addHitParticle(weapon.getShip().getLocation(), ZERO, 750.0f, 2.0f, 2.0f, COLOR1);
            Global.getSoundPlayer().playSound("empbomb_activate", 1.0f, 1.0f, weapon.getShip().getLocation(), ZERO);
            List ships = CombatUtils.getShipsWithinRange((Vector2f)weapon.getShip().getLocation(), (float)3000.0f);
            for (ShipAPI ship : ships) {
                if (ship == weapon.getShip() || bossShips.containsKey(ship.getHullSpec().getBaseHullId()) || ship.getHullSpec().getBaseHullId().contentEquals("ssp_superhyperion") && weapon.getShip() == engine.getPlayerShip()) continue;
                ship.getFluxTracker().forceOverload(10.0f + (3000.0f - MathUtils.getDistance((CombatEntityAPI)weapon.getShip(), (CombatEntityAPI)ship)) / 250.0f);
            }
        }
        if (weapon.getCooldownRemaining() <= 0.0f && this.used) {
            this.used = false;
        }
        Iterator<MegaArc> iter = arcs.iterator();
        while (iter.hasNext()) {
            arc = iter.next();
            if (!(Math.random() >= 0.67) || !arc.advance(amount)) continue;
            iter.remove();
        }
        iter = newarcs.iterator();
        while (iter.hasNext()) {
            arc = iter.next();
            arcs.add(arc);
            iter.remove();
        }
    }

    static {
        newarcs = new ArrayList<MegaArc>(100);
        bossShips.put("ssp_oberon", Float.valueOf(2.0f));
        bossShips.put("ssp_ultron", Float.valueOf(3.0f));
        bossShips.put("ssp_zeus", Float.valueOf(2.0f));
        bossShips.put("ssp_ezekiel", Float.valueOf(4.0f));
        bossShips.put("ssp_cristarium", Float.valueOf(2.0f));
        bossShips.put("ssp_zero", Float.valueOf(4.0f));
        bossShips.put("ssp_superzero", Float.valueOf(5.0f));
        bossShips.put("ssp_hyperzero", Float.valueOf(6.0f));
    }

    private static final class MegaArc {
        private final Vector2f direction;
        private final IntervalUtil interval = new IntervalUtil(0.035f, 0.035f);
        private final Vector2f location;
        private float remaining;
        private final ShipAPI source;
        private final float speed;
        private final float thickness;

        private MegaArc(ShipAPI source, Vector2f location, Vector2f direction, float speed, float thickness, float lifetime) {
            this.source = source;
            this.location = new Vector2f((ReadableVector2f)location);
            this.direction = new Vector2f((ReadableVector2f)direction);
            this.speed = speed;
            this.thickness = thickness;
            this.remaining = lifetime;
        }

        private boolean advance(float amount) {
            Vector2f newLocation = new Vector2f((ReadableVector2f)this.direction);
            newLocation.scale(this.speed * amount);
            Vector2f.add((Vector2f)newLocation, (Vector2f)this.location, (Vector2f)newLocation);
            this.interval.advance(amount);
            boolean intervalElapsed = this.interval.intervalElapsed();
            if (intervalElapsed) {
                Global.getCombatEngine().spawnEmpArc(this.source, this.location, (CombatEntityAPI)new SimpleEntity(newLocation), (CombatEntityAPI)new SimpleEntity(newLocation), DamageType.ENERGY, 0.0f, 0.0f, 10000.0f, null, this.thickness, COLOR2, COLOR1);
            }
            this.location.set((ReadableVector2f)newLocation);
            VectorUtils.rotate((Vector2f)this.direction, (float)((float)Math.random() * 60.0f - 30.0f), (Vector2f)this.direction);
            if (intervalElapsed && Math.random() > 0.94) {
                Global.getSoundPlayer().playSound("vortex_absorb", 1.0f, 0.5f, this.location, ZERO);
                Vector2f newDirection = new Vector2f(1.0f, 0.0f);
                VectorUtils.rotate((Vector2f)newDirection, (float)((float)Math.random() * 360.0f), (Vector2f)newDirection);
                newarcs.add(new MegaArc(this.source, this.location, newDirection, this.speed + (float)Math.random() * 200.0f - 100.0f, Math.max(this.thickness - (float)Math.random() * 5.0f, 2.5f), Math.max(this.remaining + (float)Math.random() * 0.3f - 0.15f, 0.01f)));
            }
            this.remaining -= amount;
            return this.remaining <= 0.0f;
        }
    }
}

