/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.util;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.characters.OfficerDataAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.mission.FleetSide;
import data.scripts.SWPModPlugin;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lwjgl.util.vector.Vector2f;

public class SWP_Util {
    public static final Set<String> SPECIAL_SHIPS = new HashSet<String>(36);

    public static int calculatePowerLevel(CampaignFleetAPI fleet) {
        int flatBonus;
        int power = fleet.getFleetPoints();
        int offLvl = 0;
        int cdrLvl = 0;
        boolean commander = false;
        for (OfficerDataAPI officer : fleet.getFleetData().getOfficersCopy()) {
            if (officer.getPerson() == fleet.getCommander()) {
                commander = true;
                cdrLvl = officer.getPerson().getStats().getLevel();
                continue;
            }
            offLvl += officer.getPerson().getStats().getLevel();
        }
        if (!commander) {
            cdrLvl = fleet.getCommanderStats().getLevel();
        }
        if ((power = (int)((double)power * Math.sqrt((float)cdrLvl / 100.0f + 1.0f))) < (flatBonus = cdrLvl + offLvl + 10) * 2) {
            flatBonus = (int)((float)flatBonus * ((float)power / (float)(flatBonus * 2)));
        }
        return power += flatBonus;
    }

    public static float effectiveRadius(ShipAPI ship) {
        if (ship.getSpriteAPI() == null || ship.isPiece()) {
            return ship.getCollisionRadius();
        }
        float fudgeFactor = 1.5f;
        return (ship.getSpriteAPI().getWidth() / 2.0f + ship.getSpriteAPI().getHeight() / 2.0f) * 0.5f * fudgeFactor;
    }

    public static Collection<String> getBuiltInHullMods(ShipAPI ship) {
        ShipVariantAPI tmp = ship.getVariant().clone();
        tmp.clearHullMods();
        return tmp.getHullMods();
    }

    public static float getMemberRadiusEstimate(FleetMemberAPI member) {
        float radius = 500.0f;
        if (member.getHullSpec().getShieldSpec() != null) {
            radius = member.getHullSpec().getShieldSpec().getRadius();
        } else if (!member.getHullSpec().getSpriteName().isEmpty()) {
            SpriteAPI sprite = Global.getSettings().getSprite(member.getHullSpec().getSpriteName());
            float fudgeFactor = 1.5f;
            radius = (sprite.getWidth() / 2.0f + sprite.getHeight() / 2.0f) * 0.5f * fudgeFactor;
        }
        return radius;
    }

    public static String getOrJoined(String ... strings) {
        if (strings.length == 1) {
            return strings[0];
        }
        String result = "";
        for (int i = 0; i < strings.length - 1; ++i) {
            result = result + strings[i] + ", ";
        }
        if (!result.isEmpty()) {
            result = result.substring(0, result.length() - 2);
        }
        if (strings.length >= 2) {
            result = result + " or " + strings[strings.length - 1];
        }
        return result;
    }

    public static Vector2f getSafeSpawn(float collisionRadius, FleetSide side, float mapX, float mapY) {
        Vector2f spawnLocation = new Vector2f();
        float searchRadius = collisionRadius * 1.25f;
        while (searchRadius > 0.0f) {
            spawnLocation.x = MathUtils.getRandomNumberInRange((float)(-mapX / 2.0f), (float)(mapX / 2.0f));
            spawnLocation.y = side == FleetSide.PLAYER ? -mapY / 2.0f : mapY / 2.0f;
            boolean collision = false;
            List ships = CombatUtils.getShipsWithinRange((Vector2f)spawnLocation, (float)(searchRadius -= collisionRadius * 0.05f));
            for (ShipAPI ship : ships) {
                if (ship.isFighter() || ship.isDrone() || ship.isShuttlePod() || ship.isPiece()) continue;
                collision = true;
            }
            if (collision) continue;
            break;
        }
        return spawnLocation;
    }

    public static Vector2f intercept(Vector2f point, float speed, Vector2f target, Vector2f targetVel) {
        Vector2f difference = new Vector2f(target.x - point.x, target.y - point.y);
        float a = targetVel.x * targetVel.x + targetVel.y * targetVel.y - speed * speed;
        float b = 2.0f * (targetVel.x * difference.x + targetVel.y * difference.y);
        float c = difference.x * difference.x + difference.y * difference.y;
        Vector2f solutionSet = SWP_Util.quad(a, b, c);
        Vector2f intercept = null;
        if (solutionSet != null) {
            float bestFit = Math.min(solutionSet.x, solutionSet.y);
            if (bestFit < 0.0f) {
                bestFit = Math.max(solutionSet.x, solutionSet.y);
            }
            if (bestFit > 0.0f) {
                intercept = new Vector2f(target.x + targetVel.x * bestFit, target.y + targetVel.y * bestFit);
            }
        }
        return intercept;
    }

    public static Vector2f intercept(Vector2f point, float speed, float acceleration, float maxspeed, Vector2f target, Vector2f targetVel) {
        Vector2f difference = new Vector2f(target.x - point.x, target.y - point.y);
        float s = speed;
        float a = acceleration / 2.0f;
        float b = speed;
        float c = difference.length();
        Vector2f solutionSet = SWP_Util.quad(a, b, c);
        if (solutionSet != null) {
            float t = Math.min(solutionSet.x, solutionSet.y);
            if (t < 0.0f) {
                t = Math.max(solutionSet.x, solutionSet.y);
            }
            if (t > 0.0f) {
                s = acceleration * t;
                s = s / 2.0f + speed;
                s = Math.min(s, maxspeed);
            }
        }
        a = targetVel.x * targetVel.x + targetVel.y * targetVel.y - s * s;
        b = 2.0f * (targetVel.x * difference.x + targetVel.y * difference.y);
        c = difference.x * difference.x + difference.y * difference.y;
        solutionSet = SWP_Util.quad(a, b, c);
        Vector2f intercept = null;
        if (solutionSet != null) {
            float bestFit = Math.min(solutionSet.x, solutionSet.y);
            if (bestFit < 0.0f) {
                bestFit = Math.max(solutionSet.x, solutionSet.y);
            }
            if (bestFit > 0.0f) {
                intercept = new Vector2f(target.x + targetVel.x * bestFit, target.y + targetVel.y * bestFit);
            }
        }
        return intercept;
    }

    public static float lerp(float x, float y, float alpha) {
        return (1.0f - alpha) * x + alpha * y;
    }

    public static Vector2f quad(float a, float b, float c) {
        Vector2f solution = null;
        if (Float.compare(Math.abs(a), 0.0f) == 0) {
            solution = Float.compare(Math.abs(b), 0.0f) == 0 ? (Float.compare(Math.abs(c), 0.0f) == 0 ? new Vector2f(0.0f, 0.0f) : null) : new Vector2f(-c / b, -c / b);
        } else {
            float d = b * b - 4.0f * a * c;
            if (d >= 0.0f) {
                d = (float)Math.sqrt(d);
                float e = 2.0f * a;
                solution = new Vector2f((-b - d) / e, (-b + d) / e);
            }
        }
        return solution;
    }

    static {
        SPECIAL_SHIPS.add("ii_boss_praetorian");
        SPECIAL_SHIPS.add("ii_boss_olympus");
        SPECIAL_SHIPS.add("ii_boss_dominus");
        SPECIAL_SHIPS.add("msp_boss_potniaBis");
        SPECIAL_SHIPS.add("ms_boss_charybdis");
        SPECIAL_SHIPS.add("ms_boss_mimir");
        SPECIAL_SHIPS.add("tem_boss_paladin");
        SPECIAL_SHIPS.add("tem_boss_archbishop");
        SPECIAL_SHIPS.add("ssp_boss_phaeton");
        SPECIAL_SHIPS.add("ssp_boss_hammerhead");
        SPECIAL_SHIPS.add("ssp_boss_sunder");
        SPECIAL_SHIPS.add("ssp_boss_tarsus");
        SPECIAL_SHIPS.add("ssp_boss_medusa");
        SPECIAL_SHIPS.add("ssp_boss_falcon");
        SPECIAL_SHIPS.add("ssp_boss_hyperion");
        SPECIAL_SHIPS.add("ssp_boss_paragon");
        SPECIAL_SHIPS.add("ssp_boss_mule");
        SPECIAL_SHIPS.add("ssp_boss_aurora");
        SPECIAL_SHIPS.add("ssp_boss_odyssey");
        SPECIAL_SHIPS.add("ssp_boss_atlas");
        SPECIAL_SHIPS.add("ssp_boss_afflictor");
        SPECIAL_SHIPS.add("ssp_boss_brawler");
        SPECIAL_SHIPS.add("ssp_boss_cerberus");
        SPECIAL_SHIPS.add("ssp_boss_dominator");
        SPECIAL_SHIPS.add("ssp_boss_doom");
        SPECIAL_SHIPS.add("ssp_boss_euryale");
        SPECIAL_SHIPS.add("ssp_boss_lasher_b");
        SPECIAL_SHIPS.add("ssp_boss_lasher_r");
        SPECIAL_SHIPS.add("ssp_boss_onslaught");
        SPECIAL_SHIPS.add("ssp_boss_shade");
        SPECIAL_SHIPS.add("ssp_boss_eagle");
        SPECIAL_SHIPS.add("ssp_boss_beholder");
        SPECIAL_SHIPS.add("ssp_boss_dominator_luddic_path");
        SPECIAL_SHIPS.add("ssp_boss_onslaught_luddic_path");
        SPECIAL_SHIPS.add("ssp_boss_astral");
        SPECIAL_SHIPS.add("ssp_boss_conquest");
        SPECIAL_SHIPS.add("swp_boss_frankenstein");
        SPECIAL_SHIPS.add("swp_boss_sporeship");
        SPECIAL_SHIPS.add("tiandong_boss_wuzhang");
        SPECIAL_SHIPS.add("pack_bulldog_bullseye");
        SPECIAL_SHIPS.add("pack_pitbull_bullseye");
        SPECIAL_SHIPS.add("pack_komondor_bullseye");
        SPECIAL_SHIPS.add("pack_schnauzer_bullseye");
        SPECIAL_SHIPS.add("diableavionics_IBBgulf");
    }

    public static enum RequiredFaction {
        NONE,
        JUNK_PIRATES,
        TIANDONG,
        SHADOWYARDS,
        IMPERIUM,
        TEMPLARS,
        DIABLE,
        BLACKROCK,
        CITADEL,
        EXIGENCY,
        MAYORATE,
        SCY,
        CABAL,
        ORA,
        TYRADOR,
        DME;


        public boolean isLoaded() {
            switch (this) {
                case JUNK_PIRATES: {
                    return SWPModPlugin.junkPiratesExists;
                }
                case TIANDONG: {
                    return SWPModPlugin.tiandongExists;
                }
                case SHADOWYARDS: {
                    return SWPModPlugin.shadowyardsExists;
                }
                case IMPERIUM: {
                    return SWPModPlugin.imperiumExists;
                }
                case TEMPLARS: {
                    return SWPModPlugin.templarsExists;
                }
                case DIABLE: {
                    return SWPModPlugin.diableExists;
                }
                case BLACKROCK: {
                    return SWPModPlugin.blackrockExists;
                }
                case CITADEL: {
                    return SWPModPlugin.citadelExists;
                }
                case EXIGENCY: {
                    return SWPModPlugin.exigencyExists;
                }
                case MAYORATE: {
                    return SWPModPlugin.mayorateExists;
                }
                case SCY: {
                    return SWPModPlugin.scyExists;
                }
                case CABAL: {
                    return SWPModPlugin.hasUnderworld;
                }
                case ORA: {
                    return SWPModPlugin.oraExists;
                }
                case TYRADOR: {
                    return SWPModPlugin.tyradorExists;
                }
                case DME: {
                    return SWPModPlugin.dmeExists;
                }
            }
            return true;
        }
    }
}

