/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.util;

import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipEngineControllerAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import java.util.ArrayList;
import java.util.List;
import org.lazywizard.lazylib.MathUtils;
import org.lwjgl.util.vector.Vector2f;

public class SWP_Multi {
    public static List<ShipAPI> getChildren(ShipAPI ship) {
        if (!ship.isShipWithModules()) {
            return new ArrayList<ShipAPI>(0);
        }
        List children = ship.getChildModulesCopy();
        ArrayList<ShipAPI> allChildren = new ArrayList<ShipAPI>(children.size());
        ArrayList toCheck = new ArrayList(children.size());
        while (!children.isEmpty()) {
            allChildren.addAll(children);
            toCheck.clear();
            toCheck.addAll(children);
            children.clear();
            for (ShipAPI child : toCheck) {
                if (!child.isShipWithModules()) continue;
                children.addAll(child.getChildModulesCopy());
            }
        }
        return allChildren;
    }

    public static ShipAPI getRoot(ShipAPI ship) {
        if (SWP_Multi.isMultiShip(ship)) {
            ShipAPI root = ship;
            while (root.getParentStation() != null) {
                root = root.getParentStation();
            }
            return root;
        }
        return ship;
    }

    public static boolean isMultiShip(ShipAPI ship) {
        return ship.getParentStation() != null || ship.isShipWithModules();
    }

    public static boolean isWithinEmpRange(Vector2f loc, float dist, ShipAPI ship) {
        float distSq = dist * dist;
        if (ship.getShield() != null && ship.getShield().isOn() && ship.getShield().isWithinArc(loc) && MathUtils.getDistance((Vector2f)ship.getLocation(), (Vector2f)loc) - ship.getShield().getRadius() <= dist) {
            return true;
        }
        for (WeaponAPI weapon : ship.getAllWeapons()) {
            if (weapon.getSlot().isHidden() || weapon.getSlot().getWeaponType() == WeaponAPI.WeaponType.DECORATIVE || weapon.getSlot().getWeaponType() == WeaponAPI.WeaponType.LAUNCH_BAY || weapon.getSlot().getWeaponType() == WeaponAPI.WeaponType.SYSTEM || !(MathUtils.getDistanceSquared((Vector2f)weapon.getLocation(), (Vector2f)loc) <= distSq)) continue;
            return true;
        }
        for (ShipEngineControllerAPI.ShipEngineAPI engine : ship.getEngineController().getShipEngines()) {
            if (engine.isSystemActivated() || !(MathUtils.getDistanceSquared((Vector2f)engine.getLocation(), (Vector2f)loc) <= distSq)) continue;
            return true;
        }
        return false;
    }
}

